# Generated by Django 2.0.9 on 2020-04-14 17:25

from django.db import migrations, models
import django.db.models.deletion
import invoices.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('products', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Arrival',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('type', invoices.models.InvoiceTypeField(choices=[(1, 'Income'), (2, 'Return'), (2, 'Custom')], verbose_name='Type')),
            ],
            options={
                'verbose_name': 'Arrival',
                'verbose_name_plural': 'Arrivals',
            },
        ),
        migrations.CreateModel(
            name='ArrivalItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price_wholesale', models.FloatField(verbose_name='Wholesale price')),
                ('price_retail', models.FloatField(verbose_name='Retail price')),
                ('price_usd', models.FloatField(default=0)),
                ('price_eur', models.FloatField(default=0)),
                ('price_uah', models.FloatField(default=0)),
                ('initial_currency', models.PositiveIntegerField(choices=[(980, 'UAH'), (840, 'USD'), (978, 'EUR')], default=980, verbose_name='Currency')),
                ('qty', models.IntegerField(verbose_name='Quantity')),
                ('invoice', invoices.models.InvoiceField(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='invoices.Arrival', verbose_name='Invoice')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='products.Product', verbose_name='Product')),
            ],
        ),
        migrations.CreateModel(
            name='Sale',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('type', invoices.models.InvoiceTypeField(choices=[(1, 'Sale'), (2, 'Cash register'), (3, 'Write off'), (4, 'Online'), (5, 'Custom')], verbose_name='Type')),
            ],
            options={
                'verbose_name': 'Sale',
                'verbose_name_plural': 'Sales',
            },
        ),
        migrations.CreateModel(
            name='SaleItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price_wholesale', models.FloatField(verbose_name='Wholesale price')),
                ('price_retail', models.FloatField(verbose_name='Retail price')),
                ('price_usd', models.FloatField(default=0)),
                ('price_eur', models.FloatField(default=0)),
                ('price_uah', models.FloatField(default=0)),
                ('initial_currency', models.PositiveIntegerField(choices=[(980, 'UAH'), (840, 'USD'), (978, 'EUR')], default=980, verbose_name='Currency')),
                ('qty', models.IntegerField(verbose_name='Quantity')),
                ('invoice', invoices.models.InvoiceField(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='invoices.Sale', verbose_name='Invoice')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='products.Product', verbose_name='Product')),
            ]
        ),
    ]
