Description
==============

The emerging field of topological signal processing brings methods from Topological Data Analysis (TDA) to create new tools for signal processing by incorporating aspects of shape.
This python package, teaspoon for tsp or topological signal processing, brings together available software for computing persistent homology, the main workhorse of TDA, with modules that expand the functionality of teaspoon as a state-of-the-art topological signal processing tool.
These modules include methods for incorporating tools from machine learning, complex networks, information, and parameter selection along with a dynamical systems library to streamline the creation and benchmarking of new methods.
All code is open source with up to date documentation, making the code easy to use, in particular for signal processing experts with limited experience in topological methods.


Full documentation of this package is available [here](https://lizliz.github.io/teaspoon/). The full documentation includes information about installation, module documentation with examples, contributing, the license, and citing teaspoon.

The code is a compilation of work done by [Elizabeth Munch](http://www.elizabethmunch.com) and [Firas Khasawneh](http://www.firaskhasawneh.com/) along with their students and collaborators.  People who have contributed to teaspoon include:

- [Audun Myers](https://www.audunmyers.com)
- [Melih Yesilli](https://www.melihcanyesilli.com)
- [Sarah Tymochko](https://www.egr.msu.edu/~tymochko/)

Installation
=============
The teaspoon package is available through pip install with version details found [here](https://pypi.org/project/teaspoon/).
The package can be installed using the following pip installation::

	``pip install teaspoon``

The current draft of the code may still have dependency issues which will be fixed by version 1.0.0. Please reference the requirements page in the [documentation](https://lizliz.github.io/teaspoon/) for more details on other required installations.

Contacts
=============
* Liz Munch: [muncheli@msu.edu](mailto:muncheli@msu.edu).
* Firas Khasawneh: [khasawn3@egr.msu.edu](mailto:khasawn3@egr.msu.edu).
