// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import React from 'react';
import clsx from 'clsx';
import useFocusVisible from '../../internal/hooks/focus-visible';
import Icon from '../../icon/internal';
import styles from './styles.css.js';
function TriggerButton({ ariaLabel, iconName, onClick, selected = false, className }, ref) {
    const focusVisible = useFocusVisible();
    return (React.createElement("button", Object.assign({ "aria-label": ariaLabel, "aria-expanded": false, "aria-haspopup": true, className: clsx(styles.trigger, {
            [styles.selected]: selected,
        }, className), onClick: onClick, type: "button", ref: ref }, focusVisible),
        React.createElement(Icon, { name: iconName })));
}
export default React.forwardRef(TriggerButton);
//# sourceMappingURL=trigger-button.js.map