# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from seaplane_framework.api import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from seaplane_framework.api import schemas  # noqa: F401

from seaplane_framework.api.model.error import Error
from seaplane_framework.api.model.key_value_etag import KeyValueEtag

from . import path

# Query params


class PurgeSchema(schemas.EnumBase, schemas.StrSchema):
    class MetaOapg:
        enum_value_to_name = {
            "true": "TRUE",
            "false": "FALSE",
        }

    @schemas.classproperty
    def TRUE(cls):
        return cls("true")

    @schemas.classproperty
    def FALSE(cls):
        return cls("false")


RequestRequiredQueryParams = typing_extensions.TypedDict(
    "RequestRequiredQueryParams", {}
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    "RequestOptionalQueryParams",
    {
        "purge": typing.Union[
            PurgeSchema,
            str,
        ],
    },
    total=False,
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_purge = api_client.QueryParameter(
    name="purge",
    style=api_client.ParameterStyle.FORM,
    schema=PurgeSchema,
    explode=True,
)
# Header params
IfMatchSchema = KeyValueEtag
RequestRequiredHeaderParams = typing_extensions.TypedDict(
    "RequestRequiredHeaderParams", {}
)
RequestOptionalHeaderParams = typing_extensions.TypedDict(
    "RequestOptionalHeaderParams",
    {
        "If-Match": typing.Union[IfMatchSchema,],
    },
    total=False,
)


class RequestHeaderParams(RequestRequiredHeaderParams, RequestOptionalHeaderParams):
    pass


request_header_if_match = api_client.HeaderParameter(
    name="If-Match",
    style=api_client.ParameterStyle.SIMPLE,
    schema=IfMatchSchema,
)
# Path params


class KeySchema(schemas.StrSchema):
    class MetaOapg:
        regex = [
            {
                "pattern": r"^([-_a-zA-Z0-9]){1,128}$",  # noqa: E501
            }
        ]


class KvStoreSchema(schemas.StrSchema):
    class MetaOapg:
        regex = [
            {
                "pattern": r"^([-_a-zA-Z0-9]){1,63}$",  # noqa: E501
            }
        ]


RequestRequiredPathParams = typing_extensions.TypedDict(
    "RequestRequiredPathParams",
    {
        "key": typing.Union[
            KeySchema,
            str,
        ],
        "kv_store": typing.Union[
            KvStoreSchema,
            str,
        ],
    },
)
RequestOptionalPathParams = typing_extensions.TypedDict(
    "RequestOptionalPathParams", {}, total=False
)


class RequestPathParams(RequestRequiredPathParams, RequestOptionalPathParams):
    pass


request_path_key = api_client.PathParameter(
    name="key",
    style=api_client.ParameterStyle.SIMPLE,
    schema=KeySchema,
    required=True,
)
request_path_kv_store = api_client.PathParameter(
    name="kv_store",
    style=api_client.ParameterStyle.SIMPLE,
    schema=KvStoreSchema,
    required=True,
)
_auth = [
    "BasicAuth",
]


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: schemas.Unset = schemas.unset
    headers: schemas.Unset = schemas.unset


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
)
SchemaFor400ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor400(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor400ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_400 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor400,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor400ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor401ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor401(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor401ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_401 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor401,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor401ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor404ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor404(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor404ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_404 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor404,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor404ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor412ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor412(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor412ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_412 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor412,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor412ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor503ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor503(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor503ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_503 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor503,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor503ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor5XXResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor5XX(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor5XXResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_5XX = api_client.OpenApiResponse(
    response_cls=ApiResponseFor5XX,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor5XXResponseBodyApplicationProblemjson
        ),
    },
)
_status_code_to_response = {
    "200": _response_for_200,
    "400": _response_for_400,
    "401": _response_for_401,
    "404": _response_for_404,
    "412": _response_for_412,
    "503": _response_for_503,
    "5XX": _response_for_5XX,
}
_all_accept_content_types = ("application/problem+json",)


class BaseApi(api_client.Api):
    @typing.overload
    def _delete_key_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor200,]:
        ...

    @typing.overload
    def _delete_key_oapg(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def _delete_key_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor200, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def _delete_key_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        """
        Remove an entry from the key-value store.
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        self._verify_typed_dict_inputs_oapg(RequestHeaderParams, header_params)
        self._verify_typed_dict_inputs_oapg(RequestPathParams, path_params)
        used_path = path.value

        _path_params = {}
        for parameter in (
            request_path_key,
            request_path_kv_store,
        ):
            parameter_data = path_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            serialized_data = parameter.serialize(parameter_data)
            _path_params.update(serialized_data)

        for k, v in _path_params.items():
            used_path = used_path.replace("{%s}" % k, v)

        prefix_separator_iterator = None
        for parameter in (request_query_purge,):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(
                parameter_data, prefix_separator_iterator
            )
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        for parameter in (request_header_if_match,):
            parameter_data = header_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            serialized_data = parameter.serialize(parameter_data)
            _headers.extend(serialized_data)
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add("Accept", accept_content_type)

        response = self.api_client.call_api(
            resource_path=used_path,
            method="delete".upper(),
            headers=_headers,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(
                response=response
            )
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(
                    response, self.api_client.configuration
                )
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(
                    response=response
                )

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(
                status=response.status,
                reason=response.reason,
                api_response=api_response,
            )

        return api_response


class DeleteKey(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    @typing.overload
    def delete_key(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor200,]:
        ...

    @typing.overload
    def delete_key(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def delete_key(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor200, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def delete_key(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._delete_key_oapg(
            query_params=query_params,
            header_params=header_params,
            path_params=path_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization,
        )


class ApiFordelete(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    @typing.overload
    def delete(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor200,]:
        ...

    @typing.overload
    def delete(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def delete(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor200, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def delete(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._delete_key_oapg(
            query_params=query_params,
            header_params=header_params,
            path_params=path_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization,
        )
