# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from seaplane_framework.api import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from seaplane_framework.api import schemas  # noqa: F401

from seaplane_framework.api.model.error import Error
from seaplane_framework.api.model.flow import Flow

from . import path

# Query params
RegionSchema = schemas.StrSchema
RequestRequiredQueryParams = typing_extensions.TypedDict(
    "RequestRequiredQueryParams", {}
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    "RequestOptionalQueryParams",
    {
        "region": typing.Union[
            RegionSchema,
            str,
        ],
    },
    total=False,
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_region = api_client.QueryParameter(
    name="region",
    style=api_client.ParameterStyle.FORM,
    schema=RegionSchema,
    explode=True,
)
# Path params


class FlowNameSchema(schemas.StrSchema):
    class MetaOapg:
        max_length = 32
        min_length = 1
        regex = [
            {
                "pattern": r"^[a-z0-9]+(-[a-z0-9]+)*$",  # noqa: E501
            }
        ]


RequestRequiredPathParams = typing_extensions.TypedDict(
    "RequestRequiredPathParams",
    {
        "flow_name": typing.Union[
            FlowNameSchema,
            str,
        ],
    },
)
RequestOptionalPathParams = typing_extensions.TypedDict(
    "RequestOptionalPathParams", {}, total=False
)


class RequestPathParams(RequestRequiredPathParams, RequestOptionalPathParams):
    pass


request_path_flow_name = api_client.PathParameter(
    name="flow_name",
    style=api_client.ParameterStyle.SIMPLE,
    schema=FlowNameSchema,
    required=True,
)
# body param
SchemaForRequestBodyApplicationJson = Flow


request_body_flow = api_client.RequestBody(
    content={
        "application/json": api_client.MediaType(
            schema=SchemaForRequestBodyApplicationJson
        ),
    },
)
_auth = [
    "BasicAuth",
]


@dataclass
class ApiResponseFor204(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: schemas.Unset = schemas.unset
    headers: schemas.Unset = schemas.unset


_response_for_204 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor204,
)
SchemaFor400ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor400(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor400ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_400 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor400,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor400ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor401ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor401(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor401ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_401 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor401,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor401ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor404ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor404(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor404ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_404 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor404,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor404ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor503ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor503(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor503ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_503 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor503,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor503ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor5XXResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor5XX(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor5XXResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_5XX = api_client.OpenApiResponse(
    response_cls=ApiResponseFor5XX,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor5XXResponseBodyApplicationProblemjson
        ),
    },
)
_status_code_to_response = {
    "204": _response_for_204,
    "400": _response_for_400,
    "401": _response_for_401,
    "404": _response_for_404,
    "503": _response_for_503,
    "5XX": _response_for_5XX,
}
_all_accept_content_types = ("application/problem+json",)


class BaseApi(api_client.Api):
    @typing.overload
    def _create_flow_oapg(
        self,
        content_type: typing_extensions.Literal["application/json"] = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor204,]:
        ...

    @typing.overload
    def _create_flow_oapg(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor204,]:
        ...

    @typing.overload
    def _create_flow_oapg(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def _create_flow_oapg(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor204, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def _create_flow_oapg(
        self,
        content_type: str = "application/json",
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        """
        Create a Flow
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        self._verify_typed_dict_inputs_oapg(RequestPathParams, path_params)
        used_path = path.value

        _path_params = {}
        for parameter in (request_path_flow_name,):
            parameter_data = path_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            serialized_data = parameter.serialize(parameter_data)
            _path_params.update(serialized_data)

        for k, v in _path_params.items():
            used_path = used_path.replace("{%s}" % k, v)

        prefix_separator_iterator = None
        for parameter in (request_query_region,):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(
                parameter_data, prefix_separator_iterator
            )
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add("Accept", accept_content_type)

        _fields = None
        _body = None
        if body is not schemas.unset:
            serialized_data = request_body_flow.serialize(body, content_type)
            _headers.add("Content-Type", content_type)
            if "fields" in serialized_data:
                _fields = serialized_data["fields"]
            elif "body" in serialized_data:
                _body = serialized_data["body"]
        response = self.api_client.call_api(
            resource_path=used_path,
            method="put".upper(),
            headers=_headers,
            fields=_fields,
            body=_body,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(
                response=response
            )
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(
                    response, self.api_client.configuration
                )
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(
                    response=response
                )

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(
                status=response.status,
                reason=response.reason,
                api_response=api_response,
            )

        return api_response


class CreateFlow(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    @typing.overload
    def create_flow(
        self,
        content_type: typing_extensions.Literal["application/json"] = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor204,]:
        ...

    @typing.overload
    def create_flow(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor204,]:
        ...

    @typing.overload
    def create_flow(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def create_flow(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor204, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def create_flow(
        self,
        content_type: str = "application/json",
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._create_flow_oapg(
            body=body,
            query_params=query_params,
            path_params=path_params,
            content_type=content_type,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization,
        )


class ApiForput(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    @typing.overload
    def put(
        self,
        content_type: typing_extensions.Literal["application/json"] = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor204,]:
        ...

    @typing.overload
    def put(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor204,]:
        ...

    @typing.overload
    def put(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def put(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor204, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def put(
        self,
        content_type: str = "application/json",
        body: typing.Union[
            SchemaForRequestBodyApplicationJson, schemas.Unset
        ] = schemas.unset,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._create_flow_oapg(
            body=body,
            query_params=query_params,
            path_params=path_params,
            content_type=content_type,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization,
        )
