# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from seaplane_framework.api import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from seaplane_framework.api import schemas  # noqa: F401

from seaplane_framework.api.model.error import Error
from seaplane_framework.api.model.x_meta_data import XMetaData

from . import path

# Header params
XMetaDataSchema = XMetaData
RequestRequiredHeaderParams = typing_extensions.TypedDict(
    "RequestRequiredHeaderParams", {}
)
RequestOptionalHeaderParams = typing_extensions.TypedDict(
    "RequestOptionalHeaderParams",
    {
        "X-Meta-Data": typing.Union[XMetaDataSchema,],
    },
    total=False,
)


class RequestHeaderParams(RequestRequiredHeaderParams, RequestOptionalHeaderParams):
    pass


request_header_x_meta_data = api_client.HeaderParameter(
    name="X-Meta-Data",
    style=api_client.ParameterStyle.SIMPLE,
    schema=XMetaDataSchema,
)
# Path params


class EndpointSchema(schemas.StrSchema):
    class MetaOapg:
        max_length = 31
        min_length = 1
        regex = [
            {
                "pattern": r"^[a-z0-9]+(-[a-z0-9]+)*$",  # noqa: E501
            }
        ]


RequestRequiredPathParams = typing_extensions.TypedDict(
    "RequestRequiredPathParams",
    {
        "endpoint": typing.Union[
            EndpointSchema,
            str,
        ],
    },
)
RequestOptionalPathParams = typing_extensions.TypedDict(
    "RequestOptionalPathParams", {}, total=False
)


class RequestPathParams(RequestRequiredPathParams, RequestOptionalPathParams):
    pass


request_path_endpoint = api_client.PathParameter(
    name="endpoint",
    style=api_client.ParameterStyle.SIMPLE,
    schema=EndpointSchema,
    required=True,
)
# body param
SchemaForRequestBodyApplicationOctetStream = schemas.BinarySchema


request_body_body = api_client.RequestBody(
    content={
        "application/octet-stream": api_client.MediaType(
            schema=SchemaForRequestBodyApplicationOctetStream
        ),
    },
)
_auth = [
    "BasicAuth",
]


class SchemaFor201ResponseBodyApplicationJson(schemas.DictSchema):
    class MetaOapg:
        class properties:
            request_id = schemas.StrSchema
            __annotations__ = {
                "request_id": request_id,
            }

        additional_properties = schemas.NotAnyTypeSchema

    @typing.overload
    def __getitem__(
        self, name: typing_extensions.Literal["request_id"]
    ) -> MetaOapg.properties.request_id:
        ...

    def __getitem__(self, name: typing.Union[typing_extensions.Literal["request_id"],]):
        # dict_instance[name] accessor
        return super().__getitem__(name)

    @typing.overload
    def get_item_oapg(
        self, name: typing_extensions.Literal["request_id"]
    ) -> typing.Union[MetaOapg.properties.request_id, schemas.Unset]:
        ...

    def get_item_oapg(
        self, name: typing.Union[typing_extensions.Literal["request_id"],]
    ):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[
            dict,
            frozendict.frozendict,
        ],
        request_id: typing.Union[
            MetaOapg.properties.request_id, str, schemas.Unset
        ] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> "SchemaFor201ResponseBodyApplicationJson":
        return super().__new__(
            cls,
            *_args,
            request_id=request_id,
            _configuration=_configuration,
        )


@dataclass
class ApiResponseFor201(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor201ResponseBodyApplicationJson,]
    headers: schemas.Unset = schemas.unset


_response_for_201 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor201,
    content={
        "application/json": api_client.MediaType(
            schema=SchemaFor201ResponseBodyApplicationJson
        ),
    },
)
SchemaFor400ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor400(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor400ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_400 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor400,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor400ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor401ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor401(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor401ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_401 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor401,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor401ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor404ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor404(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor404ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_404 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor404,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor404ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor503ResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor503(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor503ResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_503 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor503,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor503ResponseBodyApplicationProblemjson
        ),
    },
)
SchemaFor5XXResponseBodyApplicationProblemjson = Error


@dataclass
class ApiResponseFor5XX(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[SchemaFor5XXResponseBodyApplicationProblemjson,]
    headers: schemas.Unset = schemas.unset


_response_for_5XX = api_client.OpenApiResponse(
    response_cls=ApiResponseFor5XX,
    content={
        "application/problem+json": api_client.MediaType(
            schema=SchemaFor5XXResponseBodyApplicationProblemjson
        ),
    },
)
_status_code_to_response = {
    "201": _response_for_201,
    "400": _response_for_400,
    "401": _response_for_401,
    "404": _response_for_404,
    "503": _response_for_503,
    "5XX": _response_for_5XX,
}
_all_accept_content_types = (
    "application/json",
    "application/problem+json",
)


class BaseApi(api_client.Api):
    @typing.overload
    def _submit_to_endpoint_oapg(
        self,
        content_type: typing_extensions.Literal["application/octet-stream"] = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor201,]:
        ...

    @typing.overload
    def _submit_to_endpoint_oapg(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor201,]:
        ...

    @typing.overload
    def _submit_to_endpoint_oapg(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def _submit_to_endpoint_oapg(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor201, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def _submit_to_endpoint_oapg(
        self,
        content_type: str = "application/octet-stream",
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        """
        Create a endpoint request (i.e. ingress)
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestHeaderParams, header_params)
        self._verify_typed_dict_inputs_oapg(RequestPathParams, path_params)
        used_path = path.value

        _path_params = {}
        for parameter in (request_path_endpoint,):
            parameter_data = path_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            serialized_data = parameter.serialize(parameter_data)
            _path_params.update(serialized_data)

        for k, v in _path_params.items():
            used_path = used_path.replace("{%s}" % k, v)

        _headers = HTTPHeaderDict()
        for parameter in (request_header_x_meta_data,):
            parameter_data = header_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            serialized_data = parameter.serialize(parameter_data)
            _headers.extend(serialized_data)
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add("Accept", accept_content_type)

        _fields = None
        _body = None
        if body is not schemas.unset:
            serialized_data = request_body_body.serialize(body, content_type)
            _headers.add("Content-Type", content_type)
            if "fields" in serialized_data:
                _fields = serialized_data["fields"]
            elif "body" in serialized_data:
                _body = serialized_data["body"]
        response = self.api_client.call_api(
            resource_path=used_path,
            method="post".upper(),
            headers=_headers,
            fields=_fields,
            body=_body,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(
                response=response
            )
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(
                    response, self.api_client.configuration
                )
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(
                    response=response
                )

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(
                status=response.status,
                reason=response.reason,
                api_response=api_response,
            )

        return api_response


class SubmitToEndpoint(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    @typing.overload
    def submit_to_endpoint(
        self,
        content_type: typing_extensions.Literal["application/octet-stream"] = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor201,]:
        ...

    @typing.overload
    def submit_to_endpoint(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor201,]:
        ...

    @typing.overload
    def submit_to_endpoint(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def submit_to_endpoint(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor201, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def submit_to_endpoint(
        self,
        content_type: str = "application/octet-stream",
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._submit_to_endpoint_oapg(
            body=body,
            header_params=header_params,
            path_params=path_params,
            content_type=content_type,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization,
        )


class ApiForpost(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    @typing.overload
    def post(
        self,
        content_type: typing_extensions.Literal["application/octet-stream"] = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor201,]:
        ...

    @typing.overload
    def post(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[ApiResponseFor201,]:
        ...

    @typing.overload
    def post(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization:
        ...

    @typing.overload
    def post(
        self,
        content_type: str = ...,
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[ApiResponseFor201, api_client.ApiResponseWithoutDeserialization,]:
        ...

    def post(
        self,
        content_type: str = "application/octet-stream",
        body: typing.Union[
            SchemaForRequestBodyApplicationOctetStream,
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.Unset,
        ] = schemas.unset,
        header_params: RequestHeaderParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._submit_to_endpoint_oapg(
            body=body,
            header_params=header_params,
            path_params=path_params,
            content_type=content_type,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization,
        )
