# seaplane_framework.api
**Seaplane Global Messaging Service**

For information about authentication see [authentication](/docs/authentication)


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0-beta
- Package version: 0.0.12
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import seaplane_framework.api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import seaplane_framework.api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import seaplane_framework.api
from pprint import pprint
from seaplane_framework.api.apis.tags import endpoint_api
from seaplane_framework.api.model.error import Error
from seaplane_framework.api.model.x_meta_data import XMetaData
# Defining the host is optional and defaults to https://carrier.cplane.cloud/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = seaplane_framework.api.Configuration(
    host = "https://carrier.cplane.cloud/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BasicAuth
configuration = seaplane_framework.api.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with seaplane_framework.api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = endpoint_api.EndpointApi(api_client)
    endpoint = "pipe-123" # str | Subdivision of endpoints input/output. must be less than 32 characters long and a valid hostname/DNS segment (for potential subdomain hosting).
message_id = "abcf8181-f54d-412a-b708-86b8a0c38e90.1.2" # str | Seaplane-generated message ID, a request Id with an optional set of batch indices

    try:
        # GET data from a endpoint
        api_response = api_instance.get_from_endpoint(endpointmessage_id)
        pprint(api_response)
    except seaplane_framework.api.ApiException as e:
        print("Exception when calling EndpointApi->get_from_endpoint: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://carrier.cplane.cloud/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EndpointApi* | [**get_from_endpoint**](docs/apis/tags/EndpointApi.md#get_from_endpoint) | **get** /endpoints/{endpoint}/response/{message_id} | GET data from a endpoint
*EndpointApi* | [**submit_to_endpoint**](docs/apis/tags/EndpointApi.md#submit_to_endpoint) | **post** /endpoints/{endpoint}/request | Create a endpoint request (i.e. ingress)
*FlowApi* | [**create_flow**](docs/apis/tags/FlowApi.md#create_flow) | **put** /flow/{flow_name} | Create a Flow
*FlowApi* | [**delete_flow**](docs/apis/tags/FlowApi.md#delete_flow) | **delete** /flow/{flow_name} | Delete a Flow
*FlowApi* | [**delete_secret**](docs/apis/tags/FlowApi.md#delete_secret) | **delete** /flow/{flow_name}/secrets/{secret_name} | Delete a single secret k/v.
*FlowApi* | [**get_flow**](docs/apis/tags/FlowApi.md#get_flow) | **get** /flow/{flow_name} | Get a Flow summary
*FlowApi* | [**get_secret**](docs/apis/tags/FlowApi.md#get_secret) | **get** /flow/{flow_name}/secrets/{secret_name} | Get secret details
*FlowApi* | [**list_flows**](docs/apis/tags/FlowApi.md#list_flows) | **get** /flow | Get list of all flows
*FlowApi* | [**list_secrets**](docs/apis/tags/FlowApi.md#list_secrets) | **get** /flow/{flow_name}/secrets | List all secrets
*FlowApi* | [**set_secret**](docs/apis/tags/FlowApi.md#set_secret) | **put** /flow/{flow_name}/secrets/{secret_name} | Set the secret value
*FlowApi* | [**set_secrets**](docs/apis/tags/FlowApi.md#set_secrets) | **put** /flow/{flow_name}/secrets | Set all secrets
*FlowApi* | [**stream_flow_events**](docs/apis/tags/FlowApi.md#stream_flow_events) | **get** /flow/{flow_name}/events | Stream flow events with SSE
*KeyValueApi* | [**create_store**](docs/apis/tags/KeyValueApi.md#create_store) | **put** /kv/{kv_store} | Create a new key-value store.
*KeyValueApi* | [**delete_key**](docs/apis/tags/KeyValueApi.md#delete_key) | **delete** /kv/{kv_store}/key/{key} | Remove an entry from the key-value store.
*KeyValueApi* | [**delete_store**](docs/apis/tags/KeyValueApi.md#delete_store) | **delete** /kv/{kv_store} | Deletes an existing key-value store.
*KeyValueApi* | [**get_key**](docs/apis/tags/KeyValueApi.md#get_key) | **get** /kv/{kv_store}/key/{key} | Get a Key-Value entry
*KeyValueApi* | [**get_store**](docs/apis/tags/KeyValueApi.md#get_store) | **get** /kv/{kv_store} | Get information about a Key-Value store
*KeyValueApi* | [**list_keys**](docs/apis/tags/KeyValueApi.md#list_keys) | **get** /kv/{kv_store}/key | Get the list of keys currently in a store.
*KeyValueApi* | [**list_stores**](docs/apis/tags/KeyValueApi.md#list_stores) | **get** /kv | Get information about all Key-Value stores
*KeyValueApi* | [**put_key**](docs/apis/tags/KeyValueApi.md#put_key) | **put** /kv/{kv_store}/key/{key} | Place an entry into the key-value store.
*ObjectApi* | [**create_bucket**](docs/apis/tags/ObjectApi.md#create_bucket) | **put** /object/{bucket_name} | Create a Bucket
*ObjectApi* | [**create_object**](docs/apis/tags/ObjectApi.md#create_object) | **put** /object/{bucket_name}/store | Create an object in a bucket
*ObjectApi* | [**delete_bucket**](docs/apis/tags/ObjectApi.md#delete_bucket) | **delete** /object/{bucket_name} | Delete a bucket
*ObjectApi* | [**delete_object**](docs/apis/tags/ObjectApi.md#delete_object) | **delete** /object/{bucket_name}/store | Delete an object in a bucket
*ObjectApi* | [**get_bucket**](docs/apis/tags/ObjectApi.md#get_bucket) | **get** /object/{bucket_name} | Get a bucket summary
*ObjectApi* | [**get_object**](docs/apis/tags/ObjectApi.md#get_object) | **get** /object/{bucket_name}/store | Get an object in a bucket or list under a prefix
*ObjectApi* | [**list_buckets**](docs/apis/tags/ObjectApi.md#list_buckets) | **get** /object | Get list of all buckets
*ObjectApi* | [**list_objects**](docs/apis/tags/ObjectApi.md#list_objects) | **get** /object/{bucket_name}/list | Get an object in a bucket or list under a prefix
*StreamApi* | [**create_stream**](docs/apis/tags/StreamApi.md#create_stream) | **put** /stream/{stream_name} | Create a new stream
*StreamApi* | [**delete_stream**](docs/apis/tags/StreamApi.md#delete_stream) | **delete** /stream/{stream_name} | Delete a stream
*StreamApi* | [**get_stream**](docs/apis/tags/StreamApi.md#get_stream) | **get** /stream/{stream_name} | Get the details of a stream
*StreamApi* | [**list_streams**](docs/apis/tags/StreamApi.md#list_streams) | **get** /stream | Get list of all streams

## Documentation For Models

 - [AzureBlobStorageOutput](docs/models/AzureBlobStorageOutput.md)
 - [Broker](docs/models/Broker.md)
 - [Bucket](docs/models/Bucket.md)
 - [CarrierInput](docs/models/CarrierInput.md)
 - [CarrierInputConfig](docs/models/CarrierInputConfig.md)
 - [CarrierOutput](docs/models/CarrierOutput.md)
 - [CarrierOutputConfig](docs/models/CarrierOutputConfig.md)
 - [CarrierStream](docs/models/CarrierStream.md)
 - [CarrierStreamDetails](docs/models/CarrierStreamDetails.md)
 - [CarrierStreamOptions](docs/models/CarrierStreamOptions.md)
 - [Cors](docs/models/Cors.md)
 - [DockerProcessor](docs/models/DockerProcessor.md)
 - [Error](docs/models/Error.md)
 - [Flow](docs/models/Flow.md)
 - [HTTPServer](docs/models/HTTPServer.md)
 - [Headers](docs/models/Headers.md)
 - [Input](docs/models/Input.md)
 - [KeyValueConfig](docs/models/KeyValueConfig.md)
 - [KeyValueEtag](docs/models/KeyValueEtag.md)
 - [Location](docs/models/Location.md)
 - [MetadataHeaders](docs/models/MetadataHeaders.md)
 - [ObjectStat](docs/models/ObjectStat.md)
 - [Output](docs/models/Output.md)
 - [Processor](docs/models/Processor.md)
 - [Secret](docs/models/Secret.md)
 - [SecretsManifest](docs/models/SecretsManifest.md)
 - [SqlRaw](docs/models/SqlRaw.md)
 - [Switch](docs/models/Switch.md)
 - [SwitchNested1](docs/models/SwitchNested1.md)
 - [SwitchNested2](docs/models/SwitchNested2.md)
 - [SwitchOutput](docs/models/SwitchOutput.md)
 - [SyncResponse](docs/models/SyncResponse.md)
 - [XMetaData](docs/models/XMetaData.md)

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="BasicAuth"></a>
### BasicAuth

- **Type**: Bearer authentication


## Author

support@seaplane.io
support@seaplane.io
support@seaplane.io
support@seaplane.io
support@seaplane.io

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in seaplane_framework.api.apis and seaplane_framework.api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from seaplane_framework.api.apis.default_api import DefaultApi`
- `from seaplane_framework.api.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import seaplane_framework.api
from seaplane_framework.api.apis import *
from seaplane_framework.api.models import *
```
