"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("../component");
const render_options_1 = require("../javascript/render-options");
const typescript_1 = require("../typescript");
/**
 * (experimental) Sets up a typescript project to use TypeScript for projenrc.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e;
        super(project);
        this.rcfile = (_b = options.filename) !== null && _b !== void 0 ? _b : '.projenrc.ts';
        // tell eslint to take .projenrc.ts into account as a dev-dependency
        (_c = project.eslint) === null || _c === void 0 ? void 0 : _c.allowDevDeps(this.rcfile);
        (_d = project.eslint) === null || _d === void 0 ? void 0 : _d.addIgnorePattern(`!${this.rcfile}`);
        (_e = project.tsconfigEslint) === null || _e === void 0 ? void 0 : _e.addInclude(this.rcfile);
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        project.addDevDeps('ts-node');
        project.addTask(typescript_1.TypeScriptProject.DEFAULT_TASK, { exec: `ts-node ${this.rcfile}` });
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.newProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split('.');
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join('.');
        const js = render_options_1.renderJavaScriptOptions({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        const lines = new Array();
        lines.push(`import { ${importName} } from '${moduleName}';`);
        lines.push();
        lines.push(`const project = new ${className}(${js});`);
        lines.push();
        lines.push('project.synth();');
        fs_1.writeFileSync(rcfile, lines.join('\n'));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.17.95" };
//# sourceMappingURL=data:application/json;base64,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