"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
const glob_1 = require("glob");
const util_1 = require("./util");
const samples = path_1.join(__dirname, '..', '..', 'src', '__tests__', 'integration');
const files = glob_1.glob.sync('**/*.projenrc.js', { cwd: samples });
for (const projenrc of files) {
    test(path_1.basename(projenrc, '.projenrc.js'), () => {
        const workdir = util_1.mkdtemp();
        const base = path_1.join(samples, path_1.dirname(projenrc));
        if (base !== samples) {
            fs_extra_1.copySync(base, workdir, { recursive: true });
        }
        fs_extra_1.copySync(path_1.join(samples, projenrc), path_1.join(workdir, '.projenrc.js'));
        util_1.execProjenCLI(workdir, ['--no-post']);
        // patch the projen version in package.json to match the current version
        // otherwise, every bump would need to update these snapshots.
        util_1.sanitizeOutput(workdir);
        expect(util_1.directorySnapshot(workdir, { excludeGlobs: ['node_modules/**'] })).toMatchSnapshot();
    });
}
//# sourceMappingURL=data:application/json;base64,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