#
# This file is part of AceQL Python Client SDK.
# AceQL Python Client SDK: Remote SQL access over HTTP with AceQL HTTP.
# Copyright (C) 2020,  KawanSoft SAS
# (http://www.kawansoft.com). All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
##

"""aceql library. Allows to wrap the AceQL HTTP APIs to access remote SQL databases.

    The library supports Python 3.6 to 3.8.
    It provides a SQL interface compliant with the DB-API 2.0 specification described by PEP 249.
"""

from aceql.connection import Connection
from aceql.progress_indicator import ProgressIndicator
from aceql.sql_null_type import SqlNullType
from aceql.cursor import Cursor
from aceql.error import Error
from aceql.proxy_auth import ProxyAuth

from aceql.metadata.exportedkey import ExportedKey
from aceql.metadata.foreignkey import ForeignKey
from aceql.metadata.importedkey import ImportedKey
from aceql.metadata.index import Index
from aceql.metadata.jdbc_database_meta_data import JdbcDatabaseMetaData
from aceql.metadata.primarykey import PrimaryKey
from aceql.metadata.remote_database_metadata import RemoteDatabaseMetaData
from aceql.metadata.table import Table
from aceql.metadata.column import Column

from aceql.dbapi2 import *

__all__ = ["Connection", "Cursor", "Error", "ProgressIndicator", "ProxyAuth", "SqlNullType", "Column", "ExportedKey",
           "ForeignKey", "ImportedKey", "Index", "JdbcDatabaseMetaData", "PrimaryKey", "RemoteDatabaseMetaData",
           "Table"]


def connect(server_url, database, username, password, session_id=None, proxies=None, auth=None):
    """
    Creates a database connection to the remote AceQL HTTP server.

    Parameters
    ----------
    server_url : str
        The URL of the AceQL server. Example: https://www.acme.com:9443/aceql.
    database : str
        The remote database name.
    username : str
        The authentication username.
    password : str
        the authentication password.
    session_id : str
            the session_id generated by AceQL login method on server. To be used for authentication without password.
    proxies : dict
        The proxy to use, can  be an authenticated proxy.
    auth:   : ProxyAuth
        aceql.ProxyAuth instance with proxy (username, password)

    Returns
    -------
    Connection
        A connection to the remote database.

    """

    the_connection = Connection(server_url, database, username, password, session_id, proxies=proxies, auth=auth)
    return the_connection
