# Apache Airavata Python SDK

The Apache Airavata Python SDK for third party clients to integrate with Airavata middleware

### Folder Structure
- `airavata`
  Includes thrift stubs generated by a thrift compiler.
  Mainly contains data model and functions.
  You may need to import data model packages to integrate with clients.
- `airavata_sdk`
  - `clients`
    Includes integration clients, which you want to import and integrate with your code to access airavata middleware.
  - `samples`
    Includes set of sample implementation of integration clients to demonastrate the integration with airavata middleware
  - `transport`
    Includes connection handling classes and connection pool implementations
- `airavata_experiments`
  Python APIs to run experiments from anywhere.
  Handles uploading data, running experiments, tracking progress, and fetching data from past runs.
- `airavata_jupyter_magic`
  Jupyter Plugin providing magic annotations (%) to shift notebook runtimes between resources (local/remote).

### Before Integration

- Create a virtual environment
  ```bash
  python3 -m venv venv
  ```
- Activate the virtual environment
  ```bash
  source venv/bin/activate
  ```
- Install dependencies
  ```bash
  pip install -e .
  ```
- Create a INI file containing server configuration details. For more information refer to default settings file
  [settings.ini](airavata_sdk/transport/settings.ini)

### Generating Distribution Archives (Optional)

You can generate a `*.tar.gz` distribution and install to any external project.
- Make sure you have the latest versions of `build` and `setuptools` installed
  ```bash
  python3 -m pip install --upgrade build setuptools
  ```
- Now run this command from the same directory where `pyproject.toml` is located
  ```bash
  python3 -m build .
  ```
- This command should output a lot of text and once completed should generate two files in the dist directory
  ```
  dist/
      airavata_python_sdk-2.0.0-py2.py3-none-any.whl
      airavata-python-sdk-2.0.0.tar.gz
  ```

Now, you should be able to install those packages into your project.