# micromagneticdata
Marijan Beg<sup>1,2</sup>, Martin Lang<sup>1</sup>, and Hans Fangohr<sup>1,2,3</sup>

<sup>1</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, United Kingdom*  
<sup>2</sup> *European XFEL GmbH, Holzkoppel 4, 22869 Schenefeld, Germany*  
<sup>3</sup> *Max Planck Institute for the Structure and Dynamics of Matter, Luruper Chaussee 149, 22761 Hamburg, Germany*

| Description | Badge |
| --- | --- |
| Tests | [![workflow](https://github.com/ubermag/micromagneticdata/workflows/workflow/badge.svg)](https://github.com/ubermag/micromagneticdata/actions?query=workflow%3Aworkflow) |
|       | [![conda](https://github.com/ubermag/micromagneticdata/workflows/conda/badge.svg)](https://github.com/ubermag/micromagneticdata/actions?query=workflow%3Aconda) |
| Releases | [![PyPI version](https://badge.fury.io/py/micromagneticdata.svg)](https://badge.fury.io/py/micromagneticdata) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/micromagneticdata/badges/version.svg)](https://anaconda.org/conda-forge/micromagneticdata) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/micromagneticdata/branch/master/graph/badge.svg?token=Z1IbgwsLjy)](https://codecov.io/gh/ubermag/micromagneticdata) |
| Documentation | [![Documentation Status](https://readthedocs.org/projects/micromagneticdata/badge/?version=latest)](https://micromagneticdata.readthedocs.io/en/latest/?badge=latest) |
| YouTube | [![YouTube](https://img.shields.io/badge/YouTube-ubermag-blue)](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/micromagneticdata/HEAD?urlpath=lab/tree/docs/ipynb/index.ipynb) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/micromagneticdata/badges/platforms.svg)](https://anaconda.org/conda-forge/micromagneticdata) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/micromagneticdata/badges/downloads.svg)](https://anaconda.org/conda-forge/micromagneticdata) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | Coming soon... |

## About

`micromagneticdata` is a Python package, integrated into Jupyter, providing:

- The analysis of computational magnetism data.

It is available on Windows, MacOS, and Linux. It requires Python 3.8+.

## Documentation

APIs and tutorials are available in the documentation. To access the documentation, use the badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the documentation.

## Binder

This package can be used in the cloud via Binder. To access Binder, use the badge in the table above.

## YouTube

YouTube video tutorials are available on the [Ubermag channel](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg).

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## Contributions

All contributions are welcome, however small they are. If you would like to contribute, please fork the repository and create a pull request. If you are not sure how to contribute, please contact us by raising an issue in [ubermag/help](https://github.com/ubermag/help) repository, and we are going to help you get started and assist you on the way.

**Contributors**:

- Sergii Mamedov ([@sergii-mamedov](https://github.com/sergii-mamedov)), European XFEL, Germany

## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

1. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025](http://aip.scitation.org/doi/10.1063/1.4977225) (2017).

2. DOI will be available soon...

## Acknowledgements

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme Grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1)
