# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/argoproj/argo-workflows/v3.4.4/api/openapi-spec/swagger.json

from __future__ import annotations

from typing import Dict, List, Optional

from pydantic import Field

from hera.shared._base_model import BaseModel

from ...k8s.api.core import v1
from ...k8s.apimachinery.pkg.apis.meta import v1 as v1_1


class AMQPConsumeConfig(BaseModel):
    auto_ack: Optional[bool] = Field(
        None,
        alias="autoAck",
        title=(
            "AutoAck when true, the server will acknowledge deliveries to this consumer prior to writing\nthe delivery"
            " to the network\n+optional"
        ),
    )
    consumer_tag: Optional[str] = Field(
        None,
        alias="consumerTag",
        title="ConsumerTag is the identity of the consumer included in every delivery\n+optional",
    )
    exclusive: Optional[bool] = Field(
        None,
        title="Exclusive when true, the server will ensure that this is the sole consumer from this queue\n+optional",
    )
    no_local: Optional[bool] = Field(
        None, alias="noLocal", title="NoLocal flag is not supported by RabbitMQ\n+optional"
    )
    no_wait: Optional[bool] = Field(
        None,
        alias="noWait",
        title=(
            "NowWait when true, do not wait for the server to confirm the request and immediately begin"
            " deliveries\n+optional"
        ),
    )


class AMQPExchangeDeclareConfig(BaseModel):
    auto_delete: Optional[bool] = Field(
        None, alias="autoDelete", title="AutoDelete removes the exchange when no bindings are active\n+optional"
    )
    durable: Optional[bool] = Field(None, title="Durable keeps the exchange also after the server restarts\n+optional")
    internal: Optional[bool] = Field(None, title="Internal when true does not accept publishings\n+optional")
    no_wait: Optional[bool] = Field(
        None, alias="noWait", title="NowWait when true does not wait for a confirmation from the server\n+optional"
    )


class AMQPQueueBindConfig(BaseModel):
    no_wait: Optional[bool] = Field(
        None,
        alias="noWait",
        title="NowWait false and the queue could not be bound, the channel will be closed with an error\n+optional",
    )


class AMQPQueueDeclareConfig(BaseModel):
    arguments: Optional[str] = Field(
        None,
        title='Arguments of a queue (also known as "x-arguments") used for optional features and plugins\n+optional',
    )
    auto_delete: Optional[bool] = Field(
        None, alias="autoDelete", title="AutoDelete removes the queue when no consumers are active\n+optional"
    )
    durable: Optional[bool] = Field(None, title="Durable keeps the queue also after the server restarts\n+optional")
    exclusive: Optional[bool] = Field(
        None,
        title=(
            "Exclusive sets the queues to be accessible only by the connection that declares them and will be\ndeleted"
            " wgen the connection closes\n+optional"
        ),
    )
    name: Optional[str] = Field(
        None, title="Name of the queue. If empty the server auto-generates a unique name for this queue\n+optional"
    )
    no_wait: Optional[bool] = Field(
        None, alias="noWait", title="NowWait when true, the queue assumes to be declared on the server\n+optional"
    )


class Amount(BaseModel):
    value: Optional[str] = None


class BitbucketRepository(BaseModel):
    owner: Optional[str] = Field(None, title="Owner is the owner of the repository")
    repository_slug: Optional[str] = Field(
        None,
        alias="repositorySlug",
        title=(
            "RepositorySlug is a URL-friendly version of a repository name, automatically generated by Bitbucket for"
            " use in the URL"
        ),
    )


class BitbucketServerRepository(BaseModel):
    project_key: Optional[str] = Field(
        None, alias="projectKey", title="ProjectKey is the key of project for which integration needs to set up"
    )
    repository_slug: Optional[str] = Field(
        None,
        alias="repositorySlug",
        title="RepositorySlug is the slug of the repository for which integration needs to set up",
    )


class CatchupConfiguration(BaseModel):
    enabled: Optional[bool] = Field(
        None, title="Enabled enables to triggered the missed schedule when eventsource restarts"
    )
    max_duration: Optional[str] = Field(None, alias="maxDuration", title="MaxDuration holds max catchup duration")


class ConditionsResetByTime(BaseModel):
    cron: Optional[str] = Field(
        None, title="Cron is a cron-like expression. For reference, see: https://en.wikipedia.org/wiki/Cron"
    )
    timezone: Optional[str] = Field(None, title="+optional")


class ConditionsResetCriteria(BaseModel):
    by_time: Optional[ConditionsResetByTime] = Field(
        None,
        alias="byTime",
        title="Schedule is a cron-like expression. For reference, see: https://en.wikipedia.org/wiki/Cron",
    )


class ConfigMapPersistence(BaseModel):
    create_if_not_exist: Optional[bool] = Field(
        None, alias="createIfNotExist", title="CreateIfNotExist will create configmap if it doesn't exists"
    )
    name: Optional[str] = Field(None, title="Name of the configmap")


class DataFilter(BaseModel):
    comparator: Optional[str] = Field(
        None,
        description=(
            'Comparator compares the event data with a user given value.\nCan be ">=", ">", "=", "!=", "<", or'
            ' "<=".\nIs optional, and if left blank treated as equality "=".'
        ),
    )
    path: Optional[str] = Field(
        None,
        description=(
            "Path is the JSONPath of the event's (JSON decoded) data key\nPath is a series of keys separated by a dot."
            " A key may contain wildcard characters '*' and '?'.\nTo access an array value use the index as the key."
            " The dot and wildcard characters can be escaped with '\\\\'.\nSee"
            " https://github.com/tidwall/gjson#path-syntax for more information on how to use this."
        ),
    )
    template: Optional[str] = Field(
        None,
        title=(
            "Template is a go-template for extracting a string from the event's data.\nA Template is evaluated with"
            " provided path, type and value.\nThe templating follows the standard go-template syntax as well as"
            " sprig's extra functions.\nSee https://pkg.go.dev/text/template and https://masterminds.github.io/sprig/"
        ),
    )
    type: Optional[str] = Field(None, title="Type contains the JSON type of the data")
    value: Optional[List[str]] = Field(
        None,
        title=(
            "Value is the allowed string values for this key\nBooleans are passed using strconv.ParseBool()\nNumbers"
            " are parsed using as float64 using strconv.ParseFloat()\nStrings are taken as is\nNils this value is"
            " ignored"
        ),
    )


class EventDependencyTransformer(BaseModel):
    jq: Optional[str] = Field(None, title="JQ holds the jq command applied for transformation\n+optional")
    script: Optional[str] = Field(None, title="Script refers to a Lua script used to transform the event\n+optional")


class EventPersistence(BaseModel):
    catchup: Optional[CatchupConfiguration] = Field(
        None, title="Catchup enables to triggered the missed schedule when eventsource restarts"
    )
    config_map: Optional[ConfigMapPersistence] = Field(
        None, alias="configMap", title="ConfigMap holds configmap details for persistence"
    )


class EventSourceFilter(BaseModel):
    expression: Optional[str] = None


class FileArtifact(BaseModel):
    path: Optional[str] = None


class GitRemoteConfig(BaseModel):
    name: Optional[str] = Field(None, description="Name of the remote to fetch from.")
    urls: Optional[List[str]] = Field(
        None,
        description=(
            "URLs the URLs of a remote repository. It must be non-empty. Fetch will\nalways use the first URL, while"
            " push will use all of them."
        ),
    )


class Int64OrString(BaseModel):
    int64_val: Optional[str] = Field(None, alias="int64Val")
    str_val: Optional[str] = Field(None, alias="strVal")
    type: Optional[str] = None


class KafkaConsumerGroup(BaseModel):
    group_name: Optional[str] = Field(None, alias="groupName", title="The name for the consumer group to use")
    oldest: Optional[bool] = Field(
        None,
        title=(
            "When starting up a new group do we want to start from the oldest event (true) or the newest event"
            " (false), defaults to false\n+optional"
        ),
    )
    rebalance_strategy: Optional[str] = Field(
        None,
        alias="rebalanceStrategy",
        title="Rebalance strategy can be one of: sticky, roundrobin, range. Range is the default.\n+optional",
    )


class LogTrigger(BaseModel):
    interval_seconds: Optional[str] = Field(
        None,
        alias="intervalSeconds",
        title=(
            "Only print messages every interval. Useful to prevent logging too much data for busy events.\n+optional"
        ),
    )


class Metadata(BaseModel):
    annotations: Optional[Dict[str, str]] = None
    labels: Optional[Dict[str, str]] = None


class OwnedRepositories(BaseModel):
    names: Optional[List[str]] = Field(None, title="Repository names")
    owner: Optional[str] = Field(None, title="Organization or user name")


class PayloadField(BaseModel):
    name: Optional[str] = Field(None, description="Name acts as key that holds the value at the path.")
    path: Optional[str] = Field(
        None,
        description=(
            "Path is the JSONPath of the event's (JSON decoded) data key\nPath is a series of keys separated by a dot."
            " A key may contain wildcard characters '*' and '?'.\nTo access an array value use the index as the key."
            " The dot and wildcard characters can be escaped with '\\\\'.\nSee"
            " https://github.com/tidwall/gjson#path-syntax for more information on how to use this."
        ),
    )


class RateLimit(BaseModel):
    requests_per_unit: Optional[int] = Field(None, alias="requestsPerUnit")
    unit: Optional[str] = Field(None, title="Defaults to Second")


class Resource(BaseModel):
    value: Optional[str] = None


class S3Bucket(BaseModel):
    key: Optional[str] = None
    name: Optional[str] = None


class S3Filter(BaseModel):
    prefix: Optional[str] = None
    suffix: Optional[str] = None


class Selector(BaseModel):
    key: Optional[str] = Field(None, title="Key name")
    operation: Optional[str] = Field(
        None,
        title=(
            "Supported operations like ==, !=, <=, >= etc.\nDefaults to ==.\nRefer"
            " https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors for more"
            " io.argoproj.workflow.v1alpha1.\n+optional"
        ),
    )
    value: Optional[str] = Field(None, title="Value")


class StatusPolicy(BaseModel):
    allow: Optional[List[int]] = None


class StorageGridFilter(BaseModel):
    prefix: Optional[str] = None
    suffix: Optional[str] = None


class TimeFilter(BaseModel):
    start: Optional[str] = Field(
        None,
        description=(
            "Start is the beginning of a time window in UTC.\nBefore this time, events for this dependency are"
            " ignored.\nFormat is hh:mm:ss."
        ),
    )
    stop: Optional[str] = Field(
        None,
        description=(
            "Stop is the end of a time window in UTC.\nAfter or equal to this time, events for this dependency are"
            " ignored and\nFormat is hh:mm:ss.\nIf it is smaller than Start, it is treated as next day of"
            " Start\n(e.g.: 22:00:00-01:00:00 means 22:00:00-25:00:00)."
        ),
    )


class TriggerParameterSource(BaseModel):
    context_key: Optional[str] = Field(
        None,
        alias="contextKey",
        description=(
            "ContextKey is the JSONPath of the event's (JSON decoded) context key\nContextKey is a series of keys"
            " separated by a dot. A key may contain wildcard characters '*' and '?'.\nTo access an array value use the"
            " index as the key. The dot and wildcard characters can be escaped with '\\\\'.\nSee"
            " https://github.com/tidwall/gjson#path-syntax for more information on how to use this."
        ),
    )
    context_template: Optional[str] = Field(
        None,
        alias="contextTemplate",
        title=(
            "ContextTemplate is a go-template for extracting a string from the event's context.\nIf a ContextTemplate"
            " is provided with a ContextKey, the template will be evaluated first and fallback to the ContextKey.\nThe"
            " templating follows the standard go-template syntax as well as sprig's extra functions.\nSee"
            " https://pkg.go.dev/text/template and https://masterminds.github.io/sprig/"
        ),
    )
    data_key: Optional[str] = Field(
        None,
        alias="dataKey",
        description=(
            "DataKey is the JSONPath of the event's (JSON decoded) data key\nDataKey is a series of keys separated by"
            " a dot. A key may contain wildcard characters '*' and '?'.\nTo access an array value use the index as the"
            " key. The dot and wildcard characters can be escaped with '\\\\'.\nSee"
            " https://github.com/tidwall/gjson#path-syntax for more information on how to use this."
        ),
    )
    data_template: Optional[str] = Field(
        None,
        alias="dataTemplate",
        title=(
            "DataTemplate is a go-template for extracting a string from the event's data.\nIf a DataTemplate is"
            " provided with a DataKey, the template will be evaluated first and fallback to the DataKey.\nThe"
            " templating follows the standard go-template syntax as well as sprig's extra functions.\nSee"
            " https://pkg.go.dev/text/template and https://masterminds.github.io/sprig/"
        ),
    )
    dependency_name: Optional[str] = Field(
        None,
        alias="dependencyName",
        description=(
            "DependencyName refers to the name of the dependency. The event which is stored for this dependency is"
            " used as payload\nfor the parameterization. Make sure to refer to one of the dependencies you have"
            " defined under Dependencies list."
        ),
    )
    value: Optional[str] = Field(
        None,
        description=(
            "Value is the default literal value to use for this parameter source\nThis is only used if the DataKey is"
            " invalid.\nIf the DataKey is invalid and this is not defined, this param source will produce an error."
        ),
    )


class URLArtifact(BaseModel):
    path: Optional[str] = Field(None, title="Path is the complete URL")
    verify_cert: Optional[bool] = Field(
        None, alias="verifyCert", title="VerifyCert decides whether the connection is secure or not"
    )


class WatchPathConfig(BaseModel):
    directory: Optional[str] = Field(None, title="Directory to watch for events")
    path: Optional[str] = Field(None, title="Path is relative path of object to watch with respect to the directory")
    path_regexp: Optional[str] = Field(
        None,
        alias="pathRegexp",
        title="PathRegexp is regexp of relative path of object to watch with respect to the directory",
    )


class AzureEventsHubEventSource(BaseModel):
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    fqdn: Optional[str] = Field(
        None,
        title=(
            "FQDN of the EventHubs namespace you created\nMore info at"
            " https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string"
        ),
    )
    hub_name: Optional[str] = Field(None, alias="hubName", title="Event Hub path/name")
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    shared_access_key: Optional[v1.SecretKeySelector] = Field(
        None, alias="sharedAccessKey", title="SharedAccessKey is the generated value of the key"
    )
    shared_access_key_name: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="sharedAccessKeyName",
        title="SharedAccessKeyName is the name you chose for your application's SAS keys",
    )


class Backoff(BaseModel):
    duration: Optional[Int64OrString] = Field(
        None, title='The initial duration in nanoseconds or strings like "1s", "3m"\n+optional'
    )
    factor: Optional[Amount] = Field(None, title="Duration is multiplied by factor each iteration\n+optional")
    jitter: Optional[Amount] = Field(None, title="The amount of jitter applied each iteration\n+optional")
    steps: Optional[int] = Field(None, title="Exit with error after this many steps\n+optional")


class BasicAuth(BaseModel):
    password: Optional[v1.SecretKeySelector] = Field(
        None, description="Password refers to the Kubernetes secret that holds the password required for basic auth."
    )
    username: Optional[v1.SecretKeySelector] = Field(
        None, description="Username refers to the Kubernetes secret that holds the username required for basic auth."
    )


class BitbucketBasicAuth(BaseModel):
    password: Optional[v1.SecretKeySelector] = Field(
        None, description="Password refers to the K8s secret that holds the password."
    )
    username: Optional[v1.SecretKeySelector] = Field(
        None, description="Username refers to the K8s secret that holds the username."
    )


class CalendarEventSource(BaseModel):
    exclusion_dates: Optional[List[str]] = Field(
        None,
        alias="exclusionDates",
        description="ExclusionDates defines the list of DATE-TIME exceptions for recurring events.",
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    interval: Optional[str] = Field(
        None, title="Interval is a string that describes an interval duration, e.g. 1s, 30m, 2h...\n+optional"
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    persistence: Optional[EventPersistence] = Field(
        None, title="Persistence hold the configuration for event persistence"
    )
    schedule: Optional[str] = Field(
        None,
        title="Schedule is a cron-like expression. For reference, see: https://en.wikipedia.org/wiki/Cron\n+optional",
    )
    timezone: Optional[str] = Field(None, title="Timezone in which to run the schedule\n+optional")


class Condition(BaseModel):
    last_transition_time: Optional[v1_1.Time] = Field(
        None,
        alias="lastTransitionTime",
        title="Last time the condition transitioned from one status to another.\n+optional",
    )
    message: Optional[str] = Field(
        None, title="Human-readable message indicating details about last transition.\n+optional"
    )
    reason: Optional[str] = Field(
        None,
        title=(
            "Unique, this should be a short, machine understandable string that gives the reason\nfor condition's"
            ' last transition. For example, "ImageNotFound"\n+optional'
        ),
    )
    status: Optional[str] = Field(None, title="Condition status, True, False or Unknown.\n+required")
    type: Optional[str] = Field(None, title="Condition type.\n+required")


class EventContext(BaseModel):
    datacontenttype: Optional[str] = Field(
        None, description="DataContentType - A MIME (RFC2046) string describing the media type of `data`."
    )
    id: Optional[str] = Field(
        None, description="ID of the event; must be non-empty and unique within the scope of the producer."
    )
    source: Optional[str] = Field(None, description="Source - A URI describing the event producer.")
    specversion: Optional[str] = Field(
        None,
        description=(
            "SpecVersion - The version of the CloudEvents specification used by the io.argoproj.workflow.v1alpha1."
        ),
    )
    subject: Optional[str] = Field(
        None, title="Subject - The subject of the event in the context of the event producer"
    )
    time: Optional[v1_1.Time] = Field(None, description="Time - A Timestamp when the event happened.")
    type: Optional[str] = Field(None, description="Type - The type of the occurrence which has happened.")


class ExprFilter(BaseModel):
    expr: Optional[str] = Field(
        None, description="Expr refers to the expression that determines the outcome of the filter."
    )
    fields: Optional[List[PayloadField]] = Field(
        None, description="Fields refers to set of keys that refer to the paths within event payload."
    )


class FileEventSource(BaseModel):
    event_type: Optional[str] = Field(
        None,
        alias="eventType",
        title=(
            "Type of file operations to watch\nRefer https://github.com/fsnotify/fsnotify/blob/master/fsnotify.go for"
            " more information"
        ),
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    polling: Optional[bool] = Field(None, title="Use polling instead of inotify")
    watch_path_config: Optional[WatchPathConfig] = Field(
        None, alias="watchPathConfig", title="WatchPathConfig contains configuration about the file path to watch"
    )


class GenericEventSource(BaseModel):
    auth_secret: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="authSecret",
        title="AuthSecret holds a secret selector that contains a bearer token for authentication\n+optional",
    )
    config: Optional[str] = Field(None, title="Config is the event source configuration")
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    insecure: Optional[bool] = Field(None, description="Insecure determines the type of connection.")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    url: Optional[str] = Field(None, description="URL of the gRPC server that implements the event source.")


class GitCreds(BaseModel):
    password: Optional[v1.SecretKeySelector] = None
    username: Optional[v1.SecretKeySelector] = None


class GithubAppCreds(BaseModel):
    app_id: Optional[str] = Field(
        None, alias="appID", title="AppID refers to the GitHub App ID for the application you created"
    )
    installation_id: Optional[str] = Field(
        None,
        alias="installationID",
        title="InstallationID refers to the Installation ID of the GitHub app you created and installed",
    )
    private_key: Optional[v1.SecretKeySelector] = Field(
        None, alias="privateKey", title="PrivateKey refers to a K8s secret containing the GitHub app private key"
    )


class HDFSEventSource(BaseModel):
    addresses: Optional[List[str]] = None
    check_interval: Optional[str] = Field(
        None,
        alias="checkInterval",
        title=(
            "CheckInterval is a string that describes an interval duration to check the directory state, e.g. 1s, 30m,"
            " 2h... (defaults to 1m)"
        ),
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    hdfs_user: Optional[str] = Field(
        None,
        alias="hdfsUser",
        description=(
            "HDFSUser is the user to access HDFS file system.\nIt is ignored if either ccache or keytab is used."
        ),
    )
    krb_c_cache_secret: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="krbCCacheSecret",
        description=(
            "KrbCCacheSecret is the secret selector for Kerberos ccache\nEither ccache or keytab can be set to use"
            " Kerberos."
        ),
    )
    krb_config_config_map: Optional[v1.ConfigMapKeySelector] = Field(
        None,
        alias="krbConfigConfigMap",
        description=(
            "KrbConfig is the configmap selector for Kerberos config as string\nIt must be set if either ccache or"
            " keytab is used."
        ),
    )
    krb_keytab_secret: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="krbKeytabSecret",
        description=(
            "KrbKeytabSecret is the secret selector for Kerberos keytab\nEither ccache or keytab can be set to use"
            " Kerberos."
        ),
    )
    krb_realm: Optional[str] = Field(
        None,
        alias="krbRealm",
        description="KrbRealm is the Kerberos realm used with Kerberos keytab\nIt must be set if keytab is used.",
    )
    krb_service_principal_name: Optional[str] = Field(
        None,
        alias="krbServicePrincipalName",
        description=(
            "KrbServicePrincipalName is the principal name of Kerberos service\nIt must be set if either ccache or"
            " keytab is used."
        ),
    )
    krb_username: Optional[str] = Field(
        None,
        alias="krbUsername",
        description=(
            "KrbUsername is the Kerberos username used with Kerberos keytab\nIt must be set if keytab is used."
        ),
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    type: Optional[str] = Field(None, title="Type of file operations to watch")
    watch_path_config: Optional[WatchPathConfig] = Field(None, alias="watchPathConfig")


class K8SResourcePolicy(BaseModel):
    backoff: Optional[Backoff] = Field(None, title="Backoff before checking resource state")
    error_on_backoff_timeout: Optional[bool] = Field(
        None,
        alias="errorOnBackoffTimeout",
        title=(
            "ErrorOnBackoffTimeout determines whether sensor should transition to error state if the trigger policy is"
            " unable to determine\nthe state of the resource"
        ),
    )
    labels: Optional[Dict[str, str]] = Field(
        None, title="Labels required to identify whether a resource is in success state"
    )


class NATSAuth(BaseModel):
    basic: Optional[BasicAuth] = Field(None, title="Baisc auth with username and password\n+optional")
    credential: Optional[v1.SecretKeySelector] = Field(None, title="credential used to connect\n+optional")
    nkey: Optional[v1.SecretKeySelector] = Field(None, title="NKey used to connect\n+optional")
    token: Optional[v1.SecretKeySelector] = Field(None, title="Token used to connect\n+optional")


class PubSubEventSource(BaseModel):
    credential_secret: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="credentialSecret",
        title=(
            "CredentialSecret references to the secret that contains JSON credentials to access GCP.\nIf it is"
            " missing, it implicitly uses Workload Identity to"
            " access.\nhttps://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity\n+optional"
        ),
    )
    delete_subscription_on_finish: Optional[bool] = Field(
        None,
        alias="deleteSubscriptionOnFinish",
        title=(
            "DeleteSubscriptionOnFinish determines whether to delete the GCP PubSub subscription once the event source"
            " is stopped.\n+optional"
        ),
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectID",
        title=(
            "ProjectID is GCP project ID for the subscription.\nRequired if you run Argo Events outside of"
            " GKE/GCE.\n(otherwise, the default value is its project)\n+optional"
        ),
    )
    subscription_id: Optional[str] = Field(
        None,
        alias="subscriptionID",
        title=(
            "SubscriptionID is ID of subscription.\nRequired if you use existing subscription.\nThe default value will"
            " be auto generated hash based on this eventsource setting, so the subscription\nmight be recreated every"
            " time you update the setting, which has a possibility of event loss.\n+optional"
        ),
    )
    topic: Optional[str] = Field(
        None,
        title=(
            "Topic to which the subscription should belongs.\nRequired if you want the eventsource to create a new"
            " subscription.\nIf you specify this field along with an existing subscription,\nit will be verified"
            " whether it actually belongs to the specified topic.\n+optional"
        ),
    )
    topic_project_id: Optional[str] = Field(
        None,
        alias="topicProjectID",
        title="TopicProjectID is GCP project ID for the topic.\nBy default, it is same as ProjectID.\n+optional",
    )


class ResourceFilter(BaseModel):
    after_start: Optional[bool] = Field(
        None,
        alias="afterStart",
        title="If the resource is created after the start time then the event is treated as valid.\n+optional",
    )
    created_by: Optional[v1_1.Time] = Field(
        None,
        alias="createdBy",
        title="If resource is created before the specified time then the event is treated as valid.\n+optional",
    )
    fields: Optional[List[Selector]] = Field(
        None,
        title=(
            "Fields provide field filters similar to K8s field selector\n(see"
            " https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors/).\nUnlike K8s field"
            ' selector, it supports arbitrary fileds like "spec.serviceAccountName",\nand the value could be a string'
            ' or a regex.\nSame as K8s field selector, operator "=", "==" and "!=" are supported.\n+optional'
        ),
    )
    labels: Optional[List[Selector]] = Field(
        None,
        title=(
            "Labels provide listing options to K8s API to watch resource/s.\nRefer"
            " https://kubernetes.io/docs/concepts/overview/working-with-objects/label-selectors/ for more"
            " io.argoproj.workflow.v1alpha1.\n+optional"
        ),
    )
    prefix: Optional[str] = Field(None, title="Prefix filter is applied on the resource name.\n+optional")


class S3Artifact(BaseModel):
    access_key: Optional[v1.SecretKeySelector] = Field(None, alias="accessKey")
    bucket: Optional[S3Bucket] = None
    endpoint: Optional[str] = None
    events: Optional[List[str]] = None
    filter: Optional[S3Filter] = None
    insecure: Optional[bool] = None
    metadata: Optional[Dict[str, str]] = None
    region: Optional[str] = None
    secret_key: Optional[v1.SecretKeySelector] = Field(None, alias="secretKey")


class SASLConfig(BaseModel):
    mechanism: Optional[str] = Field(
        None,
        title=(
            "SASLMechanism is the name of the enabled SASL mechanism.\nPossible values: OAUTHBEARER, PLAIN (defaults"
            " to PLAIN).\n+optional"
        ),
    )
    password: Optional[v1.SecretKeySelector] = Field(None, title="Password for SASL/PLAIN authentication")
    user: Optional[v1.SecretKeySelector] = Field(
        None,
        title="User is the authentication identity (authcid) to present for\nSASL/PLAIN or SASL/SCRAM authentication",
    )


class SQSEventSource(BaseModel):
    access_key: Optional[v1.SecretKeySelector] = Field(
        None, alias="accessKey", title="AccessKey refers K8s secret containing aws access key"
    )
    dlq: Optional[bool] = Field(
        None,
        title=(
            "DLQ specifies if a dead-letter queue is configured for messages that can't be processed successfully.\nIf"
            " set to true, messages with invalid payload won't be acknowledged to allow to forward them farther to the"
            " dead-letter queue.\nThe default value is false.\n+optional"
        ),
    )
    endpoint: Optional[str] = Field(
        None, title="Endpoint configures connection to a specific SQS endpoint instead of Amazons servers\n+optional"
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    queue: Optional[str] = Field(None, title="Queue is AWS SQS queue to listen to for messages")
    queue_account_id: Optional[str] = Field(
        None,
        alias="queueAccountId",
        title="QueueAccountID is the ID of the account that created the queue to monitor\n+optional",
    )
    region: Optional[str] = Field(None, title="Region is AWS region")
    role_arn: Optional[str] = Field(
        None, alias="roleARN", title="RoleARN is the Amazon Resource Name (ARN) of the role to assume.\n+optional"
    )
    secret_key: Optional[v1.SecretKeySelector] = Field(
        None, alias="secretKey", title="SecretKey refers K8s secret containing aws secret key"
    )
    session_token: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="sessionToken",
        title="SessionToken refers to K8s secret containing AWS temporary credentials(STS) session token\n+optional",
    )
    wait_time_seconds: Optional[str] = Field(
        None,
        alias="waitTimeSeconds",
        description=(
            "WaitTimeSeconds is The duration (in seconds) for which the call waits for a message to arrive\nin the"
            " queue before returning."
        ),
    )


class Status(BaseModel):
    conditions: Optional[List[Condition]] = Field(
        None,
        title=(
            "Conditions are the latest available observations of a resource's current"
            " state.\n+optional\n+patchMergeKey=type\n+patchStrategy=merge"
        ),
    )


class TLSConfig(BaseModel):
    ca_cert_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="caCertSecret", title="CACertSecret refers to the secret that contains the CA cert"
    )
    client_cert_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="clientCertSecret", title="ClientCertSecret refers to the secret that contains the client cert"
    )
    client_key_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="clientKeySecret", title="ClientKeySecret refers to the secret that contains the client key"
    )
    insecure_skip_verify: Optional[bool] = Field(
        None,
        alias="insecureSkipVerify",
        title=(
            "If true, skips creation of TLSConfig with certs and creates an empty TLSConfig. (Defaults to"
            " false)\n+optional"
        ),
    )


class TriggerParameter(BaseModel):
    dest: Optional[str] = Field(
        None,
        description=(
            "Dest is the JSONPath of a resource key.\nA path is a series of keys separated by a dot. The colon"
            " character can be escaped with '.'\nThe -1 key can be used to append a value to an existing array.\nSee"
            " https://github.com/tidwall/sjson#path-syntax for more information about how this is used."
        ),
    )
    operation: Optional[str] = Field(
        None,
        description=(
            "Operation is what to do with the existing value at Dest, whether to\n'prepend', 'overwrite', or"
            " 'append' it."
        ),
    )
    src: Optional[TriggerParameterSource] = Field(
        None, title="Src contains a source reference to the value of the parameter from a dependency"
    )


class TriggerPolicy(BaseModel):
    k8s: Optional[K8SResourcePolicy] = Field(
        None,
        title=(
            "K8SResourcePolicy refers to the policy used to check the state of K8s based triggers using using labels"
        ),
    )
    status: Optional[StatusPolicy] = Field(
        None, title="Status refers to the policy used to check the state of the trigger using response status"
    )


class ValueFromSource(BaseModel):
    config_map_key_ref: Optional[v1.ConfigMapKeySelector] = Field(None, alias="configMapKeyRef")
    secret_key_ref: Optional[v1.SecretKeySelector] = Field(None, alias="secretKeyRef")


class WebhookContext(BaseModel):
    auth_secret: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="authSecret",
        title="AuthSecret holds a secret selector that contains a bearer token for authentication\n+optional",
    )
    endpoint: Optional[str] = Field(None, title="REST API endpoint")
    max_payload_size: Optional[str] = Field(
        None,
        alias="maxPayloadSize",
        title=(
            "MaxPayloadSize is the maximum webhook payload size that the server will accept.\nRequests exceeding that"
            ' limit will be rejected with "request too large" response.\nDefault value: 1048576 (1MB).\n+optional'
        ),
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    method: Optional[str] = Field(
        None,
        title=(
            "Method is HTTP request method that indicates the desired action to be performed for a given"
            " resource.\nSee RFC7231 Hypertext Transfer Protocol (HTTP/1.1): Semantics and Content"
        ),
    )
    port: Optional[str] = Field(None, description="Port on which HTTP server is listening for incoming events.")
    server_cert_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="serverCertSecret", description="ServerCertPath refers the file that contains the cert."
    )
    server_key_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="serverKeySecret", title="ServerKeyPath refers the file that contains private key"
    )
    url: Optional[str] = Field(None, description="URL is the url of the server.")


class WebhookEventSource(BaseModel):
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    webhook_context: Optional[WebhookContext] = Field(None, alias="webhookContext")


class AMQPEventSource(BaseModel):
    auth: Optional[BasicAuth] = Field(None, title="Auth hosts secret selectors for username and password\n+optional")
    connection_backoff: Optional[Backoff] = Field(
        None, alias="connectionBackoff", title="Backoff holds parameters applied to connection.\n+optional"
    )
    consume: Optional[AMQPConsumeConfig] = Field(
        None,
        title=(
            "Consume holds the configuration to immediately starts delivering queued messages\nFor more information,"
            " visit https://pkg.go.dev/github.com/rabbitmq/amqp091-go#Channel.Consume\n+optional"
        ),
    )
    exchange_declare: Optional[AMQPExchangeDeclareConfig] = Field(
        None,
        alias="exchangeDeclare",
        title=(
            "ExchangeDeclare holds the configuration for the exchange on the server\nFor more information, visit"
            " https://pkg.go.dev/github.com/rabbitmq/amqp091-go#Channel.ExchangeDeclare\n+optional"
        ),
    )
    exchange_name: Optional[str] = Field(
        None,
        alias="exchangeName",
        title=(
            "ExchangeName is the exchange name\nFor more information, visit"
            " https://www.rabbitmq.com/tutorials/amqp-concepts.html"
        ),
    )
    exchange_type: Optional[str] = Field(None, alias="exchangeType", title="ExchangeType is rabbitmq exchange type")
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    queue_bind: Optional[AMQPQueueBindConfig] = Field(
        None,
        alias="queueBind",
        title=(
            "QueueBind holds the configuration that binds an exchange to a queue so that publishings to the\nexchange"
            " will be routed to the queue when the publishing routing key matches the binding routing key\nFor more"
            " information, visit https://pkg.go.dev/github.com/rabbitmq/amqp091-go#Channel.QueueBind\n+optional"
        ),
    )
    queue_declare: Optional[AMQPQueueDeclareConfig] = Field(
        None,
        alias="queueDeclare",
        title=(
            "QueueDeclare holds the configuration of a queue to hold messages and deliver to consumers.\nDeclaring"
            " creates a queue if it doesn't already exist, or ensures that an existing queue matches\nthe same"
            " parameters\nFor more information, visit"
            " https://pkg.go.dev/github.com/rabbitmq/amqp091-go#Channel.QueueDeclare\n+optional"
        ),
    )
    routing_key: Optional[str] = Field(None, alias="routingKey", title="Routing key for bindings")
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the amqp client.\n+optional")
    url: Optional[str] = Field(None, title="URL for rabbitmq service")
    url_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="urlSecret", title="URLSecret is secret reference for rabbitmq service URL"
    )


class AWSLambdaTrigger(BaseModel):
    access_key: Optional[v1.SecretKeySelector] = Field(
        None, alias="accessKey", title="AccessKey refers K8s secret containing aws access key\n+optional"
    )
    function_name: Optional[str] = Field(
        None, alias="functionName", description="FunctionName refers to the name of the function to invoke."
    )
    invocation_type: Optional[str] = Field(
        None,
        alias="invocationType",
        description=(
            "Choose from the following options.\n\n   * RequestResponse (default) - Invoke the function synchronously."
            " Keep\n   the connection open until the function returns a response or times out.\n   The API response"
            " includes the function response and additional data.\n\n   * Event - Invoke the function asynchronously."
            " Send events that fail multiple\n   times to the function's dead-letter queue (if it's configured). The"
            " API\n   response only includes a status code.\n\n   * DryRun - Validate parameter values and verify that"
            " the user or role\n   has permission to invoke the function.\n+optional"
        ),
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None,
        title=(
            "Parameters is the list of key-value extracted from event's payload that are applied to\nthe trigger"
            " resource.\n+optional"
        ),
    )
    payload: Optional[List[TriggerParameter]] = Field(
        None,
        description=(
            "Payload is the list of key-value extracted from an event payload to construct the request payload."
        ),
    )
    region: Optional[str] = Field(None, title="Region is AWS region")
    role_arn: Optional[str] = Field(
        None, alias="roleARN", title="RoleARN is the Amazon Resource Name (ARN) of the role to assume.\n+optional"
    )
    secret_key: Optional[v1.SecretKeySelector] = Field(
        None, alias="secretKey", title="SecretKey refers K8s secret containing aws secret key\n+optional"
    )


class AzureEventHubsTrigger(BaseModel):
    fqdn: Optional[str] = Field(
        None,
        title=(
            "FQDN refers to the namespace dns of Azure Event Hubs to be used i.e. <namespace>.servicebus.windows.net"
        ),
    )
    hub_name: Optional[str] = Field(
        None, alias="hubName", title="HubName refers to the Azure Event Hub to send events to"
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None,
        title=(
            "Parameters is the list of key-value extracted from event's payload that are applied to\nthe trigger"
            " resource.\n+optional"
        ),
    )
    payload: Optional[List[TriggerParameter]] = Field(
        None,
        description=(
            "Payload is the list of key-value extracted from an event payload to construct the request payload."
        ),
    )
    shared_access_key: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="sharedAccessKey",
        title="SharedAccessKey refers to a K8s secret containing the primary key for the",
    )
    shared_access_key_name: Optional[v1.SecretKeySelector] = Field(
        None, alias="sharedAccessKeyName", title="SharedAccessKeyName refers to the name of the Shared Access Key"
    )


class BitbucketAuth(BaseModel):
    basic: Optional[BitbucketBasicAuth] = Field(None, title="Basic is BasicAuth auth strategy.\n+optional")
    oauth_token: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="oauthToken",
        title="OAuthToken refers to the K8s secret that holds the OAuth Bearer token.\n+optional",
    )


class BitbucketEventSource(BaseModel):
    auth: Optional[BitbucketAuth] = Field(None, description="Auth information required to connect to Bitbucket.")
    delete_hook_on_finish: Optional[bool] = Field(
        None,
        alias="deleteHookOnFinish",
        title=(
            "DeleteHookOnFinish determines whether to delete the defined Bitbucket hook once the event source is"
            " stopped.\n+optional"
        ),
    )
    events: Optional[List[str]] = Field(None, description="Events this webhook is subscribed to.")
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will be passed along the event payload.\n+optional"
    )
    owner: Optional[str] = Field(
        None,
        title=(
            "DeprecatedOwner is the owner of the repository.\nDeprecated: use Repositories instead. Will be"
            " unsupported in v1.9\n+optional"
        ),
    )
    project_key: Optional[str] = Field(
        None,
        alias="projectKey",
        title=(
            "DeprecatedProjectKey is the key of the project to which the repository relates\nDeprecated: use"
            " Repositories instead. Will be unsupported in v1.9\n+optional"
        ),
    )
    repositories: Optional[List[BitbucketRepository]] = Field(
        None, title="Repositories holds a list of repositories for which integration needs to set up\n+optional"
    )
    repository_slug: Optional[str] = Field(
        None,
        alias="repositorySlug",
        title=(
            "DeprecatedRepositorySlug is a URL-friendly version of a repository name, automatically generated by"
            " Bitbucket for use in the URL\nDeprecated: use Repositories instead. Will be unsupported in"
            " v1.9\n+optional"
        ),
    )
    webhook: Optional[WebhookContext] = Field(
        None, title="Webhook refers to the configuration required to run an http server"
    )


class BitbucketServerEventSource(BaseModel):
    access_token: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="accessToken",
        title="AccessToken is reference to K8s secret which holds the bitbucket api access information",
    )
    bitbucketserver_base_url: Optional[str] = Field(
        None,
        alias="bitbucketserverBaseURL",
        title="BitbucketServerBaseURL is the base URL for API requests to a custom endpoint",
    )
    delete_hook_on_finish: Optional[bool] = Field(
        None,
        alias="deleteHookOnFinish",
        title=(
            "DeleteHookOnFinish determines whether to delete the Bitbucket Server hook for the project once the event"
            " source is stopped.\n+optional"
        ),
    )
    events: Optional[List[str]] = Field(
        None,
        title=(
            "Events are bitbucket event to listen to.\nRefer"
            " https://confluence.atlassian.com/bitbucketserver/event-payload-938025882.html"
        ),
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    project_key: Optional[str] = Field(
        None,
        alias="projectKey",
        title=(
            "DeprecatedProjectKey is the key of project for which integration needs to set up\nDeprecated: use"
            " Repositories instead. Will be unsupported in v1.8\n+optional"
        ),
    )
    repositories: Optional[List[BitbucketServerRepository]] = Field(
        None, title="Repositories holds a list of repositories for which integration needs to set up\n+optional"
    )
    repository_slug: Optional[str] = Field(
        None,
        alias="repositorySlug",
        title=(
            "DeprecatedRepositorySlug is the slug of the repository for which integration needs to set up\nDeprecated:"
            " use Repositories instead. Will be unsupported in v1.8\n+optional"
        ),
    )
    webhook: Optional[WebhookContext] = Field(None, title="Webhook holds configuration to run a http server")
    webhook_secret: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="webhookSecret",
        title=(
            "WebhookSecret is reference to K8s secret which holds the bitbucket webhook secret (for HMAC validation)"
        ),
    )


class CustomTrigger(BaseModel):
    cert_secret: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="certSecret",
        description=(
            "CertSecret refers to the secret that contains cert for secure connection between sensor and custom"
            " trigger gRPC server."
        ),
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None,
        description="Parameters is the list of parameters that is applied to resolved custom trigger trigger object.",
    )
    payload: Optional[List[TriggerParameter]] = Field(
        None,
        description=(
            "Payload is the list of key-value extracted from an event payload to construct the request payload."
        ),
    )
    secure: Optional[bool] = Field(
        None, title="Secure refers to type of the connection between sensor to custom trigger gRPC"
    )
    server_name_override: Optional[str] = Field(
        None,
        alias="serverNameOverride",
        description="ServerNameOverride for the secure connection between sensor and custom trigger gRPC server.",
    )
    server_url: Optional[str] = Field(
        None, alias="serverURL", title="ServerURL is the url of the gRPC server that executes custom trigger"
    )
    spec: Optional[Dict[str, str]] = Field(
        None,
        description=(
            "Spec is the custom trigger resource specification that custom trigger gRPC server knows how to interpret."
        ),
    )


class EmitterEventSource(BaseModel):
    broker: Optional[str] = Field(None, description="Broker URI to connect to.")
    channel_key: Optional[str] = Field(None, alias="channelKey", title="ChannelKey refers to the channel key")
    channel_name: Optional[str] = Field(None, alias="channelName", title="ChannelName refers to the channel name")
    connection_backoff: Optional[Backoff] = Field(
        None, alias="connectionBackoff", title="Backoff holds parameters applied to connection.\n+optional"
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    password: Optional[v1.SecretKeySelector] = Field(None, title="Password to use to connect to broker\n+optional")
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the emitter client.\n+optional")
    username: Optional[v1.SecretKeySelector] = Field(None, title="Username to use to connect to broker\n+optional")


class EventDependencyFilter(BaseModel):
    context: Optional[EventContext] = Field(None, title="Context filter constraints")
    data: Optional[List[DataFilter]] = Field(None, title="Data filter constraints with escalation")
    data_logical_operator: Optional[str] = Field(
        None,
        alias="dataLogicalOperator",
        description=(
            "DataLogicalOperator defines how multiple Data filters (if defined) are evaluated together.\nAvailable"
            " values: and (&&), or (||)\nIs optional and if left blank treated as and (&&)."
        ),
    )
    expr_logical_operator: Optional[str] = Field(
        None,
        alias="exprLogicalOperator",
        description=(
            "ExprLogicalOperator defines how multiple Exprs filters (if defined) are evaluated together.\nAvailable"
            " values: and (&&), or (||)\nIs optional and if left blank treated as and (&&)."
        ),
    )
    exprs: Optional[List[ExprFilter]] = Field(
        None, description="Exprs contains the list of expressions evaluated against the event payload."
    )
    script: Optional[str] = Field(
        None,
        description=(
            "Script refers to a Lua script evaluated to determine the validity of an io.argoproj.workflow.v1alpha1."
        ),
    )
    time: Optional[TimeFilter] = Field(None, title="Time filter on the event with escalation")


class EventSourceStatus(BaseModel):
    status: Optional[Status] = None


class GitArtifact(BaseModel):
    branch: Optional[str] = Field(None, title="Branch to use to pull trigger resource\n+optional")
    clone_directory: Optional[str] = Field(
        None,
        alias="cloneDirectory",
        description=(
            "Directory to clone the repository. We clone complete directory because GitArtifact is not limited to any"
            " specific Git service providers.\nHence we don't use any specific git provider client."
        ),
    )
    creds: Optional[GitCreds] = Field(None, title="Creds contain reference to git username and password\n+optional")
    file_path: Optional[str] = Field(
        None, alias="filePath", title="Path to file that contains trigger resource definition"
    )
    insecure_ignore_host_key: Optional[bool] = Field(
        None, alias="insecureIgnoreHostKey", title="Whether to ignore host key\n+optional"
    )
    ref: Optional[str] = Field(
        None, title="Ref to use to pull trigger resource. Will result in a shallow clone and\nfetch.\n+optional"
    )
    remote: Optional[GitRemoteConfig] = Field(
        None,
        title=(
            'Remote to manage set of tracked repositories. Defaults to "origin".\nRefer'
            " https://git-scm.com/docs/git-remote\n+optional"
        ),
    )
    ssh_key_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="sshKeySecret", title="SSHKeySecret refers to the secret that contains SSH key"
    )
    tag: Optional[str] = Field(None, title="Tag to use to pull trigger resource\n+optional")
    url: Optional[str] = Field(None, title="Git URL")


class GithubEventSource(BaseModel):
    active: Optional[bool] = Field(
        None,
        title=(
            "Active refers to status of the webhook for event"
            " deliveries.\nhttps://developer.github.com/webhooks/creating/#active\n+optional"
        ),
    )
    api_token: Optional[v1.SecretKeySelector] = Field(
        None, alias="apiToken", title="APIToken refers to a K8s secret containing github api token\n+optional"
    )
    content_type: Optional[str] = Field(None, alias="contentType", title="ContentType of the event delivery")
    delete_hook_on_finish: Optional[bool] = Field(
        None,
        alias="deleteHookOnFinish",
        title=(
            "DeleteHookOnFinish determines whether to delete the GitHub hook for the repository once the event source"
            " is stopped.\n+optional"
        ),
    )
    events: Optional[List[str]] = Field(
        None, title="Events refer to Github events to which the event source will subscribe"
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    github_app: Optional[GithubAppCreds] = Field(
        None, alias="githubApp", title="GitHubApp holds the GitHub app credentials\n+optional"
    )
    github_base_url: Optional[str] = Field(
        None, alias="githubBaseURL", title="GitHub base URL (for GitHub Enterprise)\n+optional"
    )
    github_upload_url: Optional[str] = Field(
        None, alias="githubUploadURL", title="GitHub upload URL (for GitHub Enterprise)\n+optional"
    )
    id: Optional[str] = Field(
        None, title="Id is the webhook's id\nDeprecated: This is not used at all, will be removed in v1.6\n+optional"
    )
    insecure: Optional[bool] = Field(None, title="Insecure tls verification")
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    organizations: Optional[List[str]] = Field(
        None,
        description=(
            "Organizations holds the names of organizations (used for organization level webhooks). Not required if"
            " Repositories is set."
        ),
    )
    owner: Optional[str] = Field(
        None,
        title=(
            "DeprecatedOwner refers to GitHub owner name i.e. argoproj\nDeprecated: use Repositories instead. Will be"
            " unsupported in v 1.6\n+optional"
        ),
    )
    repositories: Optional[List[OwnedRepositories]] = Field(
        None,
        description=(
            "Repositories holds the information of repositories, which uses repo owner as the key,\nand list of repo"
            " names as the value. Not required if Organizations is set."
        ),
    )
    repository: Optional[str] = Field(
        None,
        title=(
            "DeprecatedRepository refers to GitHub repo name i.e. argo-events\nDeprecated: use Repositories instead."
            " Will be unsupported in v 1.6\n+optional"
        ),
    )
    webhook: Optional[WebhookContext] = Field(
        None, title="Webhook refers to the configuration required to run a http server"
    )
    webhook_secret: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="webhookSecret",
        title=(
            "WebhookSecret refers to K8s secret containing GitHub webhook"
            " secret\nhttps://developer.github.com/webhooks/securing/\n+optional"
        ),
    )


class GitlabEventSource(BaseModel):
    access_token: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="accessToken",
        title="AccessToken references to k8 secret which holds the gitlab api access information",
    )
    delete_hook_on_finish: Optional[bool] = Field(
        None,
        alias="deleteHookOnFinish",
        title=(
            "DeleteHookOnFinish determines whether to delete the GitLab hook for the project once the event source is"
            " stopped.\n+optional"
        ),
    )
    enable_ssl_verification: Optional[bool] = Field(
        None, alias="enableSSLVerification", title="EnableSSLVerification to enable ssl verification\n+optional"
    )
    events: Optional[List[str]] = Field(
        None,
        description=(
            "Events are gitlab event to listen to.\nRefer"
            " https://github.com/xanzy/go-gitlab/blob/bf34eca5d13a9f4c3f501d8a97b8ac226d55e4d9/projects.go#L794."
        ),
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    gitlab_base_url: Optional[str] = Field(
        None, alias="gitlabBaseURL", title="GitlabBaseURL is the base URL for API requests to a custom endpoint"
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    project_id: Optional[str] = Field(
        None,
        alias="projectID",
        title=(
            "DeprecatedProjectID is the id of project for which integration needs to setup\nDeprecated: use Projects"
            " instead. Will be unsupported in v 1.7\n+optional"
        ),
    )
    projects: Optional[List[str]] = Field(
        None, title='List of project IDs or project namespace paths like "whynowy/test"'
    )
    secret_token: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="secretToken",
        title="SecretToken references to k8 secret which holds the Secret Token used by webhook config",
    )
    webhook: Optional[WebhookContext] = Field(None, title="Webhook holds configuration to run a http server")


class KafkaEventSource(BaseModel):
    config: Optional[str] = Field(
        None,
        description=(
            "Yaml format Sarama config for Kafka connection.\nIt follows the struct of sarama.Config. See"
            " https://github.com/Shopify/sarama/blob/main/config.go\ne.g.\n\nconsumer:\n  fetch:\n    min: 1\nnet:\n "
            " MaxOpenRequests: 5\n\n+optional"
        ),
    )
    connection_backoff: Optional[Backoff] = Field(
        None, alias="connectionBackoff", description="Backoff holds parameters applied to connection."
    )
    consumer_group: Optional[KafkaConsumerGroup] = Field(
        None, alias="consumerGroup", title="Consumer group for kafka client\n+optional"
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    limit_events_per_second: Optional[str] = Field(
        None,
        alias="limitEventsPerSecond",
        title="Sets a limit on how many events get read from kafka per second.\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    partition: Optional[str] = Field(None, title="Partition name")
    sasl: Optional[SASLConfig] = Field(None, title="SASL configuration for the kafka client\n+optional")
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the kafka client.\n+optional")
    topic: Optional[str] = Field(None, title="Topic name")
    url: Optional[str] = Field(None, title="URL to kafka cluster, multiple URLs separated by comma")
    version: Optional[str] = Field(
        None,
        title=(
            "Specify what kafka version is being connected to enables certain features in sarama, defaults to"
            " 1.0.0\n+optional"
        ),
    )


class KafkaTrigger(BaseModel):
    compress: Optional[bool] = Field(
        None,
        title=(
            "Compress determines whether to compress message or not.\nDefaults to false.\nIf set to true, compresses"
            " message using snappy compression.\n+optional"
        ),
    )
    flush_frequency: Optional[int] = Field(
        None,
        alias="flushFrequency",
        title=(
            "FlushFrequency refers to the frequency in milliseconds to flush batches.\nDefaults to 500"
            " milliseconds.\n+optional"
        ),
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None, description="Parameters is the list of parameters that is applied to resolved Kafka trigger object."
    )
    partition: Optional[int] = Field(None, description="Partition to write data to.")
    partitioning_key: Optional[str] = Field(
        None,
        alias="partitioningKey",
        description=(
            "The partitioning key for the messages put on the Kafka topic.\nDefaults to broker url.\n+optional."
        ),
    )
    payload: Optional[List[TriggerParameter]] = Field(
        None,
        description=(
            "Payload is the list of key-value extracted from an event payload to construct the request payload."
        ),
    )
    required_acks: Optional[int] = Field(
        None,
        alias="requiredAcks",
        description=(
            "RequiredAcks used in producer to tell the broker how many replica acknowledgements\nDefaults to 1 (Only"
            " wait for the leader to ack).\n+optional."
        ),
    )
    sasl: Optional[SASLConfig] = Field(None, title="SASL configuration for the kafka client\n+optional")
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the Kafka producer.\n+optional")
    topic: Optional[str] = Field(
        None, title="Name of the topic.\nMore info at https://kafka.apache.org/documentation/#intro_topics"
    )
    url: Optional[str] = Field(None, description="URL of the Kafka broker, multiple URLs separated by comma.")
    version: Optional[str] = Field(
        None,
        title=(
            "Specify what kafka version is being connected to enables certain features in sarama, defaults to"
            " 1.0.0\n+optional"
        ),
    )


class MQTTEventSource(BaseModel):
    client_id: Optional[str] = Field(None, alias="clientId", title="ClientID is the id of the client")
    connection_backoff: Optional[Backoff] = Field(
        None, alias="connectionBackoff", description="ConnectionBackoff holds backoff applied to connection."
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the mqtt client.\n+optional")
    topic: Optional[str] = Field(None, title="Topic name")
    url: Optional[str] = Field(None, title="URL to connect to broker")


class NATSEventsSource(BaseModel):
    auth: Optional[NATSAuth] = Field(None, title="Auth information\n+optional")
    connection_backoff: Optional[Backoff] = Field(
        None, alias="connectionBackoff", description="ConnectionBackoff holds backoff applied to connection."
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    subject: Optional[str] = Field(
        None, title="Subject holds the name of the subject onto which messages are published"
    )
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the nats client.\n+optional")
    url: Optional[str] = Field(None, title="URL to connect to NATS cluster")


class NATSTrigger(BaseModel):
    parameters: Optional[List[TriggerParameter]] = None
    payload: Optional[List[TriggerParameter]] = None
    subject: Optional[str] = Field(None, description="Name of the subject to put message on.")
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the NATS producer.\n+optional")
    url: Optional[str] = Field(None, description="URL of the NATS cluster.")


class NSQEventSource(BaseModel):
    channel: Optional[str] = Field(None, title="Channel used for subscription")
    connection_backoff: Optional[Backoff] = Field(
        None, alias="connectionBackoff", title="Backoff holds parameters applied to connection.\n+optional"
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    host_address: Optional[str] = Field(
        None, alias="hostAddress", title="HostAddress is the address of the host for NSQ lookup"
    )
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the nsq client.\n+optional")
    topic: Optional[str] = Field(None, description="Topic to subscribe to.")


class OpenWhiskTrigger(BaseModel):
    action_name: Optional[str] = Field(None, alias="actionName", description="Name of the action/function.")
    auth_token: Optional[v1.SecretKeySelector] = Field(
        None, alias="authToken", title="AuthToken for authentication.\n+optional"
    )
    host: Optional[str] = Field(None, description="Host URL of the OpenWhisk.")
    namespace: Optional[str] = Field(None, description='Namespace for the action.\nDefaults to "_".\n+optional.')
    parameters: Optional[List[TriggerParameter]] = Field(
        None,
        title=(
            "Parameters is the list of key-value extracted from event's payload that are applied to\nthe trigger"
            " resource.\n+optional"
        ),
    )
    payload: Optional[List[TriggerParameter]] = Field(
        None,
        description=(
            "Payload is the list of key-value extracted from an event payload to construct the request payload."
        ),
    )
    version: Optional[str] = Field(None, title="Version for the API.\nDefaults to v1.\n+optional")


class PulsarEventSource(BaseModel):
    auth_token_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="authTokenSecret", title="Authentication token for the pulsar client.\n+optional"
    )
    connection_backoff: Optional[Backoff] = Field(
        None, alias="connectionBackoff", title="Backoff holds parameters applied to connection.\n+optional"
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the pulsar client.\n+optional")
    tls_allow_insecure_connection: Optional[bool] = Field(
        None,
        alias="tlsAllowInsecureConnection",
        title="Whether the Pulsar client accept untrusted TLS certificate from broker.\n+optional",
    )
    tls_trust_certs_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="tlsTrustCertsSecret", title="Trusted TLS certificate secret.\n+optional"
    )
    tls_validate_hostname: Optional[bool] = Field(
        None,
        alias="tlsValidateHostname",
        title="Whether the Pulsar client verify the validity of the host name from broker.\n+optional",
    )
    topics: Optional[List[str]] = Field(None, title="Name of the topics to subscribe to.\n+required")
    type: Optional[str] = Field(
        None,
        title=(
            'Type of the subscription.\nOnly "exclusive" and "shared" is supported.\nDefaults to exclusive.\n+optional'
        ),
    )
    url: Optional[str] = Field(None, title="Configure the service URL for the Pulsar service.\n+required")


class PulsarTrigger(BaseModel):
    auth_token_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="authTokenSecret", title="Authentication token for the pulsar client.\n+optional"
    )
    connection_backoff: Optional[Backoff] = Field(
        None, alias="connectionBackoff", title="Backoff holds parameters applied to connection.\n+optional"
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None, description="Parameters is the list of parameters that is applied to resolved Kafka trigger object."
    )
    payload: Optional[List[TriggerParameter]] = Field(
        None,
        description=(
            "Payload is the list of key-value extracted from an event payload to construct the request payload."
        ),
    )
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the pulsar client.\n+optional")
    tls_allow_insecure_connection: Optional[bool] = Field(
        None,
        alias="tlsAllowInsecureConnection",
        title="Whether the Pulsar client accept untrusted TLS certificate from broker.\n+optional",
    )
    tls_trust_certs_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="tlsTrustCertsSecret", title="Trusted TLS certificate secret.\n+optional"
    )
    tls_validate_hostname: Optional[bool] = Field(
        None,
        alias="tlsValidateHostname",
        title="Whether the Pulsar client verify the validity of the host name from broker.\n+optional",
    )
    topic: Optional[str] = Field(
        None, title="Name of the topic.\nSee https://pulsar.apache.org/docs/en/concepts-messaging/"
    )
    url: Optional[str] = Field(None, title="Configure the service URL for the Pulsar service.\n+required")


class RedisEventSource(BaseModel):
    channels: Optional[List[str]] = None
    db: Optional[int] = Field(None, title="DB to use. If not specified, default DB 0 will be used.\n+optional")
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    host_address: Optional[str] = Field(
        None, alias="hostAddress", title="HostAddress refers to the address of the Redis host/server"
    )
    json_body: Optional[bool] = Field(
        None,
        alias="jsonBody",
        title="JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional",
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    namespace: Optional[str] = Field(
        None,
        title=(
            "Namespace to use to retrieve the password from. It should only be specified if password is"
            " declared\n+optional"
        ),
    )
    password: Optional[v1.SecretKeySelector] = Field(
        None, title="Password required for authentication if any.\n+optional"
    )
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the redis client.\n+optional")
    username: Optional[str] = Field(None, title="Username required for ACL style authentication if any.\n+optional")


class RedisStreamEventSource(BaseModel):
    consumer_group: Optional[str] = Field(
        None,
        alias="consumerGroup",
        title=(
            "ConsumerGroup refers to the Redis stream consumer group that will be\ncreated on all redis streams."
            " Messages are read through this group. Defaults to 'argo-events-cg'\n+optional"
        ),
    )
    db: Optional[int] = Field(None, title="DB to use. If not specified, default DB 0 will be used.\n+optional")
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    host_address: Optional[str] = Field(
        None, alias="hostAddress", title="HostAddress refers to the address of the Redis host/server (master instance)"
    )
    max_msg_count_per_read: Optional[int] = Field(
        None,
        alias="maxMsgCountPerRead",
        title=(
            "MaxMsgCountPerRead holds the maximum number of messages per stream that will be read in each XREADGROUP"
            " of all streams\nExample: if there are 2 streams and MaxMsgCountPerRead=10, then each XREADGROUP may read"
            " upto a total of 20 messages.\nSame as COUNT option in XREADGROUP(https://redis.io/topics/streams-intro)."
            " Defaults to 10\n+optional"
        ),
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    password: Optional[v1.SecretKeySelector] = Field(
        None, title="Password required for authentication if any.\n+optional"
    )
    streams: Optional[List[str]] = Field(
        None,
        description="Streams to look for entries. XREADGROUP is used on all streams using a single consumer group.",
    )
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the redis client.\n+optional")
    username: Optional[str] = Field(None, title="Username required for ACL style authentication if any.\n+optional")


class ResourceEventSource(BaseModel):
    event_types: Optional[List[str]] = Field(
        None,
        alias="eventTypes",
        description="EventTypes is the list of event type to watch.\nPossible values are - ADD, UPDATE and DELETE.",
    )
    filter: Optional[ResourceFilter] = Field(
        None,
        title=(
            "Filter is applied on the metadata of the resource\nIf you apply filter, then the internal event informer"
            " will only monitor objects that pass the filter.\n+optional"
        ),
    )
    group_version_resource: Optional[v1_1.GroupVersionResource] = Field(
        None, alias="groupVersionResource", title="Group of the resource"
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    namespace: Optional[str] = Field(None, title="Namespace where resource is deployed")


class SNSEventSource(BaseModel):
    access_key: Optional[v1.SecretKeySelector] = Field(
        None, alias="accessKey", title="AccessKey refers K8s secret containing aws access key"
    )
    endpoint: Optional[str] = Field(
        None, title="Endpoint configures connection to a specific SNS endpoint instead of Amazons servers\n+optional"
    )
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    region: Optional[str] = Field(None, title="Region is AWS region")
    role_arn: Optional[str] = Field(
        None, alias="roleARN", title="RoleARN is the Amazon Resource Name (ARN) of the role to assume.\n+optional"
    )
    secret_key: Optional[v1.SecretKeySelector] = Field(
        None, alias="secretKey", title="SecretKey refers K8s secret containing aws secret key"
    )
    topic_arn: Optional[str] = Field(None, alias="topicArn", title="TopicArn")
    validate_signature: Optional[bool] = Field(
        None,
        alias="validateSignature",
        title="ValidateSignature is boolean that can be set to true for SNS signature verification\n+optional",
    )
    webhook: Optional[WebhookContext] = Field(None, title="Webhook configuration for http server")


class SecureHeader(BaseModel):
    name: Optional[str] = None
    value_from: Optional[ValueFromSource] = Field(
        None, alias="valueFrom", title="Values can be read from either secrets or configmaps"
    )


class SensorStatus(BaseModel):
    status: Optional[Status] = None


class Service(BaseModel):
    cluster_ip: Optional[str] = Field(
        None,
        alias="clusterIP",
        title=(
            "clusterIP is the IP address of the service and is usually assigned\nrandomly by the master. If an address"
            " is specified manually and is not in\nuse by others, it will be allocated to the service; otherwise,"
            " creation\nof the service will fail. This field can not be changed through updates.\nValid values are"
            ' "None", empty string (""), or a valid IP address. "None"\ncan be specified for headless services when'
            " proxying is not required.\nMore info:"
            " https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies\n+optional"
        ),
    )
    ports: Optional[List[v1.ServicePort]] = Field(
        None,
        title=(
            "The list of ports that are exposed by this ClusterIP"
            " service.\n+patchMergeKey=port\n+patchStrategy=merge\n+listType=map\n+listMapKey=port\n+listMapKey=protocol"
        ),
    )


class SlackEventSource(BaseModel):
    filter: Optional[EventSourceFilter] = Field(None, title="Filter\n+optional")
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    signing_secret: Optional[v1.SecretKeySelector] = Field(
        None, alias="signingSecret", title="Slack App signing secret"
    )
    token: Optional[v1.SecretKeySelector] = Field(None, title="Token for URL verification handshake")
    webhook: Optional[WebhookContext] = Field(None, title="Webhook holds configuration for a REST endpoint")


class SlackTrigger(BaseModel):
    channel: Optional[str] = Field(
        None, title="Channel refers to which Slack channel to send slack message.\n+optional"
    )
    message: Optional[str] = Field(
        None, title="Message refers to the message to send to the Slack channel.\n+optional"
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None,
        title=(
            "Parameters is the list of key-value extracted from event's payload that are applied to\nthe trigger"
            " resource.\n+optional"
        ),
    )
    slack_token: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="slackToken",
        description="SlackToken refers to the Kubernetes secret that holds the slack token required to send messages.",
    )


class StorageGridEventSource(BaseModel):
    api_url: Optional[str] = Field(None, alias="apiURL", description="APIURL is the url of the storagegrid api.")
    auth_token: Optional[v1.SecretKeySelector] = Field(None, alias="authToken", title="Auth token for storagegrid api")
    bucket: Optional[str] = Field(None, description="Name of the bucket to register notifications for.")
    events: Optional[List[str]] = None
    filter: Optional[StorageGridFilter] = Field(
        None, description="Filter on object key which caused the notification."
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    region: Optional[str] = Field(None, title="S3 region.\nDefaults to us-east-1\n+optional")
    topic_arn: Optional[str] = Field(None, alias="topicArn", title="TopicArn")
    webhook: Optional[WebhookContext] = Field(None, title="Webhook holds configuration for a REST endpoint")


class StripeEventSource(BaseModel):
    api_key: Optional[v1.SecretKeySelector] = Field(
        None,
        alias="apiKey",
        title=(
            "APIKey refers to K8s secret that holds Stripe API key. Used only if CreateWebhook is enabled.\n+optional"
        ),
    )
    create_webhook: Optional[bool] = Field(
        None,
        alias="createWebhook",
        title="CreateWebhook if specified creates a new webhook programmatically.\n+optional",
    )
    event_filter: Optional[List[str]] = Field(
        None,
        alias="eventFilter",
        title=(
            "EventFilter describes the type of events to listen to. If not specified, all types of events will be"
            " processed.\nMore info at https://stripe.com/docs/api/events/list\n+optional"
        ),
    )
    metadata: Optional[Dict[str, str]] = Field(
        None, title="Metadata holds the user defined metadata which will passed along the event payload.\n+optional"
    )
    webhook: Optional[WebhookContext] = Field(None, title="Webhook holds configuration for a REST endpoint")


class ArtifactLocation(BaseModel):
    configmap: Optional[v1.ConfigMapKeySelector] = Field(None, title="Configmap that stores the artifact")
    file: Optional[FileArtifact] = Field(None, title="File artifact is artifact stored in a file")
    git: Optional[GitArtifact] = Field(None, title="Git repository hosting the artifact")
    inline: Optional[str] = Field(None, title="Inline artifact is embedded in sensor spec as a string")
    resource: Optional[Resource] = Field(None, title="Resource is generic template for K8s resource")
    s3: Optional[S3Artifact] = Field(None, title="S3 compliant artifact")
    url: Optional[URLArtifact] = Field(None, title="URL to fetch the artifact from")


class EventDependency(BaseModel):
    event_name: Optional[str] = Field(None, alias="eventName", title="EventName is the name of the event")
    event_source_name: Optional[str] = Field(
        None, alias="eventSourceName", title="EventSourceName is the name of EventSource that Sensor depends on"
    )
    filters: Optional[EventDependencyFilter] = Field(
        None,
        title="Filters and rules governing toleration of success and constraints on the context and data of an event",
    )
    filters_logical_operator: Optional[str] = Field(
        None,
        alias="filtersLogicalOperator",
        description=(
            "FiltersLogicalOperator defines how different filters are evaluated together.\nAvailable values: and (&&),"
            " or (||)\nIs optional and if left blank treated as and (&&)."
        ),
    )
    name: Optional[str] = Field(None, title="Name is a unique name of this dependency")
    transform: Optional[EventDependencyTransformer] = Field(None, title="Transform transforms the event data")


class HTTPTrigger(BaseModel):
    basic_auth: Optional[BasicAuth] = Field(
        None, alias="basicAuth", title="BasicAuth configuration for the http request.\n+optional"
    )
    headers: Optional[Dict[str, str]] = Field(None, title="Headers for the HTTP request.\n+optional")
    method: Optional[str] = Field(
        None,
        title=(
            "Method refers to the type of the HTTP request.\nRefer https://golang.org/src/net/http/method.go for more"
            " io.argoproj.workflow.v1alpha1.\nDefault value is POST.\n+optional"
        ),
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None,
        description=(
            "Parameters is the list of key-value extracted from event's payload that are applied to\nthe HTTP trigger"
            " resource."
        ),
    )
    payload: Optional[List[TriggerParameter]] = None
    secure_headers: Optional[List[SecureHeader]] = Field(
        None,
        alias="secureHeaders",
        title="Secure Headers stored in Kubernetes Secrets for the HTTP requests.\n+optional",
    )
    timeout: Optional[str] = Field(
        None, title="Timeout refers to the HTTP request timeout in seconds.\nDefault value is 60 seconds.\n+optional"
    )
    tls: Optional[TLSConfig] = Field(None, title="TLS configuration for the HTTP client.\n+optional")
    url: Optional[str] = Field(None, description="URL refers to the URL to send HTTP request to.")


class StandardK8STrigger(BaseModel):
    live_object: Optional[bool] = Field(
        None,
        alias="liveObject",
        title=(
            "LiveObject specifies whether the resource should be directly fetched from K8s instead\nof being marshaled"
            " from the resource artifact. If set to true, the resource artifact\nmust contain the information required"
            ' to uniquely identify the resource in the cluster,\nthat is, you must specify "apiVersion", "kind" as'
            ' well as "name" and "namespace" meta\ndata.\nOnly valid for operation type `update`\n+optional'
        ),
    )
    operation: Optional[str] = Field(
        None,
        title=(
            "Operation refers to the type of operation performed on the k8s resource.\nDefault value is"
            " Create.\n+optional"
        ),
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None, description="Parameters is the list of parameters that is applied to resolved K8s trigger object."
    )
    patch_strategy: Optional[str] = Field(
        None,
        alias="patchStrategy",
        title=(
            "PatchStrategy controls the K8s object patching strategy when the trigger operation is specified as"
            " patch.\npossible"
            ' values:\n"application/json-patch+json"\n"application/merge-patch+json"\n"application/strategic-merge-patch+json"\n"application/apply-patch+yaml".\nDefaults'
            ' to "application/merge-patch+json"\n+optional'
        ),
    )
    source: Optional[ArtifactLocation] = Field(None, title="Source of the K8s resource file(s)")


class ArgoWorkflowTrigger(BaseModel):
    args: Optional[List[str]] = Field(None, title="Args is the list of arguments to pass to the argo CLI")
    operation: Optional[str] = Field(
        None,
        title=(
            "Operation refers to the type of operation performed on the argo workflow resource.\nDefault value is"
            " Submit.\n+optional"
        ),
    )
    parameters: Optional[List[TriggerParameter]] = Field(
        None, title="Parameters is the list of parameters to pass to resolved Argo Workflow object"
    )
    source: Optional[ArtifactLocation] = Field(None, title="Source of the K8s resource file(s)")


class TriggerTemplate(BaseModel):
    argo_workflow: Optional[ArgoWorkflowTrigger] = Field(
        None,
        alias="argoWorkflow",
        title=(
            "ArgoWorkflow refers to the trigger that can perform various operations on an Argo"
            " io.argoproj.workflow.v1alpha1.\n+optional"
        ),
    )
    aws_lambda: Optional[AWSLambdaTrigger] = Field(
        None,
        alias="awsLambda",
        title=(
            "AWSLambda refers to the trigger designed to invoke AWS Lambda function with with on-the-fly constructable"
            " payload.\n+optional"
        ),
    )
    azure_event_hubs: Optional[AzureEventHubsTrigger] = Field(
        None,
        alias="azureEventHubs",
        title="AzureEventHubs refers to the trigger send an event to an Azure Event Hub.\n+optional",
    )
    conditions: Optional[str] = Field(
        None,
        title=(
            'Conditions is the conditions to execute the trigger.\nFor example: "(dep01 || dep02) && dep04"\n+optional'
        ),
    )
    conditions_reset: Optional[List[ConditionsResetCriteria]] = Field(
        None, alias="conditionsReset", title="Criteria to reset the conditons\n+optional"
    )
    custom: Optional[CustomTrigger] = Field(
        None,
        title=(
            "CustomTrigger refers to the trigger designed to connect to a gRPC trigger server and execute a custom"
            " trigger.\n+optional"
        ),
    )
    http: Optional[HTTPTrigger] = Field(
        None,
        title=(
            "HTTP refers to the trigger designed to dispatch a HTTP request with on-the-fly constructable"
            " payload.\n+optional"
        ),
    )
    k8s: Optional[StandardK8STrigger] = Field(
        None,
        title=(
            "StandardK8STrigger refers to the trigger designed to create or update a generic Kubernetes"
            " resource.\n+optional"
        ),
    )
    kafka: Optional[KafkaTrigger] = Field(
        None, description="Kafka refers to the trigger designed to place messages on Kafka topic.\n+optional."
    )
    log: Optional[LogTrigger] = Field(
        None, title="Log refers to the trigger designed to invoke log the io.argoproj.workflow.v1alpha1.\n+optional"
    )
    name: Optional[str] = Field(None, description="Name is a unique name of the action to take.")
    nats: Optional[NATSTrigger] = Field(
        None, description="NATS refers to the trigger designed to place message on NATS subject.\n+optional."
    )
    open_whisk: Optional[OpenWhiskTrigger] = Field(
        None,
        alias="openWhisk",
        title="OpenWhisk refers to the trigger designed to invoke OpenWhisk action.\n+optional",
    )
    pulsar: Optional[PulsarTrigger] = Field(
        None, title="Pulsar refers to the trigger designed to place messages on Pulsar topic.\n+optional"
    )
    slack: Optional[SlackTrigger] = Field(
        None, title="Slack refers to the trigger designed to send slack notification message.\n+optional"
    )


class Template(BaseModel):
    affinity: Optional[v1.Affinity] = Field(None, title="If specified, the pod's scheduling constraints\n+optional")
    container: Optional[v1.Container] = Field(
        None, title="Container is the main container image to run in the sensor pod\n+optional"
    )
    image_pull_secrets: Optional[List[v1.LocalObjectReference]] = Field(
        None,
        alias="imagePullSecrets",
        title=(
            "ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling"
            " any of the images used by this PodSpec.\nIf specified, these secrets will be passed to individual puller"
            " implementations for them to use. For example,\nin the case of docker, only DockerConfig type secrets are"
            " honored.\nMore info:"
            " https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod\n+optional\n+patchMergeKey=name\n+patchStrategy=merge"
        ),
    )
    metadata: Optional[Metadata] = Field(None, title="Metadata sets the pods's metadata, i.e. annotations and labels")
    node_selector: Optional[Dict[str, str]] = Field(
        None,
        alias="nodeSelector",
        title=(
            "NodeSelector is a selector which must be true for the pod to fit on a node.\nSelector which must match a"
            " node's labels for the pod to be scheduled on that node.\nMore info:"
            " https://kubernetes.io/docs/concepts/configuration/assign-pod-node/\n+optional"
        ),
    )
    priority: Optional[int] = Field(
        None,
        title=(
            "The priority value. Various system components use this field to find the\npriority of the EventSource"
            " pod. When Priority Admission Controller is enabled,\nit prevents users from setting this field. The"
            " admission controller populates\nthis field from PriorityClassName.\nThe higher the value, the higher the"
            " priority.\nMore info:"
            " https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/\n+optional"
        ),
    )
    priority_class_name: Optional[str] = Field(
        None,
        alias="priorityClassName",
        title=(
            'If specified, indicates the EventSource pod\'s priority. "system-node-critical"\nand'
            ' "system-cluster-critical" are two special keywords which indicate the\nhighest priorities with the'
            " former being the highest priority. Any other\nname must be defined by creating a PriorityClass object"
            " with that name.\nIf not specified, the pod priority will be default or zero if there is"
            " no\ndefault.\nMore info:"
            " https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/\n+optional"
        ),
    )
    security_context: Optional[v1.PodSecurityContext] = Field(
        None,
        alias="securityContext",
        title=(
            "SecurityContext holds pod-level security attributes and common container settings.\nOptional: Defaults to"
            " empty.  See type description for default values of each field.\n+optional"
        ),
    )
    service_account_name: Optional[str] = Field(
        None,
        alias="serviceAccountName",
        title=(
            "ServiceAccountName is the name of the ServiceAccount to use to run sensor pod.\nMore info:"
            " https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/\n+optional"
        ),
    )
    tolerations: Optional[List[v1.Toleration]] = Field(None, title="If specified, the pod's tolerations.\n+optional")
    volumes: Optional[List[v1.Volume]] = Field(
        None,
        title=(
            "Volumes is a list of volumes that can be mounted by containers in a"
            " io.argoproj.workflow.v1alpha1.\n+patchStrategy=merge\n+patchMergeKey=name\n+optional"
        ),
    )


class Trigger(BaseModel):
    parameters: Optional[List[TriggerParameter]] = Field(
        None, title="Parameters is the list of parameters applied to the trigger template definition"
    )
    policy: Optional[TriggerPolicy] = Field(
        None, title="Policy to configure backoff and execution criteria for the trigger\n+optional"
    )
    rate_limit: Optional[RateLimit] = Field(
        None, alias="rateLimit", title="Rate limit, default unit is Second\n+optional"
    )
    retry_strategy: Optional[Backoff] = Field(
        None, alias="retryStrategy", title="Retry strategy, defaults to no retry\n+optional"
    )
    template: Optional[TriggerTemplate] = Field(None, description="Template describes the trigger specification.")


class EventSourceSpec(BaseModel):
    amqp: Optional[Dict[str, AMQPEventSource]] = Field(None, title="AMQP event sources")
    azure_events_hub: Optional[Dict[str, AzureEventsHubEventSource]] = Field(
        None, alias="azureEventsHub", title="AzureEventsHub event sources"
    )
    bitbucket: Optional[Dict[str, BitbucketEventSource]] = Field(None, title="Bitbucket event sources")
    bitbucketserver: Optional[Dict[str, BitbucketServerEventSource]] = Field(
        None, title="Bitbucket Server event sources"
    )
    calendar: Optional[Dict[str, CalendarEventSource]] = Field(None, title="Calendar event sources")
    emitter: Optional[Dict[str, EmitterEventSource]] = Field(None, title="Emitter event source")
    event_bus_name: Optional[str] = Field(
        None,
        alias="eventBusName",
        title='EventBusName references to a EventBus name. By default the value is "default"',
    )
    file: Optional[Dict[str, FileEventSource]] = Field(None, title="File event sources")
    generic: Optional[Dict[str, GenericEventSource]] = Field(None, title="Generic event source")
    github: Optional[Dict[str, GithubEventSource]] = Field(None, title="Github event sources")
    gitlab: Optional[Dict[str, GitlabEventSource]] = Field(None, title="Gitlab event sources")
    hdfs: Optional[Dict[str, HDFSEventSource]] = Field(None, title="HDFS event sources")
    kafka: Optional[Dict[str, KafkaEventSource]] = Field(None, title="Kafka event sources")
    minio: Optional[Dict[str, S3Artifact]] = Field(None, title="Minio event sources")
    mqtt: Optional[Dict[str, MQTTEventSource]] = Field(None, title="MQTT event sources")
    nats: Optional[Dict[str, NATSEventsSource]] = Field(None, title="NATS event sources")
    nsq: Optional[Dict[str, NSQEventSource]] = Field(None, title="NSQ event source")
    pub_sub: Optional[Dict[str, PubSubEventSource]] = Field(None, alias="pubSub", title="PubSub event sources")
    pulsar: Optional[Dict[str, PulsarEventSource]] = Field(None, title="Pulsar event source")
    redis: Optional[Dict[str, RedisEventSource]] = Field(None, title="Redis event source")
    redis_stream: Optional[Dict[str, RedisStreamEventSource]] = Field(
        None, alias="redisStream", title="Redis stream source"
    )
    replicas: Optional[int] = Field(None, title="Replicas is the event source deployment replicas")
    resource: Optional[Dict[str, ResourceEventSource]] = Field(None, title="Resource event sources")
    service: Optional[Service] = Field(
        None, title="Service is the specifications of the service to expose the event source\n+optional"
    )
    slack: Optional[Dict[str, SlackEventSource]] = Field(None, title="Slack event sources")
    sns: Optional[Dict[str, SNSEventSource]] = Field(None, title="SNS event sources")
    sqs: Optional[Dict[str, SQSEventSource]] = Field(None, title="SQS event sources")
    storage_grid: Optional[Dict[str, StorageGridEventSource]] = Field(
        None, alias="storageGrid", title="StorageGrid event sources"
    )
    stripe: Optional[Dict[str, StripeEventSource]] = Field(None, title="Stripe event sources")
    template: Optional[Template] = Field(
        None, title="Template is the pod specification for the event source\n+optional"
    )
    webhook: Optional[Dict[str, WebhookEventSource]] = Field(None, title="Webhook event sources")


class SensorSpec(BaseModel):
    dependencies: Optional[List[EventDependency]] = Field(
        None, description="Dependencies is a list of the events that this sensor is dependent on."
    )
    error_on_failed_round: Optional[bool] = Field(
        None,
        alias="errorOnFailedRound",
        description=(
            "ErrorOnFailedRound if set to true, marks sensor state as `error` if the previous trigger round"
            " fails.\nOnce sensor state is set to `error`, no further triggers will be processed."
        ),
    )
    event_bus_name: Optional[str] = Field(
        None,
        alias="eventBusName",
        title='EventBusName references to a EventBus name. By default the value is "default"',
    )
    replicas: Optional[int] = Field(None, title="Replicas is the sensor deployment replicas")
    template: Optional[Template] = Field(None, title="Template is the pod specification for the sensor\n+optional")
    triggers: Optional[List[Trigger]] = Field(
        None,
        description=(
            "Triggers is a list of the things that this sensor evokes. These are the outputs from this sensor."
        ),
    )


class EventSource(BaseModel):
    metadata: Optional[v1_1.ObjectMeta] = None
    spec: Optional[EventSourceSpec] = None
    status: Optional[EventSourceStatus] = Field(None, title="+optional")


class EventSourceList(BaseModel):
    items: Optional[List[EventSource]] = None
    metadata: Optional[v1_1.ListMeta] = None


class Sensor(BaseModel):
    metadata: Optional[v1_1.ObjectMeta] = None
    spec: Optional[SensorSpec] = None
    status: Optional[SensorStatus] = Field(None, title="+optional")


class SensorList(BaseModel):
    items: Optional[List[Sensor]] = None
    metadata: Optional[v1_1.ListMeta] = None
