"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallRuleGroup = exports.DnsBlockResponse = exports.FirewallRuleAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const firewall_rule_group_association_1 = require("./firewall-rule-group-association");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * A Firewall Rule
 */
class FirewallRuleAction {
    /**
     * Permit the request to go through
     */
    static allow() {
        return { action: 'ALLOW' };
    }
    /**
     * Permit the request to go through but send an alert to the logs
     */
    static alert() {
        return { action: 'ALERT' };
    }
    /**
     * Disallow the request
     *
     * @param [response=DnsBlockResponse.noData()] The way that you want DNS Firewall to block the request
     */
    static block(response) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_DnsBlockResponse(response);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.block);
            }
            throw error;
        }
        return {
            action: 'BLOCK',
            blockResponse: response !== null && response !== void 0 ? response : DnsBlockResponse.noData(),
        };
    }
}
exports.FirewallRuleAction = FirewallRuleAction;
_a = JSII_RTTI_SYMBOL_1;
FirewallRuleAction[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleAction", version: "1.153.1" };
/**
 * The way that you want DNS Firewall to block the request
 */
class DnsBlockResponse {
    /**
     * Respond indicating that the query was successful, but no
     * response is available for it.
     */
    static noData() {
        return { blockResponse: 'NODATA' };
    }
    /**
     * Respond indicating that the domain name that's in the query
     * doesn't exist.
     */
    static nxDomain() {
        return { blockResponse: 'NXDOMAIN' };
    }
    /**
     * Provides a custom override response to the query
     *
     * @param domain The custom DNS record to send back in response to the query
     * @param [ttl=0] The recommended amount of time for the DNS resolver or
     *   web browser to cache the provided override record
     */
    static override(domain, ttl) {
        return {
            blockResponse: 'OVERRIDE',
            blockOverrideDnsType: 'CNAME',
            blockOverrideDomain: domain,
            blockOverrideTtl: ttl !== null && ttl !== void 0 ? ttl : core_1.Duration.seconds(0),
        };
    }
}
exports.DnsBlockResponse = DnsBlockResponse;
_b = JSII_RTTI_SYMBOL_1;
DnsBlockResponse[_b] = { fqn: "@aws-cdk/aws-route53resolver.DnsBlockResponse", version: "1.153.1" };
/**
 * A Firewall Rule Group
 */
class FirewallRuleGroup extends core_1.Resource {
    constructor(scope, id, props = {}) {
        var _d;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.rules = (_d = props.rules) !== null && _d !== void 0 ? _d : [];
        const ruleGroup = new route53resolver_generated_1.CfnFirewallRuleGroup(this, 'Resource', {
            name: props.name,
            firewallRules: core_1.Lazy.any({ produce: () => this.rules.map(renderRule) }),
        });
        this.firewallRuleGroupId = ruleGroup.attrId;
        this.firewallRuleGroupArn = ruleGroup.attrArn;
        this.firewallRuleGroupCreationTime = ruleGroup.attrCreationTime;
        this.firewallRuleGroupCreatorRequestId = ruleGroup.attrCreatorRequestId;
        this.firewallRuleGroupModificationTime = ruleGroup.attrModificationTime;
        this.firewallRuleGroupOwnerId = ruleGroup.attrOwnerId;
        this.firewallRuleGroupRuleCount = ruleGroup.attrRuleCount;
        this.firewallRuleGroupShareStatus = ruleGroup.attrShareStatus;
        this.firewallRuleGroupStatus = ruleGroup.attrStatus;
        this.firewallRuleGroupStatusMessage = ruleGroup.attrStatusMessage;
    }
    /**
     * Import an existing Firewall Rule Group
     */
    static fromFirewallRuleGroupId(scope, id, firewallRuleGroupId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.firewallRuleGroupId = firewallRuleGroupId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds a rule to this group
     */
    addRule(rule) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addRule);
            }
            throw error;
        }
        this.rules.push(rule);
        return this;
    }
    /**
     * Associates this Firewall Rule Group with a VPC
     */
    associate(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupAssociationOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.associate);
            }
            throw error;
        }
        return new firewall_rule_group_association_1.FirewallRuleGroupAssociation(this, id, {
            ...props,
            firewallRuleGroup: this,
        });
    }
}
exports.FirewallRuleGroup = FirewallRuleGroup;
_c = JSII_RTTI_SYMBOL_1;
FirewallRuleGroup[_c] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleGroup", version: "1.153.1" };
function renderRule(rule) {
    var _d, _e, _f, _g, _h;
    return {
        action: rule.action.action,
        firewallDomainListId: rule.firewallDomainList.firewallDomainListId,
        priority: rule.priority,
        blockOverrideDnsType: (_d = rule.action.blockResponse) === null || _d === void 0 ? void 0 : _d.blockOverrideDnsType,
        blockOverrideDomain: (_e = rule.action.blockResponse) === null || _e === void 0 ? void 0 : _e.blockOverrideDomain,
        blockOverrideTtl: (_g = (_f = rule.action.blockResponse) === null || _f === void 0 ? void 0 : _f.blockOverrideTtl) === null || _g === void 0 ? void 0 : _g.toSeconds(),
        blockResponse: (_h = rule.action.blockResponse) === null || _h === void 0 ? void 0 : _h.blockResponse,
    };
}
//# sourceMappingURL=data:application/json;base64,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