[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause)
[![PyPI version](https://badge.fury.io/py/pycrostates.svg)](https://badge.fury.io/py/pycrostates)
[![Conda Version](https://img.shields.io/conda/vn/conda-forge/pycrostates.svg)](https://anaconda.org/conda-forge/pycrostates)
[![Documentation Status](https://readthedocs.org/projects/pycrostates/badge/?version=latest)](https://pycrostates.readthedocs.io/en/latest/?badge=latest)
[![Build Status](https://dev.azure.com/vferat/pycrostates/_apis/build/status/vferat.pycrostates?branchName=main)](https://dev.azure.com/vferat/pycrostates/_build/latest?definitionId=1&branchName=main)
[![codecov](https://codecov.io/gh/vferat/pycrostates/branch/master/graph/badge.svg?token=47COGGCGX8)](https://codecov.io/gh/vferat/pycrostates)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/029e425f90614943b0a944e03922b637)](https://www.codacy.com/gh/vferat/pycrostates/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=vferat/pycrostates&amp;utm_campaign=Badge_Grade)

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/vferat/pycrostates/main/docs/_static/logos/Pycrostates_logo_white.png">
  <source media="(prefers-color-scheme: light)" srcset="https://raw.githubusercontent.com/vferat/pycrostates/main/docs/_static/logos/Pycrostates_logo_black.png">
  <img alt="Pycrostate logo" src="https://raw.githubusercontent.com/vferat/pycrostates/main/docs/_static/logos/Pycrostates_logo_black.png">
</picture>

# Pycrostates
---

An open-source Python package for analyzing EEG microstates developed to work with [MNE-python](https://mne.tools/stable/index.html).

## Documentation
[![Documentation Status](https://readthedocs.org/projects/pycrostates/badge/?version=latest)](https://pycrostates.readthedocs.io/en/latest/?badge=latest)

The documentation including tutorials and example can be found [here](https://pycrostates.readthedocs.io/en/latest/).


## Installation
[![Downloads](https://pepy.tech/badge/pycrostates/month)](https://pepy.tech/project/pycrostates)
[![Anaconda-Server Badge](https://anaconda.org/conda-forge/pycrostates/badges/downloads.svg)](https://anaconda.org/conda-forge/pycrostates)

Installation instructions can be found [here](https://pycrostates.readthedocs.io/en/latest/install.html).

## Citing
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.6915329.svg)](https://doi.org/10.5281/zenodo.6915329)
[![status](https://joss.theoj.org/papers/be7e10c061e28f5694cb7366aef445a3/status.svg)](https://joss.theoj.org/papers/be7e10c061e28f5694cb7366aef445a3)

To cite specific version numbers of the software, you can use the DOIs provided by [Zenodo](https://doi.org/10.5281/zenodo.6915329).
The canonical journal article reference is currently under review at the [JOSS](https://joss.theoj.org/papers/be7e10c061e28f5694cb7366aef445a3) journal and can't be cited yet.

## Contributing

[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-3-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->

Pycrostates welcomes contributions from anyone interested in improving this project. These contributions can take the form of bug reports/fixes, feature requests/additions, documentation revision and new tutorials.

In all cases, it is recommended to [open a new issue](https://github.com/vferat/pycrostates/issues/new/choose) on Github to discuss the best way to integrate a contribution.

Check the [Contribution Guide](https://github.com/vferat/pycrostates/blob/main/CONTRIBUTING.md) if you want to make a changes to Pycrostates.

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://vferat.github.io/about/"><img src="https://avatars.githubusercontent.com/u/28844486?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Victor Férat</b></sub></a><br /><a href="https://github.com/vferat/pycrostates/commits?author=vferat" title="Tests">⚠️</a> <a href="https://github.com/vferat/pycrostates/commits?author=vferat" title="Code">💻</a> <a href="https://github.com/vferat/pycrostates/commits?author=vferat" title="Documentation">📖</a> <a href="#ideas-vferat" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-vferat" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#maintenance-vferat" title="Maintenance">🚧</a> <a href="#projectManagement-vferat" title="Project Management">📆</a> <a href="https://github.com/vferat/pycrostates/pulls?q=is%3Apr+reviewed-by%3Avferat" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/mscheltienne"><img src="https://avatars.githubusercontent.com/u/73893616?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mathieu Scheltienne</b></sub></a><br /><a href="https://github.com/vferat/pycrostates/commits?author=mscheltienne" title="Code">💻</a> <a href="https://github.com/vferat/pycrostates/commits?author=mscheltienne" title="Documentation">📖</a> <a href="#ideas-mscheltienne" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-mscheltienne" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#maintenance-mscheltienne" title="Maintenance">🚧</a> <a href="#projectManagement-mscheltienne" title="Project Management">📆</a> <a href="https://github.com/vferat/pycrostates/pulls?q=is%3Apr+reviewed-by%3Amscheltienne" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/vferat/pycrostates/commits?author=mscheltienne" title="Tests">⚠️</a></td>
    <td align="center"><a href="https://github.com/LouPlanchamp"><img src="https://avatars.githubusercontent.com/u/107875645?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Lou</b></sub></a><br /><a href="#design-LouPlanchamp" title="Design">🎨</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!


## Acknowledgment
---

<p float="left">
    <a href="https://www.unige.ch/medecine/neuf/en/researc/grecherche/christoph-michel/">
        <img src="https://raw.githubusercontent.com/vferat/pycrostates/main/docs/_static/logos/FBMLAB_logo.png" width="200" />
    </a>
    <a href="https://www.unige.ch/en/university/presentation/">
        <img src="https://raw.githubusercontent.com/vferat/pycrostates/main/docs/_static/logos/UNIGE_logo.png" width="300" />
    </a>
</p>
