"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpsRedirect = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const aws_certificatemanager_1 = require("@aws-cdk/aws-certificatemanager");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const aws_route53_targets_1 = require("@aws-cdk/aws-route53-targets");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * Allows creating a domainA -> domainB redirect using CloudFront and S3.
 * You can specify multiple domains to be redirected.
 */
class HttpsRedirect extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_patterns_HttpsRedirectProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpsRedirect);
            }
            throw error;
        }
        const domainNames = props.recordNames ?? [props.zone.zoneName];
        if (props.certificate) {
            const certificateRegion = core_1.Stack.of(this).splitArn(props.certificate.certificateArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).region;
            if (!core_1.Token.isUnresolved(certificateRegion) && certificateRegion !== 'us-east-1') {
                throw new Error(`The certificate must be in the us-east-1 region and the certificate you provided is in ${certificateRegion}.`);
            }
        }
        const redirectCert = props.certificate ?? new aws_certificatemanager_1.DnsValidatedCertificate(this, 'RedirectCertificate', {
            domainName: domainNames[0],
            subjectAlternativeNames: domainNames,
            hostedZone: props.zone,
            region: 'us-east-1',
        });
        const redirectBucket = new aws_s3_1.Bucket(this, 'RedirectBucket', {
            websiteRedirect: {
                hostName: props.targetDomain,
                protocol: aws_s3_1.RedirectProtocol.HTTPS,
            },
            removalPolicy: core_1.RemovalPolicy.DESTROY,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
        });
        const redirectDist = new aws_cloudfront_1.CloudFrontWebDistribution(this, 'RedirectDistribution', {
            defaultRootObject: '',
            originConfigs: [{
                    behaviors: [{ isDefaultBehavior: true }],
                    customOriginSource: {
                        domainName: redirectBucket.bucketWebsiteDomainName,
                        originProtocolPolicy: aws_cloudfront_1.OriginProtocolPolicy.HTTP_ONLY,
                    },
                }],
            viewerCertificate: aws_cloudfront_1.ViewerCertificate.fromAcmCertificate(redirectCert, {
                aliases: domainNames,
            }),
            comment: `Redirect to ${props.targetDomain} from ${domainNames.join(', ')}`,
            priceClass: aws_cloudfront_1.PriceClass.PRICE_CLASS_ALL,
            viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
        });
        domainNames.forEach((domainName) => {
            const hash = crypto.createHash('md5').update(domainName).digest('hex').slice(0, 6);
            const aliasProps = {
                recordName: domainName,
                zone: props.zone,
                target: aws_route53_1.RecordTarget.fromAlias(new aws_route53_targets_1.CloudFrontTarget(redirectDist)),
            };
            new aws_route53_1.ARecord(this, `RedirectAliasRecord${hash}`, aliasProps);
            new aws_route53_1.AaaaRecord(this, `RedirectAliasRecordSix${hash}`, aliasProps);
        });
    }
}
exports.HttpsRedirect = HttpsRedirect;
_a = JSII_RTTI_SYMBOL_1;
HttpsRedirect[_a] = { fqn: "@aws-cdk/aws-route53-patterns.HttpsRedirect", version: "1.163.2" };
//# sourceMappingURL=data:application/json;base64,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