---
id: papers
title: Papers using BoTorch
---

The main reference for BoTorch is

[BoTorch: A Framework for Efficient Monte-Carlo Bayesian Optimization](https://proceedings.neurips.cc/paper/2020/hash/f5b1b89d98b7286673128a5fb112cb9a-Abstract.html):

    @inproceedings{balandat2020botorch,
        title = {{BoTorch: A Framework for Efficient Monte-Carlo Bayesian Optimization}},
        author = {Balandat, Maximilian and Karrer, Brian and Jiang, Daniel R. and Daulton, Samuel and Letham, Benjamin and Wilson, Andrew Gordon and Bakshy, Eytan},
        booktitle = {Advances in Neural Information Processing Systems 33},
        year = 2020,
        url = {https://proceedings.neurips.cc/paper/2020/hash/f5b1b89d98b7286673128a5fb112cb9a-Abstract.html}
    }


Here is an incomplete selection of peer-reviewed Bayesian optimization papers that build off of BoTorch:

- [Differentiable Expected Hypervolume Improvement for Parallel Multi-Objective Bayesian Optimization](https://proceedings.neurips.cc/paper/2020/hash/6fec24eac8f18ed793f5eaad3dd7977c-Abstract.html). Sam Daulton, Maximilian Balandat, Eytan Bakshy. NeurIPS 2020.
- [Bayesian Optimization of Risk Measures
](https://proceedings.neurips.cc/paper/2020/hash/e8f2779682fd11fa2067beffc27a9192-Abstract.html). Sait Cakmak, Raul Astudillo Marban, Peter Frazier, Enlu Zhou. NeurIPS 2020.
- [High-Dimensional Contextual Policy Search with Unknown Context Rewards using Bayesian Optimization
](https://proceedings.neurips.cc/paper/2020/hash/faff959d885ec0ecf70741a846c34d1d-Abstract.html). Qing Feng, Benjamin Letham, Hongzi Mao, Eytan Bakshy. NeurIPS 2020.
- [High-Dimensional Bayesian Optimization via Nested Riemannian Manifolds](https://proceedings.neurips.cc/paper/2020/hash/f05da679342107f92111ad9d65959cd3-Abstract.html). Noémie Jaquier, Leonel Rozo. NeurIPS 2020.
- [Efficient Nonmyopic Bayesian Optimization via One-Shot Multi-Step Trees](https://proceedings.neurips.cc/paper/2020/hash/d1d5923fc822531bbfd9d87d4760914b-Abstract.html). Shali Jiang, Daniel Jiang, Maximilian Balandat, Brian Karrer, Jacob Gardner, Roman Garnett. NeurIPS 2020.
- [Re-Examining Linear Embeddings for High-Dimensional Bayesian Optimization](https://proceedings.neurips.cc/paper/2020/hash/10fb6cfa4c990d2bad5ddef4f70e8ba2-Abstract.html). Ben Letham, Roberto Calandra, Akshara Rai, Eytan Bakshy. NeurIPS 2020.
- [PareCO: Pareto-aware Channel Optimization for Slimmable Neural Networks
](https://arxiv.org/abs/2007.11752). Ting-Wu Chin, Ari S. Morcos, Diana Marculescu. ICML 2020 Workshop on Real World Experiment Design and Active Learning.
