# coding=utf-8
#
# Copyright (c) 2023, Empa, Leonie Fierz, Aaron Bojarski, Ricardo Parreira da Silva, Sven Eggimann.
#
# This file is part of CESAR-P - Combined Energy Simulation And Retrofit written in Python
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# Contact: https://www.empa.ch/web/s313
#
"""
Implementation retrofit following energy perspective 2050 (when default configurations are used).
Uses cesarp.energy_strategy for getting retrofit rates. There are two strategies, business as usual and new energy policy,
which can be chosen over the configuration of cesarp.energy_strategy package parameter ENERGY_STRATEGY_SELECTION.
"""

import os
from pathlib import Path

_default_config_file = os.path.dirname(__file__) / Path("energy_perspective_config.yml")
