# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.

""" An efficient Cython implementation of Generalized Random Forests [grf]_ and special
case python classes.

References
----------
.. [grf] Athey, Susan, Julie Tibshirani, and Stefan Wager. "Generalized random forests."
    The Annals of Statistics 47.2 (2019): 1148-1178
    https://arxiv.org/pdf/1610.01271.pdf
"""

from ._criterion import LinearMomentGRFCriterion, LinearMomentGRFCriterionMSE
from .classes import CausalForest, CausalIVForest, RegressionForest, MultiOutputGRF, BeatForest

__all__ = ["CausalForest",
           "CausalIVForest",
           "RegressionForest",
           "MultiOutputGRF",
           "BeatForest"
           "LinearMomentGRFCriterion",
           "LinearMomentGRFCriterionMSE",
           "LinearMomentGRFCriterionBEAT"]
