from typing import Tuple

from tunepy2.interfaces import AbstractRandomNumberGenerator
import numpy as np


class NumpyRNG(AbstractRandomNumberGenerator):
    """
    A tunepy2 wrapper for the number random number generator.
    """

    def __init__(
            self,
            seed=None,
            integer_type='int32'):
        """
        Creates a new numpy-based random number generator.

        :param seed: seed that will be passed into numpy (global to numpy)
        :param integer_type: numpy type of integers generated by this random number generator
        """
        if seed is not None:
            np.random.seed(seed)
        self._integer_type = integer_type

    def random(self) -> float:
        """
        Returns a random number between 0 and 1

        :return: random number between 0 and 1
        """
        return np.random.random()

    def random_int_array(self, minimum: int, maximum: int, shape: Tuple) -> Tuple:
        """
        Builds an array-like structure of random integers

        :param minimum: minimum value (inclusive)
        :param maximum: maximum value (exclusive)
        :param shape: the shape of the output
        :return: a collection of integers
        """
        return np.random.randint(minimum, maximum, size=shape, dtype=self._integer_type)
