from dataclasses import dataclass
from datetime import datetime, timedelta
from ad_leavers.models.core.object_class import ObjectClass

# > This is the User data class model
# > It inherits from the ObjectClass model
# > This class will model a user object in AD
# > It will take a schema as parameter
@dataclass
class User(ObjectClass):
    
    def __init__(self, schema: dict):
        
        # * Extract necessary parameters
        self.sam_account_name = schema['attributes']['samAccountName']
        self.description = schema['attributes'].get('description', None)
        self.display_name = schema['attributes'].get('displayName', None)
        self.member_of = schema['attributes'].get('memberOf', None)
        self.last_logon = schema['attributes'].get('lastLogon', None)
        self.last_logoff = schema['attributes'].get('lastLogoff', None)
        self.account_expires = schema['attributes'].get('accountExpires', None)
        self.user_principal_name = schema['attributes'].get('userPrincipalName', None)

        # * Initialize the parent class
        super().__init__(
            name=schema['attributes']['name'], 
            distinguished_name=schema['attributes']['distinguishedName'], 
            when_created=schema['attributes']['whenCreated']
        )
    
    def is_eligible_for_deletion(self, days_limit: int):
        
        # * Check whether the days limit has exceeded since the
        # * account was expired
        # TODO(Unit test function)
        return (self.account_expires + timedelta(days=days_limit)) <= datetime.today()