# gooddata-api-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0
- Package version: 1.13.1.dev3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import gooddata_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import gooddata_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import gooddata_api_client
from pprint import pprint
from gooddata_api_client.api import api_tokens_api
from gooddata_api_client.model.json_api_api_token_in_document import JsonApiApiTokenInDocument
from gooddata_api_client.model.json_api_api_token_out_document import JsonApiApiTokenOutDocument
from gooddata_api_client.model.json_api_api_token_out_list import JsonApiApiTokenOutList
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = gooddata_api_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with gooddata_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = api_tokens_api.APITokensApi(api_client)
    user_id = "userId_example" # str | 
    json_api_api_token_in_document = JsonApiApiTokenInDocument(
        data=JsonApiApiTokenIn(
            id="id1",
            type="apiToken",
        ),
    ) # JsonApiApiTokenInDocument | 

    try:
        # Post a new API token for the user
        api_response = api_instance.create_entity_api_tokens(user_id, json_api_api_token_in_document)
        pprint(api_response)
    except gooddata_api_client.ApiException as e:
        print("Exception when calling APITokensApi->create_entity_api_tokens: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APITokensApi* | [**create_entity_api_tokens**](docs/APITokensApi.md#create_entity_api_tokens) | **POST** /api/v1/entities/users/{userId}/apiTokens | Post a new API token for the user
*APITokensApi* | [**delete_entity_api_tokens**](docs/APITokensApi.md#delete_entity_api_tokens) | **DELETE** /api/v1/entities/users/{userId}/apiTokens/{id} | Delete an API Token for a user
*APITokensApi* | [**get_all_entities_api_tokens**](docs/APITokensApi.md#get_all_entities_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens | List all api tokens for a user
*APITokensApi* | [**get_entity_api_tokens**](docs/APITokensApi.md#get_entity_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens/{id} | Get an API Token for a user
*AnalyticsModelApi* | [**get_analytics_model**](docs/AnalyticsModelApi.md#get_analytics_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Get analytics model
*AnalyticsModelApi* | [**set_analytics_model**](docs/AnalyticsModelApi.md#set_analytics_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Set analytics model
*AppearanceApi* | [**create_entity_color_palettes**](docs/AppearanceApi.md#create_entity_color_palettes) | **POST** /api/v1/entities/colorPalettes | Post Color Pallettes
*AppearanceApi* | [**create_entity_themes**](docs/AppearanceApi.md#create_entity_themes) | **POST** /api/v1/entities/themes | Post Theming
*AppearanceApi* | [**delete_entity_color_palettes**](docs/AppearanceApi.md#delete_entity_color_palettes) | **DELETE** /api/v1/entities/colorPalettes/{id} | Delete a Color Pallette
*AppearanceApi* | [**delete_entity_themes**](docs/AppearanceApi.md#delete_entity_themes) | **DELETE** /api/v1/entities/themes/{id} | Delete Theming
*AppearanceApi* | [**get_all_entities_color_palettes**](docs/AppearanceApi.md#get_all_entities_color_palettes) | **GET** /api/v1/entities/colorPalettes | Get all Color Pallettes
*AppearanceApi* | [**get_all_entities_themes**](docs/AppearanceApi.md#get_all_entities_themes) | **GET** /api/v1/entities/themes | Get all Theming entities
*AppearanceApi* | [**get_entity_color_palettes**](docs/AppearanceApi.md#get_entity_color_palettes) | **GET** /api/v1/entities/colorPalettes/{id} | Get Color Pallette
*AppearanceApi* | [**get_entity_themes**](docs/AppearanceApi.md#get_entity_themes) | **GET** /api/v1/entities/themes/{id} | Get Theming
*AppearanceApi* | [**patch_entity_color_palettes**](docs/AppearanceApi.md#patch_entity_color_palettes) | **PATCH** /api/v1/entities/colorPalettes/{id} | Patch Color Pallette
*AppearanceApi* | [**patch_entity_themes**](docs/AppearanceApi.md#patch_entity_themes) | **PATCH** /api/v1/entities/themes/{id} | Patch Theming
*AppearanceApi* | [**update_entity_color_palettes**](docs/AppearanceApi.md#update_entity_color_palettes) | **PUT** /api/v1/entities/colorPalettes/{id} | Put Color Pallette
*AppearanceApi* | [**update_entity_themes**](docs/AppearanceApi.md#update_entity_themes) | **PUT** /api/v1/entities/themes/{id} | Put Theming
*AttributeHierarchiesApi* | [**create_entity_attribute_hierarchies**](docs/AttributeHierarchiesApi.md#create_entity_attribute_hierarchies) | **POST** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies | Post Attribute Hierarchies
*AttributeHierarchiesApi* | [**delete_entity_attribute_hierarchies**](docs/AttributeHierarchiesApi.md#delete_entity_attribute_hierarchies) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Delete an Attribute Hierarchy
*AttributeHierarchiesApi* | [**get_all_entities_attribute_hierarchies**](docs/AttributeHierarchiesApi.md#get_all_entities_attribute_hierarchies) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies | Get all Attribute Hierarchies
*AttributeHierarchiesApi* | [**get_entity_attribute_hierarchies**](docs/AttributeHierarchiesApi.md#get_entity_attribute_hierarchies) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Get an Attribute Hierarchy
*AttributeHierarchiesApi* | [**patch_entity_attribute_hierarchies**](docs/AttributeHierarchiesApi.md#patch_entity_attribute_hierarchies) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Patch an Attribute Hierarchy
*AttributeHierarchiesApi* | [**update_entity_attribute_hierarchies**](docs/AttributeHierarchiesApi.md#update_entity_attribute_hierarchies) | **PUT** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Put an Attribute Hierarchy
*AttributesApi* | [**get_all_entities_attributes**](docs/AttributesApi.md#get_all_entities_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes | Get all Attributes
*AttributesApi* | [**get_entity_attributes**](docs/AttributesApi.md#get_entity_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes/{objectId} | Get an Attribute
*AvailableDriversApi* | [**get_data_source_drivers**](docs/AvailableDriversApi.md#get_data_source_drivers) | **GET** /api/v1/options/availableDrivers | Get all available data source drivers
*CSPDirectivesApi* | [**create_entity_csp_directives**](docs/CSPDirectivesApi.md#create_entity_csp_directives) | **POST** /api/v1/entities/cspDirectives | Post CSP Directives
*CSPDirectivesApi* | [**delete_entity_csp_directives**](docs/CSPDirectivesApi.md#delete_entity_csp_directives) | **DELETE** /api/v1/entities/cspDirectives/{id} | Delete CSP Directives
*CSPDirectivesApi* | [**get_all_entities_csp_directives**](docs/CSPDirectivesApi.md#get_all_entities_csp_directives) | **GET** /api/v1/entities/cspDirectives | Get CSP Directives
*CSPDirectivesApi* | [**get_entity_csp_directives**](docs/CSPDirectivesApi.md#get_entity_csp_directives) | **GET** /api/v1/entities/cspDirectives/{id} | Get CSP Directives
*CSPDirectivesApi* | [**patch_entity_csp_directives**](docs/CSPDirectivesApi.md#patch_entity_csp_directives) | **PATCH** /api/v1/entities/cspDirectives/{id} | Patch CSP Directives
*CSPDirectivesApi* | [**update_entity_csp_directives**](docs/CSPDirectivesApi.md#update_entity_csp_directives) | **PUT** /api/v1/entities/cspDirectives/{id} | Put CSP Directives
*ComputationApi* | [**compute_label_elements_post**](docs/ComputationApi.md#compute_label_elements_post) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/collectLabelElements | Listing of label values. The resulting data are limited by the static platform limit to the maximum of 10000 rows.
*ComputationApi* | [**compute_report**](docs/ComputationApi.md#compute_report) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute | Executes analytical request and returns link to the result
*ComputationApi* | [**compute_valid_descendants**](docs/ComputationApi.md#compute_valid_descendants) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/computeValidDescendants | (BETA) Valid descendants
*ComputationApi* | [**compute_valid_objects**](docs/ComputationApi.md#compute_valid_objects) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/computeValidObjects | Valid objects
*ComputationApi* | [**create_tabular_export**](docs/ComputationApi.md#create_tabular_export) | **POST** /api/v1/actions/workspaces/{workspaceId}/export/tabular | Create tabular export request
*ComputationApi* | [**explain_afm**](docs/ComputationApi.md#explain_afm) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/explain | AFM explain resource.
*ComputationApi* | [**get_anomaly_detection_result**](docs/ComputationApi.md#get_anomaly_detection_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/ml/anomalyDetection/result/{resultId} | 
*ComputationApi* | [**get_clustering_result**](docs/ComputationApi.md#get_clustering_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/ml/clustering/result/{resultId} | 
*ComputationApi* | [**get_forecast_result**](docs/ComputationApi.md#get_forecast_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/ml/forecast/result/{resultId} | 
*ComputationApi* | [**get_result**](docs/ComputationApi.md#get_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/computeKeyDrivers/result/{resultId} | 
*ComputationApi* | [**get_tabular_export**](docs/ComputationApi.md#get_tabular_export) | **GET** /api/v1/actions/workspaces/{workspaceId}/export/tabular/{exportId} | Retrieve exported files
*ComputationApi* | [**process_anomaly_detection**](docs/ComputationApi.md#process_anomaly_detection) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/ml/anomalyDetection/{resultId} | 
*ComputationApi* | [**process_clustering_request**](docs/ComputationApi.md#process_clustering_request) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/ml/clustering/{resultId} | 
*ComputationApi* | [**process_forecast_request**](docs/ComputationApi.md#process_forecast_request) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/ml/forecast/{resultId} | 
*ComputationApi* | [**process_key_drivers_request**](docs/ComputationApi.md#process_key_drivers_request) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/computeKeyDrivers | 
*ComputationApi* | [**retrieve_execution_metadata**](docs/ComputationApi.md#retrieve_execution_metadata) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute/result/{resultId}/metadata | Get a single execution result&#39;s metadata.
*ComputationApi* | [**retrieve_result**](docs/ComputationApi.md#retrieve_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute/result/{resultId} | Get a single execution result
*ContextFiltersApi* | [**create_entity_filter_contexts**](docs/ContextFiltersApi.md#create_entity_filter_contexts) | **POST** /api/v1/entities/workspaces/{workspaceId}/filterContexts | Post Context Filters
*ContextFiltersApi* | [**delete_entity_filter_contexts**](docs/ContextFiltersApi.md#delete_entity_filter_contexts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Delete a Context Filter
*ContextFiltersApi* | [**get_all_entities_filter_contexts**](docs/ContextFiltersApi.md#get_all_entities_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts | Get all Context Filters
*ContextFiltersApi* | [**get_entity_filter_contexts**](docs/ContextFiltersApi.md#get_entity_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Get a Context Filter
*ContextFiltersApi* | [**patch_entity_filter_contexts**](docs/ContextFiltersApi.md#patch_entity_filter_contexts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Patch a Context Filter
*ContextFiltersApi* | [**update_entity_filter_contexts**](docs/ContextFiltersApi.md#update_entity_filter_contexts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Put a Context Filter
*CookieSecurityConfigurationApi* | [**get_entity_cookie_security_configurations**](docs/CookieSecurityConfigurationApi.md#get_entity_cookie_security_configurations) | **GET** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Get CookieSecurityConfiguration
*CookieSecurityConfigurationApi* | [**patch_entity_cookie_security_configurations**](docs/CookieSecurityConfigurationApi.md#patch_entity_cookie_security_configurations) | **PATCH** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Patch CookieSecurityConfiguration
*CookieSecurityConfigurationApi* | [**update_entity_cookie_security_configurations**](docs/CookieSecurityConfigurationApi.md#update_entity_cookie_security_configurations) | **PUT** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Put CookieSecurityConfiguration
*DashboardsApi* | [**create_entity_analytical_dashboards**](docs/DashboardsApi.md#create_entity_analytical_dashboards) | **POST** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | Post Dashboards
*DashboardsApi* | [**delete_entity_analytical_dashboards**](docs/DashboardsApi.md#delete_entity_analytical_dashboards) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Delete a Dashboard
*DashboardsApi* | [**get_all_entities_analytical_dashboards**](docs/DashboardsApi.md#get_all_entities_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | Get all Dashboards
*DashboardsApi* | [**get_entity_analytical_dashboards**](docs/DashboardsApi.md#get_entity_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Get a Dashboard
*DashboardsApi* | [**patch_entity_analytical_dashboards**](docs/DashboardsApi.md#patch_entity_analytical_dashboards) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Patch a Dashboard
*DashboardsApi* | [**update_entity_analytical_dashboards**](docs/DashboardsApi.md#update_entity_analytical_dashboards) | **PUT** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Put Dashboards
*DataFiltersApi* | [**create_entity_user_data_filters**](docs/DataFiltersApi.md#create_entity_user_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/userDataFilters | Post User Data Filters
*DataFiltersApi* | [**create_entity_workspace_data_filter_settings**](docs/DataFiltersApi.md#create_entity_workspace_data_filter_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | Post Settings for Workspace Data Filters
*DataFiltersApi* | [**create_entity_workspace_data_filters**](docs/DataFiltersApi.md#create_entity_workspace_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | Post Workspace Data Filters
*DataFiltersApi* | [**delete_entity_user_data_filters**](docs/DataFiltersApi.md#delete_entity_user_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Delete a User Data Filter
*DataFiltersApi* | [**delete_entity_workspace_data_filter_settings**](docs/DataFiltersApi.md#delete_entity_workspace_data_filter_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Delete a Settings for Workspace Data Filter
*DataFiltersApi* | [**delete_entity_workspace_data_filters**](docs/DataFiltersApi.md#delete_entity_workspace_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Delete a Workspace Data Filter
*DataFiltersApi* | [**get_all_entities_user_data_filters**](docs/DataFiltersApi.md#get_all_entities_user_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/userDataFilters | Get all User Data Filters
*DataFiltersApi* | [**get_all_entities_workspace_data_filter_settings**](docs/DataFiltersApi.md#get_all_entities_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | Get all Settings for Workspace Data Filters
*DataFiltersApi* | [**get_all_entities_workspace_data_filters**](docs/DataFiltersApi.md#get_all_entities_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | Get all Workspace Data Filters
*DataFiltersApi* | [**get_entity_user_data_filters**](docs/DataFiltersApi.md#get_entity_user_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Get a User Data Filter
*DataFiltersApi* | [**get_entity_workspace_data_filter_settings**](docs/DataFiltersApi.md#get_entity_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Get a Setting for Workspace Data Filter
*DataFiltersApi* | [**get_entity_workspace_data_filters**](docs/DataFiltersApi.md#get_entity_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Get a Workspace Data Filter
*DataFiltersApi* | [**get_workspace_data_filters_layout**](docs/DataFiltersApi.md#get_workspace_data_filters_layout) | **GET** /api/v1/layout/workspaceDataFilters | Get workspace data filters for all workspaces
*DataFiltersApi* | [**patch_entity_user_data_filters**](docs/DataFiltersApi.md#patch_entity_user_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Patch a User Data Filter
*DataFiltersApi* | [**patch_entity_workspace_data_filter_settings**](docs/DataFiltersApi.md#patch_entity_workspace_data_filter_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Patch a Settings for Workspace Data Filter
*DataFiltersApi* | [**patch_entity_workspace_data_filters**](docs/DataFiltersApi.md#patch_entity_workspace_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Patch a Workspace Data Filter
*DataFiltersApi* | [**set_workspace_data_filters_layout**](docs/DataFiltersApi.md#set_workspace_data_filters_layout) | **PUT** /api/v1/layout/workspaceDataFilters | Set all workspace data filters
*DataFiltersApi* | [**update_entity_user_data_filters**](docs/DataFiltersApi.md#update_entity_user_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Put a User Data Filter
*DataFiltersApi* | [**update_entity_workspace_data_filter_settings**](docs/DataFiltersApi.md#update_entity_workspace_data_filter_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Put a Settings for Workspace Data Filter
*DataFiltersApi* | [**update_entity_workspace_data_filters**](docs/DataFiltersApi.md#update_entity_workspace_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Put a Workspace Data Filter
*DataSourceDeclarativeAPIsApi* | [**get_data_sources_layout**](docs/DataSourceDeclarativeAPIsApi.md#get_data_sources_layout) | **GET** /api/v1/layout/dataSources | Get all data sources
*DataSourceDeclarativeAPIsApi* | [**put_data_sources_layout**](docs/DataSourceDeclarativeAPIsApi.md#put_data_sources_layout) | **PUT** /api/v1/layout/dataSources | Put all data sources
*DataSourceEntityAPIsApi* | [**create_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#create_entity_data_sources) | **POST** /api/v1/entities/dataSources | Post Data Sources
*DataSourceEntityAPIsApi* | [**delete_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#delete_entity_data_sources) | **DELETE** /api/v1/entities/dataSources/{id} | Delete Data Source entity
*DataSourceEntityAPIsApi* | [**get_all_entities_data_source_identifiers**](docs/DataSourceEntityAPIsApi.md#get_all_entities_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers | Get all Data Source Identifiers
*DataSourceEntityAPIsApi* | [**get_all_entities_data_sources**](docs/DataSourceEntityAPIsApi.md#get_all_entities_data_sources) | **GET** /api/v1/entities/dataSources | Get Data Source entities
*DataSourceEntityAPIsApi* | [**get_entity_data_source_identifiers**](docs/DataSourceEntityAPIsApi.md#get_entity_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers/{id} | Get Data Source Identifier
*DataSourceEntityAPIsApi* | [**get_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#get_entity_data_sources) | **GET** /api/v1/entities/dataSources/{id} | Get Data Source entity
*DataSourceEntityAPIsApi* | [**patch_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#patch_entity_data_sources) | **PATCH** /api/v1/entities/dataSources/{id} | Patch Data Source entity
*DataSourceEntityAPIsApi* | [**update_entity_data_sources**](docs/DataSourceEntityAPIsApi.md#update_entity_data_sources) | **PUT** /api/v1/entities/dataSources/{id} | Put Data Source entity
*DatasetsApi* | [**get_all_entities_datasets**](docs/DatasetsApi.md#get_all_entities_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets | Get all Datasets
*DatasetsApi* | [**get_entity_datasets**](docs/DatasetsApi.md#get_entity_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets/{objectId} | Get a Dataset
*DependencyGraphApi* | [**get_dependent_entities_graph**](docs/DependencyGraphApi.md#get_dependent_entities_graph) | **GET** /api/v1/actions/workspaces/{workspaceId}/dependentEntitiesGraph | Computes the dependent entities graph
*DependencyGraphApi* | [**get_dependent_entities_graph_from_entry_points**](docs/DependencyGraphApi.md#get_dependent_entities_graph_from_entry_points) | **POST** /api/v1/actions/workspaces/{workspaceId}/dependentEntitiesGraph | Computes the dependent entities graph from given entry points
*EntitlementApi* | [**get_all_entities_entitlements**](docs/EntitlementApi.md#get_all_entities_entitlements) | **GET** /api/v1/entities/entitlements | Get Entitlements
*EntitlementApi* | [**get_entity_entitlements**](docs/EntitlementApi.md#get_entity_entitlements) | **GET** /api/v1/entities/entitlements/{id} | Get Entitlement
*EntitlementApi* | [**resolve_all_entitlements**](docs/EntitlementApi.md#resolve_all_entitlements) | **GET** /api/v1/actions/resolveEntitlements | Values for all public entitlements.
*EntitlementApi* | [**resolve_requested_entitlements**](docs/EntitlementApi.md#resolve_requested_entitlements) | **POST** /api/v1/actions/resolveEntitlements | Values for requested public entitlements.
*ExportingApi* | [**create_pdf_export**](docs/ExportingApi.md#create_pdf_export) | **POST** /api/v1/actions/workspaces/{workspaceId}/export/visual | Create visual - pdf export request
*ExportingApi* | [**get_exported_file**](docs/ExportingApi.md#get_exported_file) | **GET** /api/v1/actions/workspaces/{workspaceId}/export/visual/{exportId} | Retrieve exported files
*ExportingApi* | [**get_metadata**](docs/ExportingApi.md#get_metadata) | **GET** /api/v1/actions/workspaces/{workspaceId}/export/visual/{exportId}/metadata | Retrieve metadata context
*FactsApi* | [**get_all_entities_facts**](docs/FactsApi.md#get_all_entities_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts | Get all Facts
*FactsApi* | [**get_entity_facts**](docs/FactsApi.md#get_entity_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts/{objectId} | Get a Fact
*GenerateLogicalDataModelApi* | [**generate_logical_model**](docs/GenerateLogicalDataModelApi.md#generate_logical_model) | **POST** /api/v1/actions/dataSources/{dataSourceId}/generateLogicalModel | Generate logical data model (LDM) from physical data model (PDM)
*HierarchyApi* | [**check_entity_overrides**](docs/HierarchyApi.md#check_entity_overrides) | **POST** /api/v1/actions/workspaces/{workspaceId}/checkEntityOverrides | Finds entities with given ID in hierarchy.
*HierarchyApi* | [**inherited_entity_conflicts**](docs/HierarchyApi.md#inherited_entity_conflicts) | **GET** /api/v1/actions/workspaces/{workspaceId}/inheritedEntityConflicts | Finds identifier conflicts in workspace hierarchy.
*HierarchyApi* | [**inherited_entity_prefixes**](docs/HierarchyApi.md#inherited_entity_prefixes) | **GET** /api/v1/actions/workspaces/{workspaceId}/inheritedEntityPrefixes | Get used entity prefixes in hierarchy
*HierarchyApi* | [**overridden_child_entities**](docs/HierarchyApi.md#overridden_child_entities) | **GET** /api/v1/actions/workspaces/{workspaceId}/overriddenChildEntities | Finds identifier overrides in workspace hierarchy.
*InvalidateCacheApi* | [**register_upload_notification**](docs/InvalidateCacheApi.md#register_upload_notification) | **POST** /api/v1/actions/dataSources/{dataSourceId}/uploadNotification | Register an upload notification
*JWKSApi* | [**create_entity_jwks**](docs/JWKSApi.md#create_entity_jwks) | **POST** /api/v1/entities/jwks | Post Jwks
*JWKSApi* | [**delete_entity_jwks**](docs/JWKSApi.md#delete_entity_jwks) | **DELETE** /api/v1/entities/jwks/{id} | Delete Jwk
*JWKSApi* | [**get_all_entities_jwks**](docs/JWKSApi.md#get_all_entities_jwks) | **GET** /api/v1/entities/jwks | Get all Jwks
*JWKSApi* | [**get_entity_jwks**](docs/JWKSApi.md#get_entity_jwks) | **GET** /api/v1/entities/jwks/{id} | Get Jwk
*JWKSApi* | [**patch_entity_jwks**](docs/JWKSApi.md#patch_entity_jwks) | **PATCH** /api/v1/entities/jwks/{id} | Patch Jwk
*JWKSApi* | [**update_entity_jwks**](docs/JWKSApi.md#update_entity_jwks) | **PUT** /api/v1/entities/jwks/{id} | Put Jwk
*LDMDeclarativeAPIsApi* | [**get_logical_model**](docs/LDMDeclarativeAPIsApi.md#get_logical_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Get logical model
*LDMDeclarativeAPIsApi* | [**set_logical_model**](docs/LDMDeclarativeAPIsApi.md#set_logical_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Set logical model
*LabelsApi* | [**get_all_entities_labels**](docs/LabelsApi.md#get_all_entities_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels | Get all Labels
*LabelsApi* | [**get_entity_labels**](docs/LabelsApi.md#get_entity_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels/{objectId} | Get a Label
*MetricsApi* | [**create_entity_metrics**](docs/MetricsApi.md#create_entity_metrics) | **POST** /api/v1/entities/workspaces/{workspaceId}/metrics | Post Metrics
*MetricsApi* | [**delete_entity_metrics**](docs/MetricsApi.md#delete_entity_metrics) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Delete a Metric
*MetricsApi* | [**get_all_entities_metrics**](docs/MetricsApi.md#get_all_entities_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics | Get all Metrics
*MetricsApi* | [**get_entity_metrics**](docs/MetricsApi.md#get_entity_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Get a Metric
*MetricsApi* | [**patch_entity_metrics**](docs/MetricsApi.md#patch_entity_metrics) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Patch a Metric
*MetricsApi* | [**update_entity_metrics**](docs/MetricsApi.md#update_entity_metrics) | **PUT** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Put a Metric
*OptionsApi* | [**get_all_options**](docs/OptionsApi.md#get_all_options) | **GET** /api/v1/options | Links for all configuration options
*OrganizationDeclarativeAPIsApi* | [**get_organization_layout**](docs/OrganizationDeclarativeAPIsApi.md#get_organization_layout) | **GET** /api/v1/layout/organization | Get organization layout
*OrganizationDeclarativeAPIsApi* | [**set_organization_layout**](docs/OrganizationDeclarativeAPIsApi.md#set_organization_layout) | **PUT** /api/v1/layout/organization | Set organization layout
*OrganizationEntityAPIsApi* | [**create_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#create_entity_organization_settings) | **POST** /api/v1/entities/organizationSettings | Post Organization Setting entities
*OrganizationEntityAPIsApi* | [**delete_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#delete_entity_organization_settings) | **DELETE** /api/v1/entities/organizationSettings/{id} | Delete Organization entity
*OrganizationEntityAPIsApi* | [**get_all_entities_organization_settings**](docs/OrganizationEntityAPIsApi.md#get_all_entities_organization_settings) | **GET** /api/v1/entities/organizationSettings | Get Organization entities
*OrganizationEntityAPIsApi* | [**get_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#get_entity_organization_settings) | **GET** /api/v1/entities/organizationSettings/{id} | Get Organization entity
*OrganizationEntityAPIsApi* | [**get_entity_organizations**](docs/OrganizationEntityAPIsApi.md#get_entity_organizations) | **GET** /api/v1/entities/admin/organizations/{id} | Get Organizations
*OrganizationEntityAPIsApi* | [**get_organization**](docs/OrganizationEntityAPIsApi.md#get_organization) | **GET** /api/v1/entities/organization | Get current organization info
*OrganizationEntityAPIsApi* | [**patch_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#patch_entity_organization_settings) | **PATCH** /api/v1/entities/organizationSettings/{id} | Patch Organization entity
*OrganizationEntityAPIsApi* | [**patch_entity_organizations**](docs/OrganizationEntityAPIsApi.md#patch_entity_organizations) | **PATCH** /api/v1/entities/admin/organizations/{id} | Patch Organization
*OrganizationEntityAPIsApi* | [**update_entity_organization_settings**](docs/OrganizationEntityAPIsApi.md#update_entity_organization_settings) | **PUT** /api/v1/entities/organizationSettings/{id} | Put Organization entity
*OrganizationEntityAPIsApi* | [**update_entity_organizations**](docs/OrganizationEntityAPIsApi.md#update_entity_organizations) | **PUT** /api/v1/entities/admin/organizations/{id} | Put Organization
*PermissionsApi* | [**available_assignees**](docs/PermissionsApi.md#available_assignees) | **GET** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/availableAssignees | Get Available Assignees
*PermissionsApi* | [**dashboard_permissions**](docs/PermissionsApi.md#dashboard_permissions) | **GET** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/permissions | Get Dashboard Permissions
*PermissionsApi* | [**get_organization_permissions**](docs/PermissionsApi.md#get_organization_permissions) | **GET** /api/v1/layout/organization/permissions | Get organization permissions
*PermissionsApi* | [**get_user_group_permissions**](docs/PermissionsApi.md#get_user_group_permissions) | **GET** /api/v1/layout/userGroups/{userGroupId}/permissions | Get permissions for the user-group
*PermissionsApi* | [**get_user_permissions**](docs/PermissionsApi.md#get_user_permissions) | **GET** /api/v1/layout/users/{userId}/permissions | Get permissions for the user
*PermissionsApi* | [**get_workspace_permissions**](docs/PermissionsApi.md#get_workspace_permissions) | **GET** /api/v1/layout/workspaces/{workspaceId}/permissions | Get permissions for the workspace
*PermissionsApi* | [**manage_dashboard_permissions**](docs/PermissionsApi.md#manage_dashboard_permissions) | **POST** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/managePermissions | Manage Permissions for a Dashboard
*PermissionsApi* | [**manage_data_source_permissions**](docs/PermissionsApi.md#manage_data_source_permissions) | **POST** /api/v1/actions/dataSources/{dataSourceId}/managePermissions | Manage Permissions for a Data Source
*PermissionsApi* | [**manage_organization_permissions**](docs/PermissionsApi.md#manage_organization_permissions) | **POST** /api/v1/actions/organization/managePermissions | Manage Permissions for a Organization
*PermissionsApi* | [**manage_workspace_permissions**](docs/PermissionsApi.md#manage_workspace_permissions) | **POST** /api/v1/actions/workspaces/{workspaceId}/managePermissions | Manage Permissions for a Workspace
*PermissionsApi* | [**set_organization_permissions**](docs/PermissionsApi.md#set_organization_permissions) | **PUT** /api/v1/layout/organization/permissions | Set organization permissions
*PermissionsApi* | [**set_user_group_permissions**](docs/PermissionsApi.md#set_user_group_permissions) | **PUT** /api/v1/layout/userGroups/{userGroupId}/permissions | Set permissions for the user-group
*PermissionsApi* | [**set_user_permissions**](docs/PermissionsApi.md#set_user_permissions) | **PUT** /api/v1/layout/users/{userId}/permissions | Set permissions for the user
*PermissionsApi* | [**set_workspace_permissions**](docs/PermissionsApi.md#set_workspace_permissions) | **PUT** /api/v1/layout/workspaces/{workspaceId}/permissions | Set permissions for the workspace
*PluginsApi* | [**create_entity_dashboard_plugins**](docs/PluginsApi.md#create_entity_dashboard_plugins) | **POST** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | Post Plugins
*PluginsApi* | [**delete_entity_dashboard_plugins**](docs/PluginsApi.md#delete_entity_dashboard_plugins) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Delete a Plugin
*PluginsApi* | [**get_all_entities_dashboard_plugins**](docs/PluginsApi.md#get_all_entities_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | Get all Plugins
*PluginsApi* | [**get_entity_dashboard_plugins**](docs/PluginsApi.md#get_entity_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Get a Plugin
*PluginsApi* | [**patch_entity_dashboard_plugins**](docs/PluginsApi.md#patch_entity_dashboard_plugins) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Patch a Plugin
*PluginsApi* | [**update_entity_dashboard_plugins**](docs/PluginsApi.md#update_entity_dashboard_plugins) | **PUT** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Put a Plugin
*ReportingSettingsApi* | [**resolve_all_settings_without_workspace**](docs/ReportingSettingsApi.md#resolve_all_settings_without_workspace) | **GET** /api/v1/actions/resolveSettings | Values for all settings without workspace.
*ReportingSettingsApi* | [**resolve_settings_without_workspace**](docs/ReportingSettingsApi.md#resolve_settings_without_workspace) | **POST** /api/v1/actions/resolveSettings | Values for selected settings without workspace.
*ScanningApi* | [**get_data_source_schemata**](docs/ScanningApi.md#get_data_source_schemata) | **GET** /api/v1/actions/dataSources/{dataSourceId}/scanSchemata | Get a list of schema names of a database
*ScanningApi* | [**scan_data_source**](docs/ScanningApi.md#scan_data_source) | **POST** /api/v1/actions/dataSources/{dataSourceId}/scan | Scan a database to get a physical data model (PDM)
*ScanningApi* | [**scan_sql**](docs/ScanningApi.md#scan_sql) | **POST** /api/v1/actions/dataSources/{dataSourceId}/scanSql | Collect metadata about SQL query
*TestConnectionApi* | [**test_data_source**](docs/TestConnectionApi.md#test_data_source) | **POST** /api/v1/actions/dataSources/{dataSourceId}/test | Test data source connection by data source id
*TestConnectionApi* | [**test_data_source_definition**](docs/TestConnectionApi.md#test_data_source_definition) | **POST** /api/v1/actions/dataSource/test | Test connection by data source definition
*TranslationsApi* | [**clean_translations**](docs/TranslationsApi.md#clean_translations) | **POST** /api/v1/actions/workspaces/{workspaceId}/translations/clean | Cleans up translations.
*TranslationsApi* | [**get_translation_tags**](docs/TranslationsApi.md#get_translation_tags) | **GET** /api/v1/actions/workspaces/{workspaceId}/translations | Get translation tags.
*TranslationsApi* | [**retrieve_translations**](docs/TranslationsApi.md#retrieve_translations) | **POST** /api/v1/actions/workspaces/{workspaceId}/translations/retrieve | Retrieve translations for entities.
*TranslationsApi* | [**set_translations**](docs/TranslationsApi.md#set_translations) | **POST** /api/v1/actions/workspaces/{workspaceId}/translations/set | Set translations for entities.
*UsageApi* | [**all_platform_usage**](docs/UsageApi.md#all_platform_usage) | **GET** /api/v1/actions/collectUsage | Info about the platform usage.
*UsageApi* | [**particular_platform_usage**](docs/UsageApi.md#particular_platform_usage) | **POST** /api/v1/actions/collectUsage | Info about the platform usage for particular items.
*UserGroupsDeclarativeAPIsApi* | [**get_user_groups_layout**](docs/UserGroupsDeclarativeAPIsApi.md#get_user_groups_layout) | **GET** /api/v1/layout/userGroups | Get all user groups
*UserGroupsDeclarativeAPIsApi* | [**get_users_user_groups_layout**](docs/UserGroupsDeclarativeAPIsApi.md#get_users_user_groups_layout) | **GET** /api/v1/layout/usersAndUserGroups | Get all users and user groups
*UserGroupsDeclarativeAPIsApi* | [**put_user_groups_layout**](docs/UserGroupsDeclarativeAPIsApi.md#put_user_groups_layout) | **PUT** /api/v1/layout/userGroups | Put all user groups
*UserGroupsDeclarativeAPIsApi* | [**put_users_user_groups_layout**](docs/UserGroupsDeclarativeAPIsApi.md#put_users_user_groups_layout) | **PUT** /api/v1/layout/usersAndUserGroups | Put all users and user groups
*UserGroupsEntityAPIsApi* | [**create_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#create_entity_user_groups) | **POST** /api/v1/entities/userGroups | Post User Group entities
*UserGroupsEntityAPIsApi* | [**delete_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#delete_entity_user_groups) | **DELETE** /api/v1/entities/userGroups/{id} | Delete UserGroup entity
*UserGroupsEntityAPIsApi* | [**get_all_entities_user_groups**](docs/UserGroupsEntityAPIsApi.md#get_all_entities_user_groups) | **GET** /api/v1/entities/userGroups | Get UserGroup entities
*UserGroupsEntityAPIsApi* | [**get_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#get_entity_user_groups) | **GET** /api/v1/entities/userGroups/{id} | Get UserGroup entity
*UserGroupsEntityAPIsApi* | [**patch_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#patch_entity_user_groups) | **PATCH** /api/v1/entities/userGroups/{id} | Patch UserGroup entity
*UserGroupsEntityAPIsApi* | [**update_entity_user_groups**](docs/UserGroupsEntityAPIsApi.md#update_entity_user_groups) | **PUT** /api/v1/entities/userGroups/{id} | Put UserGroup entity
*UserDataFiltersApi* | [**get_user_data_filters**](docs/UserDataFiltersApi.md#get_user_data_filters) | **GET** /api/v1/layout/workspaces/{workspaceId}/userDataFilters | Get user data filters
*UserDataFiltersApi* | [**set_user_data_filters**](docs/UserDataFiltersApi.md#set_user_data_filters) | **PUT** /api/v1/layout/workspaces/{workspaceId}/userDataFilters | Set user data filters
*UserIdentifiersApi* | [**get_all_entities_user_identifiers**](docs/UserIdentifiersApi.md#get_all_entities_user_identifiers) | **GET** /api/v1/entities/userIdentifiers | Get UserIdentifier entities
*UserIdentifiersApi* | [**get_entity_user_identifiers**](docs/UserIdentifiersApi.md#get_entity_user_identifiers) | **GET** /api/v1/entities/userIdentifiers/{id} | Get UserIdentifier entity
*UserSettingsApi* | [**create_entity_user_settings**](docs/UserSettingsApi.md#create_entity_user_settings) | **POST** /api/v1/entities/users/{userId}/userSettings | Post new user settings for the user
*UserSettingsApi* | [**delete_entity_user_settings**](docs/UserSettingsApi.md#delete_entity_user_settings) | **DELETE** /api/v1/entities/users/{userId}/userSettings/{id} | Delete a setting for a user
*UserSettingsApi* | [**get_all_entities_user_settings**](docs/UserSettingsApi.md#get_all_entities_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings | List all settings for a user
*UserSettingsApi* | [**get_entity_user_settings**](docs/UserSettingsApi.md#get_entity_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings/{id} | Get a setting for a user
*UserSettingsApi* | [**update_entity_user_settings**](docs/UserSettingsApi.md#update_entity_user_settings) | **PUT** /api/v1/entities/users/{userId}/userSettings/{id} | Put new user settings for the user
*UsersDeclarativeAPIsApi* | [**get_users_layout**](docs/UsersDeclarativeAPIsApi.md#get_users_layout) | **GET** /api/v1/layout/users | Get all users
*UsersDeclarativeAPIsApi* | [**put_users_layout**](docs/UsersDeclarativeAPIsApi.md#put_users_layout) | **PUT** /api/v1/layout/users | Put all users
*UsersEntityAPIsApi* | [**create_entity_users**](docs/UsersEntityAPIsApi.md#create_entity_users) | **POST** /api/v1/entities/users | Post User entities
*UsersEntityAPIsApi* | [**delete_entity_users**](docs/UsersEntityAPIsApi.md#delete_entity_users) | **DELETE** /api/v1/entities/users/{id} | Delete User entity
*UsersEntityAPIsApi* | [**get_all_entities_users**](docs/UsersEntityAPIsApi.md#get_all_entities_users) | **GET** /api/v1/entities/users | Get User entities
*UsersEntityAPIsApi* | [**get_entity_users**](docs/UsersEntityAPIsApi.md#get_entity_users) | **GET** /api/v1/entities/users/{id} | Get User entity
*UsersEntityAPIsApi* | [**patch_entity_users**](docs/UsersEntityAPIsApi.md#patch_entity_users) | **PATCH** /api/v1/entities/users/{id} | Patch User entity
*UsersEntityAPIsApi* | [**update_entity_users**](docs/UsersEntityAPIsApi.md#update_entity_users) | **PUT** /api/v1/entities/users/{id} | Put User entity
*VisualizationObjectApi* | [**create_entity_visualization_objects**](docs/VisualizationObjectApi.md#create_entity_visualization_objects) | **POST** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | Post Visualization Objects
*VisualizationObjectApi* | [**delete_entity_visualization_objects**](docs/VisualizationObjectApi.md#delete_entity_visualization_objects) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Delete a Visualization Object
*VisualizationObjectApi* | [**get_all_entities_visualization_objects**](docs/VisualizationObjectApi.md#get_all_entities_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | Get all Visualization Objects
*VisualizationObjectApi* | [**get_entity_visualization_objects**](docs/VisualizationObjectApi.md#get_entity_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Get a Visualization Object
*VisualizationObjectApi* | [**patch_entity_visualization_objects**](docs/VisualizationObjectApi.md#patch_entity_visualization_objects) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Patch a Visualization Object
*VisualizationObjectApi* | [**update_entity_visualization_objects**](docs/VisualizationObjectApi.md#update_entity_visualization_objects) | **PUT** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Put a Visualization Object
*WidgetAlertsApi* | [**create_entity_widget_alerts**](docs/WidgetAlertsApi.md#create_entity_widget_alerts) | **POST** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts | Post Widget Alerts
*WidgetAlertsApi* | [**delete_entity_widget_alerts**](docs/WidgetAlertsApi.md#delete_entity_widget_alerts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Delete a Widget Alert
*WidgetAlertsApi* | [**get_all_entities_widget_alerts**](docs/WidgetAlertsApi.md#get_all_entities_widget_alerts) | **GET** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts | Get all Widget Alerts
*WidgetAlertsApi* | [**get_entity_widget_alerts**](docs/WidgetAlertsApi.md#get_entity_widget_alerts) | **GET** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Get a Widget Alert
*WidgetAlertsApi* | [**patch_entity_widget_alerts**](docs/WidgetAlertsApi.md#patch_entity_widget_alerts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Patch a Widget Alert
*WidgetAlertsApi* | [**update_entity_widget_alerts**](docs/WidgetAlertsApi.md#update_entity_widget_alerts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Put a Widget Alert
*WorkspacesDeclarativeAPIsApi* | [**get_workspace_layout**](docs/WorkspacesDeclarativeAPIsApi.md#get_workspace_layout) | **GET** /api/v1/layout/workspaces/{workspaceId} | Get workspace layout
*WorkspacesDeclarativeAPIsApi* | [**get_workspaces_layout**](docs/WorkspacesDeclarativeAPIsApi.md#get_workspaces_layout) | **GET** /api/v1/layout/workspaces | Get all workspaces layout
*WorkspacesDeclarativeAPIsApi* | [**put_workspace_layout**](docs/WorkspacesDeclarativeAPIsApi.md#put_workspace_layout) | **PUT** /api/v1/layout/workspaces/{workspaceId} | Set workspace layout
*WorkspacesDeclarativeAPIsApi* | [**set_workspaces_layout**](docs/WorkspacesDeclarativeAPIsApi.md#set_workspaces_layout) | **PUT** /api/v1/layout/workspaces | Set all workspaces layout
*WorkspacesEntityAPIsApi* | [**create_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#create_entity_workspaces) | **POST** /api/v1/entities/workspaces | Post Workspace entities
*WorkspacesEntityAPIsApi* | [**delete_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#delete_entity_workspaces) | **DELETE** /api/v1/entities/workspaces/{id} | Delete Workspace entity
*WorkspacesEntityAPIsApi* | [**get_all_entities_workspaces**](docs/WorkspacesEntityAPIsApi.md#get_all_entities_workspaces) | **GET** /api/v1/entities/workspaces | Get Workspace entities
*WorkspacesEntityAPIsApi* | [**get_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#get_entity_workspaces) | **GET** /api/v1/entities/workspaces/{id} | Get Workspace entity
*WorkspacesEntityAPIsApi* | [**patch_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#patch_entity_workspaces) | **PATCH** /api/v1/entities/workspaces/{id} | Patch Workspace entity
*WorkspacesEntityAPIsApi* | [**update_entity_workspaces**](docs/WorkspacesEntityAPIsApi.md#update_entity_workspaces) | **PUT** /api/v1/entities/workspaces/{id} | Put Workspace entity
*WorkspacesSettingsApi* | [**create_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#create_entity_custom_application_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | Post Custom Application Settings
*WorkspacesSettingsApi* | [**create_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#create_entity_workspace_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | Post Settings for Workspaces
*WorkspacesSettingsApi* | [**delete_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#delete_entity_custom_application_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Delete a Custom Application Setting
*WorkspacesSettingsApi* | [**delete_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#delete_entity_workspace_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Delete a Setting for Workspace
*WorkspacesSettingsApi* | [**get_all_entities_custom_application_settings**](docs/WorkspacesSettingsApi.md#get_all_entities_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | Get all Custom Application Settings
*WorkspacesSettingsApi* | [**get_all_entities_workspace_settings**](docs/WorkspacesSettingsApi.md#get_all_entities_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | Get all Setting for Workspaces
*WorkspacesSettingsApi* | [**get_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#get_entity_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Get a Custom Application Setting
*WorkspacesSettingsApi* | [**get_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#get_entity_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Get a Setting for Workspace
*WorkspacesSettingsApi* | [**patch_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#patch_entity_custom_application_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Patch a Custom Application Setting
*WorkspacesSettingsApi* | [**patch_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#patch_entity_workspace_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Patch a Setting for Workspace
*WorkspacesSettingsApi* | [**update_entity_custom_application_settings**](docs/WorkspacesSettingsApi.md#update_entity_custom_application_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Put a Custom Application Setting
*WorkspacesSettingsApi* | [**update_entity_workspace_settings**](docs/WorkspacesSettingsApi.md#update_entity_workspace_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Put a Setting for a Workspace
*WorkspacesSettingsApi* | [**workspace_resolve_all_settings**](docs/WorkspacesSettingsApi.md#workspace_resolve_all_settings) | **GET** /api/v1/actions/workspaces/{workspaceId}/resolveSettings | Values for all settings.
*WorkspacesSettingsApi* | [**workspace_resolve_settings**](docs/WorkspacesSettingsApi.md#workspace_resolve_settings) | **POST** /api/v1/actions/workspaces/{workspaceId}/resolveSettings | Values for selected settings.
*ActionsApi* | [**add_group_members**](docs/ActionsApi.md#add_group_members) | **POST** /api/v1/actions/userManagement/userGroups/{userGroupId}/addMembers | 
*ActionsApi* | [**all_platform_usage**](docs/ActionsApi.md#all_platform_usage) | **GET** /api/v1/actions/collectUsage | Info about the platform usage.
*ActionsApi* | [**available_assignees**](docs/ActionsApi.md#available_assignees) | **GET** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/availableAssignees | Get Available Assignees
*ActionsApi* | [**cache_anomaly_detection_result**](docs/ActionsApi.md#cache_anomaly_detection_result) | **POST** /api/v1/actions/workspaces/{workspaceId}/cache/anomalyDetection/{resultId} | 
*ActionsApi* | [**cache_clustering_result**](docs/ActionsApi.md#cache_clustering_result) | **POST** /api/v1/actions/workspaces/{workspaceId}/cache/clustering/{resultId} | 
*ActionsApi* | [**cache_forecast_result**](docs/ActionsApi.md#cache_forecast_result) | **POST** /api/v1/actions/workspaces/{workspaceId}/cache/forecast/{resultId} | 
*ActionsApi* | [**check_entity_overrides**](docs/ActionsApi.md#check_entity_overrides) | **POST** /api/v1/actions/workspaces/{workspaceId}/checkEntityOverrides | Finds entities with given ID in hierarchy.
*ActionsApi* | [**clean_translations**](docs/ActionsApi.md#clean_translations) | **POST** /api/v1/actions/workspaces/{workspaceId}/translations/clean | Cleans up translations.
*ActionsApi* | [**compute_column_statistics**](docs/ActionsApi.md#compute_column_statistics) | **POST** /api/v1/actions/dataSources/{dataSourceId}/computeColumnStatistics | 
*ActionsApi* | [**compute_label_elements_post**](docs/ActionsApi.md#compute_label_elements_post) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/collectLabelElements | Listing of label values. The resulting data are limited by the static platform limit to the maximum of 10000 rows.
*ActionsApi* | [**compute_report**](docs/ActionsApi.md#compute_report) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute | Executes analytical request and returns link to the result
*ActionsApi* | [**compute_valid_descendants**](docs/ActionsApi.md#compute_valid_descendants) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/computeValidDescendants | (BETA) Valid descendants
*ActionsApi* | [**compute_valid_objects**](docs/ActionsApi.md#compute_valid_objects) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/computeValidObjects | Valid objects
*ActionsApi* | [**create_pdf_export**](docs/ActionsApi.md#create_pdf_export) | **POST** /api/v1/actions/workspaces/{workspaceId}/export/visual | Create visual - pdf export request
*ActionsApi* | [**create_tabular_export**](docs/ActionsApi.md#create_tabular_export) | **POST** /api/v1/actions/workspaces/{workspaceId}/export/tabular | Create tabular export request
*ActionsApi* | [**dashboard_permissions**](docs/ActionsApi.md#dashboard_permissions) | **GET** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/permissions | Get Dashboard Permissions
*ActionsApi* | [**delete_anomaly_detection_result**](docs/ActionsApi.md#delete_anomaly_detection_result) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/cache/anomalyDetection/{resultId} | 
*ActionsApi* | [**delete_clustering_result**](docs/ActionsApi.md#delete_clustering_result) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/cache/clustering/{resultId} | 
*ActionsApi* | [**delete_forecast_result**](docs/ActionsApi.md#delete_forecast_result) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/cache/forecast/{resultId} | 
*ActionsApi* | [**dislike_analytical_dashboard**](docs/ActionsApi.md#dislike_analytical_dashboard) | **POST** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{objectId}/dislike | 
*ActionsApi* | [**dislike_metric**](docs/ActionsApi.md#dislike_metric) | **POST** /api/v1/actions/workspaces/{workspaceId}/metrics/{objectId}/dislike | 
*ActionsApi* | [**dislike_visualization_object**](docs/ActionsApi.md#dislike_visualization_object) | **POST** /api/v1/actions/workspaces/{workspaceId}/visualizationObjects/{objectId}/dislike | 
*ActionsApi* | [**explain_afm**](docs/ActionsApi.md#explain_afm) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/afm/explain | AFM explain resource.
*ActionsApi* | [**favorite_analytical_dashboard**](docs/ActionsApi.md#favorite_analytical_dashboard) | **POST** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{objectId}/favorite | 
*ActionsApi* | [**favorite_metric**](docs/ActionsApi.md#favorite_metric) | **POST** /api/v1/actions/workspaces/{workspaceId}/metrics/{objectId}/favorite | 
*ActionsApi* | [**favorite_visualization_object**](docs/ActionsApi.md#favorite_visualization_object) | **POST** /api/v1/actions/workspaces/{workspaceId}/visualizationObjects/{objectId}/favorite | 
*ActionsApi* | [**fetch_anomaly_detection_result**](docs/ActionsApi.md#fetch_anomaly_detection_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/cache/anomalyDetection/{resultId} | 
*ActionsApi* | [**fetch_clustering_result**](docs/ActionsApi.md#fetch_clustering_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/cache/clustering/{resultId} | 
*ActionsApi* | [**fetch_forecast_result**](docs/ActionsApi.md#fetch_forecast_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/cache/forecast/{resultId} | 
*ActionsApi* | [**find_recent_analytics**](docs/ActionsApi.md#find_recent_analytics) | **GET** /api/v1/actions/workspaces/{workspaceId}/recent | 
*ActionsApi* | [**find_recommendations**](docs/ActionsApi.md#find_recommendations) | **POST** /api/v1/actions/workspaces/{workspaceId}/findRecommendations | 
*ActionsApi* | [**generate_logical_model**](docs/ActionsApi.md#generate_logical_model) | **POST** /api/v1/actions/dataSources/{dataSourceId}/generateLogicalModel | Generate logical data model (LDM) from physical data model (PDM)
*ActionsApi* | [**get_anomaly_detection_result**](docs/ActionsApi.md#get_anomaly_detection_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/ml/anomalyDetection/result/{resultId} | 
*ActionsApi* | [**get_clustering_result**](docs/ActionsApi.md#get_clustering_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/ml/clustering/result/{resultId} | 
*ActionsApi* | [**get_data_source_schemata**](docs/ActionsApi.md#get_data_source_schemata) | **GET** /api/v1/actions/dataSources/{dataSourceId}/scanSchemata | Get a list of schema names of a database
*ActionsApi* | [**get_dependent_entities_graph**](docs/ActionsApi.md#get_dependent_entities_graph) | **GET** /api/v1/actions/workspaces/{workspaceId}/dependentEntitiesGraph | Computes the dependent entities graph
*ActionsApi* | [**get_dependent_entities_graph_from_entry_points**](docs/ActionsApi.md#get_dependent_entities_graph_from_entry_points) | **POST** /api/v1/actions/workspaces/{workspaceId}/dependentEntitiesGraph | Computes the dependent entities graph from given entry points
*ActionsApi* | [**get_exported_file**](docs/ActionsApi.md#get_exported_file) | **GET** /api/v1/actions/workspaces/{workspaceId}/export/visual/{exportId} | Retrieve exported files
*ActionsApi* | [**get_forecast_result**](docs/ActionsApi.md#get_forecast_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/ml/forecast/result/{resultId} | 
*ActionsApi* | [**get_group_members**](docs/ActionsApi.md#get_group_members) | **GET** /api/v1/actions/userManagement/userGroups/{userGroupId}/members | 
*ActionsApi* | [**get_metadata**](docs/ActionsApi.md#get_metadata) | **GET** /api/v1/actions/workspaces/{workspaceId}/export/visual/{exportId}/metadata | Retrieve metadata context
*ActionsApi* | [**get_notifications_for_current_user**](docs/ActionsApi.md#get_notifications_for_current_user) | **GET** /api/v1/actions/workspaces/{workspaceId}/notifications | 
*ActionsApi* | [**get_result**](docs/ActionsApi.md#get_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/computeKeyDrivers/result/{resultId} | 
*ActionsApi* | [**get_tabular_export**](docs/ActionsApi.md#get_tabular_export) | **GET** /api/v1/actions/workspaces/{workspaceId}/export/tabular/{exportId} | Retrieve exported files
*ActionsApi* | [**get_translation_tags**](docs/ActionsApi.md#get_translation_tags) | **GET** /api/v1/actions/workspaces/{workspaceId}/translations | Get translation tags.
*ActionsApi* | [**inherited_entity_conflicts**](docs/ActionsApi.md#inherited_entity_conflicts) | **GET** /api/v1/actions/workspaces/{workspaceId}/inheritedEntityConflicts | Finds identifier conflicts in workspace hierarchy.
*ActionsApi* | [**inherited_entity_prefixes**](docs/ActionsApi.md#inherited_entity_prefixes) | **GET** /api/v1/actions/workspaces/{workspaceId}/inheritedEntityPrefixes | Get used entity prefixes in hierarchy
*ActionsApi* | [**like_analytical_dashboard**](docs/ActionsApi.md#like_analytical_dashboard) | **POST** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{objectId}/like | 
*ActionsApi* | [**like_metric**](docs/ActionsApi.md#like_metric) | **POST** /api/v1/actions/workspaces/{workspaceId}/metrics/{objectId}/like | 
*ActionsApi* | [**like_visualization_object**](docs/ActionsApi.md#like_visualization_object) | **POST** /api/v1/actions/workspaces/{workspaceId}/visualizationObjects/{objectId}/like | 
*ActionsApi* | [**list_subscriptions**](docs/ActionsApi.md#list_subscriptions) | **GET** /api/v1/actions/workspaces/{workspaceId}/subscriptions | 
*ActionsApi* | [**list_user_groups**](docs/ActionsApi.md#list_user_groups) | **GET** /api/v1/actions/userManagement/groups | 
*ActionsApi* | [**list_users**](docs/ActionsApi.md#list_users) | **GET** /api/v1/actions/userManagement/users | 
*ActionsApi* | [**list_workspace_permissions_for_user**](docs/ActionsApi.md#list_workspace_permissions_for_user) | **GET** /api/v1/actions/userManagement/users/{userId}/permissions | 
*ActionsApi* | [**list_workspace_permissions_for_user_group**](docs/ActionsApi.md#list_workspace_permissions_for_user_group) | **GET** /api/v1/actions/userManagement/userGroups/{userGroupId}/permissions | 
*ActionsApi* | [**manage_dashboard_permissions**](docs/ActionsApi.md#manage_dashboard_permissions) | **POST** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{dashboardId}/managePermissions | Manage Permissions for a Dashboard
*ActionsApi* | [**manage_data_source_permissions**](docs/ActionsApi.md#manage_data_source_permissions) | **POST** /api/v1/actions/dataSources/{dataSourceId}/managePermissions | Manage Permissions for a Data Source
*ActionsApi* | [**manage_organization_permissions**](docs/ActionsApi.md#manage_organization_permissions) | **POST** /api/v1/actions/organization/managePermissions | Manage Permissions for a Organization
*ActionsApi* | [**manage_workspace_permissions**](docs/ActionsApi.md#manage_workspace_permissions) | **POST** /api/v1/actions/workspaces/{workspaceId}/managePermissions | Manage Permissions for a Workspace
*ActionsApi* | [**manage_workspace_permissions_for_user**](docs/ActionsApi.md#manage_workspace_permissions_for_user) | **POST** /api/v1/actions/userManagement/users/{userId}/permissions | 
*ActionsApi* | [**manage_workspace_permissions_for_user_group**](docs/ActionsApi.md#manage_workspace_permissions_for_user_group) | **POST** /api/v1/actions/userManagement/userGroups/{userGroupId}/permissions | 
*ActionsApi* | [**mark_all_notifications_as_read**](docs/ActionsApi.md#mark_all_notifications_as_read) | **POST** /api/v1/actions/workspaces/{workspaceId}/markAllNotificationsAsRead | 
*ActionsApi* | [**mark_notification_as_read**](docs/ActionsApi.md#mark_notification_as_read) | **POST** /api/v1/actions/workspaces/{workspaceId}/markNotificationAsRead | 
*ActionsApi* | [**overridden_child_entities**](docs/ActionsApi.md#overridden_child_entities) | **GET** /api/v1/actions/workspaces/{workspaceId}/overriddenChildEntities | Finds identifier overrides in workspace hierarchy.
*ActionsApi* | [**particular_platform_usage**](docs/ActionsApi.md#particular_platform_usage) | **POST** /api/v1/actions/collectUsage | Info about the platform usage for particular items.
*ActionsApi* | [**process_anomaly_detection**](docs/ActionsApi.md#process_anomaly_detection) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/ml/anomalyDetection/{resultId} | 
*ActionsApi* | [**process_clustering_request**](docs/ActionsApi.md#process_clustering_request) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/ml/clustering/{resultId} | 
*ActionsApi* | [**process_forecast_request**](docs/ActionsApi.md#process_forecast_request) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/ml/forecast/{resultId} | 
*ActionsApi* | [**process_key_drivers_request**](docs/ActionsApi.md#process_key_drivers_request) | **POST** /api/v1/actions/workspaces/{workspaceId}/execution/computeKeyDrivers | 
*ActionsApi* | [**register_upload_notification**](docs/ActionsApi.md#register_upload_notification) | **POST** /api/v1/actions/dataSources/{dataSourceId}/uploadNotification | Register an upload notification
*ActionsApi* | [**remove_group_members**](docs/ActionsApi.md#remove_group_members) | **POST** /api/v1/actions/userManagement/userGroups/{userGroupId}/removeMembers | 
*ActionsApi* | [**resolve_all_entitlements**](docs/ActionsApi.md#resolve_all_entitlements) | **GET** /api/v1/actions/resolveEntitlements | Values for all public entitlements.
*ActionsApi* | [**resolve_all_settings_without_workspace**](docs/ActionsApi.md#resolve_all_settings_without_workspace) | **GET** /api/v1/actions/resolveSettings | Values for all settings without workspace.
*ActionsApi* | [**resolve_requested_entitlements**](docs/ActionsApi.md#resolve_requested_entitlements) | **POST** /api/v1/actions/resolveEntitlements | Values for requested public entitlements.
*ActionsApi* | [**resolve_settings_without_workspace**](docs/ActionsApi.md#resolve_settings_without_workspace) | **POST** /api/v1/actions/resolveSettings | Values for selected settings without workspace.
*ActionsApi* | [**retrieve_execution_metadata**](docs/ActionsApi.md#retrieve_execution_metadata) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute/result/{resultId}/metadata | Get a single execution result&#39;s metadata.
*ActionsApi* | [**retrieve_result**](docs/ActionsApi.md#retrieve_result) | **GET** /api/v1/actions/workspaces/{workspaceId}/execution/afm/execute/result/{resultId} | Get a single execution result
*ActionsApi* | [**retrieve_translations**](docs/ActionsApi.md#retrieve_translations) | **POST** /api/v1/actions/workspaces/{workspaceId}/translations/retrieve | Retrieve translations for entities.
*ActionsApi* | [**scan_data_source**](docs/ActionsApi.md#scan_data_source) | **POST** /api/v1/actions/dataSources/{dataSourceId}/scan | Scan a database to get a physical data model (PDM)
*ActionsApi* | [**scan_sql**](docs/ActionsApi.md#scan_sql) | **POST** /api/v1/actions/dataSources/{dataSourceId}/scanSql | Collect metadata about SQL query
*ActionsApi* | [**set_translations**](docs/ActionsApi.md#set_translations) | **POST** /api/v1/actions/workspaces/{workspaceId}/translations/set | Set translations for entities.
*ActionsApi* | [**subscribe_to_tag**](docs/ActionsApi.md#subscribe_to_tag) | **POST** /api/v1/actions/workspaces/{workspaceId}/tags/{objectId}/subscribe | 
*ActionsApi* | [**test_data_source**](docs/ActionsApi.md#test_data_source) | **POST** /api/v1/actions/dataSources/{dataSourceId}/test | Test data source connection by data source id
*ActionsApi* | [**test_data_source_definition**](docs/ActionsApi.md#test_data_source_definition) | **POST** /api/v1/actions/dataSource/test | Test connection by data source definition
*ActionsApi* | [**undislike_analytical_dashboard**](docs/ActionsApi.md#undislike_analytical_dashboard) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{objectId}/dislike | 
*ActionsApi* | [**undislike_metric**](docs/ActionsApi.md#undislike_metric) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/metrics/{objectId}/dislike | 
*ActionsApi* | [**undislike_visualization_object**](docs/ActionsApi.md#undislike_visualization_object) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/visualizationObjects/{objectId}/dislike | 
*ActionsApi* | [**unfavorite_analytical_dashboard**](docs/ActionsApi.md#unfavorite_analytical_dashboard) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{objectId}/favorite | 
*ActionsApi* | [**unfavorite_metric**](docs/ActionsApi.md#unfavorite_metric) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/metrics/{objectId}/favorite | 
*ActionsApi* | [**unfavorite_visualization_object**](docs/ActionsApi.md#unfavorite_visualization_object) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/visualizationObjects/{objectId}/favorite | 
*ActionsApi* | [**unlike_analytical_dashboard**](docs/ActionsApi.md#unlike_analytical_dashboard) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/analyticalDashboards/{objectId}/like | 
*ActionsApi* | [**unlike_metric**](docs/ActionsApi.md#unlike_metric) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/metrics/{objectId}/like | 
*ActionsApi* | [**unlike_visualization_object**](docs/ActionsApi.md#unlike_visualization_object) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/visualizationObjects/{objectId}/like | 
*ActionsApi* | [**unsubscribe_from_tag**](docs/ActionsApi.md#unsubscribe_from_tag) | **DELETE** /api/v1/actions/workspaces/{workspaceId}/tags/{objectId}/subscribe | 
*ActionsApi* | [**workspace_resolve_all_settings**](docs/ActionsApi.md#workspace_resolve_all_settings) | **GET** /api/v1/actions/workspaces/{workspaceId}/resolveSettings | Values for all settings.
*ActionsApi* | [**workspace_resolve_settings**](docs/ActionsApi.md#workspace_resolve_settings) | **POST** /api/v1/actions/workspaces/{workspaceId}/resolveSettings | Values for selected settings.
*EntitiesApi* | [**create_entity_analytical_dashboards**](docs/EntitiesApi.md#create_entity_analytical_dashboards) | **POST** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | Post Dashboards
*EntitiesApi* | [**create_entity_api_tokens**](docs/EntitiesApi.md#create_entity_api_tokens) | **POST** /api/v1/entities/users/{userId}/apiTokens | Post a new API token for the user
*EntitiesApi* | [**create_entity_attribute_hierarchies**](docs/EntitiesApi.md#create_entity_attribute_hierarchies) | **POST** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies | Post Attribute Hierarchies
*EntitiesApi* | [**create_entity_color_palettes**](docs/EntitiesApi.md#create_entity_color_palettes) | **POST** /api/v1/entities/colorPalettes | Post Color Pallettes
*EntitiesApi* | [**create_entity_csp_directives**](docs/EntitiesApi.md#create_entity_csp_directives) | **POST** /api/v1/entities/cspDirectives | Post CSP Directives
*EntitiesApi* | [**create_entity_custom_application_settings**](docs/EntitiesApi.md#create_entity_custom_application_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | Post Custom Application Settings
*EntitiesApi* | [**create_entity_dashboard_plugins**](docs/EntitiesApi.md#create_entity_dashboard_plugins) | **POST** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | Post Plugins
*EntitiesApi* | [**create_entity_data_sources**](docs/EntitiesApi.md#create_entity_data_sources) | **POST** /api/v1/entities/dataSources | Post Data Sources
*EntitiesApi* | [**create_entity_filter_contexts**](docs/EntitiesApi.md#create_entity_filter_contexts) | **POST** /api/v1/entities/workspaces/{workspaceId}/filterContexts | Post Context Filters
*EntitiesApi* | [**create_entity_jwks**](docs/EntitiesApi.md#create_entity_jwks) | **POST** /api/v1/entities/jwks | Post Jwks
*EntitiesApi* | [**create_entity_metrics**](docs/EntitiesApi.md#create_entity_metrics) | **POST** /api/v1/entities/workspaces/{workspaceId}/metrics | Post Metrics
*EntitiesApi* | [**create_entity_organization_settings**](docs/EntitiesApi.md#create_entity_organization_settings) | **POST** /api/v1/entities/organizationSettings | Post Organization Setting entities
*EntitiesApi* | [**create_entity_themes**](docs/EntitiesApi.md#create_entity_themes) | **POST** /api/v1/entities/themes | Post Theming
*EntitiesApi* | [**create_entity_user_data_filters**](docs/EntitiesApi.md#create_entity_user_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/userDataFilters | Post User Data Filters
*EntitiesApi* | [**create_entity_user_groups**](docs/EntitiesApi.md#create_entity_user_groups) | **POST** /api/v1/entities/userGroups | Post User Group entities
*EntitiesApi* | [**create_entity_user_settings**](docs/EntitiesApi.md#create_entity_user_settings) | **POST** /api/v1/entities/users/{userId}/userSettings | Post new user settings for the user
*EntitiesApi* | [**create_entity_users**](docs/EntitiesApi.md#create_entity_users) | **POST** /api/v1/entities/users | Post User entities
*EntitiesApi* | [**create_entity_visualization_objects**](docs/EntitiesApi.md#create_entity_visualization_objects) | **POST** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | Post Visualization Objects
*EntitiesApi* | [**create_entity_widget_alerts**](docs/EntitiesApi.md#create_entity_widget_alerts) | **POST** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts | Post Widget Alerts
*EntitiesApi* | [**create_entity_workspace_data_filter_settings**](docs/EntitiesApi.md#create_entity_workspace_data_filter_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | Post Settings for Workspace Data Filters
*EntitiesApi* | [**create_entity_workspace_data_filters**](docs/EntitiesApi.md#create_entity_workspace_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | Post Workspace Data Filters
*EntitiesApi* | [**create_entity_workspace_settings**](docs/EntitiesApi.md#create_entity_workspace_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | Post Settings for Workspaces
*EntitiesApi* | [**create_entity_workspaces**](docs/EntitiesApi.md#create_entity_workspaces) | **POST** /api/v1/entities/workspaces | Post Workspace entities
*EntitiesApi* | [**create_entity_zapier_subscriptions**](docs/EntitiesApi.md#create_entity_zapier_subscriptions) | **POST** /api/v1/entities/zapierSubscriptions | Post Zapier subscription
*EntitiesApi* | [**delete_entity_analytical_dashboards**](docs/EntitiesApi.md#delete_entity_analytical_dashboards) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Delete a Dashboard
*EntitiesApi* | [**delete_entity_api_tokens**](docs/EntitiesApi.md#delete_entity_api_tokens) | **DELETE** /api/v1/entities/users/{userId}/apiTokens/{id} | Delete an API Token for a user
*EntitiesApi* | [**delete_entity_attribute_hierarchies**](docs/EntitiesApi.md#delete_entity_attribute_hierarchies) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Delete an Attribute Hierarchy
*EntitiesApi* | [**delete_entity_color_palettes**](docs/EntitiesApi.md#delete_entity_color_palettes) | **DELETE** /api/v1/entities/colorPalettes/{id} | Delete a Color Pallette
*EntitiesApi* | [**delete_entity_csp_directives**](docs/EntitiesApi.md#delete_entity_csp_directives) | **DELETE** /api/v1/entities/cspDirectives/{id} | Delete CSP Directives
*EntitiesApi* | [**delete_entity_custom_application_settings**](docs/EntitiesApi.md#delete_entity_custom_application_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Delete a Custom Application Setting
*EntitiesApi* | [**delete_entity_dashboard_plugins**](docs/EntitiesApi.md#delete_entity_dashboard_plugins) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Delete a Plugin
*EntitiesApi* | [**delete_entity_data_sources**](docs/EntitiesApi.md#delete_entity_data_sources) | **DELETE** /api/v1/entities/dataSources/{id} | Delete Data Source entity
*EntitiesApi* | [**delete_entity_filter_contexts**](docs/EntitiesApi.md#delete_entity_filter_contexts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Delete a Context Filter
*EntitiesApi* | [**delete_entity_jwks**](docs/EntitiesApi.md#delete_entity_jwks) | **DELETE** /api/v1/entities/jwks/{id} | Delete Jwk
*EntitiesApi* | [**delete_entity_metrics**](docs/EntitiesApi.md#delete_entity_metrics) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Delete a Metric
*EntitiesApi* | [**delete_entity_organization_settings**](docs/EntitiesApi.md#delete_entity_organization_settings) | **DELETE** /api/v1/entities/organizationSettings/{id} | Delete Organization entity
*EntitiesApi* | [**delete_entity_themes**](docs/EntitiesApi.md#delete_entity_themes) | **DELETE** /api/v1/entities/themes/{id} | Delete Theming
*EntitiesApi* | [**delete_entity_user_data_filters**](docs/EntitiesApi.md#delete_entity_user_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Delete a User Data Filter
*EntitiesApi* | [**delete_entity_user_groups**](docs/EntitiesApi.md#delete_entity_user_groups) | **DELETE** /api/v1/entities/userGroups/{id} | Delete UserGroup entity
*EntitiesApi* | [**delete_entity_user_settings**](docs/EntitiesApi.md#delete_entity_user_settings) | **DELETE** /api/v1/entities/users/{userId}/userSettings/{id} | Delete a setting for a user
*EntitiesApi* | [**delete_entity_users**](docs/EntitiesApi.md#delete_entity_users) | **DELETE** /api/v1/entities/users/{id} | Delete User entity
*EntitiesApi* | [**delete_entity_visualization_objects**](docs/EntitiesApi.md#delete_entity_visualization_objects) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Delete a Visualization Object
*EntitiesApi* | [**delete_entity_widget_alerts**](docs/EntitiesApi.md#delete_entity_widget_alerts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Delete a Widget Alert
*EntitiesApi* | [**delete_entity_workspace_data_filter_settings**](docs/EntitiesApi.md#delete_entity_workspace_data_filter_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Delete a Settings for Workspace Data Filter
*EntitiesApi* | [**delete_entity_workspace_data_filters**](docs/EntitiesApi.md#delete_entity_workspace_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Delete a Workspace Data Filter
*EntitiesApi* | [**delete_entity_workspace_settings**](docs/EntitiesApi.md#delete_entity_workspace_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Delete a Setting for Workspace
*EntitiesApi* | [**delete_entity_workspaces**](docs/EntitiesApi.md#delete_entity_workspaces) | **DELETE** /api/v1/entities/workspaces/{id} | Delete Workspace entity
*EntitiesApi* | [**delete_entity_zapier_subscriptions**](docs/EntitiesApi.md#delete_entity_zapier_subscriptions) | **DELETE** /api/v1/entities/zapierSubscriptions/{id} | Delete Zapier subscription
*EntitiesApi* | [**get_all_entities_analytical_dashboards**](docs/EntitiesApi.md#get_all_entities_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | Get all Dashboards
*EntitiesApi* | [**get_all_entities_api_tokens**](docs/EntitiesApi.md#get_all_entities_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens | List all api tokens for a user
*EntitiesApi* | [**get_all_entities_attribute_hierarchies**](docs/EntitiesApi.md#get_all_entities_attribute_hierarchies) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies | Get all Attribute Hierarchies
*EntitiesApi* | [**get_all_entities_attributes**](docs/EntitiesApi.md#get_all_entities_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes | Get all Attributes
*EntitiesApi* | [**get_all_entities_color_palettes**](docs/EntitiesApi.md#get_all_entities_color_palettes) | **GET** /api/v1/entities/colorPalettes | Get all Color Pallettes
*EntitiesApi* | [**get_all_entities_csp_directives**](docs/EntitiesApi.md#get_all_entities_csp_directives) | **GET** /api/v1/entities/cspDirectives | Get CSP Directives
*EntitiesApi* | [**get_all_entities_custom_application_settings**](docs/EntitiesApi.md#get_all_entities_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | Get all Custom Application Settings
*EntitiesApi* | [**get_all_entities_dashboard_plugins**](docs/EntitiesApi.md#get_all_entities_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | Get all Plugins
*EntitiesApi* | [**get_all_entities_data_source_identifiers**](docs/EntitiesApi.md#get_all_entities_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers | Get all Data Source Identifiers
*EntitiesApi* | [**get_all_entities_data_sources**](docs/EntitiesApi.md#get_all_entities_data_sources) | **GET** /api/v1/entities/dataSources | Get Data Source entities
*EntitiesApi* | [**get_all_entities_datasets**](docs/EntitiesApi.md#get_all_entities_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets | Get all Datasets
*EntitiesApi* | [**get_all_entities_entitlements**](docs/EntitiesApi.md#get_all_entities_entitlements) | **GET** /api/v1/entities/entitlements | Get Entitlements
*EntitiesApi* | [**get_all_entities_facts**](docs/EntitiesApi.md#get_all_entities_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts | Get all Facts
*EntitiesApi* | [**get_all_entities_filter_contexts**](docs/EntitiesApi.md#get_all_entities_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts | Get all Context Filters
*EntitiesApi* | [**get_all_entities_jwks**](docs/EntitiesApi.md#get_all_entities_jwks) | **GET** /api/v1/entities/jwks | Get all Jwks
*EntitiesApi* | [**get_all_entities_labels**](docs/EntitiesApi.md#get_all_entities_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels | Get all Labels
*EntitiesApi* | [**get_all_entities_metrics**](docs/EntitiesApi.md#get_all_entities_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics | Get all Metrics
*EntitiesApi* | [**get_all_entities_organization_settings**](docs/EntitiesApi.md#get_all_entities_organization_settings) | **GET** /api/v1/entities/organizationSettings | Get Organization entities
*EntitiesApi* | [**get_all_entities_themes**](docs/EntitiesApi.md#get_all_entities_themes) | **GET** /api/v1/entities/themes | Get all Theming entities
*EntitiesApi* | [**get_all_entities_user_data_filters**](docs/EntitiesApi.md#get_all_entities_user_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/userDataFilters | Get all User Data Filters
*EntitiesApi* | [**get_all_entities_user_groups**](docs/EntitiesApi.md#get_all_entities_user_groups) | **GET** /api/v1/entities/userGroups | Get UserGroup entities
*EntitiesApi* | [**get_all_entities_user_identifiers**](docs/EntitiesApi.md#get_all_entities_user_identifiers) | **GET** /api/v1/entities/userIdentifiers | Get UserIdentifier entities
*EntitiesApi* | [**get_all_entities_user_settings**](docs/EntitiesApi.md#get_all_entities_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings | List all settings for a user
*EntitiesApi* | [**get_all_entities_users**](docs/EntitiesApi.md#get_all_entities_users) | **GET** /api/v1/entities/users | Get User entities
*EntitiesApi* | [**get_all_entities_visualization_objects**](docs/EntitiesApi.md#get_all_entities_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | Get all Visualization Objects
*EntitiesApi* | [**get_all_entities_widget_alerts**](docs/EntitiesApi.md#get_all_entities_widget_alerts) | **GET** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts | Get all Widget Alerts
*EntitiesApi* | [**get_all_entities_workspace_data_filter_settings**](docs/EntitiesApi.md#get_all_entities_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | Get all Settings for Workspace Data Filters
*EntitiesApi* | [**get_all_entities_workspace_data_filters**](docs/EntitiesApi.md#get_all_entities_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | Get all Workspace Data Filters
*EntitiesApi* | [**get_all_entities_workspace_settings**](docs/EntitiesApi.md#get_all_entities_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | Get all Setting for Workspaces
*EntitiesApi* | [**get_all_entities_workspaces**](docs/EntitiesApi.md#get_all_entities_workspaces) | **GET** /api/v1/entities/workspaces | Get Workspace entities
*EntitiesApi* | [**get_all_entities_zapier_subscriptions**](docs/EntitiesApi.md#get_all_entities_zapier_subscriptions) | **GET** /api/v1/entities/zapierSubscriptions | 
*EntitiesApi* | [**get_all_options**](docs/EntitiesApi.md#get_all_options) | **GET** /api/v1/options | Links for all configuration options
*EntitiesApi* | [**get_data_source_drivers**](docs/EntitiesApi.md#get_data_source_drivers) | **GET** /api/v1/options/availableDrivers | Get all available data source drivers
*EntitiesApi* | [**get_entity_analytical_dashboards**](docs/EntitiesApi.md#get_entity_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Get a Dashboard
*EntitiesApi* | [**get_entity_api_tokens**](docs/EntitiesApi.md#get_entity_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens/{id} | Get an API Token for a user
*EntitiesApi* | [**get_entity_attribute_hierarchies**](docs/EntitiesApi.md#get_entity_attribute_hierarchies) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Get an Attribute Hierarchy
*EntitiesApi* | [**get_entity_attributes**](docs/EntitiesApi.md#get_entity_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes/{objectId} | Get an Attribute
*EntitiesApi* | [**get_entity_color_palettes**](docs/EntitiesApi.md#get_entity_color_palettes) | **GET** /api/v1/entities/colorPalettes/{id} | Get Color Pallette
*EntitiesApi* | [**get_entity_cookie_security_configurations**](docs/EntitiesApi.md#get_entity_cookie_security_configurations) | **GET** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Get CookieSecurityConfiguration
*EntitiesApi* | [**get_entity_csp_directives**](docs/EntitiesApi.md#get_entity_csp_directives) | **GET** /api/v1/entities/cspDirectives/{id} | Get CSP Directives
*EntitiesApi* | [**get_entity_custom_application_settings**](docs/EntitiesApi.md#get_entity_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Get a Custom Application Setting
*EntitiesApi* | [**get_entity_dashboard_plugins**](docs/EntitiesApi.md#get_entity_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Get a Plugin
*EntitiesApi* | [**get_entity_data_source_identifiers**](docs/EntitiesApi.md#get_entity_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers/{id} | Get Data Source Identifier
*EntitiesApi* | [**get_entity_data_sources**](docs/EntitiesApi.md#get_entity_data_sources) | **GET** /api/v1/entities/dataSources/{id} | Get Data Source entity
*EntitiesApi* | [**get_entity_datasets**](docs/EntitiesApi.md#get_entity_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets/{objectId} | Get a Dataset
*EntitiesApi* | [**get_entity_entitlements**](docs/EntitiesApi.md#get_entity_entitlements) | **GET** /api/v1/entities/entitlements/{id} | Get Entitlement
*EntitiesApi* | [**get_entity_facts**](docs/EntitiesApi.md#get_entity_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts/{objectId} | Get a Fact
*EntitiesApi* | [**get_entity_filter_contexts**](docs/EntitiesApi.md#get_entity_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Get a Context Filter
*EntitiesApi* | [**get_entity_jwks**](docs/EntitiesApi.md#get_entity_jwks) | **GET** /api/v1/entities/jwks/{id} | Get Jwk
*EntitiesApi* | [**get_entity_labels**](docs/EntitiesApi.md#get_entity_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels/{objectId} | Get a Label
*EntitiesApi* | [**get_entity_metrics**](docs/EntitiesApi.md#get_entity_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Get a Metric
*EntitiesApi* | [**get_entity_organization_settings**](docs/EntitiesApi.md#get_entity_organization_settings) | **GET** /api/v1/entities/organizationSettings/{id} | Get Organization entity
*EntitiesApi* | [**get_entity_organizations**](docs/EntitiesApi.md#get_entity_organizations) | **GET** /api/v1/entities/admin/organizations/{id} | Get Organizations
*EntitiesApi* | [**get_entity_themes**](docs/EntitiesApi.md#get_entity_themes) | **GET** /api/v1/entities/themes/{id} | Get Theming
*EntitiesApi* | [**get_entity_user_data_filters**](docs/EntitiesApi.md#get_entity_user_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Get a User Data Filter
*EntitiesApi* | [**get_entity_user_groups**](docs/EntitiesApi.md#get_entity_user_groups) | **GET** /api/v1/entities/userGroups/{id} | Get UserGroup entity
*EntitiesApi* | [**get_entity_user_identifiers**](docs/EntitiesApi.md#get_entity_user_identifiers) | **GET** /api/v1/entities/userIdentifiers/{id} | Get UserIdentifier entity
*EntitiesApi* | [**get_entity_user_settings**](docs/EntitiesApi.md#get_entity_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings/{id} | Get a setting for a user
*EntitiesApi* | [**get_entity_users**](docs/EntitiesApi.md#get_entity_users) | **GET** /api/v1/entities/users/{id} | Get User entity
*EntitiesApi* | [**get_entity_visualization_objects**](docs/EntitiesApi.md#get_entity_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Get a Visualization Object
*EntitiesApi* | [**get_entity_widget_alerts**](docs/EntitiesApi.md#get_entity_widget_alerts) | **GET** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Get a Widget Alert
*EntitiesApi* | [**get_entity_workspace_data_filter_settings**](docs/EntitiesApi.md#get_entity_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Get a Setting for Workspace Data Filter
*EntitiesApi* | [**get_entity_workspace_data_filters**](docs/EntitiesApi.md#get_entity_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Get a Workspace Data Filter
*EntitiesApi* | [**get_entity_workspace_settings**](docs/EntitiesApi.md#get_entity_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Get a Setting for Workspace
*EntitiesApi* | [**get_entity_workspaces**](docs/EntitiesApi.md#get_entity_workspaces) | **GET** /api/v1/entities/workspaces/{id} | Get Workspace entity
*EntitiesApi* | [**get_entity_zapier_subscriptions**](docs/EntitiesApi.md#get_entity_zapier_subscriptions) | **GET** /api/v1/entities/zapierSubscriptions/{id} | 
*EntitiesApi* | [**get_organization**](docs/EntitiesApi.md#get_organization) | **GET** /api/v1/entities/organization | Get current organization info
*EntitiesApi* | [**patch_entity_analytical_dashboards**](docs/EntitiesApi.md#patch_entity_analytical_dashboards) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Patch a Dashboard
*EntitiesApi* | [**patch_entity_attribute_hierarchies**](docs/EntitiesApi.md#patch_entity_attribute_hierarchies) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Patch an Attribute Hierarchy
*EntitiesApi* | [**patch_entity_color_palettes**](docs/EntitiesApi.md#patch_entity_color_palettes) | **PATCH** /api/v1/entities/colorPalettes/{id} | Patch Color Pallette
*EntitiesApi* | [**patch_entity_cookie_security_configurations**](docs/EntitiesApi.md#patch_entity_cookie_security_configurations) | **PATCH** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Patch CookieSecurityConfiguration
*EntitiesApi* | [**patch_entity_csp_directives**](docs/EntitiesApi.md#patch_entity_csp_directives) | **PATCH** /api/v1/entities/cspDirectives/{id} | Patch CSP Directives
*EntitiesApi* | [**patch_entity_custom_application_settings**](docs/EntitiesApi.md#patch_entity_custom_application_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Patch a Custom Application Setting
*EntitiesApi* | [**patch_entity_dashboard_plugins**](docs/EntitiesApi.md#patch_entity_dashboard_plugins) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Patch a Plugin
*EntitiesApi* | [**patch_entity_data_sources**](docs/EntitiesApi.md#patch_entity_data_sources) | **PATCH** /api/v1/entities/dataSources/{id} | Patch Data Source entity
*EntitiesApi* | [**patch_entity_filter_contexts**](docs/EntitiesApi.md#patch_entity_filter_contexts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Patch a Context Filter
*EntitiesApi* | [**patch_entity_jwks**](docs/EntitiesApi.md#patch_entity_jwks) | **PATCH** /api/v1/entities/jwks/{id} | Patch Jwk
*EntitiesApi* | [**patch_entity_metrics**](docs/EntitiesApi.md#patch_entity_metrics) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Patch a Metric
*EntitiesApi* | [**patch_entity_organization_settings**](docs/EntitiesApi.md#patch_entity_organization_settings) | **PATCH** /api/v1/entities/organizationSettings/{id} | Patch Organization entity
*EntitiesApi* | [**patch_entity_organizations**](docs/EntitiesApi.md#patch_entity_organizations) | **PATCH** /api/v1/entities/admin/organizations/{id} | Patch Organization
*EntitiesApi* | [**patch_entity_themes**](docs/EntitiesApi.md#patch_entity_themes) | **PATCH** /api/v1/entities/themes/{id} | Patch Theming
*EntitiesApi* | [**patch_entity_user_data_filters**](docs/EntitiesApi.md#patch_entity_user_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Patch a User Data Filter
*EntitiesApi* | [**patch_entity_user_groups**](docs/EntitiesApi.md#patch_entity_user_groups) | **PATCH** /api/v1/entities/userGroups/{id} | Patch UserGroup entity
*EntitiesApi* | [**patch_entity_users**](docs/EntitiesApi.md#patch_entity_users) | **PATCH** /api/v1/entities/users/{id} | Patch User entity
*EntitiesApi* | [**patch_entity_visualization_objects**](docs/EntitiesApi.md#patch_entity_visualization_objects) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Patch a Visualization Object
*EntitiesApi* | [**patch_entity_widget_alerts**](docs/EntitiesApi.md#patch_entity_widget_alerts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Patch a Widget Alert
*EntitiesApi* | [**patch_entity_workspace_data_filter_settings**](docs/EntitiesApi.md#patch_entity_workspace_data_filter_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Patch a Settings for Workspace Data Filter
*EntitiesApi* | [**patch_entity_workspace_data_filters**](docs/EntitiesApi.md#patch_entity_workspace_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Patch a Workspace Data Filter
*EntitiesApi* | [**patch_entity_workspace_settings**](docs/EntitiesApi.md#patch_entity_workspace_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Patch a Setting for Workspace
*EntitiesApi* | [**patch_entity_workspaces**](docs/EntitiesApi.md#patch_entity_workspaces) | **PATCH** /api/v1/entities/workspaces/{id} | Patch Workspace entity
*EntitiesApi* | [**patch_entity_zapier_subscriptions**](docs/EntitiesApi.md#patch_entity_zapier_subscriptions) | **PATCH** /api/v1/entities/zapierSubscriptions/{id} | 
*EntitiesApi* | [**update_entity_analytical_dashboards**](docs/EntitiesApi.md#update_entity_analytical_dashboards) | **PUT** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Put Dashboards
*EntitiesApi* | [**update_entity_attribute_hierarchies**](docs/EntitiesApi.md#update_entity_attribute_hierarchies) | **PUT** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Put an Attribute Hierarchy
*EntitiesApi* | [**update_entity_color_palettes**](docs/EntitiesApi.md#update_entity_color_palettes) | **PUT** /api/v1/entities/colorPalettes/{id} | Put Color Pallette
*EntitiesApi* | [**update_entity_cookie_security_configurations**](docs/EntitiesApi.md#update_entity_cookie_security_configurations) | **PUT** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Put CookieSecurityConfiguration
*EntitiesApi* | [**update_entity_csp_directives**](docs/EntitiesApi.md#update_entity_csp_directives) | **PUT** /api/v1/entities/cspDirectives/{id} | Put CSP Directives
*EntitiesApi* | [**update_entity_custom_application_settings**](docs/EntitiesApi.md#update_entity_custom_application_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Put a Custom Application Setting
*EntitiesApi* | [**update_entity_dashboard_plugins**](docs/EntitiesApi.md#update_entity_dashboard_plugins) | **PUT** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Put a Plugin
*EntitiesApi* | [**update_entity_data_sources**](docs/EntitiesApi.md#update_entity_data_sources) | **PUT** /api/v1/entities/dataSources/{id} | Put Data Source entity
*EntitiesApi* | [**update_entity_filter_contexts**](docs/EntitiesApi.md#update_entity_filter_contexts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Put a Context Filter
*EntitiesApi* | [**update_entity_jwks**](docs/EntitiesApi.md#update_entity_jwks) | **PUT** /api/v1/entities/jwks/{id} | Put Jwk
*EntitiesApi* | [**update_entity_metrics**](docs/EntitiesApi.md#update_entity_metrics) | **PUT** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Put a Metric
*EntitiesApi* | [**update_entity_organization_settings**](docs/EntitiesApi.md#update_entity_organization_settings) | **PUT** /api/v1/entities/organizationSettings/{id} | Put Organization entity
*EntitiesApi* | [**update_entity_organizations**](docs/EntitiesApi.md#update_entity_organizations) | **PUT** /api/v1/entities/admin/organizations/{id} | Put Organization
*EntitiesApi* | [**update_entity_themes**](docs/EntitiesApi.md#update_entity_themes) | **PUT** /api/v1/entities/themes/{id} | Put Theming
*EntitiesApi* | [**update_entity_user_data_filters**](docs/EntitiesApi.md#update_entity_user_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Put a User Data Filter
*EntitiesApi* | [**update_entity_user_groups**](docs/EntitiesApi.md#update_entity_user_groups) | **PUT** /api/v1/entities/userGroups/{id} | Put UserGroup entity
*EntitiesApi* | [**update_entity_user_settings**](docs/EntitiesApi.md#update_entity_user_settings) | **PUT** /api/v1/entities/users/{userId}/userSettings/{id} | Put new user settings for the user
*EntitiesApi* | [**update_entity_users**](docs/EntitiesApi.md#update_entity_users) | **PUT** /api/v1/entities/users/{id} | Put User entity
*EntitiesApi* | [**update_entity_visualization_objects**](docs/EntitiesApi.md#update_entity_visualization_objects) | **PUT** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Put a Visualization Object
*EntitiesApi* | [**update_entity_widget_alerts**](docs/EntitiesApi.md#update_entity_widget_alerts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Put a Widget Alert
*EntitiesApi* | [**update_entity_workspace_data_filter_settings**](docs/EntitiesApi.md#update_entity_workspace_data_filter_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Put a Settings for Workspace Data Filter
*EntitiesApi* | [**update_entity_workspace_data_filters**](docs/EntitiesApi.md#update_entity_workspace_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Put a Workspace Data Filter
*EntitiesApi* | [**update_entity_workspace_settings**](docs/EntitiesApi.md#update_entity_workspace_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Put a Setting for a Workspace
*EntitiesApi* | [**update_entity_workspaces**](docs/EntitiesApi.md#update_entity_workspaces) | **PUT** /api/v1/entities/workspaces/{id} | Put Workspace entity
*EntitiesApi* | [**update_entity_zapier_subscriptions**](docs/EntitiesApi.md#update_entity_zapier_subscriptions) | **PUT** /api/v1/entities/zapierSubscriptions/{id} | 
*LayoutApi* | [**get_analytics_model**](docs/LayoutApi.md#get_analytics_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Get analytics model
*LayoutApi* | [**get_data_source_permissions**](docs/LayoutApi.md#get_data_source_permissions) | **GET** /api/v1/layout/dataSources/{dataSourceId}/permissions | Get permissions for the data source
*LayoutApi* | [**get_data_sources_layout**](docs/LayoutApi.md#get_data_sources_layout) | **GET** /api/v1/layout/dataSources | Get all data sources
*LayoutApi* | [**get_logical_model**](docs/LayoutApi.md#get_logical_model) | **GET** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Get logical model
*LayoutApi* | [**get_organization_layout**](docs/LayoutApi.md#get_organization_layout) | **GET** /api/v1/layout/organization | Get organization layout
*LayoutApi* | [**get_organization_permissions**](docs/LayoutApi.md#get_organization_permissions) | **GET** /api/v1/layout/organization/permissions | Get organization permissions
*LayoutApi* | [**get_user_data_filters**](docs/LayoutApi.md#get_user_data_filters) | **GET** /api/v1/layout/workspaces/{workspaceId}/userDataFilters | Get user data filters
*LayoutApi* | [**get_user_group_permissions**](docs/LayoutApi.md#get_user_group_permissions) | **GET** /api/v1/layout/userGroups/{userGroupId}/permissions | Get permissions for the user-group
*LayoutApi* | [**get_user_groups_layout**](docs/LayoutApi.md#get_user_groups_layout) | **GET** /api/v1/layout/userGroups | Get all user groups
*LayoutApi* | [**get_user_permissions**](docs/LayoutApi.md#get_user_permissions) | **GET** /api/v1/layout/users/{userId}/permissions | Get permissions for the user
*LayoutApi* | [**get_users_layout**](docs/LayoutApi.md#get_users_layout) | **GET** /api/v1/layout/users | Get all users
*LayoutApi* | [**get_users_user_groups_layout**](docs/LayoutApi.md#get_users_user_groups_layout) | **GET** /api/v1/layout/usersAndUserGroups | Get all users and user groups
*LayoutApi* | [**get_workspace_data_filters_layout**](docs/LayoutApi.md#get_workspace_data_filters_layout) | **GET** /api/v1/layout/workspaceDataFilters | Get workspace data filters for all workspaces
*LayoutApi* | [**get_workspace_layout**](docs/LayoutApi.md#get_workspace_layout) | **GET** /api/v1/layout/workspaces/{workspaceId} | Get workspace layout
*LayoutApi* | [**get_workspace_permissions**](docs/LayoutApi.md#get_workspace_permissions) | **GET** /api/v1/layout/workspaces/{workspaceId}/permissions | Get permissions for the workspace
*LayoutApi* | [**get_workspaces_layout**](docs/LayoutApi.md#get_workspaces_layout) | **GET** /api/v1/layout/workspaces | Get all workspaces layout
*LayoutApi* | [**put_data_sources_layout**](docs/LayoutApi.md#put_data_sources_layout) | **PUT** /api/v1/layout/dataSources | Put all data sources
*LayoutApi* | [**put_user_groups_layout**](docs/LayoutApi.md#put_user_groups_layout) | **PUT** /api/v1/layout/userGroups | Put all user groups
*LayoutApi* | [**put_users_layout**](docs/LayoutApi.md#put_users_layout) | **PUT** /api/v1/layout/users | Put all users
*LayoutApi* | [**put_users_user_groups_layout**](docs/LayoutApi.md#put_users_user_groups_layout) | **PUT** /api/v1/layout/usersAndUserGroups | Put all users and user groups
*LayoutApi* | [**put_workspace_layout**](docs/LayoutApi.md#put_workspace_layout) | **PUT** /api/v1/layout/workspaces/{workspaceId} | Set workspace layout
*LayoutApi* | [**set_analytics_model**](docs/LayoutApi.md#set_analytics_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/analyticsModel | Set analytics model
*LayoutApi* | [**set_data_source_permissions**](docs/LayoutApi.md#set_data_source_permissions) | **PUT** /api/v1/layout/dataSources/{dataSourceId}/permissions | Set data source permissions.
*LayoutApi* | [**set_logical_model**](docs/LayoutApi.md#set_logical_model) | **PUT** /api/v1/layout/workspaces/{workspaceId}/logicalModel | Set logical model
*LayoutApi* | [**set_organization_layout**](docs/LayoutApi.md#set_organization_layout) | **PUT** /api/v1/layout/organization | Set organization layout
*LayoutApi* | [**set_organization_permissions**](docs/LayoutApi.md#set_organization_permissions) | **PUT** /api/v1/layout/organization/permissions | Set organization permissions
*LayoutApi* | [**set_user_data_filters**](docs/LayoutApi.md#set_user_data_filters) | **PUT** /api/v1/layout/workspaces/{workspaceId}/userDataFilters | Set user data filters
*LayoutApi* | [**set_user_group_permissions**](docs/LayoutApi.md#set_user_group_permissions) | **PUT** /api/v1/layout/userGroups/{userGroupId}/permissions | Set permissions for the user-group
*LayoutApi* | [**set_user_permissions**](docs/LayoutApi.md#set_user_permissions) | **PUT** /api/v1/layout/users/{userId}/permissions | Set permissions for the user
*LayoutApi* | [**set_workspace_data_filters_layout**](docs/LayoutApi.md#set_workspace_data_filters_layout) | **PUT** /api/v1/layout/workspaceDataFilters | Set all workspace data filters
*LayoutApi* | [**set_workspace_permissions**](docs/LayoutApi.md#set_workspace_permissions) | **PUT** /api/v1/layout/workspaces/{workspaceId}/permissions | Set permissions for the workspace
*LayoutApi* | [**set_workspaces_layout**](docs/LayoutApi.md#set_workspaces_layout) | **PUT** /api/v1/layout/workspaces | Set all workspaces layout
*OrganizationControllerApi* | [**get_entity_cookie_security_configurations**](docs/OrganizationControllerApi.md#get_entity_cookie_security_configurations) | **GET** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Get CookieSecurityConfiguration
*OrganizationControllerApi* | [**get_entity_organizations**](docs/OrganizationControllerApi.md#get_entity_organizations) | **GET** /api/v1/entities/admin/organizations/{id} | Get Organizations
*OrganizationControllerApi* | [**patch_entity_cookie_security_configurations**](docs/OrganizationControllerApi.md#patch_entity_cookie_security_configurations) | **PATCH** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Patch CookieSecurityConfiguration
*OrganizationControllerApi* | [**patch_entity_organizations**](docs/OrganizationControllerApi.md#patch_entity_organizations) | **PATCH** /api/v1/entities/admin/organizations/{id} | Patch Organization
*OrganizationControllerApi* | [**update_entity_cookie_security_configurations**](docs/OrganizationControllerApi.md#update_entity_cookie_security_configurations) | **PUT** /api/v1/entities/admin/cookieSecurityConfigurations/{id} | Put CookieSecurityConfiguration
*OrganizationControllerApi* | [**update_entity_organizations**](docs/OrganizationControllerApi.md#update_entity_organizations) | **PUT** /api/v1/entities/admin/organizations/{id} | Put Organization
*OrganizationModelControllerApi* | [**create_entity_color_palettes**](docs/OrganizationModelControllerApi.md#create_entity_color_palettes) | **POST** /api/v1/entities/colorPalettes | Post Color Pallettes
*OrganizationModelControllerApi* | [**create_entity_csp_directives**](docs/OrganizationModelControllerApi.md#create_entity_csp_directives) | **POST** /api/v1/entities/cspDirectives | Post CSP Directives
*OrganizationModelControllerApi* | [**create_entity_data_sources**](docs/OrganizationModelControllerApi.md#create_entity_data_sources) | **POST** /api/v1/entities/dataSources | Post Data Sources
*OrganizationModelControllerApi* | [**create_entity_jwks**](docs/OrganizationModelControllerApi.md#create_entity_jwks) | **POST** /api/v1/entities/jwks | Post Jwks
*OrganizationModelControllerApi* | [**create_entity_organization_settings**](docs/OrganizationModelControllerApi.md#create_entity_organization_settings) | **POST** /api/v1/entities/organizationSettings | Post Organization Setting entities
*OrganizationModelControllerApi* | [**create_entity_themes**](docs/OrganizationModelControllerApi.md#create_entity_themes) | **POST** /api/v1/entities/themes | Post Theming
*OrganizationModelControllerApi* | [**create_entity_user_groups**](docs/OrganizationModelControllerApi.md#create_entity_user_groups) | **POST** /api/v1/entities/userGroups | Post User Group entities
*OrganizationModelControllerApi* | [**create_entity_users**](docs/OrganizationModelControllerApi.md#create_entity_users) | **POST** /api/v1/entities/users | Post User entities
*OrganizationModelControllerApi* | [**create_entity_workspaces**](docs/OrganizationModelControllerApi.md#create_entity_workspaces) | **POST** /api/v1/entities/workspaces | Post Workspace entities
*OrganizationModelControllerApi* | [**create_entity_zapier_subscriptions**](docs/OrganizationModelControllerApi.md#create_entity_zapier_subscriptions) | **POST** /api/v1/entities/zapierSubscriptions | Post Zapier subscription
*OrganizationModelControllerApi* | [**delete_entity_color_palettes**](docs/OrganizationModelControllerApi.md#delete_entity_color_palettes) | **DELETE** /api/v1/entities/colorPalettes/{id} | Delete a Color Pallette
*OrganizationModelControllerApi* | [**delete_entity_csp_directives**](docs/OrganizationModelControllerApi.md#delete_entity_csp_directives) | **DELETE** /api/v1/entities/cspDirectives/{id} | Delete CSP Directives
*OrganizationModelControllerApi* | [**delete_entity_data_sources**](docs/OrganizationModelControllerApi.md#delete_entity_data_sources) | **DELETE** /api/v1/entities/dataSources/{id} | Delete Data Source entity
*OrganizationModelControllerApi* | [**delete_entity_jwks**](docs/OrganizationModelControllerApi.md#delete_entity_jwks) | **DELETE** /api/v1/entities/jwks/{id} | Delete Jwk
*OrganizationModelControllerApi* | [**delete_entity_organization_settings**](docs/OrganizationModelControllerApi.md#delete_entity_organization_settings) | **DELETE** /api/v1/entities/organizationSettings/{id} | Delete Organization entity
*OrganizationModelControllerApi* | [**delete_entity_themes**](docs/OrganizationModelControllerApi.md#delete_entity_themes) | **DELETE** /api/v1/entities/themes/{id} | Delete Theming
*OrganizationModelControllerApi* | [**delete_entity_user_groups**](docs/OrganizationModelControllerApi.md#delete_entity_user_groups) | **DELETE** /api/v1/entities/userGroups/{id} | Delete UserGroup entity
*OrganizationModelControllerApi* | [**delete_entity_users**](docs/OrganizationModelControllerApi.md#delete_entity_users) | **DELETE** /api/v1/entities/users/{id} | Delete User entity
*OrganizationModelControllerApi* | [**delete_entity_workspaces**](docs/OrganizationModelControllerApi.md#delete_entity_workspaces) | **DELETE** /api/v1/entities/workspaces/{id} | Delete Workspace entity
*OrganizationModelControllerApi* | [**delete_entity_zapier_subscriptions**](docs/OrganizationModelControllerApi.md#delete_entity_zapier_subscriptions) | **DELETE** /api/v1/entities/zapierSubscriptions/{id} | Delete Zapier subscription
*OrganizationModelControllerApi* | [**get_all_entities_color_palettes**](docs/OrganizationModelControllerApi.md#get_all_entities_color_palettes) | **GET** /api/v1/entities/colorPalettes | Get all Color Pallettes
*OrganizationModelControllerApi* | [**get_all_entities_csp_directives**](docs/OrganizationModelControllerApi.md#get_all_entities_csp_directives) | **GET** /api/v1/entities/cspDirectives | Get CSP Directives
*OrganizationModelControllerApi* | [**get_all_entities_data_source_identifiers**](docs/OrganizationModelControllerApi.md#get_all_entities_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers | Get all Data Source Identifiers
*OrganizationModelControllerApi* | [**get_all_entities_data_sources**](docs/OrganizationModelControllerApi.md#get_all_entities_data_sources) | **GET** /api/v1/entities/dataSources | Get Data Source entities
*OrganizationModelControllerApi* | [**get_all_entities_entitlements**](docs/OrganizationModelControllerApi.md#get_all_entities_entitlements) | **GET** /api/v1/entities/entitlements | Get Entitlements
*OrganizationModelControllerApi* | [**get_all_entities_jwks**](docs/OrganizationModelControllerApi.md#get_all_entities_jwks) | **GET** /api/v1/entities/jwks | Get all Jwks
*OrganizationModelControllerApi* | [**get_all_entities_organization_settings**](docs/OrganizationModelControllerApi.md#get_all_entities_organization_settings) | **GET** /api/v1/entities/organizationSettings | Get Organization entities
*OrganizationModelControllerApi* | [**get_all_entities_themes**](docs/OrganizationModelControllerApi.md#get_all_entities_themes) | **GET** /api/v1/entities/themes | Get all Theming entities
*OrganizationModelControllerApi* | [**get_all_entities_user_groups**](docs/OrganizationModelControllerApi.md#get_all_entities_user_groups) | **GET** /api/v1/entities/userGroups | Get UserGroup entities
*OrganizationModelControllerApi* | [**get_all_entities_user_identifiers**](docs/OrganizationModelControllerApi.md#get_all_entities_user_identifiers) | **GET** /api/v1/entities/userIdentifiers | Get UserIdentifier entities
*OrganizationModelControllerApi* | [**get_all_entities_users**](docs/OrganizationModelControllerApi.md#get_all_entities_users) | **GET** /api/v1/entities/users | Get User entities
*OrganizationModelControllerApi* | [**get_all_entities_workspaces**](docs/OrganizationModelControllerApi.md#get_all_entities_workspaces) | **GET** /api/v1/entities/workspaces | Get Workspace entities
*OrganizationModelControllerApi* | [**get_all_entities_zapier_subscriptions**](docs/OrganizationModelControllerApi.md#get_all_entities_zapier_subscriptions) | **GET** /api/v1/entities/zapierSubscriptions | 
*OrganizationModelControllerApi* | [**get_entity_color_palettes**](docs/OrganizationModelControllerApi.md#get_entity_color_palettes) | **GET** /api/v1/entities/colorPalettes/{id} | Get Color Pallette
*OrganizationModelControllerApi* | [**get_entity_csp_directives**](docs/OrganizationModelControllerApi.md#get_entity_csp_directives) | **GET** /api/v1/entities/cspDirectives/{id} | Get CSP Directives
*OrganizationModelControllerApi* | [**get_entity_data_source_identifiers**](docs/OrganizationModelControllerApi.md#get_entity_data_source_identifiers) | **GET** /api/v1/entities/dataSourceIdentifiers/{id} | Get Data Source Identifier
*OrganizationModelControllerApi* | [**get_entity_data_sources**](docs/OrganizationModelControllerApi.md#get_entity_data_sources) | **GET** /api/v1/entities/dataSources/{id} | Get Data Source entity
*OrganizationModelControllerApi* | [**get_entity_entitlements**](docs/OrganizationModelControllerApi.md#get_entity_entitlements) | **GET** /api/v1/entities/entitlements/{id} | Get Entitlement
*OrganizationModelControllerApi* | [**get_entity_jwks**](docs/OrganizationModelControllerApi.md#get_entity_jwks) | **GET** /api/v1/entities/jwks/{id} | Get Jwk
*OrganizationModelControllerApi* | [**get_entity_organization_settings**](docs/OrganizationModelControllerApi.md#get_entity_organization_settings) | **GET** /api/v1/entities/organizationSettings/{id} | Get Organization entity
*OrganizationModelControllerApi* | [**get_entity_themes**](docs/OrganizationModelControllerApi.md#get_entity_themes) | **GET** /api/v1/entities/themes/{id} | Get Theming
*OrganizationModelControllerApi* | [**get_entity_user_groups**](docs/OrganizationModelControllerApi.md#get_entity_user_groups) | **GET** /api/v1/entities/userGroups/{id} | Get UserGroup entity
*OrganizationModelControllerApi* | [**get_entity_user_identifiers**](docs/OrganizationModelControllerApi.md#get_entity_user_identifiers) | **GET** /api/v1/entities/userIdentifiers/{id} | Get UserIdentifier entity
*OrganizationModelControllerApi* | [**get_entity_users**](docs/OrganizationModelControllerApi.md#get_entity_users) | **GET** /api/v1/entities/users/{id} | Get User entity
*OrganizationModelControllerApi* | [**get_entity_workspaces**](docs/OrganizationModelControllerApi.md#get_entity_workspaces) | **GET** /api/v1/entities/workspaces/{id} | Get Workspace entity
*OrganizationModelControllerApi* | [**get_entity_zapier_subscriptions**](docs/OrganizationModelControllerApi.md#get_entity_zapier_subscriptions) | **GET** /api/v1/entities/zapierSubscriptions/{id} | 
*OrganizationModelControllerApi* | [**patch_entity_color_palettes**](docs/OrganizationModelControllerApi.md#patch_entity_color_palettes) | **PATCH** /api/v1/entities/colorPalettes/{id} | Patch Color Pallette
*OrganizationModelControllerApi* | [**patch_entity_csp_directives**](docs/OrganizationModelControllerApi.md#patch_entity_csp_directives) | **PATCH** /api/v1/entities/cspDirectives/{id} | Patch CSP Directives
*OrganizationModelControllerApi* | [**patch_entity_data_sources**](docs/OrganizationModelControllerApi.md#patch_entity_data_sources) | **PATCH** /api/v1/entities/dataSources/{id} | Patch Data Source entity
*OrganizationModelControllerApi* | [**patch_entity_jwks**](docs/OrganizationModelControllerApi.md#patch_entity_jwks) | **PATCH** /api/v1/entities/jwks/{id} | Patch Jwk
*OrganizationModelControllerApi* | [**patch_entity_organization_settings**](docs/OrganizationModelControllerApi.md#patch_entity_organization_settings) | **PATCH** /api/v1/entities/organizationSettings/{id} | Patch Organization entity
*OrganizationModelControllerApi* | [**patch_entity_themes**](docs/OrganizationModelControllerApi.md#patch_entity_themes) | **PATCH** /api/v1/entities/themes/{id} | Patch Theming
*OrganizationModelControllerApi* | [**patch_entity_user_groups**](docs/OrganizationModelControllerApi.md#patch_entity_user_groups) | **PATCH** /api/v1/entities/userGroups/{id} | Patch UserGroup entity
*OrganizationModelControllerApi* | [**patch_entity_users**](docs/OrganizationModelControllerApi.md#patch_entity_users) | **PATCH** /api/v1/entities/users/{id} | Patch User entity
*OrganizationModelControllerApi* | [**patch_entity_workspaces**](docs/OrganizationModelControllerApi.md#patch_entity_workspaces) | **PATCH** /api/v1/entities/workspaces/{id} | Patch Workspace entity
*OrganizationModelControllerApi* | [**patch_entity_zapier_subscriptions**](docs/OrganizationModelControllerApi.md#patch_entity_zapier_subscriptions) | **PATCH** /api/v1/entities/zapierSubscriptions/{id} | 
*OrganizationModelControllerApi* | [**update_entity_color_palettes**](docs/OrganizationModelControllerApi.md#update_entity_color_palettes) | **PUT** /api/v1/entities/colorPalettes/{id} | Put Color Pallette
*OrganizationModelControllerApi* | [**update_entity_csp_directives**](docs/OrganizationModelControllerApi.md#update_entity_csp_directives) | **PUT** /api/v1/entities/cspDirectives/{id} | Put CSP Directives
*OrganizationModelControllerApi* | [**update_entity_data_sources**](docs/OrganizationModelControllerApi.md#update_entity_data_sources) | **PUT** /api/v1/entities/dataSources/{id} | Put Data Source entity
*OrganizationModelControllerApi* | [**update_entity_jwks**](docs/OrganizationModelControllerApi.md#update_entity_jwks) | **PUT** /api/v1/entities/jwks/{id} | Put Jwk
*OrganizationModelControllerApi* | [**update_entity_organization_settings**](docs/OrganizationModelControllerApi.md#update_entity_organization_settings) | **PUT** /api/v1/entities/organizationSettings/{id} | Put Organization entity
*OrganizationModelControllerApi* | [**update_entity_themes**](docs/OrganizationModelControllerApi.md#update_entity_themes) | **PUT** /api/v1/entities/themes/{id} | Put Theming
*OrganizationModelControllerApi* | [**update_entity_user_groups**](docs/OrganizationModelControllerApi.md#update_entity_user_groups) | **PUT** /api/v1/entities/userGroups/{id} | Put UserGroup entity
*OrganizationModelControllerApi* | [**update_entity_users**](docs/OrganizationModelControllerApi.md#update_entity_users) | **PUT** /api/v1/entities/users/{id} | Put User entity
*OrganizationModelControllerApi* | [**update_entity_workspaces**](docs/OrganizationModelControllerApi.md#update_entity_workspaces) | **PUT** /api/v1/entities/workspaces/{id} | Put Workspace entity
*OrganizationModelControllerApi* | [**update_entity_zapier_subscriptions**](docs/OrganizationModelControllerApi.md#update_entity_zapier_subscriptions) | **PUT** /api/v1/entities/zapierSubscriptions/{id} | 
*UserModelControllerApi* | [**create_entity_api_tokens**](docs/UserModelControllerApi.md#create_entity_api_tokens) | **POST** /api/v1/entities/users/{userId}/apiTokens | Post a new API token for the user
*UserModelControllerApi* | [**create_entity_user_settings**](docs/UserModelControllerApi.md#create_entity_user_settings) | **POST** /api/v1/entities/users/{userId}/userSettings | Post new user settings for the user
*UserModelControllerApi* | [**delete_entity_api_tokens**](docs/UserModelControllerApi.md#delete_entity_api_tokens) | **DELETE** /api/v1/entities/users/{userId}/apiTokens/{id} | Delete an API Token for a user
*UserModelControllerApi* | [**delete_entity_user_settings**](docs/UserModelControllerApi.md#delete_entity_user_settings) | **DELETE** /api/v1/entities/users/{userId}/userSettings/{id} | Delete a setting for a user
*UserModelControllerApi* | [**get_all_entities_api_tokens**](docs/UserModelControllerApi.md#get_all_entities_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens | List all api tokens for a user
*UserModelControllerApi* | [**get_all_entities_user_settings**](docs/UserModelControllerApi.md#get_all_entities_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings | List all settings for a user
*UserModelControllerApi* | [**get_entity_api_tokens**](docs/UserModelControllerApi.md#get_entity_api_tokens) | **GET** /api/v1/entities/users/{userId}/apiTokens/{id} | Get an API Token for a user
*UserModelControllerApi* | [**get_entity_user_settings**](docs/UserModelControllerApi.md#get_entity_user_settings) | **GET** /api/v1/entities/users/{userId}/userSettings/{id} | Get a setting for a user
*UserModelControllerApi* | [**update_entity_user_settings**](docs/UserModelControllerApi.md#update_entity_user_settings) | **PUT** /api/v1/entities/users/{userId}/userSettings/{id} | Put new user settings for the user
*WorkspaceObjectControllerApi* | [**create_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#create_entity_analytical_dashboards) | **POST** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | Post Dashboards
*WorkspaceObjectControllerApi* | [**create_entity_attribute_hierarchies**](docs/WorkspaceObjectControllerApi.md#create_entity_attribute_hierarchies) | **POST** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies | Post Attribute Hierarchies
*WorkspaceObjectControllerApi* | [**create_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#create_entity_custom_application_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | Post Custom Application Settings
*WorkspaceObjectControllerApi* | [**create_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#create_entity_dashboard_plugins) | **POST** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | Post Plugins
*WorkspaceObjectControllerApi* | [**create_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#create_entity_filter_contexts) | **POST** /api/v1/entities/workspaces/{workspaceId}/filterContexts | Post Context Filters
*WorkspaceObjectControllerApi* | [**create_entity_metrics**](docs/WorkspaceObjectControllerApi.md#create_entity_metrics) | **POST** /api/v1/entities/workspaces/{workspaceId}/metrics | Post Metrics
*WorkspaceObjectControllerApi* | [**create_entity_user_data_filters**](docs/WorkspaceObjectControllerApi.md#create_entity_user_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/userDataFilters | Post User Data Filters
*WorkspaceObjectControllerApi* | [**create_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#create_entity_visualization_objects) | **POST** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | Post Visualization Objects
*WorkspaceObjectControllerApi* | [**create_entity_widget_alerts**](docs/WorkspaceObjectControllerApi.md#create_entity_widget_alerts) | **POST** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts | Post Widget Alerts
*WorkspaceObjectControllerApi* | [**create_entity_workspace_data_filter_settings**](docs/WorkspaceObjectControllerApi.md#create_entity_workspace_data_filter_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | Post Settings for Workspace Data Filters
*WorkspaceObjectControllerApi* | [**create_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#create_entity_workspace_data_filters) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | Post Workspace Data Filters
*WorkspaceObjectControllerApi* | [**create_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#create_entity_workspace_settings) | **POST** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | Post Settings for Workspaces
*WorkspaceObjectControllerApi* | [**delete_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#delete_entity_analytical_dashboards) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Delete a Dashboard
*WorkspaceObjectControllerApi* | [**delete_entity_attribute_hierarchies**](docs/WorkspaceObjectControllerApi.md#delete_entity_attribute_hierarchies) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Delete an Attribute Hierarchy
*WorkspaceObjectControllerApi* | [**delete_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#delete_entity_custom_application_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Delete a Custom Application Setting
*WorkspaceObjectControllerApi* | [**delete_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#delete_entity_dashboard_plugins) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Delete a Plugin
*WorkspaceObjectControllerApi* | [**delete_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#delete_entity_filter_contexts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Delete a Context Filter
*WorkspaceObjectControllerApi* | [**delete_entity_metrics**](docs/WorkspaceObjectControllerApi.md#delete_entity_metrics) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Delete a Metric
*WorkspaceObjectControllerApi* | [**delete_entity_user_data_filters**](docs/WorkspaceObjectControllerApi.md#delete_entity_user_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Delete a User Data Filter
*WorkspaceObjectControllerApi* | [**delete_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#delete_entity_visualization_objects) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Delete a Visualization Object
*WorkspaceObjectControllerApi* | [**delete_entity_widget_alerts**](docs/WorkspaceObjectControllerApi.md#delete_entity_widget_alerts) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Delete a Widget Alert
*WorkspaceObjectControllerApi* | [**delete_entity_workspace_data_filter_settings**](docs/WorkspaceObjectControllerApi.md#delete_entity_workspace_data_filter_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Delete a Settings for Workspace Data Filter
*WorkspaceObjectControllerApi* | [**delete_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#delete_entity_workspace_data_filters) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Delete a Workspace Data Filter
*WorkspaceObjectControllerApi* | [**delete_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#delete_entity_workspace_settings) | **DELETE** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Delete a Setting for Workspace
*WorkspaceObjectControllerApi* | [**get_all_entities_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#get_all_entities_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards | Get all Dashboards
*WorkspaceObjectControllerApi* | [**get_all_entities_attribute_hierarchies**](docs/WorkspaceObjectControllerApi.md#get_all_entities_attribute_hierarchies) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies | Get all Attribute Hierarchies
*WorkspaceObjectControllerApi* | [**get_all_entities_attributes**](docs/WorkspaceObjectControllerApi.md#get_all_entities_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes | Get all Attributes
*WorkspaceObjectControllerApi* | [**get_all_entities_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#get_all_entities_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings | Get all Custom Application Settings
*WorkspaceObjectControllerApi* | [**get_all_entities_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#get_all_entities_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins | Get all Plugins
*WorkspaceObjectControllerApi* | [**get_all_entities_datasets**](docs/WorkspaceObjectControllerApi.md#get_all_entities_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets | Get all Datasets
*WorkspaceObjectControllerApi* | [**get_all_entities_facts**](docs/WorkspaceObjectControllerApi.md#get_all_entities_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts | Get all Facts
*WorkspaceObjectControllerApi* | [**get_all_entities_filter_contexts**](docs/WorkspaceObjectControllerApi.md#get_all_entities_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts | Get all Context Filters
*WorkspaceObjectControllerApi* | [**get_all_entities_labels**](docs/WorkspaceObjectControllerApi.md#get_all_entities_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels | Get all Labels
*WorkspaceObjectControllerApi* | [**get_all_entities_metrics**](docs/WorkspaceObjectControllerApi.md#get_all_entities_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics | Get all Metrics
*WorkspaceObjectControllerApi* | [**get_all_entities_user_data_filters**](docs/WorkspaceObjectControllerApi.md#get_all_entities_user_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/userDataFilters | Get all User Data Filters
*WorkspaceObjectControllerApi* | [**get_all_entities_visualization_objects**](docs/WorkspaceObjectControllerApi.md#get_all_entities_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects | Get all Visualization Objects
*WorkspaceObjectControllerApi* | [**get_all_entities_widget_alerts**](docs/WorkspaceObjectControllerApi.md#get_all_entities_widget_alerts) | **GET** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts | Get all Widget Alerts
*WorkspaceObjectControllerApi* | [**get_all_entities_workspace_data_filter_settings**](docs/WorkspaceObjectControllerApi.md#get_all_entities_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings | Get all Settings for Workspace Data Filters
*WorkspaceObjectControllerApi* | [**get_all_entities_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#get_all_entities_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters | Get all Workspace Data Filters
*WorkspaceObjectControllerApi* | [**get_all_entities_workspace_settings**](docs/WorkspaceObjectControllerApi.md#get_all_entities_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings | Get all Setting for Workspaces
*WorkspaceObjectControllerApi* | [**get_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#get_entity_analytical_dashboards) | **GET** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Get a Dashboard
*WorkspaceObjectControllerApi* | [**get_entity_attribute_hierarchies**](docs/WorkspaceObjectControllerApi.md#get_entity_attribute_hierarchies) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Get an Attribute Hierarchy
*WorkspaceObjectControllerApi* | [**get_entity_attributes**](docs/WorkspaceObjectControllerApi.md#get_entity_attributes) | **GET** /api/v1/entities/workspaces/{workspaceId}/attributes/{objectId} | Get an Attribute
*WorkspaceObjectControllerApi* | [**get_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#get_entity_custom_application_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Get a Custom Application Setting
*WorkspaceObjectControllerApi* | [**get_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#get_entity_dashboard_plugins) | **GET** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Get a Plugin
*WorkspaceObjectControllerApi* | [**get_entity_datasets**](docs/WorkspaceObjectControllerApi.md#get_entity_datasets) | **GET** /api/v1/entities/workspaces/{workspaceId}/datasets/{objectId} | Get a Dataset
*WorkspaceObjectControllerApi* | [**get_entity_facts**](docs/WorkspaceObjectControllerApi.md#get_entity_facts) | **GET** /api/v1/entities/workspaces/{workspaceId}/facts/{objectId} | Get a Fact
*WorkspaceObjectControllerApi* | [**get_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#get_entity_filter_contexts) | **GET** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Get a Context Filter
*WorkspaceObjectControllerApi* | [**get_entity_labels**](docs/WorkspaceObjectControllerApi.md#get_entity_labels) | **GET** /api/v1/entities/workspaces/{workspaceId}/labels/{objectId} | Get a Label
*WorkspaceObjectControllerApi* | [**get_entity_metrics**](docs/WorkspaceObjectControllerApi.md#get_entity_metrics) | **GET** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Get a Metric
*WorkspaceObjectControllerApi* | [**get_entity_user_data_filters**](docs/WorkspaceObjectControllerApi.md#get_entity_user_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Get a User Data Filter
*WorkspaceObjectControllerApi* | [**get_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#get_entity_visualization_objects) | **GET** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Get a Visualization Object
*WorkspaceObjectControllerApi* | [**get_entity_widget_alerts**](docs/WorkspaceObjectControllerApi.md#get_entity_widget_alerts) | **GET** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Get a Widget Alert
*WorkspaceObjectControllerApi* | [**get_entity_workspace_data_filter_settings**](docs/WorkspaceObjectControllerApi.md#get_entity_workspace_data_filter_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Get a Setting for Workspace Data Filter
*WorkspaceObjectControllerApi* | [**get_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#get_entity_workspace_data_filters) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Get a Workspace Data Filter
*WorkspaceObjectControllerApi* | [**get_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#get_entity_workspace_settings) | **GET** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Get a Setting for Workspace
*WorkspaceObjectControllerApi* | [**patch_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#patch_entity_analytical_dashboards) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Patch a Dashboard
*WorkspaceObjectControllerApi* | [**patch_entity_attribute_hierarchies**](docs/WorkspaceObjectControllerApi.md#patch_entity_attribute_hierarchies) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Patch an Attribute Hierarchy
*WorkspaceObjectControllerApi* | [**patch_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#patch_entity_custom_application_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Patch a Custom Application Setting
*WorkspaceObjectControllerApi* | [**patch_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#patch_entity_dashboard_plugins) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Patch a Plugin
*WorkspaceObjectControllerApi* | [**patch_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#patch_entity_filter_contexts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Patch a Context Filter
*WorkspaceObjectControllerApi* | [**patch_entity_metrics**](docs/WorkspaceObjectControllerApi.md#patch_entity_metrics) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Patch a Metric
*WorkspaceObjectControllerApi* | [**patch_entity_user_data_filters**](docs/WorkspaceObjectControllerApi.md#patch_entity_user_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Patch a User Data Filter
*WorkspaceObjectControllerApi* | [**patch_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#patch_entity_visualization_objects) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Patch a Visualization Object
*WorkspaceObjectControllerApi* | [**patch_entity_widget_alerts**](docs/WorkspaceObjectControllerApi.md#patch_entity_widget_alerts) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Patch a Widget Alert
*WorkspaceObjectControllerApi* | [**patch_entity_workspace_data_filter_settings**](docs/WorkspaceObjectControllerApi.md#patch_entity_workspace_data_filter_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Patch a Settings for Workspace Data Filter
*WorkspaceObjectControllerApi* | [**patch_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#patch_entity_workspace_data_filters) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Patch a Workspace Data Filter
*WorkspaceObjectControllerApi* | [**patch_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#patch_entity_workspace_settings) | **PATCH** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Patch a Setting for Workspace
*WorkspaceObjectControllerApi* | [**update_entity_analytical_dashboards**](docs/WorkspaceObjectControllerApi.md#update_entity_analytical_dashboards) | **PUT** /api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId} | Put Dashboards
*WorkspaceObjectControllerApi* | [**update_entity_attribute_hierarchies**](docs/WorkspaceObjectControllerApi.md#update_entity_attribute_hierarchies) | **PUT** /api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId} | Put an Attribute Hierarchy
*WorkspaceObjectControllerApi* | [**update_entity_custom_application_settings**](docs/WorkspaceObjectControllerApi.md#update_entity_custom_application_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId} | Put a Custom Application Setting
*WorkspaceObjectControllerApi* | [**update_entity_dashboard_plugins**](docs/WorkspaceObjectControllerApi.md#update_entity_dashboard_plugins) | **PUT** /api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId} | Put a Plugin
*WorkspaceObjectControllerApi* | [**update_entity_filter_contexts**](docs/WorkspaceObjectControllerApi.md#update_entity_filter_contexts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId} | Put a Context Filter
*WorkspaceObjectControllerApi* | [**update_entity_metrics**](docs/WorkspaceObjectControllerApi.md#update_entity_metrics) | **PUT** /api/v1/entities/workspaces/{workspaceId}/metrics/{objectId} | Put a Metric
*WorkspaceObjectControllerApi* | [**update_entity_user_data_filters**](docs/WorkspaceObjectControllerApi.md#update_entity_user_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId} | Put a User Data Filter
*WorkspaceObjectControllerApi* | [**update_entity_visualization_objects**](docs/WorkspaceObjectControllerApi.md#update_entity_visualization_objects) | **PUT** /api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId} | Put a Visualization Object
*WorkspaceObjectControllerApi* | [**update_entity_widget_alerts**](docs/WorkspaceObjectControllerApi.md#update_entity_widget_alerts) | **PUT** /api/v1/entities/workspaces/{workspaceId}/widgetAlerts/{objectId} | Put a Widget Alert
*WorkspaceObjectControllerApi* | [**update_entity_workspace_data_filter_settings**](docs/WorkspaceObjectControllerApi.md#update_entity_workspace_data_filter_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId} | Put a Settings for Workspace Data Filter
*WorkspaceObjectControllerApi* | [**update_entity_workspace_data_filters**](docs/WorkspaceObjectControllerApi.md#update_entity_workspace_data_filters) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId} | Put a Workspace Data Filter
*WorkspaceObjectControllerApi* | [**update_entity_workspace_settings**](docs/WorkspaceObjectControllerApi.md#update_entity_workspace_settings) | **PUT** /api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId} | Put a Setting for a Workspace


## Documentation For Models

 - [AFM](docs/AFM.md)
 - [AbsoluteDateFilter](docs/AbsoluteDateFilter.md)
 - [AbsoluteDateFilterAbsoluteDateFilter](docs/AbsoluteDateFilterAbsoluteDateFilter.md)
 - [AbstractMeasureValueFilter](docs/AbstractMeasureValueFilter.md)
 - [AfmExecution](docs/AfmExecution.md)
 - [AfmExecutionResponse](docs/AfmExecutionResponse.md)
 - [AfmIdentifier](docs/AfmIdentifier.md)
 - [AfmLocalIdentifier](docs/AfmLocalIdentifier.md)
 - [AfmObjectIdentifier](docs/AfmObjectIdentifier.md)
 - [AfmObjectIdentifierAttribute](docs/AfmObjectIdentifierAttribute.md)
 - [AfmObjectIdentifierAttributeIdentifier](docs/AfmObjectIdentifierAttributeIdentifier.md)
 - [AfmObjectIdentifierCore](docs/AfmObjectIdentifierCore.md)
 - [AfmObjectIdentifierCoreIdentifier](docs/AfmObjectIdentifierCoreIdentifier.md)
 - [AfmObjectIdentifierDataset](docs/AfmObjectIdentifierDataset.md)
 - [AfmObjectIdentifierDatasetIdentifier](docs/AfmObjectIdentifierDatasetIdentifier.md)
 - [AfmObjectIdentifierIdentifier](docs/AfmObjectIdentifierIdentifier.md)
 - [AfmObjectIdentifierLabel](docs/AfmObjectIdentifierLabel.md)
 - [AfmObjectIdentifierLabelIdentifier](docs/AfmObjectIdentifierLabelIdentifier.md)
 - [AfmValidDescendantsQuery](docs/AfmValidDescendantsQuery.md)
 - [AfmValidDescendantsResponse](docs/AfmValidDescendantsResponse.md)
 - [AfmValidObjectsQuery](docs/AfmValidObjectsQuery.md)
 - [AfmValidObjectsResponse](docs/AfmValidObjectsResponse.md)
 - [AnomalyDetectionRequest](docs/AnomalyDetectionRequest.md)
 - [AnomalyDetectionResult](docs/AnomalyDetectionResult.md)
 - [AnomalyDetectionResultAllOf](docs/AnomalyDetectionResultAllOf.md)
 - [AnomalyUserNotification](docs/AnomalyUserNotification.md)
 - [ApiEntitlement](docs/ApiEntitlement.md)
 - [ArithmeticMeasureDefinition](docs/ArithmeticMeasureDefinition.md)
 - [ArithmeticMeasureDefinitionArithmeticMeasure](docs/ArithmeticMeasureDefinitionArithmeticMeasure.md)
 - [AssigneeIdentifier](docs/AssigneeIdentifier.md)
 - [AssigneeRule](docs/AssigneeRule.md)
 - [AttributeExecutionResultHeader](docs/AttributeExecutionResultHeader.md)
 - [AttributeFilter](docs/AttributeFilter.md)
 - [AttributeFilterElements](docs/AttributeFilterElements.md)
 - [AttributeFormat](docs/AttributeFormat.md)
 - [AttributeHeaderOut](docs/AttributeHeaderOut.md)
 - [AttributeHeaderOutAttributeHeader](docs/AttributeHeaderOutAttributeHeader.md)
 - [AttributeItem](docs/AttributeItem.md)
 - [AttributeResultHeader](docs/AttributeResultHeader.md)
 - [AvailableAssignees](docs/AvailableAssignees.md)
 - [CacheResponse](docs/CacheResponse.md)
 - [ClusteringRequest](docs/ClusteringRequest.md)
 - [ClusteringResult](docs/ClusteringResult.md)
 - [ClusteringResultAllOf](docs/ClusteringResultAllOf.md)
 - [ClusteringResultValue](docs/ClusteringResultValue.md)
 - [ColumnLocation](docs/ColumnLocation.md)
 - [ColumnStatistic](docs/ColumnStatistic.md)
 - [ColumnStatisticWarning](docs/ColumnStatisticWarning.md)
 - [ColumnStatisticsRequest](docs/ColumnStatisticsRequest.md)
 - [ColumnStatisticsRequestFrom](docs/ColumnStatisticsRequestFrom.md)
 - [ColumnStatisticsResponse](docs/ColumnStatisticsResponse.md)
 - [ColumnWarning](docs/ColumnWarning.md)
 - [ComparisonMeasureValueFilter](docs/ComparisonMeasureValueFilter.md)
 - [ComparisonMeasureValueFilterComparisonMeasureValueFilter](docs/ComparisonMeasureValueFilterComparisonMeasureValueFilter.md)
 - [CustomLabel](docs/CustomLabel.md)
 - [CustomMetric](docs/CustomMetric.md)
 - [CustomOverride](docs/CustomOverride.md)
 - [DashboardPermissions](docs/DashboardPermissions.md)
 - [DashboardPermissionsAssignment](docs/DashboardPermissionsAssignment.md)
 - [DataColumnLocator](docs/DataColumnLocator.md)
 - [DataColumnLocators](docs/DataColumnLocators.md)
 - [DataSourceParameter](docs/DataSourceParameter.md)
 - [DataSourcePermissionAssignment](docs/DataSourcePermissionAssignment.md)
 - [DataSourceSchemata](docs/DataSourceSchemata.md)
 - [DataSourceTableIdentifier](docs/DataSourceTableIdentifier.md)
 - [DatasetGrain](docs/DatasetGrain.md)
 - [DatasetReferenceIdentifier](docs/DatasetReferenceIdentifier.md)
 - [DatasetWorkspaceDataFilterIdentifier](docs/DatasetWorkspaceDataFilterIdentifier.md)
 - [DateFilter](docs/DateFilter.md)
 - [DeclarativeAnalyticalDashboard](docs/DeclarativeAnalyticalDashboard.md)
 - [DeclarativeAnalyticalDashboardExtension](docs/DeclarativeAnalyticalDashboardExtension.md)
 - [DeclarativeAnalyticalDashboardPermissionAssignment](docs/DeclarativeAnalyticalDashboardPermissionAssignment.md)
 - [DeclarativeAnalyticalDashboardPermissionForAssignee](docs/DeclarativeAnalyticalDashboardPermissionForAssignee.md)
 - [DeclarativeAnalyticalDashboardPermissionForAssigneeAllOf](docs/DeclarativeAnalyticalDashboardPermissionForAssigneeAllOf.md)
 - [DeclarativeAnalyticalDashboardPermissionForAssigneeRule](docs/DeclarativeAnalyticalDashboardPermissionForAssigneeRule.md)
 - [DeclarativeAnalyticalDashboardPermissionForAssigneeRuleAllOf](docs/DeclarativeAnalyticalDashboardPermissionForAssigneeRuleAllOf.md)
 - [DeclarativeAnalyticalDashboardPermissionsInner](docs/DeclarativeAnalyticalDashboardPermissionsInner.md)
 - [DeclarativeAnalytics](docs/DeclarativeAnalytics.md)
 - [DeclarativeAnalyticsLayer](docs/DeclarativeAnalyticsLayer.md)
 - [DeclarativeAttribute](docs/DeclarativeAttribute.md)
 - [DeclarativeAttributeHierarchy](docs/DeclarativeAttributeHierarchy.md)
 - [DeclarativeColorPalette](docs/DeclarativeColorPalette.md)
 - [DeclarativeColumn](docs/DeclarativeColumn.md)
 - [DeclarativeCspDirective](docs/DeclarativeCspDirective.md)
 - [DeclarativeCustomApplicationSetting](docs/DeclarativeCustomApplicationSetting.md)
 - [DeclarativeDashboardPlugin](docs/DeclarativeDashboardPlugin.md)
 - [DeclarativeDataSource](docs/DeclarativeDataSource.md)
 - [DeclarativeDataSourcePermission](docs/DeclarativeDataSourcePermission.md)
 - [DeclarativeDataSourcePermissions](docs/DeclarativeDataSourcePermissions.md)
 - [DeclarativeDataSources](docs/DeclarativeDataSources.md)
 - [DeclarativeDataset](docs/DeclarativeDataset.md)
 - [DeclarativeDatasetExtension](docs/DeclarativeDatasetExtension.md)
 - [DeclarativeDatasetSql](docs/DeclarativeDatasetSql.md)
 - [DeclarativeDateDataset](docs/DeclarativeDateDataset.md)
 - [DeclarativeFact](docs/DeclarativeFact.md)
 - [DeclarativeFilterContext](docs/DeclarativeFilterContext.md)
 - [DeclarativeJwk](docs/DeclarativeJwk.md)
 - [DeclarativeJwkSpecification](docs/DeclarativeJwkSpecification.md)
 - [DeclarativeLabel](docs/DeclarativeLabel.md)
 - [DeclarativeLdm](docs/DeclarativeLdm.md)
 - [DeclarativeMetric](docs/DeclarativeMetric.md)
 - [DeclarativeModel](docs/DeclarativeModel.md)
 - [DeclarativeOrganization](docs/DeclarativeOrganization.md)
 - [DeclarativeOrganizationInfo](docs/DeclarativeOrganizationInfo.md)
 - [DeclarativeOrganizationPermission](docs/DeclarativeOrganizationPermission.md)
 - [DeclarativeReference](docs/DeclarativeReference.md)
 - [DeclarativeReferenceSource](docs/DeclarativeReferenceSource.md)
 - [DeclarativeRsaSpecification](docs/DeclarativeRsaSpecification.md)
 - [DeclarativeSetting](docs/DeclarativeSetting.md)
 - [DeclarativeSingleWorkspacePermission](docs/DeclarativeSingleWorkspacePermission.md)
 - [DeclarativeTable](docs/DeclarativeTable.md)
 - [DeclarativeTables](docs/DeclarativeTables.md)
 - [DeclarativeTheme](docs/DeclarativeTheme.md)
 - [DeclarativeUser](docs/DeclarativeUser.md)
 - [DeclarativeUserDataFilter](docs/DeclarativeUserDataFilter.md)
 - [DeclarativeUserDataFilters](docs/DeclarativeUserDataFilters.md)
 - [DeclarativeUserGroup](docs/DeclarativeUserGroup.md)
 - [DeclarativeUserGroupIdentifier](docs/DeclarativeUserGroupIdentifier.md)
 - [DeclarativeUserGroupPermission](docs/DeclarativeUserGroupPermission.md)
 - [DeclarativeUserGroupPermissions](docs/DeclarativeUserGroupPermissions.md)
 - [DeclarativeUserGroups](docs/DeclarativeUserGroups.md)
 - [DeclarativeUserIdentifier](docs/DeclarativeUserIdentifier.md)
 - [DeclarativeUserPermission](docs/DeclarativeUserPermission.md)
 - [DeclarativeUserPermissions](docs/DeclarativeUserPermissions.md)
 - [DeclarativeUsers](docs/DeclarativeUsers.md)
 - [DeclarativeUsersUserGroups](docs/DeclarativeUsersUserGroups.md)
 - [DeclarativeVisualizationObject](docs/DeclarativeVisualizationObject.md)
 - [DeclarativeWorkspace](docs/DeclarativeWorkspace.md)
 - [DeclarativeWorkspaceDataFilter](docs/DeclarativeWorkspaceDataFilter.md)
 - [DeclarativeWorkspaceDataFilterColumn](docs/DeclarativeWorkspaceDataFilterColumn.md)
 - [DeclarativeWorkspaceDataFilterReferences](docs/DeclarativeWorkspaceDataFilterReferences.md)
 - [DeclarativeWorkspaceDataFilterSetting](docs/DeclarativeWorkspaceDataFilterSetting.md)
 - [DeclarativeWorkspaceDataFilters](docs/DeclarativeWorkspaceDataFilters.md)
 - [DeclarativeWorkspaceHierarchyPermission](docs/DeclarativeWorkspaceHierarchyPermission.md)
 - [DeclarativeWorkspaceModel](docs/DeclarativeWorkspaceModel.md)
 - [DeclarativeWorkspacePermissions](docs/DeclarativeWorkspacePermissions.md)
 - [DeclarativeWorkspaces](docs/DeclarativeWorkspaces.md)
 - [DependentEntitiesGraph](docs/DependentEntitiesGraph.md)
 - [DependentEntitiesNode](docs/DependentEntitiesNode.md)
 - [DependentEntitiesRequest](docs/DependentEntitiesRequest.md)
 - [DependentEntitiesResponse](docs/DependentEntitiesResponse.md)
 - [DependsOn](docs/DependsOn.md)
 - [Dimension](docs/Dimension.md)
 - [DimensionHeader](docs/DimensionHeader.md)
 - [Element](docs/Element.md)
 - [ElementsRequest](docs/ElementsRequest.md)
 - [ElementsResponse](docs/ElementsResponse.md)
 - [EntitlementsRequest](docs/EntitlementsRequest.md)
 - [EntityIdentifier](docs/EntityIdentifier.md)
 - [ExecutionLinks](docs/ExecutionLinks.md)
 - [ExecutionResponse](docs/ExecutionResponse.md)
 - [ExecutionResult](docs/ExecutionResult.md)
 - [ExecutionResultGrandTotal](docs/ExecutionResultGrandTotal.md)
 - [ExecutionResultHeader](docs/ExecutionResultHeader.md)
 - [ExecutionResultPaging](docs/ExecutionResultPaging.md)
 - [ExecutionSettings](docs/ExecutionSettings.md)
 - [ExportResponse](docs/ExportResponse.md)
 - [FetchAnomalyDetectionResult200Response](docs/FetchAnomalyDetectionResult200Response.md)
 - [File](docs/File.md)
 - [FilterBy](docs/FilterBy.md)
 - [FilterDefinition](docs/FilterDefinition.md)
 - [FilterDefinitionForSimpleMeasure](docs/FilterDefinitionForSimpleMeasure.md)
 - [FindRecommendationsRequest](docs/FindRecommendationsRequest.md)
 - [ForecastRequest](docs/ForecastRequest.md)
 - [ForecastResult](docs/ForecastResult.md)
 - [ForecastResultAllOf](docs/ForecastResultAllOf.md)
 - [Frequency](docs/Frequency.md)
 - [FrequencyBucket](docs/FrequencyBucket.md)
 - [FrequencyProperties](docs/FrequencyProperties.md)
 - [GenerateLdmRequest](docs/GenerateLdmRequest.md)
 - [GetNotificationsForCurrentUser200ResponseInner](docs/GetNotificationsForCurrentUser200ResponseInner.md)
 - [GrainIdentifier](docs/GrainIdentifier.md)
 - [GrantedPermission](docs/GrantedPermission.md)
 - [GranularitiesFormatting](docs/GranularitiesFormatting.md)
 - [HeaderGroup](docs/HeaderGroup.md)
 - [HierarchyObjectIdentification](docs/HierarchyObjectIdentification.md)
 - [Histogram](docs/Histogram.md)
 - [HistogramBucket](docs/HistogramBucket.md)
 - [HistogramProperties](docs/HistogramProperties.md)
 - [IdentifierDuplications](docs/IdentifierDuplications.md)
 - [InlineFilterDefinition](docs/InlineFilterDefinition.md)
 - [InlineFilterDefinitionInline](docs/InlineFilterDefinitionInline.md)
 - [InlineMeasureDefinition](docs/InlineMeasureDefinition.md)
 - [InlineMeasureDefinitionInline](docs/InlineMeasureDefinitionInline.md)
 - [JsonApiAnalyticalDashboardIn](docs/JsonApiAnalyticalDashboardIn.md)
 - [JsonApiAnalyticalDashboardInAttributes](docs/JsonApiAnalyticalDashboardInAttributes.md)
 - [JsonApiAnalyticalDashboardInDocument](docs/JsonApiAnalyticalDashboardInDocument.md)
 - [JsonApiAnalyticalDashboardLinkage](docs/JsonApiAnalyticalDashboardLinkage.md)
 - [JsonApiAnalyticalDashboardOut](docs/JsonApiAnalyticalDashboardOut.md)
 - [JsonApiAnalyticalDashboardOutAttributes](docs/JsonApiAnalyticalDashboardOutAttributes.md)
 - [JsonApiAnalyticalDashboardOutAttributesInteractions](docs/JsonApiAnalyticalDashboardOutAttributesInteractions.md)
 - [JsonApiAnalyticalDashboardOutDocument](docs/JsonApiAnalyticalDashboardOutDocument.md)
 - [JsonApiAnalyticalDashboardOutIncludes](docs/JsonApiAnalyticalDashboardOutIncludes.md)
 - [JsonApiAnalyticalDashboardOutList](docs/JsonApiAnalyticalDashboardOutList.md)
 - [JsonApiAnalyticalDashboardOutMeta](docs/JsonApiAnalyticalDashboardOutMeta.md)
 - [JsonApiAnalyticalDashboardOutMetaAccessInfo](docs/JsonApiAnalyticalDashboardOutMetaAccessInfo.md)
 - [JsonApiAnalyticalDashboardOutMetaOrigin](docs/JsonApiAnalyticalDashboardOutMetaOrigin.md)
 - [JsonApiAnalyticalDashboardOutRelationships](docs/JsonApiAnalyticalDashboardOutRelationships.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsAnalyticalDashboards](docs/JsonApiAnalyticalDashboardOutRelationshipsAnalyticalDashboards.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsCreatedBy](docs/JsonApiAnalyticalDashboardOutRelationshipsCreatedBy.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsDashboardPlugins](docs/JsonApiAnalyticalDashboardOutRelationshipsDashboardPlugins.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsDatasets](docs/JsonApiAnalyticalDashboardOutRelationshipsDatasets.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsFilterContexts](docs/JsonApiAnalyticalDashboardOutRelationshipsFilterContexts.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsLabels](docs/JsonApiAnalyticalDashboardOutRelationshipsLabels.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsMetrics](docs/JsonApiAnalyticalDashboardOutRelationshipsMetrics.md)
 - [JsonApiAnalyticalDashboardOutRelationshipsVisualizationObjects](docs/JsonApiAnalyticalDashboardOutRelationshipsVisualizationObjects.md)
 - [JsonApiAnalyticalDashboardOutWithLinks](docs/JsonApiAnalyticalDashboardOutWithLinks.md)
 - [JsonApiAnalyticalDashboardPatch](docs/JsonApiAnalyticalDashboardPatch.md)
 - [JsonApiAnalyticalDashboardPatchAttributes](docs/JsonApiAnalyticalDashboardPatchAttributes.md)
 - [JsonApiAnalyticalDashboardPatchDocument](docs/JsonApiAnalyticalDashboardPatchDocument.md)
 - [JsonApiAnalyticalDashboardPostOptionalId](docs/JsonApiAnalyticalDashboardPostOptionalId.md)
 - [JsonApiAnalyticalDashboardPostOptionalIdDocument](docs/JsonApiAnalyticalDashboardPostOptionalIdDocument.md)
 - [JsonApiAnalyticalDashboardToManyLinkage](docs/JsonApiAnalyticalDashboardToManyLinkage.md)
 - [JsonApiAnalyticalDashboardToOneLinkage](docs/JsonApiAnalyticalDashboardToOneLinkage.md)
 - [JsonApiApiTokenIn](docs/JsonApiApiTokenIn.md)
 - [JsonApiApiTokenInDocument](docs/JsonApiApiTokenInDocument.md)
 - [JsonApiApiTokenOut](docs/JsonApiApiTokenOut.md)
 - [JsonApiApiTokenOutAttributes](docs/JsonApiApiTokenOutAttributes.md)
 - [JsonApiApiTokenOutDocument](docs/JsonApiApiTokenOutDocument.md)
 - [JsonApiApiTokenOutList](docs/JsonApiApiTokenOutList.md)
 - [JsonApiApiTokenOutWithLinks](docs/JsonApiApiTokenOutWithLinks.md)
 - [JsonApiAttributeHierarchyIn](docs/JsonApiAttributeHierarchyIn.md)
 - [JsonApiAttributeHierarchyInAttributes](docs/JsonApiAttributeHierarchyInAttributes.md)
 - [JsonApiAttributeHierarchyInDocument](docs/JsonApiAttributeHierarchyInDocument.md)
 - [JsonApiAttributeHierarchyLinkage](docs/JsonApiAttributeHierarchyLinkage.md)
 - [JsonApiAttributeHierarchyOut](docs/JsonApiAttributeHierarchyOut.md)
 - [JsonApiAttributeHierarchyOutAttributes](docs/JsonApiAttributeHierarchyOutAttributes.md)
 - [JsonApiAttributeHierarchyOutDocument](docs/JsonApiAttributeHierarchyOutDocument.md)
 - [JsonApiAttributeHierarchyOutIncludes](docs/JsonApiAttributeHierarchyOutIncludes.md)
 - [JsonApiAttributeHierarchyOutList](docs/JsonApiAttributeHierarchyOutList.md)
 - [JsonApiAttributeHierarchyOutMeta](docs/JsonApiAttributeHierarchyOutMeta.md)
 - [JsonApiAttributeHierarchyOutRelationships](docs/JsonApiAttributeHierarchyOutRelationships.md)
 - [JsonApiAttributeHierarchyOutRelationshipsAttributes](docs/JsonApiAttributeHierarchyOutRelationshipsAttributes.md)
 - [JsonApiAttributeHierarchyOutWithLinks](docs/JsonApiAttributeHierarchyOutWithLinks.md)
 - [JsonApiAttributeHierarchyPatch](docs/JsonApiAttributeHierarchyPatch.md)
 - [JsonApiAttributeHierarchyPatchDocument](docs/JsonApiAttributeHierarchyPatchDocument.md)
 - [JsonApiAttributeHierarchyToManyLinkage](docs/JsonApiAttributeHierarchyToManyLinkage.md)
 - [JsonApiAttributeLinkage](docs/JsonApiAttributeLinkage.md)
 - [JsonApiAttributeOut](docs/JsonApiAttributeOut.md)
 - [JsonApiAttributeOutAttributes](docs/JsonApiAttributeOutAttributes.md)
 - [JsonApiAttributeOutDocument](docs/JsonApiAttributeOutDocument.md)
 - [JsonApiAttributeOutIncludes](docs/JsonApiAttributeOutIncludes.md)
 - [JsonApiAttributeOutList](docs/JsonApiAttributeOutList.md)
 - [JsonApiAttributeOutRelationships](docs/JsonApiAttributeOutRelationships.md)
 - [JsonApiAttributeOutRelationshipsAttributeHierarchies](docs/JsonApiAttributeOutRelationshipsAttributeHierarchies.md)
 - [JsonApiAttributeOutRelationshipsDataset](docs/JsonApiAttributeOutRelationshipsDataset.md)
 - [JsonApiAttributeOutRelationshipsDefaultView](docs/JsonApiAttributeOutRelationshipsDefaultView.md)
 - [JsonApiAttributeOutWithLinks](docs/JsonApiAttributeOutWithLinks.md)
 - [JsonApiAttributeToManyLinkage](docs/JsonApiAttributeToManyLinkage.md)
 - [JsonApiAttributeToOneLinkage](docs/JsonApiAttributeToOneLinkage.md)
 - [JsonApiColorPaletteIn](docs/JsonApiColorPaletteIn.md)
 - [JsonApiColorPaletteInAttributes](docs/JsonApiColorPaletteInAttributes.md)
 - [JsonApiColorPaletteInDocument](docs/JsonApiColorPaletteInDocument.md)
 - [JsonApiColorPaletteOut](docs/JsonApiColorPaletteOut.md)
 - [JsonApiColorPaletteOutDocument](docs/JsonApiColorPaletteOutDocument.md)
 - [JsonApiColorPaletteOutList](docs/JsonApiColorPaletteOutList.md)
 - [JsonApiColorPaletteOutWithLinks](docs/JsonApiColorPaletteOutWithLinks.md)
 - [JsonApiColorPalettePatch](docs/JsonApiColorPalettePatch.md)
 - [JsonApiColorPalettePatchAttributes](docs/JsonApiColorPalettePatchAttributes.md)
 - [JsonApiColorPalettePatchDocument](docs/JsonApiColorPalettePatchDocument.md)
 - [JsonApiCookieSecurityConfigurationIn](docs/JsonApiCookieSecurityConfigurationIn.md)
 - [JsonApiCookieSecurityConfigurationInAttributes](docs/JsonApiCookieSecurityConfigurationInAttributes.md)
 - [JsonApiCookieSecurityConfigurationInDocument](docs/JsonApiCookieSecurityConfigurationInDocument.md)
 - [JsonApiCookieSecurityConfigurationOut](docs/JsonApiCookieSecurityConfigurationOut.md)
 - [JsonApiCookieSecurityConfigurationOutDocument](docs/JsonApiCookieSecurityConfigurationOutDocument.md)
 - [JsonApiCookieSecurityConfigurationPatch](docs/JsonApiCookieSecurityConfigurationPatch.md)
 - [JsonApiCookieSecurityConfigurationPatchDocument](docs/JsonApiCookieSecurityConfigurationPatchDocument.md)
 - [JsonApiCspDirectiveIn](docs/JsonApiCspDirectiveIn.md)
 - [JsonApiCspDirectiveInAttributes](docs/JsonApiCspDirectiveInAttributes.md)
 - [JsonApiCspDirectiveInDocument](docs/JsonApiCspDirectiveInDocument.md)
 - [JsonApiCspDirectiveOut](docs/JsonApiCspDirectiveOut.md)
 - [JsonApiCspDirectiveOutDocument](docs/JsonApiCspDirectiveOutDocument.md)
 - [JsonApiCspDirectiveOutList](docs/JsonApiCspDirectiveOutList.md)
 - [JsonApiCspDirectiveOutWithLinks](docs/JsonApiCspDirectiveOutWithLinks.md)
 - [JsonApiCspDirectivePatch](docs/JsonApiCspDirectivePatch.md)
 - [JsonApiCspDirectivePatchAttributes](docs/JsonApiCspDirectivePatchAttributes.md)
 - [JsonApiCspDirectivePatchDocument](docs/JsonApiCspDirectivePatchDocument.md)
 - [JsonApiCustomApplicationSettingIn](docs/JsonApiCustomApplicationSettingIn.md)
 - [JsonApiCustomApplicationSettingInAttributes](docs/JsonApiCustomApplicationSettingInAttributes.md)
 - [JsonApiCustomApplicationSettingInDocument](docs/JsonApiCustomApplicationSettingInDocument.md)
 - [JsonApiCustomApplicationSettingOut](docs/JsonApiCustomApplicationSettingOut.md)
 - [JsonApiCustomApplicationSettingOutDocument](docs/JsonApiCustomApplicationSettingOutDocument.md)
 - [JsonApiCustomApplicationSettingOutList](docs/JsonApiCustomApplicationSettingOutList.md)
 - [JsonApiCustomApplicationSettingOutWithLinks](docs/JsonApiCustomApplicationSettingOutWithLinks.md)
 - [JsonApiCustomApplicationSettingPatch](docs/JsonApiCustomApplicationSettingPatch.md)
 - [JsonApiCustomApplicationSettingPatchAttributes](docs/JsonApiCustomApplicationSettingPatchAttributes.md)
 - [JsonApiCustomApplicationSettingPatchDocument](docs/JsonApiCustomApplicationSettingPatchDocument.md)
 - [JsonApiCustomApplicationSettingPostOptionalId](docs/JsonApiCustomApplicationSettingPostOptionalId.md)
 - [JsonApiCustomApplicationSettingPostOptionalIdDocument](docs/JsonApiCustomApplicationSettingPostOptionalIdDocument.md)
 - [JsonApiDashboardPluginIn](docs/JsonApiDashboardPluginIn.md)
 - [JsonApiDashboardPluginInAttributes](docs/JsonApiDashboardPluginInAttributes.md)
 - [JsonApiDashboardPluginInDocument](docs/JsonApiDashboardPluginInDocument.md)
 - [JsonApiDashboardPluginLinkage](docs/JsonApiDashboardPluginLinkage.md)
 - [JsonApiDashboardPluginOut](docs/JsonApiDashboardPluginOut.md)
 - [JsonApiDashboardPluginOutAttributes](docs/JsonApiDashboardPluginOutAttributes.md)
 - [JsonApiDashboardPluginOutDocument](docs/JsonApiDashboardPluginOutDocument.md)
 - [JsonApiDashboardPluginOutList](docs/JsonApiDashboardPluginOutList.md)
 - [JsonApiDashboardPluginOutRelationships](docs/JsonApiDashboardPluginOutRelationships.md)
 - [JsonApiDashboardPluginOutWithLinks](docs/JsonApiDashboardPluginOutWithLinks.md)
 - [JsonApiDashboardPluginPatch](docs/JsonApiDashboardPluginPatch.md)
 - [JsonApiDashboardPluginPatchDocument](docs/JsonApiDashboardPluginPatchDocument.md)
 - [JsonApiDashboardPluginPostOptionalId](docs/JsonApiDashboardPluginPostOptionalId.md)
 - [JsonApiDashboardPluginPostOptionalIdDocument](docs/JsonApiDashboardPluginPostOptionalIdDocument.md)
 - [JsonApiDashboardPluginToManyLinkage](docs/JsonApiDashboardPluginToManyLinkage.md)
 - [JsonApiDataSourceIdentifierOut](docs/JsonApiDataSourceIdentifierOut.md)
 - [JsonApiDataSourceIdentifierOutAttributes](docs/JsonApiDataSourceIdentifierOutAttributes.md)
 - [JsonApiDataSourceIdentifierOutDocument](docs/JsonApiDataSourceIdentifierOutDocument.md)
 - [JsonApiDataSourceIdentifierOutList](docs/JsonApiDataSourceIdentifierOutList.md)
 - [JsonApiDataSourceIdentifierOutMeta](docs/JsonApiDataSourceIdentifierOutMeta.md)
 - [JsonApiDataSourceIdentifierOutWithLinks](docs/JsonApiDataSourceIdentifierOutWithLinks.md)
 - [JsonApiDataSourceIn](docs/JsonApiDataSourceIn.md)
 - [JsonApiDataSourceInAttributes](docs/JsonApiDataSourceInAttributes.md)
 - [JsonApiDataSourceInAttributesParametersInner](docs/JsonApiDataSourceInAttributesParametersInner.md)
 - [JsonApiDataSourceInDocument](docs/JsonApiDataSourceInDocument.md)
 - [JsonApiDataSourceOut](docs/JsonApiDataSourceOut.md)
 - [JsonApiDataSourceOutAttributes](docs/JsonApiDataSourceOutAttributes.md)
 - [JsonApiDataSourceOutDocument](docs/JsonApiDataSourceOutDocument.md)
 - [JsonApiDataSourceOutList](docs/JsonApiDataSourceOutList.md)
 - [JsonApiDataSourceOutWithLinks](docs/JsonApiDataSourceOutWithLinks.md)
 - [JsonApiDataSourcePatch](docs/JsonApiDataSourcePatch.md)
 - [JsonApiDataSourcePatchAttributes](docs/JsonApiDataSourcePatchAttributes.md)
 - [JsonApiDataSourcePatchDocument](docs/JsonApiDataSourcePatchDocument.md)
 - [JsonApiDatasetLinkage](docs/JsonApiDatasetLinkage.md)
 - [JsonApiDatasetOut](docs/JsonApiDatasetOut.md)
 - [JsonApiDatasetOutAttributes](docs/JsonApiDatasetOutAttributes.md)
 - [JsonApiDatasetOutAttributesGrainInner](docs/JsonApiDatasetOutAttributesGrainInner.md)
 - [JsonApiDatasetOutAttributesReferencePropertiesInner](docs/JsonApiDatasetOutAttributesReferencePropertiesInner.md)
 - [JsonApiDatasetOutAttributesSql](docs/JsonApiDatasetOutAttributesSql.md)
 - [JsonApiDatasetOutAttributesWorkspaceDataFilterColumnsInner](docs/JsonApiDatasetOutAttributesWorkspaceDataFilterColumnsInner.md)
 - [JsonApiDatasetOutAttributesWorkspaceDataFilterReferencesInner](docs/JsonApiDatasetOutAttributesWorkspaceDataFilterReferencesInner.md)
 - [JsonApiDatasetOutDocument](docs/JsonApiDatasetOutDocument.md)
 - [JsonApiDatasetOutIncludes](docs/JsonApiDatasetOutIncludes.md)
 - [JsonApiDatasetOutList](docs/JsonApiDatasetOutList.md)
 - [JsonApiDatasetOutRelationships](docs/JsonApiDatasetOutRelationships.md)
 - [JsonApiDatasetOutRelationshipsFacts](docs/JsonApiDatasetOutRelationshipsFacts.md)
 - [JsonApiDatasetOutRelationshipsWorkspaceDataFilters](docs/JsonApiDatasetOutRelationshipsWorkspaceDataFilters.md)
 - [JsonApiDatasetOutWithLinks](docs/JsonApiDatasetOutWithLinks.md)
 - [JsonApiDatasetToManyLinkage](docs/JsonApiDatasetToManyLinkage.md)
 - [JsonApiDatasetToOneLinkage](docs/JsonApiDatasetToOneLinkage.md)
 - [JsonApiEntitlementOut](docs/JsonApiEntitlementOut.md)
 - [JsonApiEntitlementOutAttributes](docs/JsonApiEntitlementOutAttributes.md)
 - [JsonApiEntitlementOutDocument](docs/JsonApiEntitlementOutDocument.md)
 - [JsonApiEntitlementOutList](docs/JsonApiEntitlementOutList.md)
 - [JsonApiEntitlementOutWithLinks](docs/JsonApiEntitlementOutWithLinks.md)
 - [JsonApiFactLinkage](docs/JsonApiFactLinkage.md)
 - [JsonApiFactOut](docs/JsonApiFactOut.md)
 - [JsonApiFactOutAttributes](docs/JsonApiFactOutAttributes.md)
 - [JsonApiFactOutDocument](docs/JsonApiFactOutDocument.md)
 - [JsonApiFactOutList](docs/JsonApiFactOutList.md)
 - [JsonApiFactOutRelationships](docs/JsonApiFactOutRelationships.md)
 - [JsonApiFactOutWithLinks](docs/JsonApiFactOutWithLinks.md)
 - [JsonApiFactToManyLinkage](docs/JsonApiFactToManyLinkage.md)
 - [JsonApiFilterContextIn](docs/JsonApiFilterContextIn.md)
 - [JsonApiFilterContextInDocument](docs/JsonApiFilterContextInDocument.md)
 - [JsonApiFilterContextLinkage](docs/JsonApiFilterContextLinkage.md)
 - [JsonApiFilterContextOut](docs/JsonApiFilterContextOut.md)
 - [JsonApiFilterContextOutDocument](docs/JsonApiFilterContextOutDocument.md)
 - [JsonApiFilterContextOutIncludes](docs/JsonApiFilterContextOutIncludes.md)
 - [JsonApiFilterContextOutList](docs/JsonApiFilterContextOutList.md)
 - [JsonApiFilterContextOutRelationships](docs/JsonApiFilterContextOutRelationships.md)
 - [JsonApiFilterContextOutWithLinks](docs/JsonApiFilterContextOutWithLinks.md)
 - [JsonApiFilterContextPatch](docs/JsonApiFilterContextPatch.md)
 - [JsonApiFilterContextPatchDocument](docs/JsonApiFilterContextPatchDocument.md)
 - [JsonApiFilterContextPostOptionalId](docs/JsonApiFilterContextPostOptionalId.md)
 - [JsonApiFilterContextPostOptionalIdDocument](docs/JsonApiFilterContextPostOptionalIdDocument.md)
 - [JsonApiFilterContextToManyLinkage](docs/JsonApiFilterContextToManyLinkage.md)
 - [JsonApiFilterContextToOneLinkage](docs/JsonApiFilterContextToOneLinkage.md)
 - [JsonApiJwkIn](docs/JsonApiJwkIn.md)
 - [JsonApiJwkInAttributes](docs/JsonApiJwkInAttributes.md)
 - [JsonApiJwkInAttributesContent](docs/JsonApiJwkInAttributesContent.md)
 - [JsonApiJwkInDocument](docs/JsonApiJwkInDocument.md)
 - [JsonApiJwkOut](docs/JsonApiJwkOut.md)
 - [JsonApiJwkOutDocument](docs/JsonApiJwkOutDocument.md)
 - [JsonApiJwkOutList](docs/JsonApiJwkOutList.md)
 - [JsonApiJwkOutWithLinks](docs/JsonApiJwkOutWithLinks.md)
 - [JsonApiJwkPatch](docs/JsonApiJwkPatch.md)
 - [JsonApiJwkPatchDocument](docs/JsonApiJwkPatchDocument.md)
 - [JsonApiLabelLinkage](docs/JsonApiLabelLinkage.md)
 - [JsonApiLabelOut](docs/JsonApiLabelOut.md)
 - [JsonApiLabelOutAttributes](docs/JsonApiLabelOutAttributes.md)
 - [JsonApiLabelOutDocument](docs/JsonApiLabelOutDocument.md)
 - [JsonApiLabelOutList](docs/JsonApiLabelOutList.md)
 - [JsonApiLabelOutRelationships](docs/JsonApiLabelOutRelationships.md)
 - [JsonApiLabelOutRelationshipsAttribute](docs/JsonApiLabelOutRelationshipsAttribute.md)
 - [JsonApiLabelOutWithLinks](docs/JsonApiLabelOutWithLinks.md)
 - [JsonApiLabelToManyLinkage](docs/JsonApiLabelToManyLinkage.md)
 - [JsonApiLabelToOneLinkage](docs/JsonApiLabelToOneLinkage.md)
 - [JsonApiMetricIn](docs/JsonApiMetricIn.md)
 - [JsonApiMetricInAttributes](docs/JsonApiMetricInAttributes.md)
 - [JsonApiMetricInAttributesContent](docs/JsonApiMetricInAttributesContent.md)
 - [JsonApiMetricInDocument](docs/JsonApiMetricInDocument.md)
 - [JsonApiMetricLinkage](docs/JsonApiMetricLinkage.md)
 - [JsonApiMetricOut](docs/JsonApiMetricOut.md)
 - [JsonApiMetricOutAttributes](docs/JsonApiMetricOutAttributes.md)
 - [JsonApiMetricOutDocument](docs/JsonApiMetricOutDocument.md)
 - [JsonApiMetricOutIncludes](docs/JsonApiMetricOutIncludes.md)
 - [JsonApiMetricOutList](docs/JsonApiMetricOutList.md)
 - [JsonApiMetricOutRelationships](docs/JsonApiMetricOutRelationships.md)
 - [JsonApiMetricOutWithLinks](docs/JsonApiMetricOutWithLinks.md)
 - [JsonApiMetricPatch](docs/JsonApiMetricPatch.md)
 - [JsonApiMetricPatchAttributes](docs/JsonApiMetricPatchAttributes.md)
 - [JsonApiMetricPatchDocument](docs/JsonApiMetricPatchDocument.md)
 - [JsonApiMetricPostOptionalId](docs/JsonApiMetricPostOptionalId.md)
 - [JsonApiMetricPostOptionalIdDocument](docs/JsonApiMetricPostOptionalIdDocument.md)
 - [JsonApiMetricToManyLinkage](docs/JsonApiMetricToManyLinkage.md)
 - [JsonApiOrganizationIn](docs/JsonApiOrganizationIn.md)
 - [JsonApiOrganizationInAttributes](docs/JsonApiOrganizationInAttributes.md)
 - [JsonApiOrganizationInDocument](docs/JsonApiOrganizationInDocument.md)
 - [JsonApiOrganizationOut](docs/JsonApiOrganizationOut.md)
 - [JsonApiOrganizationOutAttributes](docs/JsonApiOrganizationOutAttributes.md)
 - [JsonApiOrganizationOutAttributesCacheSettings](docs/JsonApiOrganizationOutAttributesCacheSettings.md)
 - [JsonApiOrganizationOutDocument](docs/JsonApiOrganizationOutDocument.md)
 - [JsonApiOrganizationOutIncludes](docs/JsonApiOrganizationOutIncludes.md)
 - [JsonApiOrganizationOutMeta](docs/JsonApiOrganizationOutMeta.md)
 - [JsonApiOrganizationOutRelationships](docs/JsonApiOrganizationOutRelationships.md)
 - [JsonApiOrganizationOutRelationshipsBootstrapUser](docs/JsonApiOrganizationOutRelationshipsBootstrapUser.md)
 - [JsonApiOrganizationOutRelationshipsBootstrapUserGroup](docs/JsonApiOrganizationOutRelationshipsBootstrapUserGroup.md)
 - [JsonApiOrganizationPatch](docs/JsonApiOrganizationPatch.md)
 - [JsonApiOrganizationPatchDocument](docs/JsonApiOrganizationPatchDocument.md)
 - [JsonApiOrganizationSettingIn](docs/JsonApiOrganizationSettingIn.md)
 - [JsonApiOrganizationSettingInAttributes](docs/JsonApiOrganizationSettingInAttributes.md)
 - [JsonApiOrganizationSettingInDocument](docs/JsonApiOrganizationSettingInDocument.md)
 - [JsonApiOrganizationSettingOut](docs/JsonApiOrganizationSettingOut.md)
 - [JsonApiOrganizationSettingOutDocument](docs/JsonApiOrganizationSettingOutDocument.md)
 - [JsonApiOrganizationSettingOutList](docs/JsonApiOrganizationSettingOutList.md)
 - [JsonApiOrganizationSettingOutWithLinks](docs/JsonApiOrganizationSettingOutWithLinks.md)
 - [JsonApiOrganizationSettingPatch](docs/JsonApiOrganizationSettingPatch.md)
 - [JsonApiOrganizationSettingPatchDocument](docs/JsonApiOrganizationSettingPatchDocument.md)
 - [JsonApiThemeIn](docs/JsonApiThemeIn.md)
 - [JsonApiThemeInDocument](docs/JsonApiThemeInDocument.md)
 - [JsonApiThemeOut](docs/JsonApiThemeOut.md)
 - [JsonApiThemeOutDocument](docs/JsonApiThemeOutDocument.md)
 - [JsonApiThemeOutList](docs/JsonApiThemeOutList.md)
 - [JsonApiThemeOutWithLinks](docs/JsonApiThemeOutWithLinks.md)
 - [JsonApiThemePatch](docs/JsonApiThemePatch.md)
 - [JsonApiThemePatchDocument](docs/JsonApiThemePatchDocument.md)
 - [JsonApiUserDataFilterIn](docs/JsonApiUserDataFilterIn.md)
 - [JsonApiUserDataFilterInAttributes](docs/JsonApiUserDataFilterInAttributes.md)
 - [JsonApiUserDataFilterInDocument](docs/JsonApiUserDataFilterInDocument.md)
 - [JsonApiUserDataFilterInRelationships](docs/JsonApiUserDataFilterInRelationships.md)
 - [JsonApiUserDataFilterOut](docs/JsonApiUserDataFilterOut.md)
 - [JsonApiUserDataFilterOutDocument](docs/JsonApiUserDataFilterOutDocument.md)
 - [JsonApiUserDataFilterOutIncludes](docs/JsonApiUserDataFilterOutIncludes.md)
 - [JsonApiUserDataFilterOutList](docs/JsonApiUserDataFilterOutList.md)
 - [JsonApiUserDataFilterOutRelationships](docs/JsonApiUserDataFilterOutRelationships.md)
 - [JsonApiUserDataFilterOutWithLinks](docs/JsonApiUserDataFilterOutWithLinks.md)
 - [JsonApiUserDataFilterPatch](docs/JsonApiUserDataFilterPatch.md)
 - [JsonApiUserDataFilterPatchAttributes](docs/JsonApiUserDataFilterPatchAttributes.md)
 - [JsonApiUserDataFilterPatchDocument](docs/JsonApiUserDataFilterPatchDocument.md)
 - [JsonApiUserDataFilterPostOptionalId](docs/JsonApiUserDataFilterPostOptionalId.md)
 - [JsonApiUserDataFilterPostOptionalIdDocument](docs/JsonApiUserDataFilterPostOptionalIdDocument.md)
 - [JsonApiUserGroupIn](docs/JsonApiUserGroupIn.md)
 - [JsonApiUserGroupInAttributes](docs/JsonApiUserGroupInAttributes.md)
 - [JsonApiUserGroupInDocument](docs/JsonApiUserGroupInDocument.md)
 - [JsonApiUserGroupInRelationships](docs/JsonApiUserGroupInRelationships.md)
 - [JsonApiUserGroupInRelationshipsParents](docs/JsonApiUserGroupInRelationshipsParents.md)
 - [JsonApiUserGroupLinkage](docs/JsonApiUserGroupLinkage.md)
 - [JsonApiUserGroupOut](docs/JsonApiUserGroupOut.md)
 - [JsonApiUserGroupOutDocument](docs/JsonApiUserGroupOutDocument.md)
 - [JsonApiUserGroupOutList](docs/JsonApiUserGroupOutList.md)
 - [JsonApiUserGroupOutWithLinks](docs/JsonApiUserGroupOutWithLinks.md)
 - [JsonApiUserGroupPatch](docs/JsonApiUserGroupPatch.md)
 - [JsonApiUserGroupPatchDocument](docs/JsonApiUserGroupPatchDocument.md)
 - [JsonApiUserGroupToManyLinkage](docs/JsonApiUserGroupToManyLinkage.md)
 - [JsonApiUserGroupToOneLinkage](docs/JsonApiUserGroupToOneLinkage.md)
 - [JsonApiUserIdentifierLinkage](docs/JsonApiUserIdentifierLinkage.md)
 - [JsonApiUserIdentifierOut](docs/JsonApiUserIdentifierOut.md)
 - [JsonApiUserIdentifierOutAttributes](docs/JsonApiUserIdentifierOutAttributes.md)
 - [JsonApiUserIdentifierOutDocument](docs/JsonApiUserIdentifierOutDocument.md)
 - [JsonApiUserIdentifierOutList](docs/JsonApiUserIdentifierOutList.md)
 - [JsonApiUserIdentifierOutWithLinks](docs/JsonApiUserIdentifierOutWithLinks.md)
 - [JsonApiUserIdentifierToOneLinkage](docs/JsonApiUserIdentifierToOneLinkage.md)
 - [JsonApiUserIn](docs/JsonApiUserIn.md)
 - [JsonApiUserInAttributes](docs/JsonApiUserInAttributes.md)
 - [JsonApiUserInDocument](docs/JsonApiUserInDocument.md)
 - [JsonApiUserInRelationships](docs/JsonApiUserInRelationships.md)
 - [JsonApiUserLinkage](docs/JsonApiUserLinkage.md)
 - [JsonApiUserOut](docs/JsonApiUserOut.md)
 - [JsonApiUserOutDocument](docs/JsonApiUserOutDocument.md)
 - [JsonApiUserOutList](docs/JsonApiUserOutList.md)
 - [JsonApiUserOutWithLinks](docs/JsonApiUserOutWithLinks.md)
 - [JsonApiUserPatch](docs/JsonApiUserPatch.md)
 - [JsonApiUserPatchDocument](docs/JsonApiUserPatchDocument.md)
 - [JsonApiUserSettingIn](docs/JsonApiUserSettingIn.md)
 - [JsonApiUserSettingInDocument](docs/JsonApiUserSettingInDocument.md)
 - [JsonApiUserSettingOut](docs/JsonApiUserSettingOut.md)
 - [JsonApiUserSettingOutDocument](docs/JsonApiUserSettingOutDocument.md)
 - [JsonApiUserSettingOutList](docs/JsonApiUserSettingOutList.md)
 - [JsonApiUserSettingOutWithLinks](docs/JsonApiUserSettingOutWithLinks.md)
 - [JsonApiUserToOneLinkage](docs/JsonApiUserToOneLinkage.md)
 - [JsonApiVisualizationObjectIn](docs/JsonApiVisualizationObjectIn.md)
 - [JsonApiVisualizationObjectInDocument](docs/JsonApiVisualizationObjectInDocument.md)
 - [JsonApiVisualizationObjectLinkage](docs/JsonApiVisualizationObjectLinkage.md)
 - [JsonApiVisualizationObjectOut](docs/JsonApiVisualizationObjectOut.md)
 - [JsonApiVisualizationObjectOutDocument](docs/JsonApiVisualizationObjectOutDocument.md)
 - [JsonApiVisualizationObjectOutList](docs/JsonApiVisualizationObjectOutList.md)
 - [JsonApiVisualizationObjectOutWithLinks](docs/JsonApiVisualizationObjectOutWithLinks.md)
 - [JsonApiVisualizationObjectPatch](docs/JsonApiVisualizationObjectPatch.md)
 - [JsonApiVisualizationObjectPatchDocument](docs/JsonApiVisualizationObjectPatchDocument.md)
 - [JsonApiVisualizationObjectPostOptionalId](docs/JsonApiVisualizationObjectPostOptionalId.md)
 - [JsonApiVisualizationObjectPostOptionalIdDocument](docs/JsonApiVisualizationObjectPostOptionalIdDocument.md)
 - [JsonApiVisualizationObjectToManyLinkage](docs/JsonApiVisualizationObjectToManyLinkage.md)
 - [JsonApiVisualizationObjectToOneLinkage](docs/JsonApiVisualizationObjectToOneLinkage.md)
 - [JsonApiWidgetAlertIn](docs/JsonApiWidgetAlertIn.md)
 - [JsonApiWidgetAlertInAttributes](docs/JsonApiWidgetAlertInAttributes.md)
 - [JsonApiWidgetAlertInDocument](docs/JsonApiWidgetAlertInDocument.md)
 - [JsonApiWidgetAlertInRelationships](docs/JsonApiWidgetAlertInRelationships.md)
 - [JsonApiWidgetAlertInRelationshipsAnalyticalDashboard](docs/JsonApiWidgetAlertInRelationshipsAnalyticalDashboard.md)
 - [JsonApiWidgetAlertInRelationshipsFilterContext](docs/JsonApiWidgetAlertInRelationshipsFilterContext.md)
 - [JsonApiWidgetAlertInRelationshipsVisualizationObject](docs/JsonApiWidgetAlertInRelationshipsVisualizationObject.md)
 - [JsonApiWidgetAlertOut](docs/JsonApiWidgetAlertOut.md)
 - [JsonApiWidgetAlertOutAttributes](docs/JsonApiWidgetAlertOutAttributes.md)
 - [JsonApiWidgetAlertOutDocument](docs/JsonApiWidgetAlertOutDocument.md)
 - [JsonApiWidgetAlertOutIncludes](docs/JsonApiWidgetAlertOutIncludes.md)
 - [JsonApiWidgetAlertOutList](docs/JsonApiWidgetAlertOutList.md)
 - [JsonApiWidgetAlertOutRelationships](docs/JsonApiWidgetAlertOutRelationships.md)
 - [JsonApiWidgetAlertOutWithLinks](docs/JsonApiWidgetAlertOutWithLinks.md)
 - [JsonApiWidgetAlertPatch](docs/JsonApiWidgetAlertPatch.md)
 - [JsonApiWidgetAlertPatchDocument](docs/JsonApiWidgetAlertPatchDocument.md)
 - [JsonApiWorkspaceDataFilterIn](docs/JsonApiWorkspaceDataFilterIn.md)
 - [JsonApiWorkspaceDataFilterInAttributes](docs/JsonApiWorkspaceDataFilterInAttributes.md)
 - [JsonApiWorkspaceDataFilterInDocument](docs/JsonApiWorkspaceDataFilterInDocument.md)
 - [JsonApiWorkspaceDataFilterInRelationships](docs/JsonApiWorkspaceDataFilterInRelationships.md)
 - [JsonApiWorkspaceDataFilterInRelationshipsFilterSettings](docs/JsonApiWorkspaceDataFilterInRelationshipsFilterSettings.md)
 - [JsonApiWorkspaceDataFilterLinkage](docs/JsonApiWorkspaceDataFilterLinkage.md)
 - [JsonApiWorkspaceDataFilterOut](docs/JsonApiWorkspaceDataFilterOut.md)
 - [JsonApiWorkspaceDataFilterOutDocument](docs/JsonApiWorkspaceDataFilterOutDocument.md)
 - [JsonApiWorkspaceDataFilterOutList](docs/JsonApiWorkspaceDataFilterOutList.md)
 - [JsonApiWorkspaceDataFilterOutWithLinks](docs/JsonApiWorkspaceDataFilterOutWithLinks.md)
 - [JsonApiWorkspaceDataFilterPatch](docs/JsonApiWorkspaceDataFilterPatch.md)
 - [JsonApiWorkspaceDataFilterPatchDocument](docs/JsonApiWorkspaceDataFilterPatchDocument.md)
 - [JsonApiWorkspaceDataFilterSettingIn](docs/JsonApiWorkspaceDataFilterSettingIn.md)
 - [JsonApiWorkspaceDataFilterSettingInAttributes](docs/JsonApiWorkspaceDataFilterSettingInAttributes.md)
 - [JsonApiWorkspaceDataFilterSettingInDocument](docs/JsonApiWorkspaceDataFilterSettingInDocument.md)
 - [JsonApiWorkspaceDataFilterSettingInRelationships](docs/JsonApiWorkspaceDataFilterSettingInRelationships.md)
 - [JsonApiWorkspaceDataFilterSettingInRelationshipsWorkspaceDataFilter](docs/JsonApiWorkspaceDataFilterSettingInRelationshipsWorkspaceDataFilter.md)
 - [JsonApiWorkspaceDataFilterSettingLinkage](docs/JsonApiWorkspaceDataFilterSettingLinkage.md)
 - [JsonApiWorkspaceDataFilterSettingOut](docs/JsonApiWorkspaceDataFilterSettingOut.md)
 - [JsonApiWorkspaceDataFilterSettingOutDocument](docs/JsonApiWorkspaceDataFilterSettingOutDocument.md)
 - [JsonApiWorkspaceDataFilterSettingOutList](docs/JsonApiWorkspaceDataFilterSettingOutList.md)
 - [JsonApiWorkspaceDataFilterSettingOutWithLinks](docs/JsonApiWorkspaceDataFilterSettingOutWithLinks.md)
 - [JsonApiWorkspaceDataFilterSettingPatch](docs/JsonApiWorkspaceDataFilterSettingPatch.md)
 - [JsonApiWorkspaceDataFilterSettingPatchDocument](docs/JsonApiWorkspaceDataFilterSettingPatchDocument.md)
 - [JsonApiWorkspaceDataFilterSettingToManyLinkage](docs/JsonApiWorkspaceDataFilterSettingToManyLinkage.md)
 - [JsonApiWorkspaceDataFilterToManyLinkage](docs/JsonApiWorkspaceDataFilterToManyLinkage.md)
 - [JsonApiWorkspaceDataFilterToOneLinkage](docs/JsonApiWorkspaceDataFilterToOneLinkage.md)
 - [JsonApiWorkspaceIn](docs/JsonApiWorkspaceIn.md)
 - [JsonApiWorkspaceInAttributes](docs/JsonApiWorkspaceInAttributes.md)
 - [JsonApiWorkspaceInDocument](docs/JsonApiWorkspaceInDocument.md)
 - [JsonApiWorkspaceInRelationships](docs/JsonApiWorkspaceInRelationships.md)
 - [JsonApiWorkspaceInRelationshipsParent](docs/JsonApiWorkspaceInRelationshipsParent.md)
 - [JsonApiWorkspaceLinkage](docs/JsonApiWorkspaceLinkage.md)
 - [JsonApiWorkspaceOut](docs/JsonApiWorkspaceOut.md)
 - [JsonApiWorkspaceOutDocument](docs/JsonApiWorkspaceOutDocument.md)
 - [JsonApiWorkspaceOutList](docs/JsonApiWorkspaceOutList.md)
 - [JsonApiWorkspaceOutMeta](docs/JsonApiWorkspaceOutMeta.md)
 - [JsonApiWorkspaceOutMetaConfig](docs/JsonApiWorkspaceOutMetaConfig.md)
 - [JsonApiWorkspaceOutMetaDataModel](docs/JsonApiWorkspaceOutMetaDataModel.md)
 - [JsonApiWorkspaceOutMetaHierarchy](docs/JsonApiWorkspaceOutMetaHierarchy.md)
 - [JsonApiWorkspaceOutWithLinks](docs/JsonApiWorkspaceOutWithLinks.md)
 - [JsonApiWorkspacePatch](docs/JsonApiWorkspacePatch.md)
 - [JsonApiWorkspacePatchDocument](docs/JsonApiWorkspacePatchDocument.md)
 - [JsonApiWorkspaceSettingIn](docs/JsonApiWorkspaceSettingIn.md)
 - [JsonApiWorkspaceSettingInDocument](docs/JsonApiWorkspaceSettingInDocument.md)
 - [JsonApiWorkspaceSettingOut](docs/JsonApiWorkspaceSettingOut.md)
 - [JsonApiWorkspaceSettingOutDocument](docs/JsonApiWorkspaceSettingOutDocument.md)
 - [JsonApiWorkspaceSettingOutList](docs/JsonApiWorkspaceSettingOutList.md)
 - [JsonApiWorkspaceSettingOutWithLinks](docs/JsonApiWorkspaceSettingOutWithLinks.md)
 - [JsonApiWorkspaceSettingPatch](docs/JsonApiWorkspaceSettingPatch.md)
 - [JsonApiWorkspaceSettingPatchDocument](docs/JsonApiWorkspaceSettingPatchDocument.md)
 - [JsonApiWorkspaceSettingPostOptionalId](docs/JsonApiWorkspaceSettingPostOptionalId.md)
 - [JsonApiWorkspaceSettingPostOptionalIdDocument](docs/JsonApiWorkspaceSettingPostOptionalIdDocument.md)
 - [JsonApiWorkspaceToOneLinkage](docs/JsonApiWorkspaceToOneLinkage.md)
 - [JsonApiZapierSubscriptionIn](docs/JsonApiZapierSubscriptionIn.md)
 - [JsonApiZapierSubscriptionInAttributes](docs/JsonApiZapierSubscriptionInAttributes.md)
 - [JsonApiZapierSubscriptionInDocument](docs/JsonApiZapierSubscriptionInDocument.md)
 - [JsonApiZapierSubscriptionOut](docs/JsonApiZapierSubscriptionOut.md)
 - [JsonApiZapierSubscriptionOutDocument](docs/JsonApiZapierSubscriptionOutDocument.md)
 - [JsonApiZapierSubscriptionOutList](docs/JsonApiZapierSubscriptionOutList.md)
 - [JsonApiZapierSubscriptionOutWithLinks](docs/JsonApiZapierSubscriptionOutWithLinks.md)
 - [JsonApiZapierSubscriptionPatch](docs/JsonApiZapierSubscriptionPatch.md)
 - [JsonApiZapierSubscriptionPatchAttributes](docs/JsonApiZapierSubscriptionPatchAttributes.md)
 - [JsonApiZapierSubscriptionPatchDocument](docs/JsonApiZapierSubscriptionPatchDocument.md)
 - [KeyDriversDimension](docs/KeyDriversDimension.md)
 - [KeyDriversRequest](docs/KeyDriversRequest.md)
 - [KeyDriversResponse](docs/KeyDriversResponse.md)
 - [KeyDriversResult](docs/KeyDriversResult.md)
 - [LabelIdentifier](docs/LabelIdentifier.md)
 - [ListLinks](docs/ListLinks.md)
 - [ListLinksAllOf](docs/ListLinksAllOf.md)
 - [LocaleRequest](docs/LocaleRequest.md)
 - [MachineLearningResponse](docs/MachineLearningResponse.md)
 - [MachineLearningResult](docs/MachineLearningResult.md)
 - [ManageDashboardPermissionsRequestInner](docs/ManageDashboardPermissionsRequestInner.md)
 - [MarkNotificationAsReadRequest](docs/MarkNotificationAsReadRequest.md)
 - [MeasureDefinition](docs/MeasureDefinition.md)
 - [MeasureExecutionResultHeader](docs/MeasureExecutionResultHeader.md)
 - [MeasureGroupHeaders](docs/MeasureGroupHeaders.md)
 - [MeasureHeaderOut](docs/MeasureHeaderOut.md)
 - [MeasureItem](docs/MeasureItem.md)
 - [MeasureResultHeader](docs/MeasureResultHeader.md)
 - [MeasureValueFilter](docs/MeasureValueFilter.md)
 - [NegativeAttributeFilter](docs/NegativeAttributeFilter.md)
 - [NegativeAttributeFilterNegativeAttributeFilter](docs/NegativeAttributeFilterNegativeAttributeFilter.md)
 - [Note](docs/Note.md)
 - [Notes](docs/Notes.md)
 - [ObjectLinks](docs/ObjectLinks.md)
 - [ObjectLinksContainer](docs/ObjectLinksContainer.md)
 - [OrganizationPermissionAssignment](docs/OrganizationPermissionAssignment.md)
 - [Paging](docs/Paging.md)
 - [Parameter](docs/Parameter.md)
 - [PdfExportRequest](docs/PdfExportRequest.md)
 - [PdmLdmRequest](docs/PdmLdmRequest.md)
 - [PdmSql](docs/PdmSql.md)
 - [PermissionsForAssignee](docs/PermissionsForAssignee.md)
 - [PermissionsForAssigneeAllOf](docs/PermissionsForAssigneeAllOf.md)
 - [PermissionsForAssigneeRule](docs/PermissionsForAssigneeRule.md)
 - [PlatformUsage](docs/PlatformUsage.md)
 - [PlatformUsageRequest](docs/PlatformUsageRequest.md)
 - [PopDataset](docs/PopDataset.md)
 - [PopDatasetMeasureDefinition](docs/PopDatasetMeasureDefinition.md)
 - [PopDatasetMeasureDefinitionPreviousPeriodMeasure](docs/PopDatasetMeasureDefinitionPreviousPeriodMeasure.md)
 - [PopDate](docs/PopDate.md)
 - [PopDateMeasureDefinition](docs/PopDateMeasureDefinition.md)
 - [PopDateMeasureDefinitionOverPeriodMeasure](docs/PopDateMeasureDefinitionOverPeriodMeasure.md)
 - [PopMeasureDefinition](docs/PopMeasureDefinition.md)
 - [PositiveAttributeFilter](docs/PositiveAttributeFilter.md)
 - [PositiveAttributeFilterPositiveAttributeFilter](docs/PositiveAttributeFilterPositiveAttributeFilter.md)
 - [RangeMeasureValueFilter](docs/RangeMeasureValueFilter.md)
 - [RangeMeasureValueFilterRangeMeasureValueFilter](docs/RangeMeasureValueFilterRangeMeasureValueFilter.md)
 - [RankingFilter](docs/RankingFilter.md)
 - [RankingFilterRankingFilter](docs/RankingFilterRankingFilter.md)
 - [RecentAnalyticalObject](docs/RecentAnalyticalObject.md)
 - [Recommendation](docs/Recommendation.md)
 - [ReferenceIdentifier](docs/ReferenceIdentifier.md)
 - [ReferenceSourceColumn](docs/ReferenceSourceColumn.md)
 - [RelativeDateFilter](docs/RelativeDateFilter.md)
 - [RelativeDateFilterRelativeDateFilter](docs/RelativeDateFilterRelativeDateFilter.md)
 - [ResolveSettingsRequest](docs/ResolveSettingsRequest.md)
 - [ResolvedSetting](docs/ResolvedSetting.md)
 - [RestApiIdentifier](docs/RestApiIdentifier.md)
 - [ResultCacheMetadata](docs/ResultCacheMetadata.md)
 - [ResultDimension](docs/ResultDimension.md)
 - [ResultDimensionHeader](docs/ResultDimensionHeader.md)
 - [ResultSpec](docs/ResultSpec.md)
 - [RsaSpecification](docs/RsaSpecification.md)
 - [RulePermission](docs/RulePermission.md)
 - [ScanRequest](docs/ScanRequest.md)
 - [ScanResultPdm](docs/ScanResultPdm.md)
 - [ScanSqlRequest](docs/ScanSqlRequest.md)
 - [ScanSqlResponse](docs/ScanSqlResponse.md)
 - [Settings](docs/Settings.md)
 - [SimpleMeasureDefinition](docs/SimpleMeasureDefinition.md)
 - [SimpleMeasureDefinitionMeasure](docs/SimpleMeasureDefinitionMeasure.md)
 - [Skeleton](docs/Skeleton.md)
 - [SortKey](docs/SortKey.md)
 - [SortKeyAttribute](docs/SortKeyAttribute.md)
 - [SortKeyAttributeAttribute](docs/SortKeyAttributeAttribute.md)
 - [SortKeyTotal](docs/SortKeyTotal.md)
 - [SortKeyTotalTotal](docs/SortKeyTotalTotal.md)
 - [SortKeyValue](docs/SortKeyValue.md)
 - [SortKeyValueValue](docs/SortKeyValueValue.md)
 - [SqlColumn](docs/SqlColumn.md)
 - [SqlQuery](docs/SqlQuery.md)
 - [SqlQueryAllOf](docs/SqlQueryAllOf.md)
 - [Table](docs/Table.md)
 - [TableAllOf](docs/TableAllOf.md)
 - [TableWarning](docs/TableWarning.md)
 - [TabularExportRequest](docs/TabularExportRequest.md)
 - [TestDefinitionRequest](docs/TestDefinitionRequest.md)
 - [TestQueryDuration](docs/TestQueryDuration.md)
 - [TestRequest](docs/TestRequest.md)
 - [TestResponse](docs/TestResponse.md)
 - [Total](docs/Total.md)
 - [TotalDimension](docs/TotalDimension.md)
 - [TotalExecutionResultHeader](docs/TotalExecutionResultHeader.md)
 - [TotalResultHeader](docs/TotalResultHeader.md)
 - [UserAssignee](docs/UserAssignee.md)
 - [UserGroupAssignee](docs/UserGroupAssignee.md)
 - [UserGroupPermission](docs/UserGroupPermission.md)
 - [UserManagementUserGroupMember](docs/UserManagementUserGroupMember.md)
 - [UserManagementUserGroupMembers](docs/UserManagementUserGroupMembers.md)
 - [UserManagementUserGroups](docs/UserManagementUserGroups.md)
 - [UserManagementUserGroupsItem](docs/UserManagementUserGroupsItem.md)
 - [UserManagementUsers](docs/UserManagementUsers.md)
 - [UserManagementUsersItem](docs/UserManagementUsersItem.md)
 - [UserManagementWorkspacePermissionAssignment](docs/UserManagementWorkspacePermissionAssignment.md)
 - [UserManagementWorkspacePermissionAssignments](docs/UserManagementWorkspacePermissionAssignments.md)
 - [UserPermission](docs/UserPermission.md)
 - [ValidateByItem](docs/ValidateByItem.md)
 - [WidgetAlertUserNotification](docs/WidgetAlertUserNotification.md)
 - [WorkspaceIdentifier](docs/WorkspaceIdentifier.md)
 - [WorkspacePermissionAssignment](docs/WorkspacePermissionAssignment.md)
 - [Xliff](docs/Xliff.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

support@gooddata.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in gooddata_api_client.apis and gooddata_api_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from gooddata_api_client.api.default_api import DefaultApi`
- `from gooddata_api_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import gooddata_api_client
from gooddata_api_client.apis import *
from gooddata_api_client.models import *
```

