import pytest

from modgeosys.graph.prim import prim
from modgeosys.graph.types import Edge


def test_prim_finds_minimum_spanning_tree(valid_graph1):
    result = prim(graph=valid_graph1, start_node_index=0)

    assert len(result) == 4
    assert result == {Edge(weight=2.0, node_indices=frozenset({0, 1})),
                      Edge(weight=1.0, node_indices=frozenset({0, 2})),
                      Edge(weight=1.0, node_indices=frozenset({2, 3})),
                      Edge(weight=1.0, node_indices=frozenset({3, 4}))}
    assert sum(edge.weight for edge in result) == 5.0


def test_prim_finds_minimum_spanning_tree_from_edge_definitions(valid_graph_from_edge_definitions):
    result = prim(graph=valid_graph_from_edge_definitions, start_node_index=0)

    assert len(result) == 4
    assert result == {Edge(weight=1.0, node_indices=frozenset({0, 2}), properties={'cost_per_unit': 1}),
                      Edge(weight=2.0, node_indices=frozenset({3, 4}), properties={'cost_per_unit': 1}),
                      Edge(weight=2.0, node_indices=frozenset({2, 3}), properties={'cost_per_unit': 1}),
                      Edge(weight=4.0, node_indices=frozenset({0, 1}), properties={'cost_per_unit': 2})}
    assert sum(edge.weight for edge in result) == 9.0


def test_prim_finds_minimum_spanning_tree_larger(valid_graph_larger):
    result = prim(graph=valid_graph_larger, start_node_index=0)

    assert len(result) == 251
    assert result == {Edge(weight=0.218304277932577, node_indices=frozenset({112, 113})),
                      Edge(weight=0.21830427793264628, node_indices=frozenset({194, 195})),
                      Edge(weight=0.21830427793264628, node_indices=frozenset({200, 199})),
                      Edge(weight=0.21830427793264628, node_indices=frozenset({37, 38})),
                      Edge(weight=0.21830427793264628, node_indices=frozenset({145, 146})),
                      Edge(weight=0.2183042779326562, node_indices=frozenset({91, 92})),
                      Edge(weight=0.2183042779326562, node_indices=frozenset({86, 87})),
                      Edge(weight=0.21830427793270832, node_indices=frozenset({73, 74})),
                      Edge(weight=0.21830427793270832, node_indices=frozenset({128, 127})),
                      Edge(weight=0.21830427793271542, node_indices=frozenset({166, 167})),
                      Edge(weight=0.21830427793271542, node_indices=frozenset({220, 221})),
                      Edge(weight=0.21830427793278184, node_indices=frozenset({224, 225})),
                      Edge(weight=0.21830427793278184, node_indices=frozenset({170, 171})),
                      Edge(weight=0.21830427793286347, node_indices=frozenset({76, 77})),
                      Edge(weight=0.21830427793286347, node_indices=frozenset({104, 103})),
                      Edge(weight=0.21830427793286347, node_indices=frozenset({236, 237})),
                      Edge(weight=0.21830427793286347, node_indices=frozenset({157, 158})),
                      Edge(weight=0.21830427793286347, node_indices=frozenset({211, 212})),
                      Edge(weight=0.21830427793286347, node_indices=frozenset({182, 183})),
                      Edge(weight=0.21830427793286347, node_indices=frozenset({49, 50})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({154, 155})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({208, 209})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({240, 239})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({98, 99})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({241, 242})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({46, 47})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({131, 132})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({185, 186})),
                      Edge(weight=0.21830427793288512, node_indices=frozenset({80, 79})),
                      Edge(weight=0.21830427793289012, node_indices=frozenset({124, 125})),
                      Edge(weight=0.21830427793289012, node_indices=frozenset({107, 108})),
                      Edge(weight=0.21830427793289012, node_indices=frozenset({216, 215})),
                      Edge(weight=0.21830427793289012, node_indices=frozenset({178, 179})),
                      Edge(weight=0.21830427793289012, node_indices=frozenset({232, 233})),
                      Edge(weight=0.21830427793289012, node_indices=frozenset({161, 162})),
                      Edge(weight=0.21830427793289012, node_indices=frozenset({70, 71})),
                      Edge(weight=0.21830427793289012, node_indices=frozenset({53, 54})),
                      Edge(weight=0.21830427793295348, node_indices=frozenset({100, 101})),
                      Edge(weight=0.2183042779329635, node_indices=frozenset({64, 65})),
                      Edge(weight=0.2183042779329635, node_indices=frozenset({62, 63})),
                      Edge(weight=0.2183042779329635, node_indices=frozenset({115, 116})),
                      Edge(weight=0.21830427793298862, node_indices=frozenset({40, 41})),
                      Edge(weight=0.21830427793298862, node_indices=frozenset({94, 95})),
                      Edge(weight=0.21830427793298862, node_indices=frozenset({137, 138})),
                      Edge(weight=0.21830427793298862, node_indices=frozenset({192, 191})),
                      Edge(weight=0.21830427793298862, node_indices=frozenset({248, 247})),
                      Edge(weight=0.21830427793298862, node_indices=frozenset({139, 140})),
                      Edge(weight=0.21830427793298862, node_indices=frozenset({148, 149})),
                      Edge(weight=0.21830427793298862, node_indices=frozenset({202, 203})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({67, 68})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({65, 66})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({110, 111})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({218, 219})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({229, 230})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({56, 57})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({121, 122})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({176, 175})),
                      Edge(weight=0.2183042779330762, node_indices=frozenset({164, 165})),
                      Edge(weight=0.2183042779331006, node_indices=frozenset({140, 141})),
                      Edge(weight=0.2183042779331006, node_indices=frozenset({196, 197})),
                      Edge(weight=0.2183042779331006, node_indices=frozenset({197, 198})),
                      Edge(weight=0.2183042779331006, node_indices=frozenset({142, 143})),
                      Edge(weight=0.2183042779331006, node_indices=frozenset({250, 251})),
                      Edge(weight=0.2183042779331006, node_indices=frozenset({248, 249})),
                      Edge(weight=0.2183042779331006, node_indices=frozenset({251, 36})),
                      Edge(weight=0.2183042779331006, node_indices=frozenset({144, 143})),
                      Edge(weight=0.2183042779331105, node_indices=frozenset({89, 90})),
                      Edge(weight=0.2183042779331105, node_indices=frozenset({88, 89})),
                      Edge(weight=0.2183042779331117, node_indices=frozenset({158, 159})),
                      Edge(weight=0.2183042779331117, node_indices=frozenset({235, 236})),
                      Edge(weight=0.2183042779331117, node_indices=frozenset({50, 51})),
                      Edge(weight=0.2183042779331117, node_indices=frozenset({212, 213})),
                      Edge(weight=0.2183042779331117, node_indices=frozenset({181, 182})),
                      Edge(weight=0.21830427793311713, node_indices=frozenset({169, 170})),
                      Edge(weight=0.21830427793311713, node_indices=frozenset({172, 173})),
                      Edge(weight=0.21830427793311713, node_indices=frozenset({226, 227})),
                      Edge(weight=0.21830427793311713, node_indices=frozenset({118, 119})),
                      Edge(weight=0.21830427793311713, node_indices=frozenset({59, 60})),
                      Edge(weight=0.21830427793311713, node_indices=frozenset({224, 223})),
                      Edge(weight=0.21830427793320395, node_indices=frozenset({152, 151})),
                      Edge(weight=0.21830427793320395, node_indices=frozenset({188, 189})),
                      Edge(weight=0.21830427793320395, node_indices=frozenset({80, 81})),
                      Edge(weight=0.21830427793320395, node_indices=frozenset({242, 243})),
                      Edge(weight=0.21830427793320395, node_indices=frozenset({205, 206})),
                      Edge(weight=0.21830427793320395, node_indices=frozenset({43, 44})),
                      Edge(weight=0.21830427793320395, node_indices=frozenset({134, 135})),
                      Edge(weight=0.2183042779332167, node_indices=frozenset({104, 105})),
                      Edge(weight=0.21830427793325316, node_indices=frozenset({82, 83})),
                      Edge(weight=0.21830427793325316, node_indices=frozenset({96, 95})),
                      Edge(weight=0.2183042779332566, node_indices=frozenset({120, 119})),
                      Edge(weight=0.2183042779332566, node_indices=frozenset({58, 59})),
                      Edge(weight=0.21830427793327364, node_indices=frozenset({56, 55})),
                      Edge(weight=0.21830427793327364, node_indices=frozenset({230, 231})),
                      Edge(weight=0.21830427793327364, node_indices=frozenset({176, 177})),
                      Edge(weight=0.21830427793327364, node_indices=frozenset({217, 218})),
                      Edge(weight=0.21830427793327364, node_indices=frozenset({163, 164})),
                      Edge(weight=0.21830427793327364, node_indices=frozenset({122, 123})),
                      Edge(weight=0.21830427793327364, node_indices=frozenset({68, 69})),
                      Edge(weight=0.21830427793327364, node_indices=frozenset({109, 110})),
                      Edge(weight=0.2183042779332836, node_indices=frozenset({128, 129})),
                      Edge(weight=0.2183042779332836, node_indices=frozenset({101, 102})),
                      Edge(weight=0.21830427793328475, node_indices=frozenset({61, 62})),
                      Edge(weight=0.21830427793328475, node_indices=frozenset({116, 117})),
                      Edge(weight=0.21830427793330237, node_indices=frozenset({149, 150})),
                      Edge(weight=0.21830427793330237, node_indices=frozenset({136, 137})),
                      Edge(weight=0.21830427793330237, node_indices=frozenset({244, 245})),
                      Edge(weight=0.21830427793330237, node_indices=frozenset({41, 42})),
                      Edge(weight=0.21830427793330237, node_indices=frozenset({203, 204})),
                      Edge(weight=0.21830427793330237, node_indices=frozenset({190, 191})),
                      Edge(weight=0.2183042779333188, node_indices=frozenset({133, 134})),
                      Edge(weight=0.2183042779333188, node_indices=frozenset({152, 153})),
                      Edge(weight=0.2183042779333188, node_indices=frozenset({187, 188})),
                      Edge(weight=0.2183042779333188, node_indices=frozenset({44, 45})),
                      Edge(weight=0.2183042779333188, node_indices=frozenset({206, 207})),
                      Edge(weight=0.2183042779333706, node_indices=frozenset({74, 75})),
                      Edge(weight=0.2183042779333872, node_indices=frozenset({77, 78})),
                      Edge(weight=0.21830427793343699, node_indices=frozenset({227, 228})),
                      Edge(weight=0.21830427793343699, node_indices=frozenset({173, 174})),
                      Edge(weight=0.21830427793343948, node_indices=frozenset({146, 147})),
                      Edge(weight=0.21830427793343948, node_indices=frozenset({92, 93})),
                      Edge(weight=0.21830427793343948, node_indices=frozenset({83, 84})),
                      Edge(weight=0.21830427793343948, node_indices=frozenset({85, 86})),
                      Edge(weight=0.21830427793343948, node_indices=frozenset({245, 246})),
                      Edge(weight=0.21830427793343948, node_indices=frozenset({38, 39})),
                      Edge(weight=0.21830427793343948, node_indices=frozenset({193, 194})),
                      Edge(weight=0.21830427793343948, node_indices=frozenset({200, 201})),
                      Edge(weight=0.2183042779334524, node_indices=frozenset({113, 114})),
                      Edge(weight=0.2183042779334524, node_indices=frozenset({168, 167})),
                      Edge(weight=0.2183042779334524, node_indices=frozenset({221, 222})),
                      Edge(weight=0.2183042779334576, node_indices=frozenset({130, 131})),
                      Edge(weight=0.2183042779334576, node_indices=frozenset({48, 47})),
                      Edge(weight=0.2183042779334576, node_indices=frozenset({209, 210})),
                      Edge(weight=0.2183042779334576, node_indices=frozenset({155, 156})),
                      Edge(weight=0.2183042779334576, node_indices=frozenset({184, 185})),
                      Edge(weight=0.2183042779334576, node_indices=frozenset({238, 239})),
                      Edge(weight=0.21830427793351506, node_indices=frozenset({179, 180})),
                      Edge(weight=0.21830427793351506, node_indices=frozenset({214, 215})),
                      Edge(weight=0.21830427793351506, node_indices=frozenset({52, 53})),
                      Edge(weight=0.21830427793351506, node_indices=frozenset({160, 161})),
                      Edge(weight=0.21830427793351506, node_indices=frozenset({125, 126})),
                      Edge(weight=0.21830427793351506, node_indices=frozenset({72, 71})),
                      Edge(weight=0.21830427793351506, node_indices=frozenset({233, 234})),
                      Edge(weight=0.21830427793351506, node_indices=frozenset({106, 107})),
                      Edge(weight=0.2183042779336479, node_indices=frozenset({97, 98})),
                      Edge(weight=33.196548630617556, node_indices=frozenset({136, 135})),
                      Edge(weight=33.19654863061766, node_indices=frozenset({240, 241})),
                      Edge(weight=33.196548630617734, node_indices=frozenset({99, 100})),
                      Edge(weight=33.19654863061781, node_indices=frozenset({246, 247})),
                      Edge(weight=33.19654863061783, node_indices=frozenset({112, 111})),
                      Edge(weight=33.19654863061785, node_indices=frozenset({126, 127})),
                      Edge(weight=33.19654863061785, node_indices=frozenset({72, 73})),
                      Edge(weight=33.19654863061792, node_indices=frozenset({64, 63})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({88, 87})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({165, 166})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({195, 196})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({36, 37})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({198, 199})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({144, 145})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({57, 58})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({219, 220})),
                      Edge(weight=33.19654863061797, node_indices=frozenset({90, 91})),
                      Edge(weight=33.196548630618004, node_indices=frozenset({150, 151})),
                      Edge(weight=33.196548630618004, node_indices=frozenset({42, 43})),
                      Edge(weight=33.196548630618004, node_indices=frozenset({204, 205})),
                      Edge(weight=33.196548630618004, node_indices=frozenset({189, 190})),
                      Edge(weight=33.196548630618054, node_indices=frozenset({81, 82})),
                      Edge(weight=33.196548630618054, node_indices=frozenset({120, 121})),
                      Edge(weight=33.196548630618054, node_indices=frozenset({228, 229})),
                      Edge(weight=33.19654863061807, node_indices=frozenset({117, 118})),
                      Edge(weight=33.19654863061807, node_indices=frozenset({171, 172})),
                      Edge(weight=33.19654863061807, node_indices=frozenset({225, 226})),
                      Edge(weight=33.196548630618146, node_indices=frozenset({237, 238})),
                      Edge(weight=33.196548630618146, node_indices=frozenset({184, 183})),
                      Edge(weight=33.196548630618146, node_indices=frozenset({156, 157})),
                      Edge(weight=33.196548630618146, node_indices=frozenset({102, 103})),
                      Edge(weight=33.196548630618146, node_indices=frozenset({210, 211})),
                      Edge(weight=33.196548630618146, node_indices=frozenset({48, 49})),
                      Edge(weight=33.19654863061816, node_indices=frozenset({162, 163})),
                      Edge(weight=33.19654863061816, node_indices=frozenset({108, 109})),
                      Edge(weight=33.19654863061816, node_indices=frozenset({177, 178})),
                      Edge(weight=33.19654863061816, node_indices=frozenset({216, 217})),
                      Edge(weight=33.19654863061816, node_indices=frozenset({54, 55})),
                      Edge(weight=33.196548630618196, node_indices=frozenset({66, 67})),
                      Edge(weight=33.19654863061823, node_indices=frozenset({153, 154})),
                      Edge(weight=33.19654863061823, node_indices=frozenset({208, 207})),
                      Edge(weight=33.19654863061823, node_indices=frozenset({75, 76})),
                      Edge(weight=33.19654863061823, node_indices=frozenset({45, 46})),
                      Edge(weight=33.19654863061823, node_indices=frozenset({186, 187})),
                      Edge(weight=33.19654863061823, node_indices=frozenset({132, 133})),
                      Edge(weight=33.19654863061825, node_indices=frozenset({51, 52})),
                      Edge(weight=33.19654863061825, node_indices=frozenset({180, 181})),
                      Edge(weight=33.19654863061825, node_indices=frozenset({234, 235})),
                      Edge(weight=33.19654863061825, node_indices=frozenset({213, 214})),
                      Edge(weight=33.19654863061825, node_indices=frozenset({160, 159})),
                      Edge(weight=33.19654863061826, node_indices=frozenset({40, 39})),
                      Edge(weight=33.19654863061826, node_indices=frozenset({138, 139})),
                      Edge(weight=33.19654863061826, node_indices=frozenset({147, 148})),
                      Edge(weight=33.19654863061826, node_indices=frozenset({93, 94})),
                      Edge(weight=33.19654863061826, node_indices=frozenset({192, 193})),
                      Edge(weight=33.19654863061826, node_indices=frozenset({84, 85})),
                      Edge(weight=33.19654863061826, node_indices=frozenset({201, 202})),
                      Edge(weight=33.19654863061829, node_indices=frozenset({69, 70})),
                      Edge(weight=33.19654863061833, node_indices=frozenset({174, 175})),
                      Edge(weight=33.19654863061836, node_indices=frozenset({105, 106})),
                      Edge(weight=33.1965486306184, node_indices=frozenset({222, 223})),
                      Edge(weight=33.1965486306184, node_indices=frozenset({232, 231})),
                      Edge(weight=33.1965486306184, node_indices=frozenset({114, 115})),
                      Edge(weight=33.1965486306184, node_indices=frozenset({168, 169})),
                      Edge(weight=33.1965486306184, node_indices=frozenset({123, 124})),
                      Edge(weight=33.1965486306184, node_indices=frozenset({60, 61})),
                      Edge(weight=33.19654863061842, node_indices=frozenset({249, 250})),
                      Edge(weight=33.19654863061842, node_indices=frozenset({141, 142})),
                      Edge(weight=33.196548630618494, node_indices=frozenset({96, 97})),
                      Edge(weight=33.196548630618544, node_indices=frozenset({243, 244})),
                      Edge(weight=33.196548630618565, node_indices=frozenset({129, 130})),
                      Edge(weight=101.77374506529435, node_indices=frozenset({25, 30})),
                      Edge(weight=101.77374506529435, node_indices=frozenset({24, 31})),
                      Edge(weight=101.77374552358492, node_indices=frozenset({16, 23})),
                      Edge(weight=101.77374552358516, node_indices=frozenset({17, 22})),
                      Edge(weight=101.79769950915306, node_indices=frozenset({2, 7})),
                      Edge(weight=101.79769950915306, node_indices=frozenset({1, 4})),
                      Edge(weight=105.22962628070559, node_indices=frozenset({11, 14})),
                      Edge(weight=105.22962628070559, node_indices=frozenset({8, 13})),
                      Edge(weight=112.26752910001987, node_indices=frozenset({18, 27})),
                      Edge(weight=112.26752910001987, node_indices=frozenset({24, 17})),
                      Edge(weight=112.2675424511398, node_indices=frozenset({28, 21})),
                      Edge(weight=119.1691147454244, node_indices=frozenset({11, 4})),
                      Edge(weight=119.16911474542485, node_indices=frozenset({10, 5})),
                      Edge(weight=122.70985671734266, node_indices=frozenset({0, 15})),
                      Edge(weight=181.06175320416855, node_indices=frozenset({32, 35})),
                      Edge(weight=181.06175320416855, node_indices=frozenset({33, 34})),
                      Edge(weight=202.04933270623224, node_indices=frozenset({32, 33})),
                      Edge(weight=327.686127809774, node_indices=frozenset({28, 31})),
                      Edge(weight=327.686127809774, node_indices=frozenset({9, 10})),
                      Edge(weight=327.686127809774, node_indices=frozenset({5, 6})),
                      Edge(weight=327.68612780977423, node_indices=frozenset({24, 27})),
                      Edge(weight=327.68612780977423, node_indices=frozenset({29, 30})),
                      Edge(weight=327.68612780977423, node_indices=frozenset({20, 23})),
                      Edge(weight=327.68612780977423, node_indices=frozenset({25, 26})),
                      Edge(weight=327.68612780977446, node_indices=frozenset({0, 3})),
                      Edge(weight=327.68612780977446, node_indices=frozenset({8, 11})),
                      Edge(weight=327.68612780977446, node_indices=frozenset({1, 2})),
                      Edge(weight=327.68612780977446, node_indices=frozenset({16, 19})),
                      Edge(weight=327.68612780977446, node_indices=frozenset({12, 15})),
                      Edge(weight=377.41233141596683, node_indices=frozenset({9, 245})),
                      Edge(weight=517.5342710386278, node_indices=frozenset({26, 75})),
                      Edge(weight=830.5744457304636, node_indices=frozenset({6, 7})),
                      Edge(weight=830.5744457304636, node_indices=frozenset({14, 15})),
                      Edge(weight=830.5744457304638, node_indices=frozenset({22, 23})),
                      Edge(weight=830.574445730464, node_indices=frozenset({24, 25})),
                      Edge(weight=1059.2412796377762, node_indices=frozenset({35, 116}))}
