"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCollaborator = exports.CfnCollaboratorPropsPermission = exports.toJson_CfnCollaboratorProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnCollaboratorProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnCollaboratorProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Owner': obj.owner,
        'Repository': obj.repository,
        'Username': obj.username,
        'Permission': obj.permission,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnCollaboratorProps = toJson_CfnCollaboratorProps;
/* eslint-enable max-len, quote-props */
/**
 * The permission to grant the collaborator. Only valid on organization-owned repositories. In addition to the enumerated values, you can also specify a custom repository role name, if the owning organization has defined any..
 *
 * @schema CfnCollaboratorPropsPermission
 */
var CfnCollaboratorPropsPermission;
(function (CfnCollaboratorPropsPermission) {
    /** pull */
    CfnCollaboratorPropsPermission["PULL"] = "pull";
    /** push */
    CfnCollaboratorPropsPermission["PUSH"] = "push";
    /** admin */
    CfnCollaboratorPropsPermission["ADMIN"] = "admin";
    /** maintain */
    CfnCollaboratorPropsPermission["MAINTAIN"] = "maintain";
    /** triage */
    CfnCollaboratorPropsPermission["TRIAGE"] = "triage";
})(CfnCollaboratorPropsPermission = exports.CfnCollaboratorPropsPermission || (exports.CfnCollaboratorPropsPermission = {}));
/**
 * A CloudFormation `GitHub::Repositories::Collaborator`
 *
 * @cloudformationResource GitHub::Repositories::Collaborator
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
class CfnCollaborator extends cdk.CfnResource {
    /**
     * Create a new `GitHub::Repositories::Collaborator`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCollaborator.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnCollaboratorProps(props) });
        this.props = props;
    }
}
exports.CfnCollaborator = CfnCollaborator;
_a = JSII_RTTI_SYMBOL_1;
CfnCollaborator[_a] = { fqn: "@cdk-cloudformation/github-repositories-collaborator.CfnCollaborator", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnCollaborator.CFN_RESOURCE_TYPE_NAME = "GitHub::Repositories::Collaborator";
//# sourceMappingURL=data:application/json;base64,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