"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const k3s = require("./");
const core_1 = require("@aws-cdk/core");
const ec2 = require("@aws-cdk/aws-ec2");
class IntegTesting {
    constructor() {
        const app = new core_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new core_1.Stack(app, 'testing-stack', { env });
        const vpc = k3s.VpcProvider.getOrCreate(stack);
        const cluster = new k3s.Cluster(stack, 'Cluster', {
            vpc,
            spotWorkerNodes: true,
            workerMinCapacity: 1,
            workerInstanceType: new ec2.InstanceType('m6g.medium'),
            controlPlaneInstanceType: new ec2.InstanceType('m6g.medium'),
            bucketRemovalPolicy: core_1.RemovalPolicy.DESTROY,
        });
        new core_1.CfnOutput(stack, 'EndpointURI', { value: cluster.endpointUri });
        new core_1.CfnOutput(stack, 'Region', { value: core_1.Stack.of(stack).region });
        this.stack = [stack];
    }
    ;
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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