# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Span(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'annotations': 'list[dict(str, str)]',
        'duration_ms': 'int',
        'host': 'str',
        'name': 'str',
        'span_id': 'str',
        'start_ms': 'int',
        'trace_id': 'str'
    }

    attribute_map = {
        'annotations': 'annotations',
        'duration_ms': 'durationMs',
        'host': 'host',
        'name': 'name',
        'span_id': 'spanId',
        'start_ms': 'startMs',
        'trace_id': 'traceId'
    }

    def __init__(self, annotations=None, duration_ms=None, host=None, name=None, span_id=None, start_ms=None, trace_id=None, _configuration=None):  # noqa: E501
        """Span - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._annotations = None
        self._duration_ms = None
        self._host = None
        self._name = None
        self._span_id = None
        self._start_ms = None
        self._trace_id = None
        self.discriminator = None

        if annotations is not None:
            self.annotations = annotations
        if duration_ms is not None:
            self.duration_ms = duration_ms
        if host is not None:
            self.host = host
        if name is not None:
            self.name = name
        if span_id is not None:
            self.span_id = span_id
        if start_ms is not None:
            self.start_ms = start_ms
        if trace_id is not None:
            self.trace_id = trace_id

    @property
    def annotations(self):
        """Gets the annotations of this Span.  # noqa: E501

        Annotations (key-value pairs) of this span  # noqa: E501

        :return: The annotations of this Span.  # noqa: E501
        :rtype: list[dict(str, str)]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Span.

        Annotations (key-value pairs) of this span  # noqa: E501

        :param annotations: The annotations of this Span.  # noqa: E501
        :type: list[dict(str, str)]
        """

        self._annotations = annotations

    @property
    def duration_ms(self):
        """Gets the duration_ms of this Span.  # noqa: E501

        Span duration (in milliseconds)  # noqa: E501

        :return: The duration_ms of this Span.  # noqa: E501
        :rtype: int
        """
        return self._duration_ms

    @duration_ms.setter
    def duration_ms(self, duration_ms):
        """Sets the duration_ms of this Span.

        Span duration (in milliseconds)  # noqa: E501

        :param duration_ms: The duration_ms of this Span.  # noqa: E501
        :type: int
        """

        self._duration_ms = duration_ms

    @property
    def host(self):
        """Gets the host of this Span.  # noqa: E501

        Source/Host of this span  # noqa: E501

        :return: The host of this Span.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this Span.

        Source/Host of this span  # noqa: E501

        :param host: The host of this Span.  # noqa: E501
        :type: str
        """

        self._host = host

    @property
    def name(self):
        """Gets the name of this Span.  # noqa: E501

        Span name  # noqa: E501

        :return: The name of this Span.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Span.

        Span name  # noqa: E501

        :param name: The name of this Span.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def span_id(self):
        """Gets the span_id of this Span.  # noqa: E501

        Span ID  # noqa: E501

        :return: The span_id of this Span.  # noqa: E501
        :rtype: str
        """
        return self._span_id

    @span_id.setter
    def span_id(self, span_id):
        """Sets the span_id of this Span.

        Span ID  # noqa: E501

        :param span_id: The span_id of this Span.  # noqa: E501
        :type: str
        """

        self._span_id = span_id

    @property
    def start_ms(self):
        """Gets the start_ms of this Span.  # noqa: E501

        Span start time (in milliseconds)  # noqa: E501

        :return: The start_ms of this Span.  # noqa: E501
        :rtype: int
        """
        return self._start_ms

    @start_ms.setter
    def start_ms(self, start_ms):
        """Sets the start_ms of this Span.

        Span start time (in milliseconds)  # noqa: E501

        :param start_ms: The start_ms of this Span.  # noqa: E501
        :type: int
        """

        self._start_ms = start_ms

    @property
    def trace_id(self):
        """Gets the trace_id of this Span.  # noqa: E501

        Trace ID  # noqa: E501

        :return: The trace_id of this Span.  # noqa: E501
        :rtype: str
        """
        return self._trace_id

    @trace_id.setter
    def trace_id(self, trace_id):
        """Sets the trace_id of this Span.

        Trace ID  # noqa: E501

        :param trace_id: The trace_id of this Span.  # noqa: E501
        :type: str
        """

        self._trace_id = trace_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Span, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Span):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Span):
            return True

        return self.to_dict() != other.to_dict()
