# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Sorting(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ascending': 'bool',
        'default': 'bool',
        'field': 'str'
    }

    attribute_map = {
        'ascending': 'ascending',
        'default': 'default',
        'field': 'field'
    }

    def __init__(self, ascending=None, default=None, field=None, _configuration=None):  # noqa: E501
        """Sorting - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._ascending = None
        self._default = None
        self._field = None
        self.discriminator = None

        self.ascending = ascending
        if default is not None:
            self.default = default
        self.field = field

    @property
    def ascending(self):
        """Gets the ascending of this Sorting.  # noqa: E501

        Whether to sort ascending.  If undefined, sorting is not guaranteed  # noqa: E501

        :return: The ascending of this Sorting.  # noqa: E501
        :rtype: bool
        """
        return self._ascending

    @ascending.setter
    def ascending(self, ascending):
        """Sets the ascending of this Sorting.

        Whether to sort ascending.  If undefined, sorting is not guaranteed  # noqa: E501

        :param ascending: The ascending of this Sorting.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and ascending is None:
            raise ValueError("Invalid value for `ascending`, must not be `None`")  # noqa: E501

        self._ascending = ascending

    @property
    def default(self):
        """Gets the default of this Sorting.  # noqa: E501

        Whether this sort requests the default ranking order.  Ascending/descending does not matter if this attribute is true.  # noqa: E501

        :return: The default of this Sorting.  # noqa: E501
        :rtype: bool
        """
        return self._default

    @default.setter
    def default(self, default):
        """Sets the default of this Sorting.

        Whether this sort requests the default ranking order.  Ascending/descending does not matter if this attribute is true.  # noqa: E501

        :param default: The default of this Sorting.  # noqa: E501
        :type: bool
        """

        self._default = default

    @property
    def field(self):
        """Gets the field of this Sorting.  # noqa: E501

        The facet by which to sort  # noqa: E501

        :return: The field of this Sorting.  # noqa: E501
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """Sets the field of this Sorting.

        The facet by which to sort  # noqa: E501

        :param field: The field of this Sorting.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and field is None:
            raise ValueError("Invalid value for `field`, must not be `None`")  # noqa: E501

        self._field = field

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Sorting, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Sorting):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Sorting):
            return True

        return self.to_dict() != other.to_dict()
