# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class ServiceAccountWrite(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'active': 'bool',
        'description': 'str',
        'groups': 'list[str]',
        'identifier': 'str',
        'roles': 'list[str]',
        'tokens': 'list[str]',
        'user_groups': 'list[str]'
    }

    attribute_map = {
        'active': 'active',
        'description': 'description',
        'groups': 'groups',
        'identifier': 'identifier',
        'roles': 'roles',
        'tokens': 'tokens',
        'user_groups': 'userGroups'
    }

    def __init__(self, active=None, description=None, groups=None, identifier=None, roles=None, tokens=None, user_groups=None, _configuration=None):  # noqa: E501
        """ServiceAccountWrite - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._active = None
        self._description = None
        self._groups = None
        self._identifier = None
        self._roles = None
        self._tokens = None
        self._user_groups = None
        self.discriminator = None

        if active is not None:
            self.active = active
        if description is not None:
            self.description = description
        if groups is not None:
            self.groups = groups
        self.identifier = identifier
        if roles is not None:
            self.roles = roles
        if tokens is not None:
            self.tokens = tokens
        if user_groups is not None:
            self.user_groups = user_groups

    @property
    def active(self):
        """Gets the active of this ServiceAccountWrite.  # noqa: E501

        The current state of the service account.  # noqa: E501

        :return: The active of this ServiceAccountWrite.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this ServiceAccountWrite.

        The current state of the service account.  # noqa: E501

        :param active: The active of this ServiceAccountWrite.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def description(self):
        """Gets the description of this ServiceAccountWrite.  # noqa: E501

        The description of the service account to be created.  # noqa: E501

        :return: The description of this ServiceAccountWrite.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ServiceAccountWrite.

        The description of the service account to be created.  # noqa: E501

        :param description: The description of this ServiceAccountWrite.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def groups(self):
        """Gets the groups of this ServiceAccountWrite.  # noqa: E501

        The list of permissions, the service account will be granted.  # noqa: E501

        :return: The groups of this ServiceAccountWrite.  # noqa: E501
        :rtype: list[str]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """Sets the groups of this ServiceAccountWrite.

        The list of permissions, the service account will be granted.  # noqa: E501

        :param groups: The groups of this ServiceAccountWrite.  # noqa: E501
        :type: list[str]
        """

        self._groups = groups

    @property
    def identifier(self):
        """Gets the identifier of this ServiceAccountWrite.  # noqa: E501

        The unique identifier for a service account.  # noqa: E501

        :return: The identifier of this ServiceAccountWrite.  # noqa: E501
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this ServiceAccountWrite.

        The unique identifier for a service account.  # noqa: E501

        :param identifier: The identifier of this ServiceAccountWrite.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and identifier is None:
            raise ValueError("Invalid value for `identifier`, must not be `None`")  # noqa: E501

        self._identifier = identifier

    @property
    def roles(self):
        """Gets the roles of this ServiceAccountWrite.  # noqa: E501

        The list of role ids, the service account will be added to.\"  # noqa: E501

        :return: The roles of this ServiceAccountWrite.  # noqa: E501
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this ServiceAccountWrite.

        The list of role ids, the service account will be added to.\"  # noqa: E501

        :param roles: The roles of this ServiceAccountWrite.  # noqa: E501
        :type: list[str]
        """

        self._roles = roles

    @property
    def tokens(self):
        """Gets the tokens of this ServiceAccountWrite.  # noqa: E501

        The service account's API tokens.  # noqa: E501

        :return: The tokens of this ServiceAccountWrite.  # noqa: E501
        :rtype: list[str]
        """
        return self._tokens

    @tokens.setter
    def tokens(self, tokens):
        """Sets the tokens of this ServiceAccountWrite.

        The service account's API tokens.  # noqa: E501

        :param tokens: The tokens of this ServiceAccountWrite.  # noqa: E501
        :type: list[str]
        """

        self._tokens = tokens

    @property
    def user_groups(self):
        """Gets the user_groups of this ServiceAccountWrite.  # noqa: E501

        The list of user group ids, the service account will be added to.  # noqa: E501

        :return: The user_groups of this ServiceAccountWrite.  # noqa: E501
        :rtype: list[str]
        """
        return self._user_groups

    @user_groups.setter
    def user_groups(self, user_groups):
        """Sets the user_groups of this ServiceAccountWrite.

        The list of user group ids, the service account will be added to.  # noqa: E501

        :param user_groups: The user_groups of this ServiceAccountWrite.  # noqa: E501
        :type: list[str]
        """

        self._user_groups = user_groups

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ServiceAccountWrite, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServiceAccountWrite):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServiceAccountWrite):
            return True

        return self.to_dict() != other.to_dict()
