# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Schema(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aliases': 'list[str]',
        'doc': 'str',
        'element_type': 'Schema',
        'enum_default': 'str',
        'enum_symbols': 'list[str]',
        'error': 'bool',
        'fields': 'list[Field]',
        'fixed_size': 'int',
        'full_name': 'str',
        'logical_type': 'LogicalType',
        'name': 'str',
        'namespace': 'str',
        'nullable': 'bool',
        'object_props': 'dict(str, object)',
        'type': 'str',
        'types': 'list[Schema]',
        'union': 'bool',
        'value_type': 'Schema'
    }

    attribute_map = {
        'aliases': 'aliases',
        'doc': 'doc',
        'element_type': 'elementType',
        'enum_default': 'enumDefault',
        'enum_symbols': 'enumSymbols',
        'error': 'error',
        'fields': 'fields',
        'fixed_size': 'fixedSize',
        'full_name': 'fullName',
        'logical_type': 'logicalType',
        'name': 'name',
        'namespace': 'namespace',
        'nullable': 'nullable',
        'object_props': 'objectProps',
        'type': 'type',
        'types': 'types',
        'union': 'union',
        'value_type': 'valueType'
    }

    def __init__(self, aliases=None, doc=None, element_type=None, enum_default=None, enum_symbols=None, error=None, fields=None, fixed_size=None, full_name=None, logical_type=None, name=None, namespace=None, nullable=None, object_props=None, type=None, types=None, union=None, value_type=None, _configuration=None):  # noqa: E501
        """Schema - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._aliases = None
        self._doc = None
        self._element_type = None
        self._enum_default = None
        self._enum_symbols = None
        self._error = None
        self._fields = None
        self._fixed_size = None
        self._full_name = None
        self._logical_type = None
        self._name = None
        self._namespace = None
        self._nullable = None
        self._object_props = None
        self._type = None
        self._types = None
        self._union = None
        self._value_type = None
        self.discriminator = None

        if aliases is not None:
            self.aliases = aliases
        if doc is not None:
            self.doc = doc
        if element_type is not None:
            self.element_type = element_type
        if enum_default is not None:
            self.enum_default = enum_default
        if enum_symbols is not None:
            self.enum_symbols = enum_symbols
        if error is not None:
            self.error = error
        if fields is not None:
            self.fields = fields
        if fixed_size is not None:
            self.fixed_size = fixed_size
        if full_name is not None:
            self.full_name = full_name
        if logical_type is not None:
            self.logical_type = logical_type
        if name is not None:
            self.name = name
        if namespace is not None:
            self.namespace = namespace
        if nullable is not None:
            self.nullable = nullable
        if object_props is not None:
            self.object_props = object_props
        if type is not None:
            self.type = type
        if types is not None:
            self.types = types
        if union is not None:
            self.union = union
        if value_type is not None:
            self.value_type = value_type

    @property
    def aliases(self):
        """Gets the aliases of this Schema.  # noqa: E501


        :return: The aliases of this Schema.  # noqa: E501
        :rtype: list[str]
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """Sets the aliases of this Schema.


        :param aliases: The aliases of this Schema.  # noqa: E501
        :type: list[str]
        """

        self._aliases = aliases

    @property
    def doc(self):
        """Gets the doc of this Schema.  # noqa: E501


        :return: The doc of this Schema.  # noqa: E501
        :rtype: str
        """
        return self._doc

    @doc.setter
    def doc(self, doc):
        """Sets the doc of this Schema.


        :param doc: The doc of this Schema.  # noqa: E501
        :type: str
        """

        self._doc = doc

    @property
    def element_type(self):
        """Gets the element_type of this Schema.  # noqa: E501


        :return: The element_type of this Schema.  # noqa: E501
        :rtype: Schema
        """
        return self._element_type

    @element_type.setter
    def element_type(self, element_type):
        """Sets the element_type of this Schema.


        :param element_type: The element_type of this Schema.  # noqa: E501
        :type: Schema
        """

        self._element_type = element_type

    @property
    def enum_default(self):
        """Gets the enum_default of this Schema.  # noqa: E501


        :return: The enum_default of this Schema.  # noqa: E501
        :rtype: str
        """
        return self._enum_default

    @enum_default.setter
    def enum_default(self, enum_default):
        """Sets the enum_default of this Schema.


        :param enum_default: The enum_default of this Schema.  # noqa: E501
        :type: str
        """

        self._enum_default = enum_default

    @property
    def enum_symbols(self):
        """Gets the enum_symbols of this Schema.  # noqa: E501


        :return: The enum_symbols of this Schema.  # noqa: E501
        :rtype: list[str]
        """
        return self._enum_symbols

    @enum_symbols.setter
    def enum_symbols(self, enum_symbols):
        """Sets the enum_symbols of this Schema.


        :param enum_symbols: The enum_symbols of this Schema.  # noqa: E501
        :type: list[str]
        """

        self._enum_symbols = enum_symbols

    @property
    def error(self):
        """Gets the error of this Schema.  # noqa: E501


        :return: The error of this Schema.  # noqa: E501
        :rtype: bool
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this Schema.


        :param error: The error of this Schema.  # noqa: E501
        :type: bool
        """

        self._error = error

    @property
    def fields(self):
        """Gets the fields of this Schema.  # noqa: E501


        :return: The fields of this Schema.  # noqa: E501
        :rtype: list[Field]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """Sets the fields of this Schema.


        :param fields: The fields of this Schema.  # noqa: E501
        :type: list[Field]
        """

        self._fields = fields

    @property
    def fixed_size(self):
        """Gets the fixed_size of this Schema.  # noqa: E501


        :return: The fixed_size of this Schema.  # noqa: E501
        :rtype: int
        """
        return self._fixed_size

    @fixed_size.setter
    def fixed_size(self, fixed_size):
        """Sets the fixed_size of this Schema.


        :param fixed_size: The fixed_size of this Schema.  # noqa: E501
        :type: int
        """

        self._fixed_size = fixed_size

    @property
    def full_name(self):
        """Gets the full_name of this Schema.  # noqa: E501


        :return: The full_name of this Schema.  # noqa: E501
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """Sets the full_name of this Schema.


        :param full_name: The full_name of this Schema.  # noqa: E501
        :type: str
        """

        self._full_name = full_name

    @property
    def logical_type(self):
        """Gets the logical_type of this Schema.  # noqa: E501


        :return: The logical_type of this Schema.  # noqa: E501
        :rtype: LogicalType
        """
        return self._logical_type

    @logical_type.setter
    def logical_type(self, logical_type):
        """Sets the logical_type of this Schema.


        :param logical_type: The logical_type of this Schema.  # noqa: E501
        :type: LogicalType
        """

        self._logical_type = logical_type

    @property
    def name(self):
        """Gets the name of this Schema.  # noqa: E501


        :return: The name of this Schema.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Schema.


        :param name: The name of this Schema.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this Schema.  # noqa: E501


        :return: The namespace of this Schema.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this Schema.


        :param namespace: The namespace of this Schema.  # noqa: E501
        :type: str
        """

        self._namespace = namespace

    @property
    def nullable(self):
        """Gets the nullable of this Schema.  # noqa: E501


        :return: The nullable of this Schema.  # noqa: E501
        :rtype: bool
        """
        return self._nullable

    @nullable.setter
    def nullable(self, nullable):
        """Sets the nullable of this Schema.


        :param nullable: The nullable of this Schema.  # noqa: E501
        :type: bool
        """

        self._nullable = nullable

    @property
    def object_props(self):
        """Gets the object_props of this Schema.  # noqa: E501


        :return: The object_props of this Schema.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._object_props

    @object_props.setter
    def object_props(self, object_props):
        """Sets the object_props of this Schema.


        :param object_props: The object_props of this Schema.  # noqa: E501
        :type: dict(str, object)
        """

        self._object_props = object_props

    @property
    def type(self):
        """Gets the type of this Schema.  # noqa: E501


        :return: The type of this Schema.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Schema.


        :param type: The type of this Schema.  # noqa: E501
        :type: str
        """
        allowed_values = ["RECORD", "ENUM", "ARRAY", "MAP", "UNION", "FIXED", "STRING", "BYTES", "INT", "LONG", "FLOAT", "DOUBLE", "BOOLEAN", "NULL"]  # noqa: E501
        if (self._configuration.client_side_validation and
                type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def types(self):
        """Gets the types of this Schema.  # noqa: E501


        :return: The types of this Schema.  # noqa: E501
        :rtype: list[Schema]
        """
        return self._types

    @types.setter
    def types(self, types):
        """Sets the types of this Schema.


        :param types: The types of this Schema.  # noqa: E501
        :type: list[Schema]
        """

        self._types = types

    @property
    def union(self):
        """Gets the union of this Schema.  # noqa: E501


        :return: The union of this Schema.  # noqa: E501
        :rtype: bool
        """
        return self._union

    @union.setter
    def union(self, union):
        """Sets the union of this Schema.


        :param union: The union of this Schema.  # noqa: E501
        :type: bool
        """

        self._union = union

    @property
    def value_type(self):
        """Gets the value_type of this Schema.  # noqa: E501


        :return: The value_type of this Schema.  # noqa: E501
        :rtype: Schema
        """
        return self._value_type

    @value_type.setter
    def value_type(self, value_type):
        """Sets the value_type of this Schema.


        :param value_type: The value_type of this Schema.  # noqa: E501
        :type: Schema
        """

        self._value_type = value_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Schema, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Schema):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Schema):
            return True

        return self.to_dict() != other.to_dict()
