# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class QueryTypeDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'input_query': 'str',
        'query_type': 'str',
        'translated_input': 'str'
    }

    attribute_map = {
        'input_query': 'inputQuery',
        'query_type': 'queryType',
        'translated_input': 'translatedInput'
    }

    def __init__(self, input_query=None, query_type=None, translated_input=None, _configuration=None):  # noqa: E501
        """QueryTypeDTO - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._input_query = None
        self._query_type = None
        self._translated_input = None
        self.discriminator = None

        if input_query is not None:
            self.input_query = input_query
        if query_type is not None:
            self.query_type = query_type
        if translated_input is not None:
            self.translated_input = translated_input

    @property
    def input_query(self):
        """Gets the input_query of this QueryTypeDTO.  # noqa: E501


        :return: The input_query of this QueryTypeDTO.  # noqa: E501
        :rtype: str
        """
        return self._input_query

    @input_query.setter
    def input_query(self, input_query):
        """Sets the input_query of this QueryTypeDTO.


        :param input_query: The input_query of this QueryTypeDTO.  # noqa: E501
        :type: str
        """

        self._input_query = input_query

    @property
    def query_type(self):
        """Gets the query_type of this QueryTypeDTO.  # noqa: E501


        :return: The query_type of this QueryTypeDTO.  # noqa: E501
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type):
        """Sets the query_type of this QueryTypeDTO.


        :param query_type: The query_type of this QueryTypeDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["WQL", "PROMQL", "HYBRID"]  # noqa: E501
        if (self._configuration.client_side_validation and
                query_type not in allowed_values):
            raise ValueError(
                "Invalid value for `query_type` ({0}), must be one of {1}"  # noqa: E501
                .format(query_type, allowed_values)
            )

        self._query_type = query_type

    @property
    def translated_input(self):
        """Gets the translated_input of this QueryTypeDTO.  # noqa: E501


        :return: The translated_input of this QueryTypeDTO.  # noqa: E501
        :rtype: str
        """
        return self._translated_input

    @translated_input.setter
    def translated_input(self, translated_input):
        """Sets the translated_input of this QueryTypeDTO.


        :param translated_input: The translated_input of this QueryTypeDTO.  # noqa: E501
        :type: str
        """

        self._translated_input = translated_input

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QueryTypeDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryTypeDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QueryTypeDTO):
            return True

        return self.to_dict() != other.to_dict()
