# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class QueryEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'end': 'int',
        'hosts': 'list[str]',
        'is_ephemeral': 'bool',
        'name': 'str',
        'start': 'int',
        'summarized': 'int',
        'tags': 'dict(str, str)'
    }

    attribute_map = {
        'end': 'end',
        'hosts': 'hosts',
        'is_ephemeral': 'isEphemeral',
        'name': 'name',
        'start': 'start',
        'summarized': 'summarized',
        'tags': 'tags'
    }

    def __init__(self, end=None, hosts=None, is_ephemeral=None, name=None, start=None, summarized=None, tags=None, _configuration=None):  # noqa: E501
        """QueryEvent - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._end = None
        self._hosts = None
        self._is_ephemeral = None
        self._name = None
        self._start = None
        self._summarized = None
        self._tags = None
        self.discriminator = None

        if end is not None:
            self.end = end
        if hosts is not None:
            self.hosts = hosts
        if is_ephemeral is not None:
            self.is_ephemeral = is_ephemeral
        if name is not None:
            self.name = name
        if start is not None:
            self.start = start
        if summarized is not None:
            self.summarized = summarized
        if tags is not None:
            self.tags = tags

    @property
    def end(self):
        """Gets the end of this QueryEvent.  # noqa: E501

        End time of event, in epoch millis  # noqa: E501

        :return: The end of this QueryEvent.  # noqa: E501
        :rtype: int
        """
        return self._end

    @end.setter
    def end(self, end):
        """Sets the end of this QueryEvent.

        End time of event, in epoch millis  # noqa: E501

        :param end: The end of this QueryEvent.  # noqa: E501
        :type: int
        """

        self._end = end

    @property
    def hosts(self):
        """Gets the hosts of this QueryEvent.  # noqa: E501

        Sources (hosts) to which the event pertains  # noqa: E501

        :return: The hosts of this QueryEvent.  # noqa: E501
        :rtype: list[str]
        """
        return self._hosts

    @hosts.setter
    def hosts(self, hosts):
        """Sets the hosts of this QueryEvent.

        Sources (hosts) to which the event pertains  # noqa: E501

        :param hosts: The hosts of this QueryEvent.  # noqa: E501
        :type: list[str]
        """

        self._hosts = hosts

    @property
    def is_ephemeral(self):
        """Gets the is_ephemeral of this QueryEvent.  # noqa: E501

        Whether the event is an artificial event generated by a literal expression or alert backtesting, i.e. not stored in the Wavefront backend  # noqa: E501

        :return: The is_ephemeral of this QueryEvent.  # noqa: E501
        :rtype: bool
        """
        return self._is_ephemeral

    @is_ephemeral.setter
    def is_ephemeral(self, is_ephemeral):
        """Sets the is_ephemeral of this QueryEvent.

        Whether the event is an artificial event generated by a literal expression or alert backtesting, i.e. not stored in the Wavefront backend  # noqa: E501

        :param is_ephemeral: The is_ephemeral of this QueryEvent.  # noqa: E501
        :type: bool
        """

        self._is_ephemeral = is_ephemeral

    @property
    def name(self):
        """Gets the name of this QueryEvent.  # noqa: E501

        Event name  # noqa: E501

        :return: The name of this QueryEvent.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this QueryEvent.

        Event name  # noqa: E501

        :param name: The name of this QueryEvent.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def start(self):
        """Gets the start of this QueryEvent.  # noqa: E501

        Start time of event, in epoch millis  # noqa: E501

        :return: The start of this QueryEvent.  # noqa: E501
        :rtype: int
        """
        return self._start

    @start.setter
    def start(self, start):
        """Sets the start of this QueryEvent.

        Start time of event, in epoch millis  # noqa: E501

        :param start: The start of this QueryEvent.  # noqa: E501
        :type: int
        """

        self._start = start

    @property
    def summarized(self):
        """Gets the summarized of this QueryEvent.  # noqa: E501

        In some event queries, multiple events that occur nearly simultaneously are summarized under a single event.  This value specifies the number of events summarized under this one  # noqa: E501

        :return: The summarized of this QueryEvent.  # noqa: E501
        :rtype: int
        """
        return self._summarized

    @summarized.setter
    def summarized(self, summarized):
        """Sets the summarized of this QueryEvent.

        In some event queries, multiple events that occur nearly simultaneously are summarized under a single event.  This value specifies the number of events summarized under this one  # noqa: E501

        :param summarized: The summarized of this QueryEvent.  # noqa: E501
        :type: int
        """

        self._summarized = summarized

    @property
    def tags(self):
        """Gets the tags of this QueryEvent.  # noqa: E501

        Tags (annotations) on the event  # noqa: E501

        :return: The tags of this QueryEvent.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this QueryEvent.

        Tags (annotations) on the event  # noqa: E501

        :param tags: The tags of this QueryEvent.  # noqa: E501
        :type: dict(str, str)
        """

        self._tags = tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QueryEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryEvent):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QueryEvent):
            return True

        return self.to_dict() != other.to_dict()
