# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Package(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'annotations': 'list[Annotation]',
        'declared_annotations': 'list[Annotation]',
        'implementation_title': 'str',
        'implementation_vendor': 'str',
        'implementation_version': 'str',
        'name': 'str',
        'sealed': 'bool',
        'specification_title': 'str',
        'specification_vendor': 'str',
        'specification_version': 'str'
    }

    attribute_map = {
        'annotations': 'annotations',
        'declared_annotations': 'declaredAnnotations',
        'implementation_title': 'implementationTitle',
        'implementation_vendor': 'implementationVendor',
        'implementation_version': 'implementationVersion',
        'name': 'name',
        'sealed': 'sealed',
        'specification_title': 'specificationTitle',
        'specification_vendor': 'specificationVendor',
        'specification_version': 'specificationVersion'
    }

    def __init__(self, annotations=None, declared_annotations=None, implementation_title=None, implementation_vendor=None, implementation_version=None, name=None, sealed=None, specification_title=None, specification_vendor=None, specification_version=None, _configuration=None):  # noqa: E501
        """Package - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._annotations = None
        self._declared_annotations = None
        self._implementation_title = None
        self._implementation_vendor = None
        self._implementation_version = None
        self._name = None
        self._sealed = None
        self._specification_title = None
        self._specification_vendor = None
        self._specification_version = None
        self.discriminator = None

        if annotations is not None:
            self.annotations = annotations
        if declared_annotations is not None:
            self.declared_annotations = declared_annotations
        if implementation_title is not None:
            self.implementation_title = implementation_title
        if implementation_vendor is not None:
            self.implementation_vendor = implementation_vendor
        if implementation_version is not None:
            self.implementation_version = implementation_version
        if name is not None:
            self.name = name
        if sealed is not None:
            self.sealed = sealed
        if specification_title is not None:
            self.specification_title = specification_title
        if specification_vendor is not None:
            self.specification_vendor = specification_vendor
        if specification_version is not None:
            self.specification_version = specification_version

    @property
    def annotations(self):
        """Gets the annotations of this Package.  # noqa: E501


        :return: The annotations of this Package.  # noqa: E501
        :rtype: list[Annotation]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Package.


        :param annotations: The annotations of this Package.  # noqa: E501
        :type: list[Annotation]
        """

        self._annotations = annotations

    @property
    def declared_annotations(self):
        """Gets the declared_annotations of this Package.  # noqa: E501


        :return: The declared_annotations of this Package.  # noqa: E501
        :rtype: list[Annotation]
        """
        return self._declared_annotations

    @declared_annotations.setter
    def declared_annotations(self, declared_annotations):
        """Sets the declared_annotations of this Package.


        :param declared_annotations: The declared_annotations of this Package.  # noqa: E501
        :type: list[Annotation]
        """

        self._declared_annotations = declared_annotations

    @property
    def implementation_title(self):
        """Gets the implementation_title of this Package.  # noqa: E501


        :return: The implementation_title of this Package.  # noqa: E501
        :rtype: str
        """
        return self._implementation_title

    @implementation_title.setter
    def implementation_title(self, implementation_title):
        """Sets the implementation_title of this Package.


        :param implementation_title: The implementation_title of this Package.  # noqa: E501
        :type: str
        """

        self._implementation_title = implementation_title

    @property
    def implementation_vendor(self):
        """Gets the implementation_vendor of this Package.  # noqa: E501


        :return: The implementation_vendor of this Package.  # noqa: E501
        :rtype: str
        """
        return self._implementation_vendor

    @implementation_vendor.setter
    def implementation_vendor(self, implementation_vendor):
        """Sets the implementation_vendor of this Package.


        :param implementation_vendor: The implementation_vendor of this Package.  # noqa: E501
        :type: str
        """

        self._implementation_vendor = implementation_vendor

    @property
    def implementation_version(self):
        """Gets the implementation_version of this Package.  # noqa: E501


        :return: The implementation_version of this Package.  # noqa: E501
        :rtype: str
        """
        return self._implementation_version

    @implementation_version.setter
    def implementation_version(self, implementation_version):
        """Sets the implementation_version of this Package.


        :param implementation_version: The implementation_version of this Package.  # noqa: E501
        :type: str
        """

        self._implementation_version = implementation_version

    @property
    def name(self):
        """Gets the name of this Package.  # noqa: E501


        :return: The name of this Package.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Package.


        :param name: The name of this Package.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def sealed(self):
        """Gets the sealed of this Package.  # noqa: E501


        :return: The sealed of this Package.  # noqa: E501
        :rtype: bool
        """
        return self._sealed

    @sealed.setter
    def sealed(self, sealed):
        """Sets the sealed of this Package.


        :param sealed: The sealed of this Package.  # noqa: E501
        :type: bool
        """

        self._sealed = sealed

    @property
    def specification_title(self):
        """Gets the specification_title of this Package.  # noqa: E501


        :return: The specification_title of this Package.  # noqa: E501
        :rtype: str
        """
        return self._specification_title

    @specification_title.setter
    def specification_title(self, specification_title):
        """Sets the specification_title of this Package.


        :param specification_title: The specification_title of this Package.  # noqa: E501
        :type: str
        """

        self._specification_title = specification_title

    @property
    def specification_vendor(self):
        """Gets the specification_vendor of this Package.  # noqa: E501


        :return: The specification_vendor of this Package.  # noqa: E501
        :rtype: str
        """
        return self._specification_vendor

    @specification_vendor.setter
    def specification_vendor(self, specification_vendor):
        """Sets the specification_vendor of this Package.


        :param specification_vendor: The specification_vendor of this Package.  # noqa: E501
        :type: str
        """

        self._specification_vendor = specification_vendor

    @property
    def specification_version(self):
        """Gets the specification_version of this Package.  # noqa: E501


        :return: The specification_version of this Package.  # noqa: E501
        :rtype: str
        """
        return self._specification_version

    @specification_version.setter
    def specification_version(self, specification_version):
        """Sets the specification_version of this Package.


        :param specification_version: The specification_version of this Package.  # noqa: E501
        :type: str
        """

        self._specification_version = specification_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Package, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Package):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Package):
            return True

        return self.to_dict() != other.to_dict()
