# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class MonitoredCluster(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_tags': 'dict(str, str)',
        'alias': 'str',
        'components': 'list[KubernetesComponent]',
        'deleted': 'bool',
        'id': 'str',
        'last_updated': 'int',
        'monitored': 'bool',
        'name': 'str',
        'platform': 'str',
        'tags': 'list[str]',
        'version': 'str'
    }

    attribute_map = {
        'additional_tags': 'additionalTags',
        'alias': 'alias',
        'components': 'components',
        'deleted': 'deleted',
        'id': 'id',
        'last_updated': 'lastUpdated',
        'monitored': 'monitored',
        'name': 'name',
        'platform': 'platform',
        'tags': 'tags',
        'version': 'version'
    }

    def __init__(self, additional_tags=None, alias=None, components=None, deleted=None, id=None, last_updated=None, monitored=None, name=None, platform=None, tags=None, version=None, _configuration=None):  # noqa: E501
        """MonitoredCluster - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._additional_tags = None
        self._alias = None
        self._components = None
        self._deleted = None
        self._id = None
        self._last_updated = None
        self._monitored = None
        self._name = None
        self._platform = None
        self._tags = None
        self._version = None
        self.discriminator = None

        if additional_tags is not None:
            self.additional_tags = additional_tags
        if alias is not None:
            self.alias = alias
        if components is not None:
            self.components = components
        if deleted is not None:
            self.deleted = deleted
        self.id = id
        if last_updated is not None:
            self.last_updated = last_updated
        if monitored is not None:
            self.monitored = monitored
        self.name = name
        if platform is not None:
            self.platform = platform
        if tags is not None:
            self.tags = tags
        if version is not None:
            self.version = version

    @property
    def additional_tags(self):
        """Gets the additional_tags of this MonitoredCluster.  # noqa: E501


        :return: The additional_tags of this MonitoredCluster.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._additional_tags

    @additional_tags.setter
    def additional_tags(self, additional_tags):
        """Sets the additional_tags of this MonitoredCluster.


        :param additional_tags: The additional_tags of this MonitoredCluster.  # noqa: E501
        :type: dict(str, str)
        """

        self._additional_tags = additional_tags

    @property
    def alias(self):
        """Gets the alias of this MonitoredCluster.  # noqa: E501

        ID of a monitored cluster that was merged into this one.  # noqa: E501

        :return: The alias of this MonitoredCluster.  # noqa: E501
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """Sets the alias of this MonitoredCluster.

        ID of a monitored cluster that was merged into this one.  # noqa: E501

        :param alias: The alias of this MonitoredCluster.  # noqa: E501
        :type: str
        """

        self._alias = alias

    @property
    def components(self):
        """Gets the components of this MonitoredCluster.  # noqa: E501


        :return: The components of this MonitoredCluster.  # noqa: E501
        :rtype: list[KubernetesComponent]
        """
        return self._components

    @components.setter
    def components(self, components):
        """Sets the components of this MonitoredCluster.


        :param components: The components of this MonitoredCluster.  # noqa: E501
        :type: list[KubernetesComponent]
        """

        self._components = components

    @property
    def deleted(self):
        """Gets the deleted of this MonitoredCluster.  # noqa: E501


        :return: The deleted of this MonitoredCluster.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this MonitoredCluster.


        :param deleted: The deleted of this MonitoredCluster.  # noqa: E501
        :type: bool
        """

        self._deleted = deleted

    @property
    def id(self):
        """Gets the id of this MonitoredCluster.  # noqa: E501

        Id of monitored cluster which is same as actual cluster id  # noqa: E501

        :return: The id of this MonitoredCluster.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MonitoredCluster.

        Id of monitored cluster which is same as actual cluster id  # noqa: E501

        :param id: The id of this MonitoredCluster.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def last_updated(self):
        """Gets the last_updated of this MonitoredCluster.  # noqa: E501


        :return: The last_updated of this MonitoredCluster.  # noqa: E501
        :rtype: int
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this MonitoredCluster.


        :param last_updated: The last_updated of this MonitoredCluster.  # noqa: E501
        :type: int
        """

        self._last_updated = last_updated

    @property
    def monitored(self):
        """Gets the monitored of this MonitoredCluster.  # noqa: E501


        :return: The monitored of this MonitoredCluster.  # noqa: E501
        :rtype: bool
        """
        return self._monitored

    @monitored.setter
    def monitored(self, monitored):
        """Sets the monitored of this MonitoredCluster.


        :param monitored: The monitored of this MonitoredCluster.  # noqa: E501
        :type: bool
        """

        self._monitored = monitored

    @property
    def name(self):
        """Gets the name of this MonitoredCluster.  # noqa: E501

        Name of the monitored cluster  # noqa: E501

        :return: The name of this MonitoredCluster.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this MonitoredCluster.

        Name of the monitored cluster  # noqa: E501

        :param name: The name of this MonitoredCluster.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def platform(self):
        """Gets the platform of this MonitoredCluster.  # noqa: E501

        Monitored cluster type  # noqa: E501

        :return: The platform of this MonitoredCluster.  # noqa: E501
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this MonitoredCluster.

        Monitored cluster type  # noqa: E501

        :param platform: The platform of this MonitoredCluster.  # noqa: E501
        :type: str
        """

        self._platform = platform

    @property
    def tags(self):
        """Gets the tags of this MonitoredCluster.  # noqa: E501


        :return: The tags of this MonitoredCluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this MonitoredCluster.


        :param tags: The tags of this MonitoredCluster.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def version(self):
        """Gets the version of this MonitoredCluster.  # noqa: E501

        Version of monitored cluster  # noqa: E501

        :return: The version of this MonitoredCluster.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this MonitoredCluster.

        Version of monitored cluster  # noqa: E501

        :param version: The version of this MonitoredCluster.  # noqa: E501
        :type: str
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MonitoredCluster, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MonitoredCluster):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MonitoredCluster):
            return True

        return self.to_dict() != other.to_dict()
