# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class IntegrationAlert(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alert_min_obj': 'AlertMin',
        'alert_obj': 'Alert',
        'description': 'str',
        'name': 'str',
        'url': 'str'
    }

    attribute_map = {
        'alert_min_obj': 'alertMinObj',
        'alert_obj': 'alertObj',
        'description': 'description',
        'name': 'name',
        'url': 'url'
    }

    def __init__(self, alert_min_obj=None, alert_obj=None, description=None, name=None, url=None, _configuration=None):  # noqa: E501
        """IntegrationAlert - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._alert_min_obj = None
        self._alert_obj = None
        self._description = None
        self._name = None
        self._url = None
        self.discriminator = None

        if alert_min_obj is not None:
            self.alert_min_obj = alert_min_obj
        if alert_obj is not None:
            self.alert_obj = alert_obj
        self.description = description
        self.name = name
        self.url = url

    @property
    def alert_min_obj(self):
        """Gets the alert_min_obj of this IntegrationAlert.  # noqa: E501


        :return: The alert_min_obj of this IntegrationAlert.  # noqa: E501
        :rtype: AlertMin
        """
        return self._alert_min_obj

    @alert_min_obj.setter
    def alert_min_obj(self, alert_min_obj):
        """Sets the alert_min_obj of this IntegrationAlert.


        :param alert_min_obj: The alert_min_obj of this IntegrationAlert.  # noqa: E501
        :type: AlertMin
        """

        self._alert_min_obj = alert_min_obj

    @property
    def alert_obj(self):
        """Gets the alert_obj of this IntegrationAlert.  # noqa: E501


        :return: The alert_obj of this IntegrationAlert.  # noqa: E501
        :rtype: Alert
        """
        return self._alert_obj

    @alert_obj.setter
    def alert_obj(self, alert_obj):
        """Sets the alert_obj of this IntegrationAlert.


        :param alert_obj: The alert_obj of this IntegrationAlert.  # noqa: E501
        :type: Alert
        """

        self._alert_obj = alert_obj

    @property
    def description(self):
        """Gets the description of this IntegrationAlert.  # noqa: E501

        Alert description  # noqa: E501

        :return: The description of this IntegrationAlert.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this IntegrationAlert.

        Alert description  # noqa: E501

        :param description: The description of this IntegrationAlert.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def name(self):
        """Gets the name of this IntegrationAlert.  # noqa: E501

        Alert name  # noqa: E501

        :return: The name of this IntegrationAlert.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IntegrationAlert.

        Alert name  # noqa: E501

        :param name: The name of this IntegrationAlert.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def url(self):
        """Gets the url of this IntegrationAlert.  # noqa: E501

        URL path to the JSON definition of this alert  # noqa: E501

        :return: The url of this IntegrationAlert.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this IntegrationAlert.

        URL path to the JSON definition of this alert  # noqa: E501

        :param url: The url of this IntegrationAlert.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and url is None:
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IntegrationAlert, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IntegrationAlert):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IntegrationAlert):
            return True

        return self.to_dict() != other.to_dict()
