# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class HistoryEntry(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'change_description': 'list[str]',
        'id': 'str',
        'in_trash': 'bool',
        'update_time': 'int',
        'update_user': 'str',
        'version': 'int'
    }

    attribute_map = {
        'change_description': 'changeDescription',
        'id': 'id',
        'in_trash': 'inTrash',
        'update_time': 'updateTime',
        'update_user': 'updateUser',
        'version': 'version'
    }

    def __init__(self, change_description=None, id=None, in_trash=None, update_time=None, update_user=None, version=None, _configuration=None):  # noqa: E501
        """HistoryEntry - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._change_description = None
        self._id = None
        self._in_trash = None
        self._update_time = None
        self._update_user = None
        self._version = None
        self.discriminator = None

        if change_description is not None:
            self.change_description = change_description
        if id is not None:
            self.id = id
        if in_trash is not None:
            self.in_trash = in_trash
        if update_time is not None:
            self.update_time = update_time
        if update_user is not None:
            self.update_user = update_user
        if version is not None:
            self.version = version

    @property
    def change_description(self):
        """Gets the change_description of this HistoryEntry.  # noqa: E501


        :return: The change_description of this HistoryEntry.  # noqa: E501
        :rtype: list[str]
        """
        return self._change_description

    @change_description.setter
    def change_description(self, change_description):
        """Sets the change_description of this HistoryEntry.


        :param change_description: The change_description of this HistoryEntry.  # noqa: E501
        :type: list[str]
        """

        self._change_description = change_description

    @property
    def id(self):
        """Gets the id of this HistoryEntry.  # noqa: E501


        :return: The id of this HistoryEntry.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoryEntry.


        :param id: The id of this HistoryEntry.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def in_trash(self):
        """Gets the in_trash of this HistoryEntry.  # noqa: E501


        :return: The in_trash of this HistoryEntry.  # noqa: E501
        :rtype: bool
        """
        return self._in_trash

    @in_trash.setter
    def in_trash(self, in_trash):
        """Sets the in_trash of this HistoryEntry.


        :param in_trash: The in_trash of this HistoryEntry.  # noqa: E501
        :type: bool
        """

        self._in_trash = in_trash

    @property
    def update_time(self):
        """Gets the update_time of this HistoryEntry.  # noqa: E501


        :return: The update_time of this HistoryEntry.  # noqa: E501
        :rtype: int
        """
        return self._update_time

    @update_time.setter
    def update_time(self, update_time):
        """Sets the update_time of this HistoryEntry.


        :param update_time: The update_time of this HistoryEntry.  # noqa: E501
        :type: int
        """

        self._update_time = update_time

    @property
    def update_user(self):
        """Gets the update_user of this HistoryEntry.  # noqa: E501


        :return: The update_user of this HistoryEntry.  # noqa: E501
        :rtype: str
        """
        return self._update_user

    @update_user.setter
    def update_user(self, update_user):
        """Sets the update_user of this HistoryEntry.


        :param update_user: The update_user of this HistoryEntry.  # noqa: E501
        :type: str
        """

        self._update_user = update_user

    @property
    def version(self):
        """Gets the version of this HistoryEntry.  # noqa: E501


        :return: The version of this HistoryEntry.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this HistoryEntry.


        :param version: The version of this HistoryEntry.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HistoryEntry, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoryEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoryEntry):
            return True

        return self.to_dict() != other.to_dict()
