# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class GlobalAlertAnalytic(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'error_breakdown': 'dict(str, int)',
        'failed': 'int',
        'success': 'int'
    }

    attribute_map = {
        'error_breakdown': 'errorBreakdown',
        'failed': 'failed',
        'success': 'success'
    }

    def __init__(self, error_breakdown=None, failed=None, success=None, _configuration=None):  # noqa: E501
        """GlobalAlertAnalytic - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._error_breakdown = None
        self._failed = None
        self._success = None
        self.discriminator = None

        if error_breakdown is not None:
            self.error_breakdown = error_breakdown
        if failed is not None:
            self.failed = failed
        if success is not None:
            self.success = success

    @property
    def error_breakdown(self):
        """Gets the error_breakdown of this GlobalAlertAnalytic.  # noqa: E501


        :return: The error_breakdown of this GlobalAlertAnalytic.  # noqa: E501
        :rtype: dict(str, int)
        """
        return self._error_breakdown

    @error_breakdown.setter
    def error_breakdown(self, error_breakdown):
        """Sets the error_breakdown of this GlobalAlertAnalytic.


        :param error_breakdown: The error_breakdown of this GlobalAlertAnalytic.  # noqa: E501
        :type: dict(str, int)
        """

        self._error_breakdown = error_breakdown

    @property
    def failed(self):
        """Gets the failed of this GlobalAlertAnalytic.  # noqa: E501


        :return: The failed of this GlobalAlertAnalytic.  # noqa: E501
        :rtype: int
        """
        return self._failed

    @failed.setter
    def failed(self, failed):
        """Sets the failed of this GlobalAlertAnalytic.


        :param failed: The failed of this GlobalAlertAnalytic.  # noqa: E501
        :type: int
        """

        self._failed = failed

    @property
    def success(self):
        """Gets the success of this GlobalAlertAnalytic.  # noqa: E501


        :return: The success of this GlobalAlertAnalytic.  # noqa: E501
        :rtype: int
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this GlobalAlertAnalytic.


        :param success: The success of this GlobalAlertAnalytic.  # noqa: E501
        :type: int
        """

        self._success = success

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GlobalAlertAnalytic, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GlobalAlertAnalytic):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GlobalAlertAnalytic):
            return True

        return self.to_dict() != other.to_dict()
