# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class GCPBillingConfiguration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gcp_api_key': 'str',
        'gcp_json_key': 'str',
        'project_id': 'str'
    }

    attribute_map = {
        'gcp_api_key': 'gcpApiKey',
        'gcp_json_key': 'gcpJsonKey',
        'project_id': 'projectId'
    }

    def __init__(self, gcp_api_key=None, gcp_json_key=None, project_id=None, _configuration=None):  # noqa: E501
        """GCPBillingConfiguration - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._gcp_api_key = None
        self._gcp_json_key = None
        self._project_id = None
        self.discriminator = None

        self.gcp_api_key = gcp_api_key
        self.gcp_json_key = gcp_json_key
        self.project_id = project_id

    @property
    def gcp_api_key(self):
        """Gets the gcp_api_key of this GCPBillingConfiguration.  # noqa: E501

        API key for Google Cloud Platform (GCP). Use 'saved_api_key' to retain existing API key when updating  # noqa: E501

        :return: The gcp_api_key of this GCPBillingConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._gcp_api_key

    @gcp_api_key.setter
    def gcp_api_key(self, gcp_api_key):
        """Sets the gcp_api_key of this GCPBillingConfiguration.

        API key for Google Cloud Platform (GCP). Use 'saved_api_key' to retain existing API key when updating  # noqa: E501

        :param gcp_api_key: The gcp_api_key of this GCPBillingConfiguration.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and gcp_api_key is None:
            raise ValueError("Invalid value for `gcp_api_key`, must not be `None`")  # noqa: E501

        self._gcp_api_key = gcp_api_key

    @property
    def gcp_json_key(self):
        """Gets the gcp_json_key of this GCPBillingConfiguration.  # noqa: E501

        Private key for a Google Cloud Platform (GCP) service account within your project.  The account must at least be granted Monitoring Viewer permissions.  This key must be in the JSON format generated by GCP. Use '{\"project_id\": \"%s\"}' to retain the existing key when updating.  # noqa: E501

        :return: The gcp_json_key of this GCPBillingConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._gcp_json_key

    @gcp_json_key.setter
    def gcp_json_key(self, gcp_json_key):
        """Sets the gcp_json_key of this GCPBillingConfiguration.

        Private key for a Google Cloud Platform (GCP) service account within your project.  The account must at least be granted Monitoring Viewer permissions.  This key must be in the JSON format generated by GCP. Use '{\"project_id\": \"%s\"}' to retain the existing key when updating.  # noqa: E501

        :param gcp_json_key: The gcp_json_key of this GCPBillingConfiguration.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and gcp_json_key is None:
            raise ValueError("Invalid value for `gcp_json_key`, must not be `None`")  # noqa: E501

        self._gcp_json_key = gcp_json_key

    @property
    def project_id(self):
        """Gets the project_id of this GCPBillingConfiguration.  # noqa: E501

        The Google Cloud Platform (GCP) project id.  # noqa: E501

        :return: The project_id of this GCPBillingConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this GCPBillingConfiguration.

        The Google Cloud Platform (GCP) project id.  # noqa: E501

        :param project_id: The project_id of this GCPBillingConfiguration.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and project_id is None:
            raise ValueError("Invalid value for `project_id`, must not be `None`")  # noqa: E501

        self._project_id = project_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GCPBillingConfiguration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GCPBillingConfiguration):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GCPBillingConfiguration):
            return True

        return self.to_dict() != other.to_dict()
