# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class FacetsSearchRequestContainer(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'facet_query': 'str',
        'facet_query_matching_method': 'str',
        'facets': 'list[str]',
        'limit': 'int',
        'query': 'list[SearchQuery]'
    }

    attribute_map = {
        'facet_query': 'facetQuery',
        'facet_query_matching_method': 'facetQueryMatchingMethod',
        'facets': 'facets',
        'limit': 'limit',
        'query': 'query'
    }

    def __init__(self, facet_query=None, facet_query_matching_method=None, facets=None, limit=None, query=None, _configuration=None):  # noqa: E501
        """FacetsSearchRequestContainer - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._facet_query = None
        self._facet_query_matching_method = None
        self._facets = None
        self._limit = None
        self._query = None
        self.discriminator = None

        if facet_query is not None:
            self.facet_query = facet_query
        if facet_query_matching_method is not None:
            self.facet_query_matching_method = facet_query_matching_method
        self.facets = facets
        if limit is not None:
            self.limit = limit
        if query is not None:
            self.query = query

    @property
    def facet_query(self):
        """Gets the facet_query of this FacetsSearchRequestContainer.  # noqa: E501

        A string against which facet results are compared.  If the facet result either CONTAINs, STARTSWITH, or is an EXACT match for this value, as specified by facetQueryMatchingMethod, then it is returned  # noqa: E501

        :return: The facet_query of this FacetsSearchRequestContainer.  # noqa: E501
        :rtype: str
        """
        return self._facet_query

    @facet_query.setter
    def facet_query(self, facet_query):
        """Sets the facet_query of this FacetsSearchRequestContainer.

        A string against which facet results are compared.  If the facet result either CONTAINs, STARTSWITH, or is an EXACT match for this value, as specified by facetQueryMatchingMethod, then it is returned  # noqa: E501

        :param facet_query: The facet_query of this FacetsSearchRequestContainer.  # noqa: E501
        :type: str
        """

        self._facet_query = facet_query

    @property
    def facet_query_matching_method(self):
        """Gets the facet_query_matching_method of this FacetsSearchRequestContainer.  # noqa: E501

        The matching method used to filter when 'facetQuery' is used. Defaults to CONTAINS.  # noqa: E501

        :return: The facet_query_matching_method of this FacetsSearchRequestContainer.  # noqa: E501
        :rtype: str
        """
        return self._facet_query_matching_method

    @facet_query_matching_method.setter
    def facet_query_matching_method(self, facet_query_matching_method):
        """Sets the facet_query_matching_method of this FacetsSearchRequestContainer.

        The matching method used to filter when 'facetQuery' is used. Defaults to CONTAINS.  # noqa: E501

        :param facet_query_matching_method: The facet_query_matching_method of this FacetsSearchRequestContainer.  # noqa: E501
        :type: str
        """
        allowed_values = ["CONTAINS", "STARTSWITH", "EXACT", "TAGPATH"]  # noqa: E501
        if (self._configuration.client_side_validation and
                facet_query_matching_method not in allowed_values):
            raise ValueError(
                "Invalid value for `facet_query_matching_method` ({0}), must be one of {1}"  # noqa: E501
                .format(facet_query_matching_method, allowed_values)
            )

        self._facet_query_matching_method = facet_query_matching_method

    @property
    def facets(self):
        """Gets the facets of this FacetsSearchRequestContainer.  # noqa: E501

        A list of facets (property keys) to return values from found in entities matching 'query'.  Examples are 'tags', 'creatorId', etc  # noqa: E501

        :return: The facets of this FacetsSearchRequestContainer.  # noqa: E501
        :rtype: list[str]
        """
        return self._facets

    @facets.setter
    def facets(self, facets):
        """Sets the facets of this FacetsSearchRequestContainer.

        A list of facets (property keys) to return values from found in entities matching 'query'.  Examples are 'tags', 'creatorId', etc  # noqa: E501

        :param facets: The facets of this FacetsSearchRequestContainer.  # noqa: E501
        :type: list[str]
        """
        if self._configuration.client_side_validation and facets is None:
            raise ValueError("Invalid value for `facets`, must not be `None`")  # noqa: E501

        self._facets = facets

    @property
    def limit(self):
        """Gets the limit of this FacetsSearchRequestContainer.  # noqa: E501

        The number of results to return.  Default 100, Maximum allowed: 1000  # noqa: E501

        :return: The limit of this FacetsSearchRequestContainer.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this FacetsSearchRequestContainer.

        The number of results to return.  Default 100, Maximum allowed: 1000  # noqa: E501

        :param limit: The limit of this FacetsSearchRequestContainer.  # noqa: E501
        :type: int
        """
        if (self._configuration.client_side_validation and
                limit is not None and limit > 1000):  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value less than or equal to `1000`")  # noqa: E501
        if (self._configuration.client_side_validation and
                limit is not None and limit < 1):  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value greater than or equal to `1`")  # noqa: E501

        self._limit = limit

    @property
    def query(self):
        """Gets the query of this FacetsSearchRequestContainer.  # noqa: E501

        A list of queries by which to limit the search results.  Entities that match ALL queries in this list constitute a set of 'entity search results'.  All facets listed in the 'facets' search parameter of all entities within 'entity search results' are scanned to produce the search results (of facet values).  # noqa: E501

        :return: The query of this FacetsSearchRequestContainer.  # noqa: E501
        :rtype: list[SearchQuery]
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this FacetsSearchRequestContainer.

        A list of queries by which to limit the search results.  Entities that match ALL queries in this list constitute a set of 'entity search results'.  All facets listed in the 'facets' search parameter of all entities within 'entity search results' are scanned to produce the search results (of facet values).  # noqa: E501

        :param query: The query of this FacetsSearchRequestContainer.  # noqa: E501
        :type: list[SearchQuery]
        """

        self._query = query

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FacetsSearchRequestContainer, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FacetsSearchRequestContainer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FacetsSearchRequestContainer):
            return True

        return self.to_dict() != other.to_dict()
