# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Conversion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'logical_type_name': 'str',
        'recommended_schema': 'Schema'
    }

    attribute_map = {
        'logical_type_name': 'logicalTypeName',
        'recommended_schema': 'recommendedSchema'
    }

    def __init__(self, logical_type_name=None, recommended_schema=None, _configuration=None):  # noqa: E501
        """Conversion - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._logical_type_name = None
        self._recommended_schema = None
        self.discriminator = None

        if logical_type_name is not None:
            self.logical_type_name = logical_type_name
        if recommended_schema is not None:
            self.recommended_schema = recommended_schema

    @property
    def logical_type_name(self):
        """Gets the logical_type_name of this Conversion.  # noqa: E501


        :return: The logical_type_name of this Conversion.  # noqa: E501
        :rtype: str
        """
        return self._logical_type_name

    @logical_type_name.setter
    def logical_type_name(self, logical_type_name):
        """Sets the logical_type_name of this Conversion.


        :param logical_type_name: The logical_type_name of this Conversion.  # noqa: E501
        :type: str
        """

        self._logical_type_name = logical_type_name

    @property
    def recommended_schema(self):
        """Gets the recommended_schema of this Conversion.  # noqa: E501


        :return: The recommended_schema of this Conversion.  # noqa: E501
        :rtype: Schema
        """
        return self._recommended_schema

    @recommended_schema.setter
    def recommended_schema(self, recommended_schema):
        """Sets the recommended_schema of this Conversion.


        :param recommended_schema: The recommended_schema of this Conversion.  # noqa: E501
        :type: Schema
        """

        self._recommended_schema = recommended_schema

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Conversion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Conversion):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Conversion):
            return True

        return self.to_dict() != other.to_dict()
