# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class AppSearchFilterValue(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'array_value': 'list[str]',
        'logical_value': 'list[list[str]]',
        'string_value': 'str'
    }

    attribute_map = {
        'array_value': 'arrayValue',
        'logical_value': 'logicalValue',
        'string_value': 'stringValue'
    }

    def __init__(self, array_value=None, logical_value=None, string_value=None, _configuration=None):  # noqa: E501
        """AppSearchFilterValue - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._array_value = None
        self._logical_value = None
        self._string_value = None
        self.discriminator = None

        if array_value is not None:
            self.array_value = array_value
        if logical_value is not None:
            self.logical_value = logical_value
        if string_value is not None:
            self.string_value = string_value

    @property
    def array_value(self):
        """Gets the array_value of this AppSearchFilterValue.  # noqa: E501


        :return: The array_value of this AppSearchFilterValue.  # noqa: E501
        :rtype: list[str]
        """
        return self._array_value

    @array_value.setter
    def array_value(self, array_value):
        """Sets the array_value of this AppSearchFilterValue.


        :param array_value: The array_value of this AppSearchFilterValue.  # noqa: E501
        :type: list[str]
        """

        self._array_value = array_value

    @property
    def logical_value(self):
        """Gets the logical_value of this AppSearchFilterValue.  # noqa: E501


        :return: The logical_value of this AppSearchFilterValue.  # noqa: E501
        :rtype: list[list[str]]
        """
        return self._logical_value

    @logical_value.setter
    def logical_value(self, logical_value):
        """Sets the logical_value of this AppSearchFilterValue.


        :param logical_value: The logical_value of this AppSearchFilterValue.  # noqa: E501
        :type: list[list[str]]
        """

        self._logical_value = logical_value

    @property
    def string_value(self):
        """Gets the string_value of this AppSearchFilterValue.  # noqa: E501


        :return: The string_value of this AppSearchFilterValue.  # noqa: E501
        :rtype: str
        """
        return self._string_value

    @string_value.setter
    def string_value(self, string_value):
        """Sets the string_value of this AppSearchFilterValue.


        :param string_value: The string_value of this AppSearchFilterValue.  # noqa: E501
        :type: str
        """

        self._string_value = string_value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AppSearchFilterValue, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AppSearchFilterValue):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AppSearchFilterValue):
            return True

        return self.to_dict() != other.to_dict()
