# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Alert(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'acl': 'AccessControlListSimple',
        'active_maintenance_windows': 'list[str]',
        'additional_information': 'str',
        'alert_chart_base': 'int',
        'alert_chart_description': 'str',
        'alert_chart_units': 'str',
        'alert_sources': 'list[AlertSource]',
        'alert_triage_dashboards': 'list[AlertDashboard]',
        'alert_type': 'str',
        'alerts_last_day': 'int',
        'alerts_last_month': 'int',
        'alerts_last_week': 'int',
        'application': 'list[str]',
        'chart_attributes': 'JsonNode',
        'chart_settings': 'ChartSettings',
        'condition': 'str',
        'condition_qb_enabled': 'bool',
        'condition_qb_serialization': 'str',
        'condition_query_type': 'str',
        'conditions': 'dict(str, str)',
        'create_user_id': 'str',
        'created': 'int',
        'created_epoch_millis': 'int',
        'creator_id': 'str',
        'deleted': 'bool',
        'display_expression': 'str',
        'display_expression_qb_enabled': 'bool',
        'display_expression_qb_serialization': 'str',
        'display_expression_query_type': 'str',
        'enable_pd_incident_by_series': 'bool',
        'evaluate_realtime_data': 'bool',
        'event': 'Event',
        'failing_host_label_pair_links': 'list[str]',
        'failing_host_label_pairs': 'list[SourceLabelPair]',
        'hidden': 'bool',
        'hosts_used': 'list[str]',
        'id': 'str',
        'in_maintenance_host_label_pairs': 'list[SourceLabelPair]',
        'in_trash': 'bool',
        'include_obsolete_metrics': 'bool',
        'ingestion_policy_id': 'str',
        'last_error_message': 'str',
        'last_event_time': 'int',
        'last_failed_time': 'int',
        'last_notification_millis': 'int',
        'last_processed_millis': 'int',
        'last_query_time': 'int',
        'metrics_used': 'list[str]',
        'minutes': 'int',
        'modify_acl_access': 'bool',
        'name': 'str',
        'no_data_event': 'Event',
        'notificants': 'list[str]',
        'notification_resend_frequency_minutes': 'int',
        'num_points_in_failure_frame': 'int',
        'orphan': 'bool',
        'points_scanned_at_last_query': 'int',
        'prefiring_host_label_pairs': 'list[SourceLabelPair]',
        'process_rate_minutes': 'int',
        'query_failing': 'bool',
        'query_syntax_error': 'bool',
        'resolve_after_minutes': 'int',
        'runbook_links': 'list[str]',
        'secure_metric_details': 'bool',
        'service': 'list[str]',
        'severity': 'str',
        'severity_list': 'list[str]',
        'snoozed': 'int',
        'sort_attr': 'int',
        'status': 'list[str]',
        'system_alert_version': 'int',
        'system_owned': 'bool',
        'tagpaths': 'list[str]',
        'tags': 'WFTags',
        'target': 'str',
        'target_endpoints': 'list[str]',
        'target_info': 'list[TargetInfo]',
        'targets': 'dict(str, str)',
        'triage_dashboards': 'list[TriageDashboard]',
        'update_user_id': 'str',
        'updated': 'int',
        'updated_epoch_millis': 'int',
        'updater_id': 'str'
    }

    attribute_map = {
        'acl': 'acl',
        'active_maintenance_windows': 'activeMaintenanceWindows',
        'additional_information': 'additionalInformation',
        'alert_chart_base': 'alertChartBase',
        'alert_chart_description': 'alertChartDescription',
        'alert_chart_units': 'alertChartUnits',
        'alert_sources': 'alertSources',
        'alert_triage_dashboards': 'alertTriageDashboards',
        'alert_type': 'alertType',
        'alerts_last_day': 'alertsLastDay',
        'alerts_last_month': 'alertsLastMonth',
        'alerts_last_week': 'alertsLastWeek',
        'application': 'application',
        'chart_attributes': 'chartAttributes',
        'chart_settings': 'chartSettings',
        'condition': 'condition',
        'condition_qb_enabled': 'conditionQBEnabled',
        'condition_qb_serialization': 'conditionQBSerialization',
        'condition_query_type': 'conditionQueryType',
        'conditions': 'conditions',
        'create_user_id': 'createUserId',
        'created': 'created',
        'created_epoch_millis': 'createdEpochMillis',
        'creator_id': 'creatorId',
        'deleted': 'deleted',
        'display_expression': 'displayExpression',
        'display_expression_qb_enabled': 'displayExpressionQBEnabled',
        'display_expression_qb_serialization': 'displayExpressionQBSerialization',
        'display_expression_query_type': 'displayExpressionQueryType',
        'enable_pd_incident_by_series': 'enablePDIncidentBySeries',
        'evaluate_realtime_data': 'evaluateRealtimeData',
        'event': 'event',
        'failing_host_label_pair_links': 'failingHostLabelPairLinks',
        'failing_host_label_pairs': 'failingHostLabelPairs',
        'hidden': 'hidden',
        'hosts_used': 'hostsUsed',
        'id': 'id',
        'in_maintenance_host_label_pairs': 'inMaintenanceHostLabelPairs',
        'in_trash': 'inTrash',
        'include_obsolete_metrics': 'includeObsoleteMetrics',
        'ingestion_policy_id': 'ingestionPolicyId',
        'last_error_message': 'lastErrorMessage',
        'last_event_time': 'lastEventTime',
        'last_failed_time': 'lastFailedTime',
        'last_notification_millis': 'lastNotificationMillis',
        'last_processed_millis': 'lastProcessedMillis',
        'last_query_time': 'lastQueryTime',
        'metrics_used': 'metricsUsed',
        'minutes': 'minutes',
        'modify_acl_access': 'modifyAclAccess',
        'name': 'name',
        'no_data_event': 'noDataEvent',
        'notificants': 'notificants',
        'notification_resend_frequency_minutes': 'notificationResendFrequencyMinutes',
        'num_points_in_failure_frame': 'numPointsInFailureFrame',
        'orphan': 'orphan',
        'points_scanned_at_last_query': 'pointsScannedAtLastQuery',
        'prefiring_host_label_pairs': 'prefiringHostLabelPairs',
        'process_rate_minutes': 'processRateMinutes',
        'query_failing': 'queryFailing',
        'query_syntax_error': 'querySyntaxError',
        'resolve_after_minutes': 'resolveAfterMinutes',
        'runbook_links': 'runbookLinks',
        'secure_metric_details': 'secureMetricDetails',
        'service': 'service',
        'severity': 'severity',
        'severity_list': 'severityList',
        'snoozed': 'snoozed',
        'sort_attr': 'sortAttr',
        'status': 'status',
        'system_alert_version': 'systemAlertVersion',
        'system_owned': 'systemOwned',
        'tagpaths': 'tagpaths',
        'tags': 'tags',
        'target': 'target',
        'target_endpoints': 'targetEndpoints',
        'target_info': 'targetInfo',
        'targets': 'targets',
        'triage_dashboards': 'triageDashboards',
        'update_user_id': 'updateUserId',
        'updated': 'updated',
        'updated_epoch_millis': 'updatedEpochMillis',
        'updater_id': 'updaterId'
    }

    def __init__(self, acl=None, active_maintenance_windows=None, additional_information=None, alert_chart_base=None, alert_chart_description=None, alert_chart_units=None, alert_sources=None, alert_triage_dashboards=None, alert_type=None, alerts_last_day=None, alerts_last_month=None, alerts_last_week=None, application=None, chart_attributes=None, chart_settings=None, condition=None, condition_qb_enabled=None, condition_qb_serialization=None, condition_query_type=None, conditions=None, create_user_id=None, created=None, created_epoch_millis=None, creator_id=None, deleted=None, display_expression=None, display_expression_qb_enabled=None, display_expression_qb_serialization=None, display_expression_query_type=None, enable_pd_incident_by_series=None, evaluate_realtime_data=None, event=None, failing_host_label_pair_links=None, failing_host_label_pairs=None, hidden=None, hosts_used=None, id=None, in_maintenance_host_label_pairs=None, in_trash=None, include_obsolete_metrics=None, ingestion_policy_id=None, last_error_message=None, last_event_time=None, last_failed_time=None, last_notification_millis=None, last_processed_millis=None, last_query_time=None, metrics_used=None, minutes=None, modify_acl_access=None, name=None, no_data_event=None, notificants=None, notification_resend_frequency_minutes=None, num_points_in_failure_frame=None, orphan=None, points_scanned_at_last_query=None, prefiring_host_label_pairs=None, process_rate_minutes=None, query_failing=None, query_syntax_error=None, resolve_after_minutes=None, runbook_links=None, secure_metric_details=None, service=None, severity=None, severity_list=None, snoozed=None, sort_attr=None, status=None, system_alert_version=None, system_owned=None, tagpaths=None, tags=None, target=None, target_endpoints=None, target_info=None, targets=None, triage_dashboards=None, update_user_id=None, updated=None, updated_epoch_millis=None, updater_id=None, _configuration=None):  # noqa: E501
        """Alert - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._acl = None
        self._active_maintenance_windows = None
        self._additional_information = None
        self._alert_chart_base = None
        self._alert_chart_description = None
        self._alert_chart_units = None
        self._alert_sources = None
        self._alert_triage_dashboards = None
        self._alert_type = None
        self._alerts_last_day = None
        self._alerts_last_month = None
        self._alerts_last_week = None
        self._application = None
        self._chart_attributes = None
        self._chart_settings = None
        self._condition = None
        self._condition_qb_enabled = None
        self._condition_qb_serialization = None
        self._condition_query_type = None
        self._conditions = None
        self._create_user_id = None
        self._created = None
        self._created_epoch_millis = None
        self._creator_id = None
        self._deleted = None
        self._display_expression = None
        self._display_expression_qb_enabled = None
        self._display_expression_qb_serialization = None
        self._display_expression_query_type = None
        self._enable_pd_incident_by_series = None
        self._evaluate_realtime_data = None
        self._event = None
        self._failing_host_label_pair_links = None
        self._failing_host_label_pairs = None
        self._hidden = None
        self._hosts_used = None
        self._id = None
        self._in_maintenance_host_label_pairs = None
        self._in_trash = None
        self._include_obsolete_metrics = None
        self._ingestion_policy_id = None
        self._last_error_message = None
        self._last_event_time = None
        self._last_failed_time = None
        self._last_notification_millis = None
        self._last_processed_millis = None
        self._last_query_time = None
        self._metrics_used = None
        self._minutes = None
        self._modify_acl_access = None
        self._name = None
        self._no_data_event = None
        self._notificants = None
        self._notification_resend_frequency_minutes = None
        self._num_points_in_failure_frame = None
        self._orphan = None
        self._points_scanned_at_last_query = None
        self._prefiring_host_label_pairs = None
        self._process_rate_minutes = None
        self._query_failing = None
        self._query_syntax_error = None
        self._resolve_after_minutes = None
        self._runbook_links = None
        self._secure_metric_details = None
        self._service = None
        self._severity = None
        self._severity_list = None
        self._snoozed = None
        self._sort_attr = None
        self._status = None
        self._system_alert_version = None
        self._system_owned = None
        self._tagpaths = None
        self._tags = None
        self._target = None
        self._target_endpoints = None
        self._target_info = None
        self._targets = None
        self._triage_dashboards = None
        self._update_user_id = None
        self._updated = None
        self._updated_epoch_millis = None
        self._updater_id = None
        self.discriminator = None

        if acl is not None:
            self.acl = acl
        if active_maintenance_windows is not None:
            self.active_maintenance_windows = active_maintenance_windows
        if additional_information is not None:
            self.additional_information = additional_information
        if alert_chart_base is not None:
            self.alert_chart_base = alert_chart_base
        if alert_chart_description is not None:
            self.alert_chart_description = alert_chart_description
        if alert_chart_units is not None:
            self.alert_chart_units = alert_chart_units
        if alert_sources is not None:
            self.alert_sources = alert_sources
        if alert_triage_dashboards is not None:
            self.alert_triage_dashboards = alert_triage_dashboards
        if alert_type is not None:
            self.alert_type = alert_type
        if alerts_last_day is not None:
            self.alerts_last_day = alerts_last_day
        if alerts_last_month is not None:
            self.alerts_last_month = alerts_last_month
        if alerts_last_week is not None:
            self.alerts_last_week = alerts_last_week
        if application is not None:
            self.application = application
        if chart_attributes is not None:
            self.chart_attributes = chart_attributes
        if chart_settings is not None:
            self.chart_settings = chart_settings
        self.condition = condition
        if condition_qb_enabled is not None:
            self.condition_qb_enabled = condition_qb_enabled
        if condition_qb_serialization is not None:
            self.condition_qb_serialization = condition_qb_serialization
        if condition_query_type is not None:
            self.condition_query_type = condition_query_type
        if conditions is not None:
            self.conditions = conditions
        if create_user_id is not None:
            self.create_user_id = create_user_id
        if created is not None:
            self.created = created
        if created_epoch_millis is not None:
            self.created_epoch_millis = created_epoch_millis
        if creator_id is not None:
            self.creator_id = creator_id
        if deleted is not None:
            self.deleted = deleted
        if display_expression is not None:
            self.display_expression = display_expression
        if display_expression_qb_enabled is not None:
            self.display_expression_qb_enabled = display_expression_qb_enabled
        if display_expression_qb_serialization is not None:
            self.display_expression_qb_serialization = display_expression_qb_serialization
        if display_expression_query_type is not None:
            self.display_expression_query_type = display_expression_query_type
        if enable_pd_incident_by_series is not None:
            self.enable_pd_incident_by_series = enable_pd_incident_by_series
        if evaluate_realtime_data is not None:
            self.evaluate_realtime_data = evaluate_realtime_data
        if event is not None:
            self.event = event
        if failing_host_label_pair_links is not None:
            self.failing_host_label_pair_links = failing_host_label_pair_links
        if failing_host_label_pairs is not None:
            self.failing_host_label_pairs = failing_host_label_pairs
        if hidden is not None:
            self.hidden = hidden
        if hosts_used is not None:
            self.hosts_used = hosts_used
        if id is not None:
            self.id = id
        if in_maintenance_host_label_pairs is not None:
            self.in_maintenance_host_label_pairs = in_maintenance_host_label_pairs
        if in_trash is not None:
            self.in_trash = in_trash
        if include_obsolete_metrics is not None:
            self.include_obsolete_metrics = include_obsolete_metrics
        if ingestion_policy_id is not None:
            self.ingestion_policy_id = ingestion_policy_id
        if last_error_message is not None:
            self.last_error_message = last_error_message
        if last_event_time is not None:
            self.last_event_time = last_event_time
        if last_failed_time is not None:
            self.last_failed_time = last_failed_time
        if last_notification_millis is not None:
            self.last_notification_millis = last_notification_millis
        if last_processed_millis is not None:
            self.last_processed_millis = last_processed_millis
        if last_query_time is not None:
            self.last_query_time = last_query_time
        if metrics_used is not None:
            self.metrics_used = metrics_used
        self.minutes = minutes
        if modify_acl_access is not None:
            self.modify_acl_access = modify_acl_access
        self.name = name
        if no_data_event is not None:
            self.no_data_event = no_data_event
        if notificants is not None:
            self.notificants = notificants
        if notification_resend_frequency_minutes is not None:
            self.notification_resend_frequency_minutes = notification_resend_frequency_minutes
        if num_points_in_failure_frame is not None:
            self.num_points_in_failure_frame = num_points_in_failure_frame
        if orphan is not None:
            self.orphan = orphan
        if points_scanned_at_last_query is not None:
            self.points_scanned_at_last_query = points_scanned_at_last_query
        if prefiring_host_label_pairs is not None:
            self.prefiring_host_label_pairs = prefiring_host_label_pairs
        if process_rate_minutes is not None:
            self.process_rate_minutes = process_rate_minutes
        if query_failing is not None:
            self.query_failing = query_failing
        if query_syntax_error is not None:
            self.query_syntax_error = query_syntax_error
        if resolve_after_minutes is not None:
            self.resolve_after_minutes = resolve_after_minutes
        if runbook_links is not None:
            self.runbook_links = runbook_links
        if secure_metric_details is not None:
            self.secure_metric_details = secure_metric_details
        if service is not None:
            self.service = service
        if severity is not None:
            self.severity = severity
        if severity_list is not None:
            self.severity_list = severity_list
        if snoozed is not None:
            self.snoozed = snoozed
        if sort_attr is not None:
            self.sort_attr = sort_attr
        if status is not None:
            self.status = status
        if system_alert_version is not None:
            self.system_alert_version = system_alert_version
        if system_owned is not None:
            self.system_owned = system_owned
        if tagpaths is not None:
            self.tagpaths = tagpaths
        if tags is not None:
            self.tags = tags
        if target is not None:
            self.target = target
        if target_endpoints is not None:
            self.target_endpoints = target_endpoints
        if target_info is not None:
            self.target_info = target_info
        if targets is not None:
            self.targets = targets
        if triage_dashboards is not None:
            self.triage_dashboards = triage_dashboards
        if update_user_id is not None:
            self.update_user_id = update_user_id
        if updated is not None:
            self.updated = updated
        if updated_epoch_millis is not None:
            self.updated_epoch_millis = updated_epoch_millis
        if updater_id is not None:
            self.updater_id = updater_id

    @property
    def acl(self):
        """Gets the acl of this Alert.  # noqa: E501


        :return: The acl of this Alert.  # noqa: E501
        :rtype: AccessControlListSimple
        """
        return self._acl

    @acl.setter
    def acl(self, acl):
        """Sets the acl of this Alert.


        :param acl: The acl of this Alert.  # noqa: E501
        :type: AccessControlListSimple
        """

        self._acl = acl

    @property
    def active_maintenance_windows(self):
        """Gets the active_maintenance_windows of this Alert.  # noqa: E501

        The names of the active maintenance windows that are affecting this alert  # noqa: E501

        :return: The active_maintenance_windows of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._active_maintenance_windows

    @active_maintenance_windows.setter
    def active_maintenance_windows(self, active_maintenance_windows):
        """Sets the active_maintenance_windows of this Alert.

        The names of the active maintenance windows that are affecting this alert  # noqa: E501

        :param active_maintenance_windows: The active_maintenance_windows of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._active_maintenance_windows = active_maintenance_windows

    @property
    def additional_information(self):
        """Gets the additional_information of this Alert.  # noqa: E501

        User-supplied additional explanatory information for this alert.  Useful for linking runbooks, mitigations,, etc  # noqa: E501

        :return: The additional_information of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._additional_information

    @additional_information.setter
    def additional_information(self, additional_information):
        """Sets the additional_information of this Alert.

        User-supplied additional explanatory information for this alert.  Useful for linking runbooks, mitigations,, etc  # noqa: E501

        :param additional_information: The additional_information of this Alert.  # noqa: E501
        :type: str
        """

        self._additional_information = additional_information

    @property
    def alert_chart_base(self):
        """Gets the alert_chart_base of this Alert.  # noqa: E501

        The base of alert chart. A linear chart will have base as 1. A logarithmic chart will have the other base value.The value should be an integer and should greater than or equal to 1.  # noqa: E501

        :return: The alert_chart_base of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._alert_chart_base

    @alert_chart_base.setter
    def alert_chart_base(self, alert_chart_base):
        """Sets the alert_chart_base of this Alert.

        The base of alert chart. A linear chart will have base as 1. A logarithmic chart will have the other base value.The value should be an integer and should greater than or equal to 1.  # noqa: E501

        :param alert_chart_base: The alert_chart_base of this Alert.  # noqa: E501
        :type: int
        """

        self._alert_chart_base = alert_chart_base

    @property
    def alert_chart_description(self):
        """Gets the alert_chart_description of this Alert.  # noqa: E501

        The description of alert chart. Different from alert additional info, this is used to describe the characteristics of the chart.  # noqa: E501

        :return: The alert_chart_description of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._alert_chart_description

    @alert_chart_description.setter
    def alert_chart_description(self, alert_chart_description):
        """Sets the alert_chart_description of this Alert.

        The description of alert chart. Different from alert additional info, this is used to describe the characteristics of the chart.  # noqa: E501

        :param alert_chart_description: The alert_chart_description of this Alert.  # noqa: E501
        :type: str
        """

        self._alert_chart_description = alert_chart_description

    @property
    def alert_chart_units(self):
        """Gets the alert_chart_units of this Alert.  # noqa: E501

        The y-axis unit of Alert chart.  # noqa: E501

        :return: The alert_chart_units of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._alert_chart_units

    @alert_chart_units.setter
    def alert_chart_units(self, alert_chart_units):
        """Sets the alert_chart_units of this Alert.

        The y-axis unit of Alert chart.  # noqa: E501

        :param alert_chart_units: The alert_chart_units of this Alert.  # noqa: E501
        :type: str
        """

        self._alert_chart_units = alert_chart_units

    @property
    def alert_sources(self):
        """Gets the alert_sources of this Alert.  # noqa: E501

        A list of queries represent multiple queries in alert. It must contains at least one query with AlertSourceType as CONDITION.  # noqa: E501

        :return: The alert_sources of this Alert.  # noqa: E501
        :rtype: list[AlertSource]
        """
        return self._alert_sources

    @alert_sources.setter
    def alert_sources(self, alert_sources):
        """Sets the alert_sources of this Alert.

        A list of queries represent multiple queries in alert. It must contains at least one query with AlertSourceType as CONDITION.  # noqa: E501

        :param alert_sources: The alert_sources of this Alert.  # noqa: E501
        :type: list[AlertSource]
        """

        self._alert_sources = alert_sources

    @property
    def alert_triage_dashboards(self):
        """Gets the alert_triage_dashboards of this Alert.  # noqa: E501

        User-supplied dashboard and parameters to create dashboard links. Parameters must be specified as constants or variables. Constant parameters currently only supported  # noqa: E501

        :return: The alert_triage_dashboards of this Alert.  # noqa: E501
        :rtype: list[AlertDashboard]
        """
        return self._alert_triage_dashboards

    @alert_triage_dashboards.setter
    def alert_triage_dashboards(self, alert_triage_dashboards):
        """Sets the alert_triage_dashboards of this Alert.

        User-supplied dashboard and parameters to create dashboard links. Parameters must be specified as constants or variables. Constant parameters currently only supported  # noqa: E501

        :param alert_triage_dashboards: The alert_triage_dashboards of this Alert.  # noqa: E501
        :type: list[AlertDashboard]
        """

        self._alert_triage_dashboards = alert_triage_dashboards

    @property
    def alert_type(self):
        """Gets the alert_type of this Alert.  # noqa: E501

        Alert type.  # noqa: E501

        :return: The alert_type of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._alert_type

    @alert_type.setter
    def alert_type(self, alert_type):
        """Sets the alert_type of this Alert.

        Alert type.  # noqa: E501

        :param alert_type: The alert_type of this Alert.  # noqa: E501
        :type: str
        """
        allowed_values = ["CLASSIC", "THRESHOLD"]  # noqa: E501
        if (self._configuration.client_side_validation and
                alert_type not in allowed_values):
            raise ValueError(
                "Invalid value for `alert_type` ({0}), must be one of {1}"  # noqa: E501
                .format(alert_type, allowed_values)
            )

        self._alert_type = alert_type

    @property
    def alerts_last_day(self):
        """Gets the alerts_last_day of this Alert.  # noqa: E501


        :return: The alerts_last_day of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._alerts_last_day

    @alerts_last_day.setter
    def alerts_last_day(self, alerts_last_day):
        """Sets the alerts_last_day of this Alert.


        :param alerts_last_day: The alerts_last_day of this Alert.  # noqa: E501
        :type: int
        """

        self._alerts_last_day = alerts_last_day

    @property
    def alerts_last_month(self):
        """Gets the alerts_last_month of this Alert.  # noqa: E501


        :return: The alerts_last_month of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._alerts_last_month

    @alerts_last_month.setter
    def alerts_last_month(self, alerts_last_month):
        """Sets the alerts_last_month of this Alert.


        :param alerts_last_month: The alerts_last_month of this Alert.  # noqa: E501
        :type: int
        """

        self._alerts_last_month = alerts_last_month

    @property
    def alerts_last_week(self):
        """Gets the alerts_last_week of this Alert.  # noqa: E501


        :return: The alerts_last_week of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._alerts_last_week

    @alerts_last_week.setter
    def alerts_last_week(self, alerts_last_week):
        """Sets the alerts_last_week of this Alert.


        :param alerts_last_week: The alerts_last_week of this Alert.  # noqa: E501
        :type: int
        """

        self._alerts_last_week = alerts_last_week

    @property
    def application(self):
        """Gets the application of this Alert.  # noqa: E501

        Lists the applications from the failingHostLabelPair of the alert.  # noqa: E501

        :return: The application of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._application

    @application.setter
    def application(self, application):
        """Sets the application of this Alert.

        Lists the applications from the failingHostLabelPair of the alert.  # noqa: E501

        :param application: The application of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._application = application

    @property
    def chart_attributes(self):
        """Gets the chart_attributes of this Alert.  # noqa: E501

        Additional chart settings for the alert (e.g. pie chart has its chart settings in this section).  # noqa: E501

        :return: The chart_attributes of this Alert.  # noqa: E501
        :rtype: JsonNode
        """
        return self._chart_attributes

    @chart_attributes.setter
    def chart_attributes(self, chart_attributes):
        """Sets the chart_attributes of this Alert.

        Additional chart settings for the alert (e.g. pie chart has its chart settings in this section).  # noqa: E501

        :param chart_attributes: The chart_attributes of this Alert.  # noqa: E501
        :type: JsonNode
        """

        self._chart_attributes = chart_attributes

    @property
    def chart_settings(self):
        """Gets the chart_settings of this Alert.  # noqa: E501

        The old chart settings for the alert (e.g. chart type, chart range etc.).  # noqa: E501

        :return: The chart_settings of this Alert.  # noqa: E501
        :rtype: ChartSettings
        """
        return self._chart_settings

    @chart_settings.setter
    def chart_settings(self, chart_settings):
        """Sets the chart_settings of this Alert.

        The old chart settings for the alert (e.g. chart type, chart range etc.).  # noqa: E501

        :param chart_settings: The chart_settings of this Alert.  # noqa: E501
        :type: ChartSettings
        """

        self._chart_settings = chart_settings

    @property
    def condition(self):
        """Gets the condition of this Alert.  # noqa: E501

        A Wavefront query that is evaluated at regular intervals (default 1m).  The alert fires and notifications are triggered when a data series matching this query evaluates to a non-zero value for a set number of consecutive minutes  # noqa: E501

        :return: The condition of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this Alert.

        A Wavefront query that is evaluated at regular intervals (default 1m).  The alert fires and notifications are triggered when a data series matching this query evaluates to a non-zero value for a set number of consecutive minutes  # noqa: E501

        :param condition: The condition of this Alert.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and condition is None:
            raise ValueError("Invalid value for `condition`, must not be `None`")  # noqa: E501

        self._condition = condition

    @property
    def condition_qb_enabled(self):
        """Gets the condition_qb_enabled of this Alert.  # noqa: E501

        Whether the condition query was created using the Query Builder.  Default false  # noqa: E501

        :return: The condition_qb_enabled of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._condition_qb_enabled

    @condition_qb_enabled.setter
    def condition_qb_enabled(self, condition_qb_enabled):
        """Sets the condition_qb_enabled of this Alert.

        Whether the condition query was created using the Query Builder.  Default false  # noqa: E501

        :param condition_qb_enabled: The condition_qb_enabled of this Alert.  # noqa: E501
        :type: bool
        """

        self._condition_qb_enabled = condition_qb_enabled

    @property
    def condition_qb_serialization(self):
        """Gets the condition_qb_serialization of this Alert.  # noqa: E501

        The special serialization of the Query Builder that corresponds to the condition query.  Applicable only when conditionQBEnabled is true  # noqa: E501

        :return: The condition_qb_serialization of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._condition_qb_serialization

    @condition_qb_serialization.setter
    def condition_qb_serialization(self, condition_qb_serialization):
        """Sets the condition_qb_serialization of this Alert.

        The special serialization of the Query Builder that corresponds to the condition query.  Applicable only when conditionQBEnabled is true  # noqa: E501

        :param condition_qb_serialization: The condition_qb_serialization of this Alert.  # noqa: E501
        :type: str
        """

        self._condition_qb_serialization = condition_qb_serialization

    @property
    def condition_query_type(self):
        """Gets the condition_query_type of this Alert.  # noqa: E501


        :return: The condition_query_type of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._condition_query_type

    @condition_query_type.setter
    def condition_query_type(self, condition_query_type):
        """Sets the condition_query_type of this Alert.


        :param condition_query_type: The condition_query_type of this Alert.  # noqa: E501
        :type: str
        """
        allowed_values = ["WQL", "PROMQL", "HYBRID"]  # noqa: E501
        if (self._configuration.client_side_validation and
                condition_query_type not in allowed_values):
            raise ValueError(
                "Invalid value for `condition_query_type` ({0}), must be one of {1}"  # noqa: E501
                .format(condition_query_type, allowed_values)
            )

        self._condition_query_type = condition_query_type

    @property
    def conditions(self):
        """Gets the conditions of this Alert.  # noqa: E501

        Multi - alert conditions.  # noqa: E501

        :return: The conditions of this Alert.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """Sets the conditions of this Alert.

        Multi - alert conditions.  # noqa: E501

        :param conditions: The conditions of this Alert.  # noqa: E501
        :type: dict(str, str)
        """

        self._conditions = conditions

    @property
    def create_user_id(self):
        """Gets the create_user_id of this Alert.  # noqa: E501


        :return: The create_user_id of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._create_user_id

    @create_user_id.setter
    def create_user_id(self, create_user_id):
        """Sets the create_user_id of this Alert.


        :param create_user_id: The create_user_id of this Alert.  # noqa: E501
        :type: str
        """

        self._create_user_id = create_user_id

    @property
    def created(self):
        """Gets the created of this Alert.  # noqa: E501

        When this alert was created, in epoch millis  # noqa: E501

        :return: The created of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Alert.

        When this alert was created, in epoch millis  # noqa: E501

        :param created: The created of this Alert.  # noqa: E501
        :type: int
        """

        self._created = created

    @property
    def created_epoch_millis(self):
        """Gets the created_epoch_millis of this Alert.  # noqa: E501


        :return: The created_epoch_millis of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._created_epoch_millis

    @created_epoch_millis.setter
    def created_epoch_millis(self, created_epoch_millis):
        """Sets the created_epoch_millis of this Alert.


        :param created_epoch_millis: The created_epoch_millis of this Alert.  # noqa: E501
        :type: int
        """

        self._created_epoch_millis = created_epoch_millis

    @property
    def creator_id(self):
        """Gets the creator_id of this Alert.  # noqa: E501


        :return: The creator_id of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this Alert.


        :param creator_id: The creator_id of this Alert.  # noqa: E501
        :type: str
        """

        self._creator_id = creator_id

    @property
    def deleted(self):
        """Gets the deleted of this Alert.  # noqa: E501


        :return: The deleted of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this Alert.


        :param deleted: The deleted of this Alert.  # noqa: E501
        :type: bool
        """

        self._deleted = deleted

    @property
    def display_expression(self):
        """Gets the display_expression of this Alert.  # noqa: E501

        A second query whose results are displayed in the alert user interface instead of the condition query. This field is often used to display a version of the condition query with Boolean operators removed so that numerical values are plotted  # noqa: E501

        :return: The display_expression of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._display_expression

    @display_expression.setter
    def display_expression(self, display_expression):
        """Sets the display_expression of this Alert.

        A second query whose results are displayed in the alert user interface instead of the condition query. This field is often used to display a version of the condition query with Boolean operators removed so that numerical values are plotted  # noqa: E501

        :param display_expression: The display_expression of this Alert.  # noqa: E501
        :type: str
        """

        self._display_expression = display_expression

    @property
    def display_expression_qb_enabled(self):
        """Gets the display_expression_qb_enabled of this Alert.  # noqa: E501

        Whether the display expression query was created using the Query Builder. Default false  # noqa: E501

        :return: The display_expression_qb_enabled of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._display_expression_qb_enabled

    @display_expression_qb_enabled.setter
    def display_expression_qb_enabled(self, display_expression_qb_enabled):
        """Sets the display_expression_qb_enabled of this Alert.

        Whether the display expression query was created using the Query Builder. Default false  # noqa: E501

        :param display_expression_qb_enabled: The display_expression_qb_enabled of this Alert.  # noqa: E501
        :type: bool
        """

        self._display_expression_qb_enabled = display_expression_qb_enabled

    @property
    def display_expression_qb_serialization(self):
        """Gets the display_expression_qb_serialization of this Alert.  # noqa: E501

        The special serialization of the Query Builder that corresponds to the display expression query.  Applicable only when displayExpressionQBEnabled is true  # noqa: E501

        :return: The display_expression_qb_serialization of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._display_expression_qb_serialization

    @display_expression_qb_serialization.setter
    def display_expression_qb_serialization(self, display_expression_qb_serialization):
        """Sets the display_expression_qb_serialization of this Alert.

        The special serialization of the Query Builder that corresponds to the display expression query.  Applicable only when displayExpressionQBEnabled is true  # noqa: E501

        :param display_expression_qb_serialization: The display_expression_qb_serialization of this Alert.  # noqa: E501
        :type: str
        """

        self._display_expression_qb_serialization = display_expression_qb_serialization

    @property
    def display_expression_query_type(self):
        """Gets the display_expression_query_type of this Alert.  # noqa: E501


        :return: The display_expression_query_type of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._display_expression_query_type

    @display_expression_query_type.setter
    def display_expression_query_type(self, display_expression_query_type):
        """Sets the display_expression_query_type of this Alert.


        :param display_expression_query_type: The display_expression_query_type of this Alert.  # noqa: E501
        :type: str
        """
        allowed_values = ["WQL", "PROMQL", "HYBRID"]  # noqa: E501
        if (self._configuration.client_side_validation and
                display_expression_query_type not in allowed_values):
            raise ValueError(
                "Invalid value for `display_expression_query_type` ({0}), must be one of {1}"  # noqa: E501
                .format(display_expression_query_type, allowed_values)
            )

        self._display_expression_query_type = display_expression_query_type

    @property
    def enable_pd_incident_by_series(self):
        """Gets the enable_pd_incident_by_series of this Alert.  # noqa: E501


        :return: The enable_pd_incident_by_series of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._enable_pd_incident_by_series

    @enable_pd_incident_by_series.setter
    def enable_pd_incident_by_series(self, enable_pd_incident_by_series):
        """Sets the enable_pd_incident_by_series of this Alert.


        :param enable_pd_incident_by_series: The enable_pd_incident_by_series of this Alert.  # noqa: E501
        :type: bool
        """

        self._enable_pd_incident_by_series = enable_pd_incident_by_series

    @property
    def evaluate_realtime_data(self):
        """Gets the evaluate_realtime_data of this Alert.  # noqa: E501

        Whether to alert on the real-time ingestion stream (may be noisy due to late data)  # noqa: E501

        :return: The evaluate_realtime_data of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._evaluate_realtime_data

    @evaluate_realtime_data.setter
    def evaluate_realtime_data(self, evaluate_realtime_data):
        """Sets the evaluate_realtime_data of this Alert.

        Whether to alert on the real-time ingestion stream (may be noisy due to late data)  # noqa: E501

        :param evaluate_realtime_data: The evaluate_realtime_data of this Alert.  # noqa: E501
        :type: bool
        """

        self._evaluate_realtime_data = evaluate_realtime_data

    @property
    def event(self):
        """Gets the event of this Alert.  # noqa: E501


        :return: The event of this Alert.  # noqa: E501
        :rtype: Event
        """
        return self._event

    @event.setter
    def event(self, event):
        """Sets the event of this Alert.


        :param event: The event of this Alert.  # noqa: E501
        :type: Event
        """

        self._event = event

    @property
    def failing_host_label_pair_links(self):
        """Gets the failing_host_label_pair_links of this Alert.  # noqa: E501

        List of links to tracing applications that caused a failing series  # noqa: E501

        :return: The failing_host_label_pair_links of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._failing_host_label_pair_links

    @failing_host_label_pair_links.setter
    def failing_host_label_pair_links(self, failing_host_label_pair_links):
        """Sets the failing_host_label_pair_links of this Alert.

        List of links to tracing applications that caused a failing series  # noqa: E501

        :param failing_host_label_pair_links: The failing_host_label_pair_links of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._failing_host_label_pair_links = failing_host_label_pair_links

    @property
    def failing_host_label_pairs(self):
        """Gets the failing_host_label_pairs of this Alert.  # noqa: E501

        Failing host/metric pairs  # noqa: E501

        :return: The failing_host_label_pairs of this Alert.  # noqa: E501
        :rtype: list[SourceLabelPair]
        """
        return self._failing_host_label_pairs

    @failing_host_label_pairs.setter
    def failing_host_label_pairs(self, failing_host_label_pairs):
        """Sets the failing_host_label_pairs of this Alert.

        Failing host/metric pairs  # noqa: E501

        :param failing_host_label_pairs: The failing_host_label_pairs of this Alert.  # noqa: E501
        :type: list[SourceLabelPair]
        """

        self._failing_host_label_pairs = failing_host_label_pairs

    @property
    def hidden(self):
        """Gets the hidden of this Alert.  # noqa: E501


        :return: The hidden of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """Sets the hidden of this Alert.


        :param hidden: The hidden of this Alert.  # noqa: E501
        :type: bool
        """

        self._hidden = hidden

    @property
    def hosts_used(self):
        """Gets the hosts_used of this Alert.  # noqa: E501

        Number of hosts checked by the alert condition  # noqa: E501

        :return: The hosts_used of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._hosts_used

    @hosts_used.setter
    def hosts_used(self, hosts_used):
        """Sets the hosts_used of this Alert.

        Number of hosts checked by the alert condition  # noqa: E501

        :param hosts_used: The hosts_used of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._hosts_used = hosts_used

    @property
    def id(self):
        """Gets the id of this Alert.  # noqa: E501


        :return: The id of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Alert.


        :param id: The id of this Alert.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def in_maintenance_host_label_pairs(self):
        """Gets the in_maintenance_host_label_pairs of this Alert.  # noqa: E501

        Lists the sources that will not be checked for this alert, due to matching a maintenance window  # noqa: E501

        :return: The in_maintenance_host_label_pairs of this Alert.  # noqa: E501
        :rtype: list[SourceLabelPair]
        """
        return self._in_maintenance_host_label_pairs

    @in_maintenance_host_label_pairs.setter
    def in_maintenance_host_label_pairs(self, in_maintenance_host_label_pairs):
        """Sets the in_maintenance_host_label_pairs of this Alert.

        Lists the sources that will not be checked for this alert, due to matching a maintenance window  # noqa: E501

        :param in_maintenance_host_label_pairs: The in_maintenance_host_label_pairs of this Alert.  # noqa: E501
        :type: list[SourceLabelPair]
        """

        self._in_maintenance_host_label_pairs = in_maintenance_host_label_pairs

    @property
    def in_trash(self):
        """Gets the in_trash of this Alert.  # noqa: E501


        :return: The in_trash of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._in_trash

    @in_trash.setter
    def in_trash(self, in_trash):
        """Sets the in_trash of this Alert.


        :param in_trash: The in_trash of this Alert.  # noqa: E501
        :type: bool
        """

        self._in_trash = in_trash

    @property
    def include_obsolete_metrics(self):
        """Gets the include_obsolete_metrics of this Alert.  # noqa: E501

        Whether to include obsolete metrics in alert query  # noqa: E501

        :return: The include_obsolete_metrics of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._include_obsolete_metrics

    @include_obsolete_metrics.setter
    def include_obsolete_metrics(self, include_obsolete_metrics):
        """Sets the include_obsolete_metrics of this Alert.

        Whether to include obsolete metrics in alert query  # noqa: E501

        :param include_obsolete_metrics: The include_obsolete_metrics of this Alert.  # noqa: E501
        :type: bool
        """

        self._include_obsolete_metrics = include_obsolete_metrics

    @property
    def ingestion_policy_id(self):
        """Gets the ingestion_policy_id of this Alert.  # noqa: E501

        Get the ingestion policy Id associated with ingestion policy alert.  # noqa: E501

        :return: The ingestion_policy_id of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._ingestion_policy_id

    @ingestion_policy_id.setter
    def ingestion_policy_id(self, ingestion_policy_id):
        """Sets the ingestion_policy_id of this Alert.

        Get the ingestion policy Id associated with ingestion policy alert.  # noqa: E501

        :param ingestion_policy_id: The ingestion_policy_id of this Alert.  # noqa: E501
        :type: str
        """

        self._ingestion_policy_id = ingestion_policy_id

    @property
    def last_error_message(self):
        """Gets the last_error_message of this Alert.  # noqa: E501

        The last error encountered when running this alert's condition query  # noqa: E501

        :return: The last_error_message of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._last_error_message

    @last_error_message.setter
    def last_error_message(self, last_error_message):
        """Sets the last_error_message of this Alert.

        The last error encountered when running this alert's condition query  # noqa: E501

        :param last_error_message: The last_error_message of this Alert.  # noqa: E501
        :type: str
        """

        self._last_error_message = last_error_message

    @property
    def last_event_time(self):
        """Gets the last_event_time of this Alert.  # noqa: E501

        Start time (in epoch millis) of the last event associated with this alert.  # noqa: E501

        :return: The last_event_time of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._last_event_time

    @last_event_time.setter
    def last_event_time(self, last_event_time):
        """Sets the last_event_time of this Alert.

        Start time (in epoch millis) of the last event associated with this alert.  # noqa: E501

        :param last_event_time: The last_event_time of this Alert.  # noqa: E501
        :type: int
        """

        self._last_event_time = last_event_time

    @property
    def last_failed_time(self):
        """Gets the last_failed_time of this Alert.  # noqa: E501

        The time of the last error encountered when running this alert's condition query, in epoch millis  # noqa: E501

        :return: The last_failed_time of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._last_failed_time

    @last_failed_time.setter
    def last_failed_time(self, last_failed_time):
        """Sets the last_failed_time of this Alert.

        The time of the last error encountered when running this alert's condition query, in epoch millis  # noqa: E501

        :param last_failed_time: The last_failed_time of this Alert.  # noqa: E501
        :type: int
        """

        self._last_failed_time = last_failed_time

    @property
    def last_notification_millis(self):
        """Gets the last_notification_millis of this Alert.  # noqa: E501

        When this alert last caused a notification, in epoch millis  # noqa: E501

        :return: The last_notification_millis of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._last_notification_millis

    @last_notification_millis.setter
    def last_notification_millis(self, last_notification_millis):
        """Sets the last_notification_millis of this Alert.

        When this alert last caused a notification, in epoch millis  # noqa: E501

        :param last_notification_millis: The last_notification_millis of this Alert.  # noqa: E501
        :type: int
        """

        self._last_notification_millis = last_notification_millis

    @property
    def last_processed_millis(self):
        """Gets the last_processed_millis of this Alert.  # noqa: E501

        The time when this alert was last checked, in epoch millis  # noqa: E501

        :return: The last_processed_millis of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._last_processed_millis

    @last_processed_millis.setter
    def last_processed_millis(self, last_processed_millis):
        """Sets the last_processed_millis of this Alert.

        The time when this alert was last checked, in epoch millis  # noqa: E501

        :param last_processed_millis: The last_processed_millis of this Alert.  # noqa: E501
        :type: int
        """

        self._last_processed_millis = last_processed_millis

    @property
    def last_query_time(self):
        """Gets the last_query_time of this Alert.  # noqa: E501

        Last query time of the alert, averaged on hourly basis  # noqa: E501

        :return: The last_query_time of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._last_query_time

    @last_query_time.setter
    def last_query_time(self, last_query_time):
        """Sets the last_query_time of this Alert.

        Last query time of the alert, averaged on hourly basis  # noqa: E501

        :param last_query_time: The last_query_time of this Alert.  # noqa: E501
        :type: int
        """

        self._last_query_time = last_query_time

    @property
    def metrics_used(self):
        """Gets the metrics_used of this Alert.  # noqa: E501

        Number of metrics checked by the alert condition  # noqa: E501

        :return: The metrics_used of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._metrics_used

    @metrics_used.setter
    def metrics_used(self, metrics_used):
        """Sets the metrics_used of this Alert.

        Number of metrics checked by the alert condition  # noqa: E501

        :param metrics_used: The metrics_used of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._metrics_used = metrics_used

    @property
    def minutes(self):
        """Gets the minutes of this Alert.  # noqa: E501

        The number of consecutive minutes that a series matching the condition query must evaluate to \"true\" (non-zero value) before the alert fires  # noqa: E501

        :return: The minutes of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._minutes

    @minutes.setter
    def minutes(self, minutes):
        """Sets the minutes of this Alert.

        The number of consecutive minutes that a series matching the condition query must evaluate to \"true\" (non-zero value) before the alert fires  # noqa: E501

        :param minutes: The minutes of this Alert.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and minutes is None:
            raise ValueError("Invalid value for `minutes`, must not be `None`")  # noqa: E501

        self._minutes = minutes

    @property
    def modify_acl_access(self):
        """Gets the modify_acl_access of this Alert.  # noqa: E501

        Whether the user has modify ACL access to the alert.  # noqa: E501

        :return: The modify_acl_access of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._modify_acl_access

    @modify_acl_access.setter
    def modify_acl_access(self, modify_acl_access):
        """Sets the modify_acl_access of this Alert.

        Whether the user has modify ACL access to the alert.  # noqa: E501

        :param modify_acl_access: The modify_acl_access of this Alert.  # noqa: E501
        :type: bool
        """

        self._modify_acl_access = modify_acl_access

    @property
    def name(self):
        """Gets the name of this Alert.  # noqa: E501


        :return: The name of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Alert.


        :param name: The name of this Alert.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def no_data_event(self):
        """Gets the no_data_event of this Alert.  # noqa: E501

        No data event related to the alert  # noqa: E501

        :return: The no_data_event of this Alert.  # noqa: E501
        :rtype: Event
        """
        return self._no_data_event

    @no_data_event.setter
    def no_data_event(self, no_data_event):
        """Sets the no_data_event of this Alert.

        No data event related to the alert  # noqa: E501

        :param no_data_event: The no_data_event of this Alert.  # noqa: E501
        :type: Event
        """

        self._no_data_event = no_data_event

    @property
    def notificants(self):
        """Gets the notificants of this Alert.  # noqa: E501

        A derived field listing the webhook ids used by this alert  # noqa: E501

        :return: The notificants of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._notificants

    @notificants.setter
    def notificants(self, notificants):
        """Sets the notificants of this Alert.

        A derived field listing the webhook ids used by this alert  # noqa: E501

        :param notificants: The notificants of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._notificants = notificants

    @property
    def notification_resend_frequency_minutes(self):
        """Gets the notification_resend_frequency_minutes of this Alert.  # noqa: E501

        How often to re-trigger a continually failing alert. If absent or <= 0, no retriggering occurs  # noqa: E501

        :return: The notification_resend_frequency_minutes of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._notification_resend_frequency_minutes

    @notification_resend_frequency_minutes.setter
    def notification_resend_frequency_minutes(self, notification_resend_frequency_minutes):
        """Sets the notification_resend_frequency_minutes of this Alert.

        How often to re-trigger a continually failing alert. If absent or <= 0, no retriggering occurs  # noqa: E501

        :param notification_resend_frequency_minutes: The notification_resend_frequency_minutes of this Alert.  # noqa: E501
        :type: int
        """

        self._notification_resend_frequency_minutes = notification_resend_frequency_minutes

    @property
    def num_points_in_failure_frame(self):
        """Gets the num_points_in_failure_frame of this Alert.  # noqa: E501

        Number of points scanned in alert query time frame.  # noqa: E501

        :return: The num_points_in_failure_frame of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._num_points_in_failure_frame

    @num_points_in_failure_frame.setter
    def num_points_in_failure_frame(self, num_points_in_failure_frame):
        """Sets the num_points_in_failure_frame of this Alert.

        Number of points scanned in alert query time frame.  # noqa: E501

        :param num_points_in_failure_frame: The num_points_in_failure_frame of this Alert.  # noqa: E501
        :type: int
        """

        self._num_points_in_failure_frame = num_points_in_failure_frame

    @property
    def orphan(self):
        """Gets the orphan of this Alert.  # noqa: E501


        :return: The orphan of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._orphan

    @orphan.setter
    def orphan(self, orphan):
        """Sets the orphan of this Alert.


        :param orphan: The orphan of this Alert.  # noqa: E501
        :type: bool
        """

        self._orphan = orphan

    @property
    def points_scanned_at_last_query(self):
        """Gets the points_scanned_at_last_query of this Alert.  # noqa: E501

        A derived field recording the number of data points scanned when the system last computed this alert's condition  # noqa: E501

        :return: The points_scanned_at_last_query of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._points_scanned_at_last_query

    @points_scanned_at_last_query.setter
    def points_scanned_at_last_query(self, points_scanned_at_last_query):
        """Sets the points_scanned_at_last_query of this Alert.

        A derived field recording the number of data points scanned when the system last computed this alert's condition  # noqa: E501

        :param points_scanned_at_last_query: The points_scanned_at_last_query of this Alert.  # noqa: E501
        :type: int
        """

        self._points_scanned_at_last_query = points_scanned_at_last_query

    @property
    def prefiring_host_label_pairs(self):
        """Gets the prefiring_host_label_pairs of this Alert.  # noqa: E501

        Lists the series that are starting to fail, defined as failing for greater than 50% of the checks in the window determined by the \"minutes\" parameter  # noqa: E501

        :return: The prefiring_host_label_pairs of this Alert.  # noqa: E501
        :rtype: list[SourceLabelPair]
        """
        return self._prefiring_host_label_pairs

    @prefiring_host_label_pairs.setter
    def prefiring_host_label_pairs(self, prefiring_host_label_pairs):
        """Sets the prefiring_host_label_pairs of this Alert.

        Lists the series that are starting to fail, defined as failing for greater than 50% of the checks in the window determined by the \"minutes\" parameter  # noqa: E501

        :param prefiring_host_label_pairs: The prefiring_host_label_pairs of this Alert.  # noqa: E501
        :type: list[SourceLabelPair]
        """

        self._prefiring_host_label_pairs = prefiring_host_label_pairs

    @property
    def process_rate_minutes(self):
        """Gets the process_rate_minutes of this Alert.  # noqa: E501

        The interval between checks for this alert, in minutes.  Defaults to 1 minute  # noqa: E501

        :return: The process_rate_minutes of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._process_rate_minutes

    @process_rate_minutes.setter
    def process_rate_minutes(self, process_rate_minutes):
        """Sets the process_rate_minutes of this Alert.

        The interval between checks for this alert, in minutes.  Defaults to 1 minute  # noqa: E501

        :param process_rate_minutes: The process_rate_minutes of this Alert.  # noqa: E501
        :type: int
        """

        self._process_rate_minutes = process_rate_minutes

    @property
    def query_failing(self):
        """Gets the query_failing of this Alert.  # noqa: E501

        Whether there was an exception when the alert condition last ran  # noqa: E501

        :return: The query_failing of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._query_failing

    @query_failing.setter
    def query_failing(self, query_failing):
        """Sets the query_failing of this Alert.

        Whether there was an exception when the alert condition last ran  # noqa: E501

        :param query_failing: The query_failing of this Alert.  # noqa: E501
        :type: bool
        """

        self._query_failing = query_failing

    @property
    def query_syntax_error(self):
        """Gets the query_syntax_error of this Alert.  # noqa: E501

        Whether there was an query syntax exception when the alert condition last ran  # noqa: E501

        :return: The query_syntax_error of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._query_syntax_error

    @query_syntax_error.setter
    def query_syntax_error(self, query_syntax_error):
        """Sets the query_syntax_error of this Alert.

        Whether there was an query syntax exception when the alert condition last ran  # noqa: E501

        :param query_syntax_error: The query_syntax_error of this Alert.  # noqa: E501
        :type: bool
        """

        self._query_syntax_error = query_syntax_error

    @property
    def resolve_after_minutes(self):
        """Gets the resolve_after_minutes of this Alert.  # noqa: E501

        The number of consecutive minutes that a firing series matching the condition query must evaluate to \"false\" (zero value) before the alert resolves.  When unset, this defaults to the same value as \"minutes\"  # noqa: E501

        :return: The resolve_after_minutes of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._resolve_after_minutes

    @resolve_after_minutes.setter
    def resolve_after_minutes(self, resolve_after_minutes):
        """Sets the resolve_after_minutes of this Alert.

        The number of consecutive minutes that a firing series matching the condition query must evaluate to \"false\" (zero value) before the alert resolves.  When unset, this defaults to the same value as \"minutes\"  # noqa: E501

        :param resolve_after_minutes: The resolve_after_minutes of this Alert.  # noqa: E501
        :type: int
        """

        self._resolve_after_minutes = resolve_after_minutes

    @property
    def runbook_links(self):
        """Gets the runbook_links of this Alert.  # noqa: E501

        User-supplied runbook links for this alert. Useful for linking wiki page or documentation, etc to refer to when alert is triggered  # noqa: E501

        :return: The runbook_links of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._runbook_links

    @runbook_links.setter
    def runbook_links(self, runbook_links):
        """Sets the runbook_links of this Alert.

        User-supplied runbook links for this alert. Useful for linking wiki page or documentation, etc to refer to when alert is triggered  # noqa: E501

        :param runbook_links: The runbook_links of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._runbook_links = runbook_links

    @property
    def secure_metric_details(self):
        """Gets the secure_metric_details of this Alert.  # noqa: E501

        Whether to secure sensitive metric details and alert images in alert notifications, to not break Metrics Security.  # noqa: E501

        :return: The secure_metric_details of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._secure_metric_details

    @secure_metric_details.setter
    def secure_metric_details(self, secure_metric_details):
        """Sets the secure_metric_details of this Alert.

        Whether to secure sensitive metric details and alert images in alert notifications, to not break Metrics Security.  # noqa: E501

        :param secure_metric_details: The secure_metric_details of this Alert.  # noqa: E501
        :type: bool
        """

        self._secure_metric_details = secure_metric_details

    @property
    def service(self):
        """Gets the service of this Alert.  # noqa: E501

        Lists the services from the failingHostLabelPair of the alert.  # noqa: E501

        :return: The service of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._service

    @service.setter
    def service(self, service):
        """Sets the service of this Alert.

        Lists the services from the failingHostLabelPair of the alert.  # noqa: E501

        :param service: The service of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._service = service

    @property
    def severity(self):
        """Gets the severity of this Alert.  # noqa: E501

        Severity of the alert  # noqa: E501

        :return: The severity of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this Alert.

        Severity of the alert  # noqa: E501

        :param severity: The severity of this Alert.  # noqa: E501
        :type: str
        """
        allowed_values = ["INFO", "SMOKE", "WARN", "SEVERE"]  # noqa: E501
        if (self._configuration.client_side_validation and
                severity not in allowed_values):
            raise ValueError(
                "Invalid value for `severity` ({0}), must be one of {1}"  # noqa: E501
                .format(severity, allowed_values)
            )

        self._severity = severity

    @property
    def severity_list(self):
        """Gets the severity_list of this Alert.  # noqa: E501

        Alert severity list for multi-threshold type.  # noqa: E501

        :return: The severity_list of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._severity_list

    @severity_list.setter
    def severity_list(self, severity_list):
        """Sets the severity_list of this Alert.

        Alert severity list for multi-threshold type.  # noqa: E501

        :param severity_list: The severity_list of this Alert.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["INFO", "SMOKE", "WARN", "SEVERE"]  # noqa: E501
        if (self._configuration.client_side_validation and
                not set(severity_list).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `severity_list` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(severity_list) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._severity_list = severity_list

    @property
    def snoozed(self):
        """Gets the snoozed of this Alert.  # noqa: E501

        The until which time this alert is snoozed (not checked), in epoch millis.  A negative value implies the alert is snoozed indefinitely  # noqa: E501

        :return: The snoozed of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._snoozed

    @snoozed.setter
    def snoozed(self, snoozed):
        """Sets the snoozed of this Alert.

        The until which time this alert is snoozed (not checked), in epoch millis.  A negative value implies the alert is snoozed indefinitely  # noqa: E501

        :param snoozed: The snoozed of this Alert.  # noqa: E501
        :type: int
        """

        self._snoozed = snoozed

    @property
    def sort_attr(self):
        """Gets the sort_attr of this Alert.  # noqa: E501

        Attribute used for default alert sort that is derived from state and severity  # noqa: E501

        :return: The sort_attr of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._sort_attr

    @sort_attr.setter
    def sort_attr(self, sort_attr):
        """Sets the sort_attr of this Alert.

        Attribute used for default alert sort that is derived from state and severity  # noqa: E501

        :param sort_attr: The sort_attr of this Alert.  # noqa: E501
        :type: int
        """

        self._sort_attr = sort_attr

    @property
    def status(self):
        """Gets the status of this Alert.  # noqa: E501

        Lists the current state of the alert. Can be one or more of: FIRING,SNOOZED, IN_MAINTENANCE, INVALID, NONE, CHECKING, TRASH, NO_DATA  # noqa: E501

        :return: The status of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Alert.

        Lists the current state of the alert. Can be one or more of: FIRING,SNOOZED, IN_MAINTENANCE, INVALID, NONE, CHECKING, TRASH, NO_DATA  # noqa: E501

        :param status: The status of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._status = status

    @property
    def system_alert_version(self):
        """Gets the system_alert_version of this Alert.  # noqa: E501

        If this is a system alert, the version of it  # noqa: E501

        :return: The system_alert_version of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._system_alert_version

    @system_alert_version.setter
    def system_alert_version(self, system_alert_version):
        """Sets the system_alert_version of this Alert.

        If this is a system alert, the version of it  # noqa: E501

        :param system_alert_version: The system_alert_version of this Alert.  # noqa: E501
        :type: int
        """

        self._system_alert_version = system_alert_version

    @property
    def system_owned(self):
        """Gets the system_owned of this Alert.  # noqa: E501

        Whether this alert is system-owned and not writeable  # noqa: E501

        :return: The system_owned of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._system_owned

    @system_owned.setter
    def system_owned(self, system_owned):
        """Sets the system_owned of this Alert.

        Whether this alert is system-owned and not writeable  # noqa: E501

        :param system_owned: The system_owned of this Alert.  # noqa: E501
        :type: bool
        """

        self._system_owned = system_owned

    @property
    def tagpaths(self):
        """Gets the tagpaths of this Alert.  # noqa: E501


        :return: The tagpaths of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._tagpaths

    @tagpaths.setter
    def tagpaths(self, tagpaths):
        """Sets the tagpaths of this Alert.


        :param tagpaths: The tagpaths of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._tagpaths = tagpaths

    @property
    def tags(self):
        """Gets the tags of this Alert.  # noqa: E501


        :return: The tags of this Alert.  # noqa: E501
        :rtype: WFTags
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Alert.


        :param tags: The tags of this Alert.  # noqa: E501
        :type: WFTags
        """

        self._tags = tags

    @property
    def target(self):
        """Gets the target of this Alert.  # noqa: E501

        The email address or integration endpoint (such as PagerDuty or web hook) to notify when the alert status changes. Comma-separated list of targets. Multiple target types can be in the list. Alert target format: ({email}|pd:{pd_key}|target:{alert target ID}). You cannot update this value.  # noqa: E501

        :return: The target of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this Alert.

        The email address or integration endpoint (such as PagerDuty or web hook) to notify when the alert status changes. Comma-separated list of targets. Multiple target types can be in the list. Alert target format: ({email}|pd:{pd_key}|target:{alert target ID}). You cannot update this value.  # noqa: E501

        :param target: The target of this Alert.  # noqa: E501
        :type: str
        """

        self._target = target

    @property
    def target_endpoints(self):
        """Gets the target_endpoints of this Alert.  # noqa: E501


        :return: The target_endpoints of this Alert.  # noqa: E501
        :rtype: list[str]
        """
        return self._target_endpoints

    @target_endpoints.setter
    def target_endpoints(self, target_endpoints):
        """Sets the target_endpoints of this Alert.


        :param target_endpoints: The target_endpoints of this Alert.  # noqa: E501
        :type: list[str]
        """

        self._target_endpoints = target_endpoints

    @property
    def target_info(self):
        """Gets the target_info of this Alert.  # noqa: E501

        List of alert targets display information that includes name, id and type.  # noqa: E501

        :return: The target_info of this Alert.  # noqa: E501
        :rtype: list[TargetInfo]
        """
        return self._target_info

    @target_info.setter
    def target_info(self, target_info):
        """Sets the target_info of this Alert.

        List of alert targets display information that includes name, id and type.  # noqa: E501

        :param target_info: The target_info of this Alert.  # noqa: E501
        :type: list[TargetInfo]
        """

        self._target_info = target_info

    @property
    def targets(self):
        """Gets the targets of this Alert.  # noqa: E501

        Targets for severity.  # noqa: E501

        :return: The targets of this Alert.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """Sets the targets of this Alert.

        Targets for severity.  # noqa: E501

        :param targets: The targets of this Alert.  # noqa: E501
        :type: dict(str, str)
        """

        self._targets = targets

    @property
    def triage_dashboards(self):
        """Gets the triage_dashboards of this Alert.  # noqa: E501

        Deprecated for alertTriageDashboards  # noqa: E501

        :return: The triage_dashboards of this Alert.  # noqa: E501
        :rtype: list[TriageDashboard]
        """
        return self._triage_dashboards

    @triage_dashboards.setter
    def triage_dashboards(self, triage_dashboards):
        """Sets the triage_dashboards of this Alert.

        Deprecated for alertTriageDashboards  # noqa: E501

        :param triage_dashboards: The triage_dashboards of this Alert.  # noqa: E501
        :type: list[TriageDashboard]
        """

        self._triage_dashboards = triage_dashboards

    @property
    def update_user_id(self):
        """Gets the update_user_id of this Alert.  # noqa: E501

        The user that last updated this alert  # noqa: E501

        :return: The update_user_id of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._update_user_id

    @update_user_id.setter
    def update_user_id(self, update_user_id):
        """Sets the update_user_id of this Alert.

        The user that last updated this alert  # noqa: E501

        :param update_user_id: The update_user_id of this Alert.  # noqa: E501
        :type: str
        """

        self._update_user_id = update_user_id

    @property
    def updated(self):
        """Gets the updated of this Alert.  # noqa: E501

        When the alert was last updated, in epoch millis  # noqa: E501

        :return: The updated of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """Sets the updated of this Alert.

        When the alert was last updated, in epoch millis  # noqa: E501

        :param updated: The updated of this Alert.  # noqa: E501
        :type: int
        """

        self._updated = updated

    @property
    def updated_epoch_millis(self):
        """Gets the updated_epoch_millis of this Alert.  # noqa: E501


        :return: The updated_epoch_millis of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._updated_epoch_millis

    @updated_epoch_millis.setter
    def updated_epoch_millis(self, updated_epoch_millis):
        """Sets the updated_epoch_millis of this Alert.


        :param updated_epoch_millis: The updated_epoch_millis of this Alert.  # noqa: E501
        :type: int
        """

        self._updated_epoch_millis = updated_epoch_millis

    @property
    def updater_id(self):
        """Gets the updater_id of this Alert.  # noqa: E501


        :return: The updater_id of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._updater_id

    @updater_id.setter
    def updater_id(self, updater_id):
        """Sets the updater_id of this Alert.


        :param updater_id: The updater_id of this Alert.  # noqa: E501
        :type: str
        """

        self._updater_id = updater_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Alert, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Alert):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Alert):
            return True

        return self.to_dict() != other.to_dict()
