# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from wavefront_api_client.api_client import ApiClient


class SearchApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def search_account_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_account_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_account_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_account_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_account_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_account_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_account_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/account', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedAccount',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_account_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_account_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_account_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_account_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_account_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_account_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_account_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_account_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/account/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_account_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_account_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_account_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_account_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_account_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_account_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_account_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/account/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_alert_deleted_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_deleted_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedAlert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_alert_deleted_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_alert_deleted_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_alert_deleted_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_deleted_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedAlert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_alert_deleted_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/alert/deleted', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedAlert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_alert_deleted_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_deleted_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_alert_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_alert_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_alert_deleted_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_deleted_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_alert_deleted_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_alert_deleted_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/alert/deleted/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_alert_deleted_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_deleted_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_alert_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_alert_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_alert_deleted_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_deleted_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_alert_deleted_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/alert/deleted/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_alert_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedAlertWithStats
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_alert_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_alert_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_alert_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedAlertWithStats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_alert_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/alert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedAlertWithStats',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_alert_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_alert_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_alert_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_alert_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_alert_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_alert_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/alert/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_alert_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_alert_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_alert_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_alert_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_alert_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_alert_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/alert/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_cloud_integration_deleted_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_deleted_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedCloudIntegration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_cloud_integration_deleted_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_cloud_integration_deleted_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_cloud_integration_deleted_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_deleted_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedCloudIntegration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_cloud_integration_deleted_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/cloudintegration/deleted', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedCloudIntegration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_cloud_integration_deleted_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_deleted_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_cloud_integration_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_cloud_integration_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_cloud_integration_deleted_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_deleted_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_cloud_integration_deleted_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_cloud_integration_deleted_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/cloudintegration/deleted/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_cloud_integration_deleted_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_deleted_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_cloud_integration_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_cloud_integration_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_cloud_integration_deleted_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_deleted_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_cloud_integration_deleted_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/cloudintegration/deleted/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_cloud_integration_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedCloudIntegration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_cloud_integration_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_cloud_integration_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_cloud_integration_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedCloudIntegration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_cloud_integration_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/cloudintegration', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedCloudIntegration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_cloud_integration_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_cloud_integration_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_cloud_integration_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_cloud_integration_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_cloud_integration_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_cloud_integration_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/cloudintegration/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_cloud_integration_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_cloud_integration_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_cloud_integration_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_cloud_integration_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted cloud integrations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_cloud_integration_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_cloud_integration_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/cloudintegration/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_dashboard_deleted_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_deleted_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedDashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_dashboard_deleted_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_dashboard_deleted_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_dashboard_deleted_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_deleted_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedDashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_dashboard_deleted_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/dashboard/deleted', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedDashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_dashboard_deleted_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_deleted_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_dashboard_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_dashboard_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_dashboard_deleted_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_deleted_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_dashboard_deleted_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_dashboard_deleted_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/dashboard/deleted/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_dashboard_deleted_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_deleted_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_dashboard_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_dashboard_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_dashboard_deleted_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_deleted_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_dashboard_deleted_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/dashboard/deleted/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_dashboard_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedDashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_dashboard_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_dashboard_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_dashboard_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedDashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_dashboard_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/dashboard', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedDashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_dashboard_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_dashboard_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_dashboard_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_dashboard_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_dashboard_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_dashboard_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/dashboard/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_dashboard_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_dashboard_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_dashboard_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_dashboard_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted dashboards  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_dashboard_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_dashboard_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/dashboard/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_external_link_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's external links  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_external_link_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedExternalLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_external_link_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_external_link_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_external_link_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's external links  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_external_link_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedExternalLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_external_link_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/extlink', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedExternalLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_external_links_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's external links  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_external_links_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_external_links_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_external_links_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_external_links_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's external links  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_external_links_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_external_links_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_external_links_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/extlink/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_external_links_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's external links  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_external_links_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_external_links_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_external_links_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_external_links_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's external links  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_external_links_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_external_links_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/extlink/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_ingestion_policy_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's ingestion policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_ingestion_policy_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedIngestionPolicyReadModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_ingestion_policy_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_ingestion_policy_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_ingestion_policy_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's ingestion policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_ingestion_policy_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedIngestionPolicyReadModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_ingestion_policy_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/ingestionpolicy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedIngestionPolicyReadModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_ingestion_policy_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's ingestion policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_ingestion_policy_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_ingestion_policy_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_ingestion_policy_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_ingestion_policy_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's ingestion policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_ingestion_policy_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_ingestion_policy_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_ingestion_policy_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/ingestionpolicy/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_ingestion_policy_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's ingestion policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_ingestion_policy_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_ingestion_policy_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_ingestion_policy_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_ingestion_policy_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's ingestion policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_ingestion_policy_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_ingestion_policy_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/ingestionpolicy/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_maintenance_window_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's maintenance windows  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_maintenance_window_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedMaintenanceWindow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_maintenance_window_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_maintenance_window_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_maintenance_window_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's maintenance windows  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_maintenance_window_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedMaintenanceWindow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_maintenance_window_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/maintenancewindow', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedMaintenanceWindow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_maintenance_window_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's maintenance windows  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_maintenance_window_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_maintenance_window_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_maintenance_window_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_maintenance_window_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's maintenance windows  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_maintenance_window_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_maintenance_window_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_maintenance_window_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/maintenancewindow/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_maintenance_window_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's maintenance windows  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_maintenance_window_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_maintenance_window_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_maintenance_window_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_maintenance_window_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's maintenance windows  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_maintenance_window_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_maintenance_window_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/maintenancewindow/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_monitored_application_entities(self, **kwargs):  # noqa: E501
        """Search over all the customer's non-deleted monitored applications  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_application_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedMonitoredApplicationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_monitored_application_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_monitored_application_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_monitored_application_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over all the customer's non-deleted monitored applications  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_application_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedMonitoredApplicationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_monitored_application_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/monitoredapplication', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedMonitoredApplicationDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_monitored_application_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted monitored application  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_application_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_monitored_application_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_monitored_application_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_monitored_application_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted monitored application  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_application_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_monitored_application_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_monitored_application_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/monitoredapplication/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_monitored_application_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted monitored clusters  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_application_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_monitored_application_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_monitored_application_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_monitored_application_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted monitored clusters  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_application_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_monitored_application_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/monitoredapplication/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_monitored_service_entities(self, **kwargs):  # noqa: E501
        """Search over all the customer's non-deleted monitored services  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_service_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedMonitoredServiceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_monitored_service_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_monitored_service_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_monitored_service_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over all the customer's non-deleted monitored services  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_service_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedMonitoredServiceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_monitored_service_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/monitoredservice', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedMonitoredServiceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_monitored_service_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted monitored application  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_service_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_monitored_service_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_monitored_service_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_monitored_service_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted monitored application  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_service_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_monitored_service_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_monitored_service_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/monitoredservice/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_monitored_service_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted monitored clusters  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_service_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_monitored_service_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_monitored_service_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_monitored_service_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted monitored clusters  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_monitored_service_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_monitored_service_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/monitoredservice/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_notficant_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's notificants  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_notficant_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_notficant_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_notficant_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_notficant_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's notificants  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_notficant_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_notficant_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/notificant/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_notificant_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's notificants  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_notificant_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedNotificant
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_notificant_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_notificant_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_notificant_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's notificants  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_notificant_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedNotificant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_notificant_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/notificant', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedNotificant',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_notificant_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's notificants  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_notificant_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_notificant_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_notificant_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_notificant_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's notificants  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_notificant_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_notificant_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_notificant_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/notificant/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_proxy_deleted_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_deleted_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedProxy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_proxy_deleted_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_proxy_deleted_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_proxy_deleted_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_deleted_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedProxy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_proxy_deleted_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/proxy/deleted', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedProxy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_proxy_deleted_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_deleted_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_proxy_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_proxy_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_proxy_deleted_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_deleted_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_proxy_deleted_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_proxy_deleted_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/proxy/deleted/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_proxy_deleted_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_deleted_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_proxy_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_proxy_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_proxy_deleted_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_deleted_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_proxy_deleted_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/proxy/deleted/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_proxy_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedProxy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_proxy_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_proxy_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_proxy_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedProxy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_proxy_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/proxy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedProxy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_proxy_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_proxy_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_proxy_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_proxy_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_proxy_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_proxy_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/proxy/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_proxy_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_proxy_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_proxy_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_proxy_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted proxies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_proxy_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_proxy_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/proxy/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_registered_query_deleted_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_deleted_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedDerivedMetricDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_registered_query_deleted_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_registered_query_deleted_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_registered_query_deleted_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_deleted_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedDerivedMetricDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_registered_query_deleted_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/derivedmetric/deleted', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedDerivedMetricDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_registered_query_deleted_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_deleted_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_registered_query_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_registered_query_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_registered_query_deleted_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_deleted_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_registered_query_deleted_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_registered_query_deleted_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/derivedmetric/deleted/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_registered_query_deleted_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_deleted_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_registered_query_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_registered_query_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_registered_query_deleted_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_deleted_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_registered_query_deleted_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/derivedmetric/deleted/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_registered_query_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedDerivedMetricDefinitionWithStats
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_registered_query_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_registered_query_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_registered_query_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedDerivedMetricDefinitionWithStats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_registered_query_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/derivedmetric', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedDerivedMetricDefinitionWithStats',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_registered_query_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_registered_query_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_registered_query_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_registered_query_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted derived metric definitions  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_registered_query_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_registered_query_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/derivedmetric/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_registered_query_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted derived metric definition  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_registered_query_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_registered_query_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_registered_query_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted derived metric definition  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_registered_query_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_registered_query_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/derivedmetric/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_related_report_event_anomaly_entities(self, event_id, **kwargs):  # noqa: E501
        """List the related events and anomalies over a firing event  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_related_report_event_anomaly_entities(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_id: (required)
        :param EventSearchRequest body:
        :return: ResponseContainerPagedReportEventAnomalyDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_related_report_event_anomaly_entities_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.search_related_report_event_anomaly_entities_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def search_related_report_event_anomaly_entities_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """List the related events and anomalies over a firing event  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_related_report_event_anomaly_entities_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_id: (required)
        :param EventSearchRequest body:
        :return: ResponseContainerPagedReportEventAnomalyDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_related_report_event_anomaly_entities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if self.api_client.client_side_validation and ('event_id' not in params or
                                                       params['event_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `event_id` when calling `search_related_report_event_anomaly_entities`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['eventId'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/event/related/{eventId}/withAnomalies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedReportEventAnomalyDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_related_report_event_entities(self, event_id, **kwargs):  # noqa: E501
        """List the related events over a firing event  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_related_report_event_entities(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_id: (required)
        :param EventSearchRequest body:
        :return: ResponseContainerPagedRelatedEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_related_report_event_entities_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.search_related_report_event_entities_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def search_related_report_event_entities_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """List the related events over a firing event  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_related_report_event_entities_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_id: (required)
        :param EventSearchRequest body:
        :return: ResponseContainerPagedRelatedEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_related_report_event_entities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if self.api_client.client_side_validation and ('event_id' not in params or
                                                       params['event_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `event_id` when calling `search_related_report_event_entities`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['eventId'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/event/related/{eventId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedRelatedEvent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_report_event_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's events  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_report_event_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventSearchRequest body:
        :return: ResponseContainerPagedEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_report_event_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_report_event_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_report_event_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's events  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_report_event_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventSearchRequest body:
        :return: ResponseContainerPagedEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_report_event_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/event', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedEvent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_report_event_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's events  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_report_event_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_report_event_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_report_event_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_report_event_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's events  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_report_event_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_report_event_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_report_event_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/event/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_report_event_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's events  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_report_event_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_report_event_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_report_event_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_report_event_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's events  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_report_event_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_report_event_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/event/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_role_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's roles  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_role_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_role_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_role_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_role_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's roles  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_role_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_role_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_role_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's roles  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_role_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_role_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_role_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_role_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's roles  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_role_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_role_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_role_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/role/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_role_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's roles  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_role_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_role_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_role_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_role_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's roles  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_role_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_role_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/role/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_saved_app_map_entities(self, **kwargs):  # noqa: E501
        """Search over all the customer's non-deleted saved app map searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_saved_app_map_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedSavedAppMapSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_saved_app_map_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_saved_app_map_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_saved_app_map_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over all the customer's non-deleted saved app map searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_saved_app_map_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedSavedAppMapSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_saved_app_map_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/savedappmapsearch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedSavedAppMapSearch',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_saved_app_map_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted app map searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_saved_app_map_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_saved_app_map_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_saved_app_map_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_saved_app_map_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted app map searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_saved_app_map_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_saved_app_map_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_saved_app_map_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/savedappmapsearch/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_saved_app_map_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted app map searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_saved_app_map_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_saved_app_map_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_saved_app_map_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_saved_app_map_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted app map searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_saved_app_map_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_saved_app_map_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/savedappmapsearch/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_saved_traces_entities(self, **kwargs):  # noqa: E501
        """Search over all the customer's non-deleted saved traces searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_saved_traces_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedSavedTracesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_saved_traces_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_saved_traces_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_saved_traces_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over all the customer's non-deleted saved traces searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_saved_traces_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedSavedTracesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_saved_traces_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/savedtracessearch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedSavedTracesSearch',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_service_account_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's service accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_service_account_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedServiceAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_service_account_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_service_account_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_service_account_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's service accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_service_account_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedServiceAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_service_account_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/serviceaccount', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedServiceAccount',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_service_account_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's service accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_service_account_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_service_account_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_service_account_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_service_account_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's service accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_service_account_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_service_account_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_service_account_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/serviceaccount/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_service_account_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's service accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_service_account_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_service_account_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_service_account_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_service_account_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's service accounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_service_account_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_service_account_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/serviceaccount/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_span_sampling_policy_deleted_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_deleted_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedSpanSamplingPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_span_sampling_policy_deleted_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_span_sampling_policy_deleted_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_span_sampling_policy_deleted_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_deleted_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedSpanSamplingPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_span_sampling_policy_deleted_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/spansamplingpolicy/deleted', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedSpanSamplingPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_span_sampling_policy_deleted_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_deleted_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_span_sampling_policy_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_span_sampling_policy_deleted_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_span_sampling_policy_deleted_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_deleted_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_span_sampling_policy_deleted_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_span_sampling_policy_deleted_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/spansamplingpolicy/deleted/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_span_sampling_policy_deleted_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_deleted_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_span_sampling_policy_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_span_sampling_policy_deleted_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_span_sampling_policy_deleted_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_deleted_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_span_sampling_policy_deleted_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/spansamplingpolicy/deleted/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_span_sampling_policy_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedSpanSamplingPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_span_sampling_policy_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_span_sampling_policy_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_span_sampling_policy_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's non-deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedSpanSamplingPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_span_sampling_policy_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/spansamplingpolicy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedSpanSamplingPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_span_sampling_policy_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_span_sampling_policy_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_span_sampling_policy_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_span_sampling_policy_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_span_sampling_policy_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_span_sampling_policy_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/spansamplingpolicy/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_span_sampling_policy_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_span_sampling_policy_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_span_sampling_policy_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_span_sampling_policy_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted span sampling policies  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_span_sampling_policy_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_span_sampling_policy_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/spansamplingpolicy/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_tagged_source_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's sources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_tagged_source_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SourceSearchRequestContainer body:
        :return: ResponseContainerPagedSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_tagged_source_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_tagged_source_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_tagged_source_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's sources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_tagged_source_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SourceSearchRequestContainer body:
        :return: ResponseContainerPagedSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_tagged_source_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/source', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedSource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_tagged_source_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's sources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_tagged_source_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_tagged_source_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_tagged_source_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_tagged_source_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's sources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_tagged_source_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_tagged_source_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_tagged_source_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/source/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_tagged_source_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's sources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_tagged_source_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_tagged_source_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_tagged_source_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_tagged_source_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's sources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_tagged_source_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_tagged_source_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/source/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_token_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's api tokens  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_token_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedApiTokenModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_token_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_token_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_token_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's api tokens  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_token_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedApiTokenModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_token_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedApiTokenModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_token_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's api tokens  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_token_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_token_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_token_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_token_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's api tokens  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_token_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_token_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_token_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/token/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_token_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's api tokens  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_token_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_token_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_token_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_token_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's api tokens  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_token_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_token_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/token/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_traces_map_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted traces searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_traces_map_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_traces_map_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_traces_map_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_traces_map_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's non-deleted traces searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_traces_map_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_traces_map_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_traces_map_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/savedtracessearch/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_traces_map_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted traces searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_traces_map_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_traces_map_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_traces_map_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_traces_map_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's non-deleted traces searches  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_traces_map_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_traces_map_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/savedtracessearch/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_user_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's users  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedCustomerFacingUserObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_user_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_user_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_user_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's users  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedCustomerFacingUserObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_user_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedCustomerFacingUserObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_user_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's users  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_user_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_user_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_user_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's users  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_user_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_user_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/user/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_user_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's users  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_user_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_user_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_user_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's users  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_user_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/user/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_user_group_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's user groups  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_group_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedUserGroupModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_user_group_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_user_group_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_user_group_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's user groups  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_group_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedUserGroupModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_user_group_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/usergroup', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedUserGroupModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_user_group_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's user groups  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_group_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_user_group_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_user_group_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_user_group_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's user groups  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_group_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_user_group_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_user_group_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/usergroup/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_user_group_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's user groups  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_group_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_user_group_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_user_group_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_user_group_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's user groups  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_user_group_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_user_group_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/usergroup/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_web_hook_entities(self, **kwargs):  # noqa: E501
        """Search over a customer's webhooks  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_web_hook_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedNotificant
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_web_hook_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_web_hook_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_web_hook_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Search over a customer's webhooks  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_web_hook_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SortableSearchRequest body:
        :return: ResponseContainerPagedNotificant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_web_hook_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/webhook', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedNotificant',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_web_hook_for_facet(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's webhooks  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_web_hook_for_facet(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_web_hook_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
        else:
            (data) = self.search_web_hook_for_facet_with_http_info(facet, **kwargs)  # noqa: E501
            return data

    def search_web_hook_for_facet_with_http_info(self, facet, **kwargs):  # noqa: E501
        """Lists the values of a specific facet over the customer's webhooks  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_web_hook_for_facet_with_http_info(facet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str facet: (required)
        :param FacetSearchRequestContainer body:
        :return: ResponseContainerFacetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['facet', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_web_hook_for_facet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'facet' is set
        if self.api_client.client_side_validation and ('facet' not in params or
                                                       params['facet'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `facet` when calling `search_web_hook_for_facet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'facet' in params:
            path_params['facet'] = params['facet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/webhook/{facet}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_webhook_for_facets(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's webhooks  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_webhook_for_facets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_webhook_for_facets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_webhook_for_facets_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_webhook_for_facets_with_http_info(self, **kwargs):  # noqa: E501
        """Lists the values of one or more facets over the customer's webhooks  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_webhook_for_facets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FacetsSearchRequestContainer body:
        :return: ResponseContainerFacetsResponseContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_webhook_for_facets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/search/webhook/facets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerFacetsResponseContainer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
