# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from wavefront_api_client.api_client import ApiClient


class RoleApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_assignees(self, id, body, **kwargs):  # noqa: E501
        """Add accounts and groups to a role  # noqa: E501

        Assigns a role with a given ID to a list of user and service accounts and groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assignees(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to assign. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :param list[str] body: A list of accounts and groups to add to the role. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_assignees_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_assignees_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def add_assignees_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """Add accounts and groups to a role  # noqa: E501

        Assigns a role with a given ID to a list of user and service accounts and groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assignees_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to assign. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :param list[str] body: A list of accounts and groups to add to the role. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_assignees" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `add_assignees`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_assignees`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role/{id}/addAssignees', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_role(self, body, **kwargs):  # noqa: E501
        """Create a role  # noqa: E501

        Creates a role with a specific unique name. Optionally, you can grant permissions to the role, assign the role to accounts and groups, specify a description, and configure the management properties of the role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RoleCreateDTO body: An example body for a role with all permissions:  <pre>{    \"name\": \"<i>Role_name</i>\",    \"permissions\": [        \"agent_management\", \"alerts_management\",        \"application_management\", \"batch_query_priority\",        \"dashboard_management\", \"derived_metrics_management\",        \"embedded_charts\", \"events_management\",        \"external_links_management\", \"host_tag_management\",        \"ingestion\", \"metrics_management\",        \"monitored_application_service_management\", \"saml_sso_management\",        \"token_management\", \"user_management\"    ],    \"description\": \"<i>Role_description</i>\" }</pre> (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_role_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_role_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_role_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a role  # noqa: E501

        Creates a role with a specific unique name. Optionally, you can grant permissions to the role, assign the role to accounts and groups, specify a description, and configure the management properties of the role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RoleCreateDTO body: An example body for a role with all permissions:  <pre>{    \"name\": \"<i>Role_name</i>\",    \"permissions\": [        \"agent_management\", \"alerts_management\",        \"application_management\", \"batch_query_priority\",        \"dashboard_management\", \"derived_metrics_management\",        \"embedded_charts\", \"events_management\",        \"external_links_management\", \"host_tag_management\",        \"ingestion\", \"metrics_management\",        \"monitored_application_service_management\", \"saml_sso_management\",        \"token_management\", \"user_management\"    ],    \"description\": \"<i>Role_description</i>\" }</pre> (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role(self, id, **kwargs):  # noqa: E501
        """Delete a role by ID  # noqa: E501

        Deletes a role with a given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to delete. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_role_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a role by ID  # noqa: E501

        Deletes a role with a given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to delete. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_roles(self, **kwargs):  # noqa: E501
        """Get all roles  # noqa: E501

        Returns all existing roles in the service instance with detailed information for each role, including assigned groups and accounts, management properties, permissions, name, ID, description, and the time of the last update and who has done it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_roles(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :return: ResponseContainerPagedRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_roles_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_roles_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_roles_with_http_info(self, **kwargs):  # noqa: E501
        """Get all roles  # noqa: E501

        Returns all existing roles in the service instance with detailed information for each role, including assigned groups and accounts, management properties, permissions, name, ID, description, and the time of the last update and who has done it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_roles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :return: ResponseContainerPagedRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_roles" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerPagedRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role(self, id, **kwargs):  # noqa: E501
        """Get a role by ID  # noqa: E501

        Returns the details of a role with a given ID. The response includes assigned groups and accounts, management properties, permissions, name, description, and the time of the last update and who has done it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to get. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_role_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a role by ID  # noqa: E501

        Returns the details of a role with a given ID. The response includes assigned groups and accounts, management properties, permissions, name, description, and the time of the last update and who has done it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to get. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grant_permission_to_roles(self, permission, body, **kwargs):  # noqa: E501
        """Grant a permission to roles  # noqa: E501

        Grants a given permission to a list of roles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grant_permission_to_roles(permission, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str permission: The permission to grant. Note that <code>host_tag_management</code> is the equivalent of the **Source Tag Management** permission, <code>monitored_application_service_management</code> is the equivalent of the **Integrations** permission, <code>agent_management</code> is the equivalent of the **Proxies** permission. (required)
        :param list[str] body: A list of role IDs to which to grant the permission. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grant_permission_to_roles_with_http_info(permission, body, **kwargs)  # noqa: E501
        else:
            (data) = self.grant_permission_to_roles_with_http_info(permission, body, **kwargs)  # noqa: E501
            return data

    def grant_permission_to_roles_with_http_info(self, permission, body, **kwargs):  # noqa: E501
        """Grant a permission to roles  # noqa: E501

        Grants a given permission to a list of roles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grant_permission_to_roles_with_http_info(permission, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str permission: The permission to grant. Note that <code>host_tag_management</code> is the equivalent of the **Source Tag Management** permission, <code>monitored_application_service_management</code> is the equivalent of the **Integrations** permission, <code>agent_management</code> is the equivalent of the **Proxies** permission. (required)
        :param list[str] body: A list of role IDs to which to grant the permission. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['permission', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grant_permission_to_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'permission' is set
        if self.api_client.client_side_validation and ('permission' not in params or
                                                       params['permission'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `permission` when calling `grant_permission_to_roles`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `grant_permission_to_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'permission' in params:
            path_params['permission'] = params['permission']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role/grant/{permission}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_assignees(self, id, body, **kwargs):  # noqa: E501
        """Remove accounts and groups from a role  # noqa: E501

        Revokes a role with a given ID from a list of user and service accounts and groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assignees(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to revoke. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :param list[str] body: A list of accounts and groups to remove from the role. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_assignees_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_assignees_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def remove_assignees_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """Remove accounts and groups from a role  # noqa: E501

        Revokes a role with a given ID from a list of user and service accounts and groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assignees_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to revoke. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :param list[str] body: A list of accounts and groups to remove from the role. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_assignees" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `remove_assignees`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `remove_assignees`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role/{id}/removeAssignees', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revoke_permission_from_roles(self, permission, body, **kwargs):  # noqa: E501
        """Revoke a permission from roles  # noqa: E501

        Revokes a given permission from a list of roles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_permission_from_roles(permission, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str permission: The permission to revoke. Note that <code>host_tag_management</code> is the equivalent of the **Source Tag Management** permission, <code>monitored_application_service_management</code> is the equivalent of the **Integrations** permission, <code>agent_management</code> is the equivalent of the **Proxies** permission. (required)
        :param list[str] body: A list of role IDs from which to revoke the permission. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revoke_permission_from_roles_with_http_info(permission, body, **kwargs)  # noqa: E501
        else:
            (data) = self.revoke_permission_from_roles_with_http_info(permission, body, **kwargs)  # noqa: E501
            return data

    def revoke_permission_from_roles_with_http_info(self, permission, body, **kwargs):  # noqa: E501
        """Revoke a permission from roles  # noqa: E501

        Revokes a given permission from a list of roles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_permission_from_roles_with_http_info(permission, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str permission: The permission to revoke. Note that <code>host_tag_management</code> is the equivalent of the **Source Tag Management** permission, <code>monitored_application_service_management</code> is the equivalent of the **Integrations** permission, <code>agent_management</code> is the equivalent of the **Proxies** permission. (required)
        :param list[str] body: A list of role IDs from which to revoke the permission. (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['permission', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_permission_from_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'permission' is set
        if self.api_client.client_side_validation and ('permission' not in params or
                                                       params['permission'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `permission` when calling `revoke_permission_from_roles`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `revoke_permission_from_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'permission' in params:
            path_params['permission'] = params['permission']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role/revoke/{permission}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_role(self, id, body, **kwargs):  # noqa: E501
        """Update a role by ID  # noqa: E501

        Updates a role with a given ID. You can update the assigned groups and accounts, management properties, permissions, ID, name, and description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to update. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :param RoleUpdateDTO body: You can first run the <code>Get a role by ID</code> API call, and then you can copy and edit the response body. An example body for a role with all permissions:  <pre>{   \"id\": \"<i>Role_ID</i>\",   \"name\": \"<i>Role_name</i>\",   \"permissions\": [      \"agent_management\", \"alerts_management\",      \"application_management\", \"batch_query_priority\",      \"derived_metrics_management\", \"dashboard_management\",      \"embedded_charts\", \"events_management\",      \"external_links_management\", \"host_tag_management\",      \"ingestion\", \"metrics_management\",      \"monitored_application_service_management\", \"saml_sso_management\",      \"token_management\", \"user_management\"   ],   \"description\": \"<i>Role_description</i>\" }</pre> (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_role_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_role_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def update_role_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """Update a role by ID  # noqa: E501

        Updates a role with a given ID. You can update the assigned groups and accounts, management properties, permissions, ID, name, and description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The ID of the role to update. If you don't know the role's ID, run the <code>Get all roles</code> API call to return all roles and their IDs. (required)
        :param RoleUpdateDTO body: You can first run the <code>Get a role by ID</code> API call, and then you can copy and edit the response body. An example body for a role with all permissions:  <pre>{   \"id\": \"<i>Role_ID</i>\",   \"name\": \"<i>Role_name</i>\",   \"permissions\": [      \"agent_management\", \"alerts_management\",      \"application_management\", \"batch_query_priority\",      \"derived_metrics_management\", \"dashboard_management\",      \"embedded_charts\", \"events_management\",      \"external_links_management\", \"host_tag_management\",      \"ingestion\", \"metrics_management\",      \"monitored_application_service_management\", \"saml_sso_management\",      \"token_management\", \"user_management\"   ],   \"description\": \"<i>Role_description</i>\" }</pre> (required)
        :return: ResponseContainerRoleDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/role/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseContainerRoleDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
