# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import unittest

import wavefront_api_client
from wavefront_api_client.api.integration_api import IntegrationApi  # noqa: E501
from wavefront_api_client.rest import ApiException


class TestIntegrationApi(unittest.TestCase):
    """IntegrationApi unit test stubs"""

    def setUp(self):
        self.api = wavefront_api_client.api.integration_api.IntegrationApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_get_all_integration(self):
        """Test case for get_all_integration

        Gets a flat list of all Wavefront integrations available, along with their status  # noqa: E501
        """
        pass

    def test_get_all_integration_in_manifests(self):
        """Test case for get_all_integration_in_manifests

        Gets all Wavefront integrations as structured in their integration manifests, along with their status and content  # noqa: E501
        """
        pass

    def test_get_all_integration_in_manifests_min(self):
        """Test case for get_all_integration_in_manifests_min

        Gets all Wavefront integrations as structured in their integration manifests.  # noqa: E501
        """
        pass

    def test_get_all_integration_statuses(self):
        """Test case for get_all_integration_statuses

        Gets the status of all Wavefront integrations  # noqa: E501
        """
        pass

    def test_get_installed_integration(self):
        """Test case for get_installed_integration

        Gets a flat list of all Integrations that are installed, along with their status  # noqa: E501
        """
        pass

    def test_get_integration(self):
        """Test case for get_integration

        Gets a single Wavefront integration by its id, along with its status  # noqa: E501
        """
        pass

    def test_get_integration_status(self):
        """Test case for get_integration_status

        Gets the status of a single Wavefront integration  # noqa: E501
        """
        pass

    def test_install_all_integration_alerts(self):
        """Test case for install_all_integration_alerts

        Enable all alerts associated with this integration  # noqa: E501
        """
        pass

    def test_install_integration(self):
        """Test case for install_integration

        Installs a Wavefront integration  # noqa: E501
        """
        pass

    def test_uninstall_all_integration_alerts(self):
        """Test case for uninstall_all_integration_alerts

        Disable all alerts associated with this integration  # noqa: E501
        """
        pass

    def test_uninstall_integration(self):
        """Test case for uninstall_integration

        Uninstalls a Wavefront integration  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
