# coding: utf-8

"""
    Wavefront REST API Documentation

    <p>The REST API enables you to interact with the Wavefront service by using standard REST API tools. You can use the REST API to automate commonly executed operations, for example to tag sources automatically.</p><p>When you make REST API calls outside the REST API documentation UI, to authenticate to the service, you must use an API token associated with a user account or a service account. For information on how to get the API token and examples, see <a href=\"http://docs.wavefront.com/using_wavefront_api.html\">Use the Wavefront REST API.</a></p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import unittest

import wavefront_api_client
from wavefront_api_client.api.account__user_and_service_account_api import AccountUserAndServiceAccountApi  # noqa: E501
from wavefront_api_client.rest import ApiException


class TestAccountUserAndServiceAccountApi(unittest.TestCase):
    """AccountUserAndServiceAccountApi unit test stubs"""

    def setUp(self):
        self.api = wavefront_api_client.api.account__user_and_service_account_api.AccountUserAndServiceAccountApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_activate_account(self):
        """Test case for activate_account

        Activates the given service account  # noqa: E501
        """
        pass

    def test_add_account_to_roles(self):
        """Test case for add_account_to_roles

        Adds specific roles to the account (user or service account)  # noqa: E501
        """
        pass

    def test_add_account_to_user_groups(self):
        """Test case for add_account_to_user_groups

        Adds specific groups to the account (user or service account)  # noqa: E501
        """
        pass

    def test_create_or_update_user_account(self):
        """Test case for create_or_update_user_account

        Creates or updates a user account  # noqa: E501
        """
        pass

    def test_create_service_account(self):
        """Test case for create_service_account

        Creates a service account  # noqa: E501
        """
        pass

    def test_deactivate_account(self):
        """Test case for deactivate_account

        Deactivates the given service account  # noqa: E501
        """
        pass

    def test_delete_account(self):
        """Test case for delete_account

        Deletes an account (user or service account) identified by id  # noqa: E501
        """
        pass

    def test_delete_multiple_accounts(self):
        """Test case for delete_multiple_accounts

        Deletes multiple accounts (users or service accounts)  # noqa: E501
        """
        pass

    def test_get_account(self):
        """Test case for get_account

        Get a specific account (user or service account)  # noqa: E501
        """
        pass

    def test_get_account_business_functions(self):
        """Test case for get_account_business_functions

        Returns business functions of a specific account (user or service account).  # noqa: E501
        """
        pass

    def test_get_all_accounts(self):
        """Test case for get_all_accounts

        Get all accounts (users and service accounts) of a customer  # noqa: E501
        """
        pass

    def test_get_all_service_accounts(self):
        """Test case for get_all_service_accounts

        Get all service accounts  # noqa: E501
        """
        pass

    def test_get_all_user_accounts(self):
        """Test case for get_all_user_accounts

        Get all user accounts  # noqa: E501
        """
        pass

    def test_get_service_account(self):
        """Test case for get_service_account

        Retrieves a service account by identifier  # noqa: E501
        """
        pass

    def test_get_user_account(self):
        """Test case for get_user_account

        Retrieves a user by identifier (email address)  # noqa: E501
        """
        pass

    def test_get_users_with_accounts_permission(self):
        """Test case for get_users_with_accounts_permission

        Get all users with Accounts permission  # noqa: E501
        """
        pass

    def test_grant_account_permission(self):
        """Test case for grant_account_permission

        Grants a specific permission to account (user or service account)  # noqa: E501
        """
        pass

    def test_grant_permission_to_accounts(self):
        """Test case for grant_permission_to_accounts

        Grant a permission to accounts (users or service accounts)  # noqa: E501
        """
        pass

    def test_invite_user_accounts(self):
        """Test case for invite_user_accounts

        Invite user accounts with given user groups and permissions.  # noqa: E501
        """
        pass

    def test_remove_account_from_roles(self):
        """Test case for remove_account_from_roles

        Removes specific roles from the account (user or service account)  # noqa: E501
        """
        pass

    def test_remove_account_from_user_groups(self):
        """Test case for remove_account_from_user_groups

        Removes specific groups from the account (user or service account)  # noqa: E501
        """
        pass

    def test_revoke_account_permission(self):
        """Test case for revoke_account_permission

        Revokes a specific permission from account (user or service account)  # noqa: E501
        """
        pass

    def test_revoke_permission_from_accounts(self):
        """Test case for revoke_permission_from_accounts

        Revoke a permission from accounts (users or service accounts)  # noqa: E501
        """
        pass

    def test_update_service_account(self):
        """Test case for update_service_account

        Updates the service account  # noqa: E501
        """
        pass

    def test_update_user_account(self):
        """Test case for update_user_account

        Update user with given user groups and permissions.  # noqa: E501
        """
        pass

    def test_validate_accounts(self):
        """Test case for validate_accounts

        Returns valid accounts (users and service accounts), also invalid identifiers from the given list  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
