# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyromod', 'pyromod.helpers', 'pyromod.listen', 'pyromod.nav', 'pyromod.utils']

package_data = \
{'': ['*']}

install_requires = \
['pyrogram>=1.0']

setup_kwargs = {
    'name': 'pyromod',
    'version': '2.0.0',
    'description': 'A monkeypatcher add-on for Pyrogram that does conversation handling',
    'long_description': '# pyromod\n[![Telegram](https://img.shields.io/badge/Telegram-2CA5E0?style=flat&logo=telegram&logoColor=white)](https://t.me/pyromodchat)\n![GitHub release (latest by date)](https://img.shields.io/github/v/release/usernein/pyromod)\n![GitHub commits since latest release (by date) for a branch](https://img.shields.io/github/commits-since/usernein/pyromod/latest)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/pyromod?color=388E3C)\n\nA monkeypatcher add-on for Pyrogram which does conversation handling and other cool stuff.\n\nIn other words, it is a compilation of utilities i developed for improving my personal experience with Pyrogram.\nIt works **together** with Pyrogram, it is **not** a fork/modded version. It does monkeypatching to add features to Pyrogram classes on the go (so i don\'t need to update on every Pyrogram\'s release).\n\n## Usage\nImport `pyromod` one time in your script and you\'ll already be able to use the modified pyrogram in all your handlers. Example:\n```python\n# config.py\nimport pyromod\nfrom pyrogram import Client\n\napp = Client(\'my_session\')\n```\n\nThen you can, from another file, do `from config import app` to import the modded Pyrogram Client we created above. It will be modded globally.\n\nAll the patches are applied automatically as soon as pyromod is imported.\n\n## Methods\nAll pyromod methods are callable by any of these ways:\n- `await Client.<method>(identifier, ...)`\n- `await Chat.<method>()`\n- `await User.<method>()`\n\nIn the last two, Pyrogram automatically gets the ids from the object, to compound the `identifier` tuple that `Client.listen` uses.\n\nThese are the methods pyromod adds:\n- `listen(identifier, filters=None, listener_type=ListenerTypes.MESSAGE, timeout=None, unallowed_click_alert=True)`\nAwaits for a new message in the specified chat and returns its Message object. If listener_type is set to `ListenerTypes.CALLBACK_QUERY`, it awaits and returns a CallbackQuery object.\nYou can pass Update Filters to the `filters` parameter just like you do for the update handlers. e.g. `filters=filters.photo & filters.bot`\n`identifier` is a tuple containing, in this exact order, (chat_id, user_id, message_id). It lets you specify exactly which update you want. You don\'t need to worry about that if you mostly use the bound methods.\n`unnalowed_click_alert` is the text that users will see in an alert when the button is not waiting for them to click. If True, it uses the default text at `PyromodConfig.unnalowed_click_alert_text`. If False, no text is shown.\n\n- `ask(text, identifier, filters=None, listener_type=ListenerTypes.MESSAGE, timeout=None, unallowed_click_alert=True)`\nSame as `listen`, but sends a message to identifier[0] before and only then waits for a response.\nYou can additionally pass any of the `Client.send_message()` parameters. Check the example below.\nThe object of the sent message is returned inside of the attribute `request`\n\nExample:\n```python\nanswer = await message.chat.ask(\'*Send me your name:*\', parse_mode=enums.ParseMode.MARKDOWN)\nawait answer.request.edit_text("Name received!")\nawait answer.reply(f\'Your name is: {answer.text}\', quote=True)    \n```\n\n- `Message.wait_for_click(from_user_id=None, timeout=None, filters=None, alert=True)`\nAwaits from a click on any button on the Message object. If `from_user_id` is passed, pyromod will wait for a click of that user.\nIf you pass any text to `alert`, it will be shown to any other user. If `alert` is True, it will use the default text. If False, no text will be shown.\n\n## `pyromod.helpers`\nTools for creating inline keyboards a lot easier.\n\n### `pyromod.helpers.ikb`\n\nCreates a inline keyboard.\nIts first and only argument is a list (the keyboard itself) containing lists (the lines) of buttons, which can be lists or tuples. I use tuples to avoid a mess with a lot of brackets. Tuples makes it easier to read.\n\nThe button syntax is very simple: `(TEXT, VALUE, TYPE)`, with TYPE being any existent button type (e.g. `url`) and VALUE is its value. If you omit the type, it will be considered as a callback button.\nIf you pass only a string as button, it will be used as text and callback_data for the InlineKeyboardButton.\nThis syntax will be automagically converted by pyromod.\n\nExamples:\n```python\nfrom pyromod.helpers import ikb\n...\nkeyboard = ikb([\n    [(\'Button 1\', \'call_1\'), (\'Button 2\', \'call_2\')],\n    [(\'Another button\', \'t.me/pyromodchat\', \'url\')]\n])\nawait message.reply(\'Easy inline keyboard\', reply_markup=keyboard)\n```\n\n```python\nkeyboard = ikb([\n\t["Mars", "Earth", "Venus"],\n\t["Saturn", "Jupyter"]\n])\nawait message.reply("Easiest inline keyboard", reply_markup=keyboard)\n```\n\n- `pyromod.helpers.array_chunk`\nChunk the elements of a list into small lists. i.e. [1, 2, 3, 4] can become [[1,2], [3,4]]. This is extremely useful if you want to build a keyboard dinamically with more than 1 column. You just put all buttons together in a list and run:\n```python\nlines = array_chunk(buttons, 2)\nkeyboard = ikb(lines)\n```\nThis will generate a list of lines with 2 buttons on each one.\n\n### `pyromod.nav`\nTools for creating navigation keyboards.\n\n- `pyromod.nav.Pagination`\nCreates a full paginated keyboard. Usage:\n```python\nfrom pyrogram import Client, filters\nfrom pyromod.nav import Pagination\nfrom pyromod.helpers import ikb\n\ndef page_data(page):\n    return f\'view_page {page}\'\ndef item_data(item, page):\n    return f\'view_item {item} {page}\'\ndef item_title(item, page):\n    return f\'Item {item} of page {page}\'\n\n@Client.on_message(filters.regex(\'/nav\'))\nasync def on_nav(c,m):\n    objects = [*range(1,100)]\n    page = Pagination(\n        objects,\n        page_data=page_data, # callback to define the callback_data for page buttons in the bottom\n        item_data=item_data, # callback to define the callback_data for each item button\n        item_title=item_title # callback to define the text for each item button\n    )\n    index = 0 # in which page is it now? (used to calculate the offset)\n    lines = 5 # how many lines of the keyboard to include for the items\n    columns = how many columns include in each items\' line\n    kb = page.create(index, lines, columns)\n    await m.reply(\'Test\', reply_markup=ikb(kb))\n```\n\n## pyromod.PyrogramConfig\nIt lets you do some tweaks on pyromod behavior.\n```python\nclass PyromodConfig:\n    timeout_handler = None\n    stopped_handler = None\n    throw_exceptions = True\n    unallowed_click_alert = True\n    unallowed_click_alert_text = (\n        "[pyromod] You\'re not expected to click this button."\n    )\n```\n`timeout_handler` and `stopped_handler` are callbacks that receive (identifier, listener_data) as arguments. timeout_handler receives an extra arg `timeout`. When they are in use, pyromod won\'t throw the exceptions ListenerStopped and ListenedTimeout.\n\n### Copyright & License\nThis project may include snippets of Pyrogram code\n- Pyrogram - Telegram MTProto API Client Library for Python. Copyright (C) 2017-2022 Dan <<https://github.com/delivrance>>\n\nLicensed under the terms of the [GNU Lesser General Public License v3 or later (LGPLv3+)](COPYING.lesser)\n\n\n',
    'author': 'usernein',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
