/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.CarpetSettings;
import carpet.network.ServerNetworkHandler;
import carpet.script.CarpetContext;
import carpet.script.exception.InternalExpressionException;
import carpet.script.language.Sys;
import carpet.script.value.BlockValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2223;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.Pair;

public class ShapeDispatcher {
    private static final Map<String, class_2394> particleCache = new HashMap<String, class_2394>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pair<ExpiringShape, Map<String, Value>> fromFunctionArgs(CarpetContext cc, List<Value> lv, class_3222[] playerRef) {
        Map<Object, Object> params;
        if (lv.size() < 3) {
            throw new InternalExpressionException("'draw_shape' takes at least three parameters, shape name, duration, and its params");
        }
        String shapeType = lv.get(0).getString();
        NumericValue duration = NumericValue.asNumber(lv.get(1), "duration");
        if (lv.size() == 3) {
            Value paramValue = lv.get(2);
            if (paramValue instanceof MapValue) {
                params = new HashMap();
                ((MapValue)paramValue).getMap().entrySet().forEach(e -> {
                    Value cfr_ignored_0 = (Value)params.put(((Value)e.getKey()).getString(), e.getValue());
                });
            } else {
                if (!(paramValue instanceof ListValue)) throw new InternalExpressionException("Parameters for 'draw_shape' need to be defined either in a list or a map");
                params = ShapeDispatcher.parseParams(((ListValue)paramValue).getItems());
            }
        } else {
            ArrayList<Value> paramList = new ArrayList<Value>();
            for (int i = 2; i < lv.size(); ++i) {
                paramList.add(lv.get(i));
            }
            params = ShapeDispatcher.parseParams(paramList);
        }
        params.putIfAbsent("dim", new StringValue(cc.s.method_9225().method_27983().method_29177().toString()));
        params.putIfAbsent("duration", duration);
        if (!params.containsKey("player")) return Pair.of((Object)ShapeDispatcher.create(cc, shapeType, params), params);
        class_3222 player = EntityValue.getPlayerByValue(cc.s.method_9211(), (Value)params.get("player"));
        if (player == null) {
            throw new InternalExpressionException("'player' parameter needs to represent an existing player");
        }
        params.remove("player");
        playerRef[0] = player;
        return Pair.of((Object)ShapeDispatcher.create(cc, shapeType, params), params);
    }

    public static void sendShape(List<class_3222> players, List<Pair<ExpiringShape, Map<String, Value>>> shapes) {
        ArrayList<class_3222> clientPlayers = new ArrayList<class_3222>();
        ArrayList<class_3222> alternativePlayers = new ArrayList<class_3222>();
        for (class_3222 player : players) {
            if (ServerNetworkHandler.isValidCarpetPlayer(player)) {
                clientPlayers.add(player);
                continue;
            }
            alternativePlayers.add(player);
        }
        if (!clientPlayers.isEmpty()) {
            class_2499 tag = new class_2499();
            int tagcount = 0;
            for (Pair<ExpiringShape, Map<String, Value>> s2 : shapes) {
                tag.add((Object)ExpiringShape.toTag((Map)s2.getRight()));
                if (tagcount++ <= 1000) continue;
                tagcount = 0;
                class_2499 finalTag = tag;
                clientPlayers.forEach(arg_0 -> ShapeDispatcher.lambda$sendShape$1((class_2520)finalTag, arg_0));
                tag = new class_2499();
            }
            class_2499 finalTag = tag;
            if (tag.size() > 0) {
                clientPlayers.forEach(arg_0 -> ShapeDispatcher.lambda$sendShape$2((class_2520)finalTag, arg_0));
            }
        }
        if (!alternativePlayers.isEmpty()) {
            ArrayList alternatives = new ArrayList();
            shapes.forEach(s -> alternatives.add(((ExpiringShape)s.getLeft()).alternative()));
            alternativePlayers.forEach(p -> alternatives.forEach(a -> a.accept(p)));
        }
    }

    public static class_2394 getParticleData(String name) {
        class_2394 particle = particleCache.get(name);
        if (particle != null) {
            return particle;
        }
        try {
            particle = class_2223.method_9418((StringReader)new StringReader(name));
        }
        catch (CommandSyntaxException e) {
            throw new InternalExpressionException("No such particle: " + name);
        }
        particleCache.put(name, particle);
        return particle;
    }

    public static Map<String, Value> parseParams(List<Value> items) {
        if (items.size() % 2 == 1) {
            throw new InternalExpressionException("Shape parameters list needs to be of even size");
        }
        HashMap<String, Value> param = new HashMap<String, Value>();
        for (int i = 0; i < items.size(); i += 2) {
            String name = items.get(i).getString();
            Value val = items.get(i + 1);
            param.put(name, val);
        }
        return param;
    }

    public static ExpiringShape create(CarpetContext cc, String shapeType, Map<String, Value> userParams) {
        userParams.put("shape", new StringValue(shapeType));
        userParams.keySet().forEach(key -> {
            Param param = Param.of.get(key);
            if (param == null) {
                throw new InternalExpressionException("Unknown feature for shape: " + key);
            }
            userParams.put((String)key, param.validate(userParams, cc, (Value)userParams.get(key)));
        });
        Function<Map<String, Value>, ExpiringShape> factory = ExpiringShape.shapeProviders.get(shapeType);
        if (factory == null) {
            throw new InternalExpressionException("Unknown shape: " + shapeType);
        }
        return factory.apply(userParams);
    }

    public static ExpiringShape fromTag(class_2487 tag) {
        HashMap<String, Value> options = new HashMap<String, Value>();
        for (String key : tag.method_10541()) {
            Param decoder = Param.of.get(key);
            if (decoder == null) {
                CarpetSettings.LOG.info("Unknown parameter for shape: " + key);
                return null;
            }
            Value decodedValue = decoder.decode(tag.method_10580(key));
            options.put(key, decodedValue);
        }
        Value shapeValue = (Value)options.get("shape");
        if (shapeValue == null) {
            CarpetSettings.LOG.info("Shape id missing in " + String.join((CharSequence)", ", tag.method_10541()));
            return null;
        }
        Function<Map<String, Value>, ExpiringShape> factory = ExpiringShape.shapeProviders.get(shapeValue.getString());
        if (factory == null) {
            CarpetSettings.LOG.info("Unknown shape: " + shapeValue.getString());
            return null;
        }
        try {
            return factory.apply(options);
        }
        catch (InternalExpressionException exc) {
            CarpetSettings.LOG.info(exc.getMessage());
            return null;
        }
    }

    private static boolean isStraight(class_243 from, class_243 to, double density) {
        if (from.field_1352 == to.field_1352 && from.field_1351 == to.field_1351 || from.field_1352 == to.field_1352 && from.field_1350 == to.field_1350 || from.field_1351 == to.field_1351 && from.field_1350 == to.field_1350) {
            return from.method_1022(to) / density > 20.0;
        }
        return false;
    }

    private static int drawOptimizedParticleLine(List<class_3222> playerList, class_2394 particle, class_243 from, class_243 to, double density) {
        double distance = from.method_1022(to);
        int particles = (int)(distance / density);
        class_243 towards = to.method_1020(from);
        int parts = 0;
        for (class_3222 player : playerList) {
            class_3218 world = player.method_14220();
            world.method_14166(player, particle, true, towards.field_1352 / 2.0 + from.field_1352, towards.field_1351 / 2.0 + from.field_1351, towards.field_1350 / 2.0 + from.field_1350, particles / 3, towards.field_1352 / 6.0, towards.field_1351 / 6.0, towards.field_1350 / 6.0, 0.0);
            world.method_14166(player, particle, true, from.field_1352, from.field_1351, from.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            world.method_14166(player, particle, true, to.field_1352, to.field_1351, to.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            parts += particles / 3 + 2;
        }
        int divider = 6;
        while (particles / divider > 1) {
            int center = divider * 2 / 3;
            int dev = 2 * divider;
            for (class_3222 player : playerList) {
                class_3218 world = player.method_14220();
                world.method_14166(player, particle, true, towards.field_1352 / (double)center + from.field_1352, towards.field_1351 / (double)center + from.field_1351, towards.field_1350 / (double)center + from.field_1350, particles / divider, towards.field_1352 / (double)dev, towards.field_1351 / (double)dev, towards.field_1350 / (double)dev, 0.0);
                world.method_14166(player, particle, true, towards.field_1352 * (1.0 - 1.0 / (double)center) + from.field_1352, towards.field_1351 * (1.0 - 1.0 / (double)center) + from.field_1351, towards.field_1350 * (1.0 - 1.0 / (double)center) + from.field_1350, particles / divider, towards.field_1352 / (double)dev, towards.field_1351 / (double)dev, towards.field_1350 / (double)dev, 0.0);
            }
            parts += 2 * particles / divider;
            divider = 2 * divider;
        }
        return parts;
    }

    public static int drawParticleLine(List<class_3222> players, class_2394 particle, class_243 from, class_243 to, double density) {
        double distance = from.method_1025(to);
        if (distance == 0.0) {
            return 0;
        }
        int pcount = 0;
        if (distance < 100.0) {
            Random rand = players.get((int)0).method_14220().field_9229;
            int particles = (int)(distance / density) + 1;
            class_243 towards = to.method_1020(from);
            for (int i = 0; i < particles; ++i) {
                class_243 at = from.method_1019(towards.method_1021(rand.nextDouble()));
                for (class_3222 player : players) {
                    player.method_14220().method_14166(player, particle, true, at.field_1352, at.field_1351, at.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    ++pcount;
                }
            }
            return pcount;
        }
        if (ShapeDispatcher.isStraight(from, to, density)) {
            return ShapeDispatcher.drawOptimizedParticleLine(players, particle, from, to, density);
        }
        class_243 incvec = to.method_1020(from).method_1021(2.0 * density / (double)class_3532.method_15368((double)distance));
        class_243 delta = new class_243(0.0, 0.0, 0.0);
        while (delta.method_1027() < distance) {
            for (class_3222 player : players) {
                player.method_14220().method_14166(player, particle, true, delta.field_1352 + from.field_1352, delta.field_1351 + from.field_1351, delta.field_1350 + from.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                ++pcount;
            }
            delta = delta.method_1019(incvec.method_1021((double)Sys.randomizer.nextFloat()));
        }
        return pcount;
    }

    private static /* synthetic */ void lambda$sendShape$2(class_2520 finalTag, class_3222 p) {
        ServerNetworkHandler.sendCustomCommand(p, "scShapes", finalTag);
    }

    private static /* synthetic */ void lambda$sendShape$1(class_2520 finalTag, class_3222 p) {
        ServerNetworkHandler.sendCustomCommand(p, "scShapes", finalTag);
    }

    public static class EntityParam
    extends Param {
        protected EntityParam(String id) {
            super(id);
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2497.method_23247((int)NumericValue.asNumber(value, this.id).getInt());
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            if (value instanceof EntityValue) {
                return new NumericValue(((EntityValue)value).getEntity().method_5628());
            }
            class_3222 player = EntityValue.getPlayerByValue(cc.s.method_9211(), value);
            if (player == null) {
                throw new InternalExpressionException(this.id + " parameter needs to represent an entity or player");
            }
            return new NumericValue(player.method_5628());
        }

        @Override
        public Value decode(class_2520 tag) {
            return new NumericValue(((class_2497)tag).method_10701());
        }
    }

    public static class ColorParam
    extends NumericParam {
        protected ColorParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag) {
            return new NumericValue(((class_2497)tag).method_10701());
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2497.method_23247((int)NumericValue.asNumber(value, this.id).getInt());
        }
    }

    public static class PointsParam
    extends Param {
        public PointsParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            if (!(value instanceof ListValue)) {
                throw new InternalExpressionException(this.id + " parameter should be a list");
            }
            ArrayList<Value> points = new ArrayList<Value>();
            for (Value point : ((ListValue)value).getItems()) {
                points.add(Vec3Param.validate(this, options, cc, point, false));
            }
            return ListValue.wrap(points);
        }

        @Override
        public Value decode(class_2520 tag) {
            class_2499 ltag = (class_2499)tag;
            ArrayList<Value> points = new ArrayList<Value>();
            int ll = ltag.size();
            for (int i = 0; i < ll; ++i) {
                class_2499 ptag = ltag.method_10603(i);
                points.add(ListValue.of(new NumericValue(ptag.method_10611(0)), new NumericValue(ptag.method_10611(1)), new NumericValue(ptag.method_10611(2))));
            }
            return ListValue.wrap(points);
        }

        @Override
        public class_2520 toTag(Value pointsValue) {
            List<Value> lv = ((ListValue)pointsValue).getItems();
            class_2499 ltag = new class_2499();
            for (Value value : lv) {
                List<Value> coords = ((ListValue)value).getItems();
                class_2499 tag = new class_2499();
                tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(0), "x").getDouble()));
                tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(1), "y").getDouble()));
                tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(2), "z").getDouble()));
                ltag.add((Object)tag);
            }
            return ltag;
        }
    }

    public static class Vec3Param
    extends Param {
        private boolean roundsUpForBlocks;

        protected Vec3Param(String id, boolean doesRoundUpForBlocks) {
            super(id);
            this.roundsUpForBlocks = doesRoundUpForBlocks;
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            return Vec3Param.validate(this, options, cc, value, this.roundsUpForBlocks);
        }

        public static Value validate(Param p, Map<String, Value> options, CarpetContext cc, Value value, boolean roundsUp) {
            if (value instanceof BlockValue) {
                if (options.containsKey("follow")) {
                    throw new InternalExpressionException(p.id + " parameter cannot use blocks as positions for relative positioning due to 'follow' attribute being present");
                }
                class_2338 pos = ((BlockValue)value).getPos();
                int offset = roundsUp ? 1 : 0;
                return ListValue.of(new NumericValue(pos.method_10263() + offset), new NumericValue(pos.method_10264() + offset), new NumericValue(pos.method_10260() + offset));
            }
            if (value instanceof ListValue) {
                List<Value> values = ((ListValue)value).getItems();
                if (values.size() != 3) {
                    throw new InternalExpressionException("'" + p.id + "' requires 3 numerical values");
                }
                for (Value component : values) {
                    if (component instanceof NumericValue) continue;
                    throw new InternalExpressionException("'" + p.id + "' requires 3 numerical values");
                }
                return value;
            }
            if (value instanceof EntityValue) {
                if (options.containsKey("follow")) {
                    throw new InternalExpressionException(p.id + " parameter cannot use entity as positions for relative positioning due to 'follow' attribute being present");
                }
                class_1297 e = ((EntityValue)value).getEntity();
                return ListValue.of(new NumericValue(e.method_23317()), new NumericValue(e.method_23318()), new NumericValue(e.method_23321()));
            }
            CarpetSettings.LOG.error("Value: " + value.getString());
            throw new InternalExpressionException("'" + p.id + "' requires a triple, block or entity to indicate position");
        }

        @Override
        public Value decode(class_2520 tag) {
            class_2499 ctag = (class_2499)tag;
            return ListValue.of(new NumericValue(ctag.method_10611(0)), new NumericValue(ctag.method_10611(1)), new NumericValue(ctag.method_10611(2)));
        }

        @Override
        public class_2520 toTag(Value value) {
            List<Value> lv = ((ListValue)value).getItems();
            class_2499 tag = new class_2499();
            tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(0), "x").getDouble()));
            tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(1), "y").getDouble()));
            tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(2), "z").getDouble()));
            return tag;
        }
    }

    public static class NonNegativeFloatParam
    extends NumericParam {
        protected NonNegativeFloatParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag) {
            return new NumericValue(((class_2494)tag).method_10700());
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2494.method_23244((float)NumericValue.asNumber(value, this.id).getFloat());
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            Value ret = super.validate(options, cc, value);
            if (((NumericValue)ret).getDouble() < 0.0) {
                throw new InternalExpressionException("'" + this.id + "' should be non-negative");
            }
            return ret;
        }
    }

    public static class NonNegativeIntParam
    extends NumericParam {
        protected NonNegativeIntParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag) {
            return new NumericValue(((class_2497)tag).method_10701());
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2497.method_23247((int)NumericValue.asNumber(value, this.id).getInt());
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            Value ret = super.validate(options, cc, value);
            if (((NumericValue)ret).getDouble() < 0.0) {
                throw new InternalExpressionException("'" + this.id + "' should be non-negative");
            }
            return ret;
        }
    }

    public static class PositiveIntParam
    extends PositiveParam {
        protected PositiveIntParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag) {
            return new NumericValue(((class_2497)tag).method_10701());
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2497.method_23247((int)NumericValue.asNumber(value, this.id).getInt());
        }
    }

    public static class PositiveFloatParam
    extends PositiveParam {
        protected PositiveFloatParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag) {
            return new NumericValue(((class_2494)tag).method_10700());
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2494.method_23244((float)NumericValue.asNumber(value, this.id).getFloat());
        }
    }

    public static abstract class PositiveParam
    extends NumericParam {
        protected PositiveParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            Value ret = super.validate(options, cc, value);
            if (((NumericValue)ret).getDouble() <= 0.0) {
                throw new InternalExpressionException("'" + this.id + "' should be positive");
            }
            return ret;
        }
    }

    public static class FloatParam
    extends NumericParam {
        protected FloatParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag) {
            return new NumericValue(((class_2494)tag).method_10700());
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2494.method_23244((float)NumericValue.asNumber(value, this.id).getFloat());
        }
    }

    public static class BoolParam
    extends NumericParam {
        protected BoolParam(String id) {
            super(id);
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2481.method_23234((boolean)value.getBoolean());
        }

        @Override
        public Value decode(class_2520 tag) {
            return new NumericValue(((class_2481)tag).method_10698() > 0);
        }
    }

    public static abstract class NumericParam
    extends Param {
        protected NumericParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            if (!(value instanceof NumericValue)) {
                throw new InternalExpressionException("'" + this.id + "' needs to be a number");
            }
            return value;
        }
    }

    public static class ShapeParam
    extends StringParam {
        protected ShapeParam() {
            super("shape");
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            String shape = value.getString();
            if (!ExpiringShape.shapeProviders.containsKey(shape)) {
                throw new InternalExpressionException("Unknown shape: " + shape);
            }
            return value;
        }
    }

    public static class DimensionParam
    extends StringParam {
        protected DimensionParam() {
            super("dim");
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            return value;
        }
    }

    public static class StringChoiceParam
    extends StringParam {
        private Set<String> options;

        public StringChoiceParam(String id, String ... options) {
            super(id);
            this.options = Sets.newHashSet((Object[])options);
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            if (this.options.contains(value.getString())) {
                return value;
            }
            return null;
        }
    }

    public static class FormattedTextParam
    extends StringParam {
        protected FormattedTextParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            if (!(value instanceof FormattedTextValue)) {
                value = new FormattedTextValue((class_2561)new class_2585(value.getString()));
            }
            return value;
        }

        @Override
        public class_2520 toTag(Value value) {
            if (!(value instanceof FormattedTextValue)) {
                value = new FormattedTextValue((class_2561)new class_2585(value.getString()));
            }
            return class_2519.method_23256((String)((FormattedTextValue)value).serialize());
        }

        @Override
        public Value decode(class_2520 tag) {
            return FormattedTextValue.deserialize(tag.method_10714());
        }
    }

    public static class TextParam
    extends StringParam {
        protected TextParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, CarpetContext cc, Value value) {
            return value;
        }
    }

    public static abstract class StringParam
    extends Param {
        protected StringParam(String id) {
            super(id);
        }

        @Override
        public class_2520 toTag(Value value) {
            return class_2519.method_23256((String)value.getString());
        }

        @Override
        public Value decode(class_2520 tag) {
            return new StringValue(tag.method_10714());
        }
    }

    public static abstract class Param {
        public static Map<String, Param> of = new HashMap<String, Param>(){
            {
                this.put("shape", new ShapeParam());
                this.put("dim", new DimensionParam());
                this.put("duration", new NonNegativeIntParam("duration"));
                this.put("color", new ColorParam("color"));
                this.put("follow", new EntityParam("follow"));
                this.put("snap", new StringChoiceParam("snap", "xyz", "xz", "yz", "xy", "x", "y", "z", "dxdydz", "dxdz", "dydz", "dxdy", "dx", "dy", "dz", "xdz", "dxz", "ydz", "dyz", "xdy", "dxy", "xydz", "xdyz", "xdydz", "dxyz", "dxydz", "dxdyz"));
                this.put("line", new PositiveFloatParam("line"));
                this.put("fill", new ColorParam("fill"));
                this.put("from", new Vec3Param("from", false));
                this.put("to", new Vec3Param("to", true));
                this.put("center", new Vec3Param("center", false));
                this.put("pos", new Vec3Param("pos", false));
                this.put("radius", new PositiveFloatParam("radius"));
                this.put("level", new PositiveIntParam("level"));
                this.put("height", new FloatParam("height"));
                this.put("axis", new StringChoiceParam("axis", "x", "y", "z"));
                this.put("points", new PointsParam("points"));
                this.put("text", new FormattedTextParam("text"));
                this.put("value", new FormattedTextParam("value"));
                this.put("size", new PositiveIntParam("size"));
                this.put("align", new StringChoiceParam("align", "center", "left", "right"));
                this.put("indent", new FloatParam("indent"));
                this.put("raise", new FloatParam("raise"));
                this.put("tilt", new FloatParam("tilt"));
                this.put("facing", new StringChoiceParam("axis", "player", "north", "south", "east", "west", "up", "down"));
                this.put("doublesided", new BoolParam("doublesided"));
            }
        };
        protected String id;

        protected Param(String id) {
            this.id = id;
        }

        public abstract class_2520 toTag(Value var1);

        public abstract Value validate(Map<String, Value> var1, CarpetContext var2, Value var3);

        public abstract Value decode(class_2520 var1);
    }

    public static class Cylinder
    extends ExpiringShape {
        private final Set<String> required = ImmutableSet.of((Object)"center", (Object)"radius");
        private final Map<String, Value> optional = ImmutableMap.of((Object)"level", (Object)Value.ZERO, (Object)"height", (Object)Value.ZERO, (Object)"axis", (Object)new StringValue("y"));
        class_243 center;
        float height;
        float radius;
        int level;
        int subdivisions;
        class_2350.class_2351 axis;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        private Cylinder() {
        }

        @Override
        protected void init(Map<String, Value> options) {
            super.init(options);
            this.center = this.vecFromValue(options.get("center"));
            this.radius = NumericValue.asNumber(options.get("radius")).getFloat();
            this.subdivisions = this.level = NumericValue.asNumber(options.getOrDefault("level", this.optional.get("level"))).getInt();
            if (this.subdivisions <= 0) {
                this.subdivisions = Math.max(10, (int)(10.0 * Math.sqrt(this.radius)));
            }
            this.height = NumericValue.asNumber(options.getOrDefault("height", this.optional.get("height"))).getFloat();
            this.axis = class_2350.class_2351.method_10177((String)options.getOrDefault("axis", this.optional.get("axis")).getString());
        }

        @Override
        public Consumer<class_3222> alternative() {
            return p -> {
                class_2394 particle = this.replacementParticle();
                int partno = (int)Math.min(1000.0, Math.sqrt((float)(20 * this.subdivisions) * (1.0f + this.height)));
                Random rand = p.field_6002.method_8409();
                class_3218 world = p.method_14220();
                class_243 ccenter = this.relativiseRender((class_1937)world, this.center, 0.0f);
                double ccx = ccenter.field_1352;
                double ccy = ccenter.field_1351;
                double ccz = ccenter.field_1350;
                if (this.axis == class_2350.class_2351.field_11052) {
                    for (int i = 0; i < partno; ++i) {
                        float d = rand.nextFloat() * this.height;
                        float phi = (float)(Math.PI * 2 * rand.nextDouble());
                        double x = this.radius * class_3532.method_15362((float)phi);
                        double y = d;
                        double z = this.radius * class_3532.method_15374((float)phi);
                        world.method_14166(p, particle, true, x + ccx, y + ccy, z + ccz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else if (this.axis == class_2350.class_2351.field_11048) {
                    for (int i = 0; i < partno; ++i) {
                        float d = rand.nextFloat() * this.height;
                        float phi = (float)(Math.PI * 2 * rand.nextDouble());
                        double x = d;
                        double y = this.radius * class_3532.method_15362((float)phi);
                        double z = this.radius * class_3532.method_15374((float)phi);
                        world.method_14166(p, particle, true, x + ccx, y + ccy, z + ccz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else {
                    for (int i = 0; i < partno; ++i) {
                        float d = rand.nextFloat() * this.height;
                        float phi = (float)(Math.PI * 2 * rand.nextDouble());
                        double x = this.radius * class_3532.method_15374((float)phi);
                        double y = this.radius * class_3532.method_15362((float)phi);
                        double z = d;
                        world.method_14166(p, particle, true, x + ccx, y + ccy, z + ccz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            };
        }

        @Override
        public long calcKey() {
            long hash = super.calcKey();
            hash ^= 4L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.center);
            hash *= 1099511628211L;
            hash ^= (long)Double.hashCode(this.radius);
            hash *= 1099511628211L;
            hash ^= (long)Double.hashCode(this.height);
            hash *= 1099511628211L;
            hash ^= (long)this.level;
            return hash *= 1099511628211L;
        }
    }

    public static class Sphere
    extends ExpiringShape {
        private final Set<String> required = ImmutableSet.of((Object)"center", (Object)"radius");
        private final Map<String, Value> optional = ImmutableMap.of((Object)"level", (Object)Value.ZERO);
        class_243 center;
        float radius;
        int level;
        int subdivisions;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        private Sphere() {
        }

        @Override
        protected void init(Map<String, Value> options) {
            super.init(options);
            this.center = this.vecFromValue(options.get("center"));
            this.radius = NumericValue.asNumber(options.get("radius")).getFloat();
            this.subdivisions = this.level = NumericValue.asNumber(options.getOrDefault("level", this.optional.get("level"))).getInt();
            if (this.subdivisions <= 0) {
                this.subdivisions = Math.max(10, (int)(10.0 * Math.sqrt(this.radius)));
            }
        }

        @Override
        public Consumer<class_3222> alternative() {
            return p -> {
                class_2394 particle = this.replacementParticle();
                int partno = Math.min(1000, 20 * this.subdivisions);
                Random rand = p.field_6002.method_8409();
                class_3218 world = p.method_14220();
                class_243 ccenter = this.relativiseRender((class_1937)world, this.center, 0.0f);
                double ccx = ccenter.field_1352;
                double ccy = ccenter.field_1351;
                double ccz = ccenter.field_1350;
                for (int i = 0; i < partno; ++i) {
                    float theta = (float)Math.asin(rand.nextDouble() * 2.0 - 1.0);
                    float phi = (float)(Math.PI * 2 * rand.nextDouble());
                    double x = this.radius * class_3532.method_15362((float)theta) * class_3532.method_15362((float)phi);
                    double y = this.radius * class_3532.method_15362((float)theta) * class_3532.method_15374((float)phi);
                    double z = this.radius * class_3532.method_15374((float)theta);
                    world.method_14166(p, particle, true, x + ccx, y + ccy, z + ccz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            };
        }

        @Override
        public long calcKey() {
            long hash = super.calcKey();
            hash ^= 3L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.center);
            hash *= 1099511628211L;
            hash ^= (long)Double.hashCode(this.radius);
            hash *= 1099511628211L;
            hash ^= (long)this.level;
            return hash *= 1099511628211L;
        }
    }

    public static class Line
    extends ExpiringShape {
        private final Set<String> required = ImmutableSet.of((Object)"from", (Object)"to");
        private final Map<String, Value> optional = ImmutableMap.of();
        class_243 from;
        class_243 to;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        private Line() {
        }

        @Override
        protected void init(Map<String, Value> options) {
            super.init(options);
            this.from = this.vecFromValue(options.get("from"));
            this.to = this.vecFromValue(options.get("to"));
        }

        @Override
        public Consumer<class_3222> alternative() {
            class_2394 particle = this.replacementParticle();
            double density = Math.max(2.0, this.from.method_1022(this.to) / 50.0) / ((double)this.a + 0.1);
            return p -> {
                if (p.field_6002.method_27983() == this.shapeDimension) {
                    ShapeDispatcher.drawParticleLine(Collections.singletonList(p), particle, this.relativiseRender((class_1937)p.method_14220(), this.from, 0.0f), this.relativiseRender((class_1937)p.method_14220(), this.to, 0.0f), density);
                }
            };
        }

        @Override
        public long calcKey() {
            long hash = super.calcKey();
            hash ^= 2L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.from);
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.to);
            return hash *= 1099511628211L;
        }
    }

    public static class Box
    extends ExpiringShape {
        private final Set<String> required = ImmutableSet.of((Object)"from", (Object)"to");
        private final Map<String, Value> optional = ImmutableMap.of();
        class_243 from;
        class_243 to;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        @Override
        protected void init(Map<String, Value> options) {
            super.init(options);
            this.from = this.vecFromValue(options.get("from"));
            this.to = this.vecFromValue(options.get("to"));
        }

        @Override
        public Consumer<class_3222> alternative() {
            class_2394 particle = this.replacementParticle();
            double density = Math.max(2.0, this.from.method_1022(this.to) / 50.0 / ((double)this.a + 0.1));
            return p -> {
                if (p.field_6002.method_27983() == this.shapeDimension) {
                    Box.particleMesh(Collections.singletonList(p), particle, density, this.relativiseRender((class_1937)p.method_14220(), this.from, 0.0f), this.relativiseRender((class_1937)p.method_14220(), this.to, 0.0f));
                }
            };
        }

        @Override
        public long calcKey() {
            long hash = super.calcKey();
            hash ^= 1L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.from);
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.to);
            return hash *= 1099511628211L;
        }

        public static int particleMesh(List<class_3222> playerList, class_2394 particle, double density, class_243 from, class_243 to) {
            double x1 = from.field_1352;
            double y1 = from.field_1351;
            double z1 = from.field_1350;
            double x2 = to.field_1352;
            double y2 = to.field_1351;
            double z2 = to.field_1350;
            return ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y1, z1), new class_243(x1, y2, z1), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y2, z1), new class_243(x2, y2, z1), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y2, z1), new class_243(x2, y1, z1), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y1, z1), new class_243(x1, y1, z1), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y1, z2), new class_243(x1, y2, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y2, z2), new class_243(x2, y2, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y2, z2), new class_243(x2, y1, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y1, z2), new class_243(x1, y1, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y1, z1), new class_243(x1, y1, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y2, z1), new class_243(x1, y2, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y2, z1), new class_243(x2, y2, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y1, z1), new class_243(x2, y1, z2), density);
        }
    }

    public static class DisplayedText
    extends ExpiringShape {
        private final Set<String> required = ImmutableSet.of((Object)"pos", (Object)"text");
        private final Map<String, Value> optional = ImmutableMap.builder().put((Object)"facing", (Object)new StringValue("player")).put((Object)"raise", (Object)new NumericValue(0L)).put((Object)"tilt", (Object)new NumericValue(0L)).put((Object)"indent", (Object)new NumericValue(0L)).put((Object)"height", (Object)new NumericValue(0L)).put((Object)"align", (Object)new StringValue("center")).put((Object)"size", (Object)new NumericValue(10L)).put((Object)"value", (Object)Value.NULL).put((Object)"doublesided", (Object)new NumericValue(0L)).build();
        class_243 pos;
        String text;
        int textcolor;
        int textbck;
        class_2350 facing;
        float raise;
        float tilt;
        float size;
        float indent;
        int align;
        float height;
        class_2561 value;
        boolean doublesided;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        @Override
        protected void init(Map<String, Value> options) {
            super.init(options);
            this.pos = this.vecFromValue(options.get("pos"));
            this.value = ((FormattedTextValue)options.get("text")).getText();
            this.text = this.value.getString();
            if (options.containsKey("value")) {
                this.value = ((FormattedTextValue)options.get("value")).getText();
            }
            this.textcolor = this.rgba2argb(this.color);
            this.textbck = this.rgba2argb(this.fillColor);
            String dir = options.getOrDefault("facing", this.optional.get("facing")).getString();
            this.facing = null;
            switch (dir) {
                case "north": {
                    this.facing = class_2350.field_11043;
                    break;
                }
                case "south": {
                    this.facing = class_2350.field_11035;
                    break;
                }
                case "east": {
                    this.facing = class_2350.field_11034;
                    break;
                }
                case "west": {
                    this.facing = class_2350.field_11039;
                    break;
                }
                case "up": {
                    this.facing = class_2350.field_11036;
                    break;
                }
                case "down": {
                    this.facing = class_2350.field_11033;
                }
            }
            this.align = 0;
            if (options.containsKey("align")) {
                String alignStr = options.get("align").getString();
                if ("right".equalsIgnoreCase(alignStr)) {
                    this.align = 1;
                } else if ("left".equalsIgnoreCase(alignStr)) {
                    this.align = -1;
                }
            }
            this.doublesided = false;
            if (options.containsKey("doublesided")) {
                this.doublesided = options.get("doublesided").getBoolean();
            }
            this.raise = NumericValue.asNumber(options.getOrDefault("raise", this.optional.get("raise"))).getFloat();
            this.tilt = NumericValue.asNumber(options.getOrDefault("tilt", this.optional.get("tilt"))).getFloat();
            this.indent = NumericValue.asNumber(options.getOrDefault("indent", this.optional.get("indent"))).getFloat();
            this.height = NumericValue.asNumber(options.getOrDefault("height", this.optional.get("height"))).getFloat();
            this.size = NumericValue.asNumber(options.getOrDefault("size", this.optional.get("size"))).getFloat();
        }

        private int rgba2argb(int color) {
            int r = Math.max(1, color >> 24 & 0xFF);
            int g = Math.max(1, color >> 16 & 0xFF);
            int b = Math.max(1, color >> 8 & 0xFF);
            int a = color & 0xFF;
            return (a << 24) + (r << 16) + (g << 8) + b;
        }

        @Override
        public Consumer<class_3222> alternative() {
            return s -> {};
        }

        @Override
        public long calcKey() {
            long hash = super.calcKey();
            hash ^= 5L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.pos);
            hash *= 1099511628211L;
            hash ^= (long)this.text.hashCode();
            hash *= 1099511628211L;
            if (this.facing != null) {
                hash ^= (long)this.facing.hashCode();
            }
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.raise);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.tilt);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.indent);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.height);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.size);
            hash *= 1099511628211L;
            hash ^= (long)Integer.hashCode(this.align);
            hash *= 1099511628211L;
            hash ^= (long)Boolean.hashCode(this.doublesided);
            return hash *= 1099511628211L;
        }
    }

    public static abstract class ExpiringShape {
        public static final Map<String, Function<Map<String, Value>, ExpiringShape>> shapeProviders = new HashMap<String, Function<Map<String, Value>, ExpiringShape>>(){
            {
                this.put("line", ExpiringShape.creator(() -> new Line()));
                this.put("box", ExpiringShape.creator(Box::new));
                this.put("sphere", ExpiringShape.creator(() -> new Sphere()));
                this.put("cylinder", ExpiringShape.creator(() -> new Cylinder()));
                this.put("label", ExpiringShape.creator(DisplayedText::new));
            }
        };
        float lineWidth;
        protected float r;
        protected float g;
        protected float b;
        protected float a;
        protected int color;
        protected float fr;
        protected float fg;
        protected float fb;
        protected float fa;
        protected int fillColor;
        protected int duration = 0;
        private long key;
        protected int followEntity;
        protected String snapTo;
        protected boolean snapX;
        protected boolean snapY;
        protected boolean snapZ;
        protected boolean discreteX;
        protected boolean discreteY;
        protected boolean discreteZ;
        protected class_5321<class_1937> shapeDimension;
        private static final double xdif = new Random().nextDouble();
        private static final double ydif = new Random().nextDouble();
        private static final double zdif = new Random().nextDouble();
        private final Set<String> required = ImmutableSet.of((Object)"duration", (Object)"shape", (Object)"dim");
        private final Map<String, Value> optional = ImmutableMap.of((Object)"color", (Object)new NumericValue(-1L), (Object)"follow", (Object)new NumericValue(-1L), (Object)"line", (Object)new NumericValue(2.0), (Object)"fill", (Object)new NumericValue(-256L), (Object)"snap", (Object)new StringValue("xyz"));

        private static Function<Map<String, Value>, ExpiringShape> creator(Supplier<ExpiringShape> shapeFactory) {
            return o -> {
                ExpiringShape shape = (ExpiringShape)shapeFactory.get();
                shape.fromOptions((Map<String, Value>)o);
                return shape;
            };
        }

        protected ExpiringShape() {
        }

        public static class_2487 toTag(Map<String, Value> params) {
            class_2487 tag = new class_2487();
            params.forEach((k, v) -> {
                class_2520 valTag = Param.of.get(k).toTag((Value)v);
                if (valTag != null) {
                    tag.method_10566(k, valTag);
                }
            });
            return tag;
        }

        private void fromOptions(Map<String, Value> options) {
            Set<String> required;
            Set<String> optional = this.optionalParams();
            Sets.SetView all = Sets.union(optional, required = this.requiredParams());
            if (!all.containsAll(options.keySet())) {
                throw new InternalExpressionException("Received unexpected parameters for shape: " + Sets.difference(options.keySet(), (Set)all));
            }
            if (!options.keySet().containsAll(required)) {
                throw new InternalExpressionException("Missing required parameters for shape: " + Sets.difference(required, options.keySet()));
            }
            options.keySet().forEach(k -> {
                if (!this.canTake((String)k)) {
                    throw new InternalExpressionException("Parameter " + k + " doesn't apply for shape " + ((Value)options.get("shape")).getString());
                }
            });
            this.init(options);
        }

        protected void init(Map<String, Value> options) {
            this.duration = NumericValue.asNumber(options.get("duration")).getInt();
            this.lineWidth = NumericValue.asNumber(options.getOrDefault("line", this.optional.get("line"))).getFloat();
            this.fillColor = NumericValue.asNumber(options.getOrDefault("fill", this.optional.get("fill"))).getInt();
            this.fr = (float)(this.fillColor >> 24 & 0xFF) / 255.0f;
            this.fg = (float)(this.fillColor >> 16 & 0xFF) / 255.0f;
            this.fb = (float)(this.fillColor >> 8 & 0xFF) / 255.0f;
            this.fa = (float)(this.fillColor & 0xFF) / 255.0f;
            this.color = NumericValue.asNumber(options.getOrDefault("color", this.optional.get("color"))).getInt();
            this.r = (float)(this.color >> 24 & 0xFF) / 255.0f;
            this.g = (float)(this.color >> 16 & 0xFF) / 255.0f;
            this.b = (float)(this.color >> 8 & 0xFF) / 255.0f;
            this.a = (float)(this.color & 0xFF) / 255.0f;
            this.key = 0L;
            this.followEntity = -1;
            this.shapeDimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(options.get("dim").getString()));
            if (options.containsKey("follow")) {
                this.followEntity = NumericValue.asNumber(options.getOrDefault("follow", this.optional.get("follow"))).getInt();
                this.snapTo = options.getOrDefault("snap", this.optional.get("snap")).getString().toLowerCase(Locale.ROOT);
                this.snapX = this.snapTo.contains("x");
                this.snapY = this.snapTo.contains("y");
                this.snapZ = this.snapTo.contains("z");
                this.discreteX = this.snapTo.contains("dx");
                this.discreteY = this.snapTo.contains("dy");
                this.discreteZ = this.snapTo.contains("dz");
            }
        }

        public int getExpiry() {
            return this.duration;
        }

        public class_243 toAbsolute(class_1297 e, class_243 vec, float partialTick) {
            return vec.method_1031(this.snapX ? (this.discreteX ? (double)class_3532.method_15357((double)e.method_23317()) : class_3532.method_16436((double)partialTick, (double)e.field_6014, (double)e.method_23317())) : 0.0, this.snapY ? (this.discreteY ? (double)class_3532.method_15357((double)e.method_23318()) : class_3532.method_16436((double)partialTick, (double)e.field_6036, (double)e.method_23318())) : 0.0, this.snapZ ? (this.discreteZ ? (double)class_3532.method_15357((double)e.method_23321()) : class_3532.method_16436((double)partialTick, (double)e.field_5969, (double)e.method_23321())) : 0.0);
        }

        public class_243 relativiseRender(class_1937 world, class_243 vec, float partialTick) {
            if (this.followEntity < 0) {
                return vec;
            }
            class_1297 e = world.method_8469(this.followEntity);
            if (e == null) {
                return vec;
            }
            return this.toAbsolute(e, vec, partialTick);
        }

        public class_243 vecFromValue(Value value) {
            if (!(value instanceof ListValue)) {
                throw new InternalExpressionException("decoded value of " + value.getPrettyString() + " is not a triple");
            }
            List<Value> elements = ((ListValue)value).getItems();
            return new class_243(NumericValue.asNumber(elements.get(0)).getDouble(), NumericValue.asNumber(elements.get(1)).getDouble(), NumericValue.asNumber(elements.get(2)).getDouble());
        }

        protected class_2394 replacementParticle() {
            String particleName = this.fa == 0.0f ? String.format(Locale.ROOT, "dust %.1f %.1f %.1f 1.0", Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b)) : String.format(Locale.ROOT, "dust %.1f %.1f %.1f 1.0", Float.valueOf(this.fr), Float.valueOf(this.fg), Float.valueOf(this.fb));
            return ShapeDispatcher.getParticleData(particleName);
        }

        public abstract Consumer<class_3222> alternative();

        public long key() {
            if (this.key != 0L) {
                return this.key;
            }
            this.key = this.calcKey();
            return this.key;
        }

        protected long calcKey() {
            long hash = -3750763034362895579L;
            hash ^= (long)this.shapeDimension.hashCode();
            hash *= 1099511628211L;
            hash ^= (long)this.color;
            hash *= 1099511628211L;
            hash ^= (long)this.followEntity;
            hash *= 1099511628211L;
            if (this.followEntity >= 0) {
                hash ^= (long)this.snapTo.hashCode();
                hash *= 1099511628211L;
            }
            hash ^= (long)Float.hashCode(this.lineWidth);
            hash *= 1099511628211L;
            if ((double)this.fa != 0.0) {
                hash = 31L * hash + (long)this.fillColor;
                hash *= 1099511628211L;
            }
            return hash;
        }

        int vec3dhash(class_243 vec) {
            return vec.method_1031(xdif, ydif, zdif).hashCode();
        }

        protected Set<String> requiredParams() {
            return this.required;
        }

        protected Set<String> optionalParams() {
            return this.optional.keySet();
        }

        private boolean canTake(String param) {
            return this.requiredParams().contains(param) || this.optionalParams().contains(param);
        }
    }
}

