/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.exception;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.Tokenizer;
import carpet.script.exception.ResolvedException;
import carpet.script.value.FunctionValue;
import java.util.ArrayList;
import java.util.List;

public class ExpressionException
extends RuntimeException
implements ResolvedException {
    public final Context context;
    public final List<FunctionValue> stack = new ArrayList<FunctionValue>();
    private static final Fluff.TriFunction<Expression, Tokenizer.Token, String, List<String>> errorMaker = (expr, token, errmessage) -> {
        ArrayList<String> errMsg = new ArrayList<String>();
        errmessage = errmessage + (expr.getModuleName() == null ? "" : " in " + expr.getModuleName());
        if (token != null) {
            List<String> snippet = expr.getExpressionSnippet((Tokenizer.Token)token);
            errMsg.addAll(snippet);
            errmessage = snippet.size() != 1 ? errmessage + " at line " + (token.lineno + 1) + ", pos " + (token.linepos + 1) : errmessage + " at pos " + (token.pos + 1);
        }
        errMsg.add((String)errmessage);
        return errMsg;
    };

    public ExpressionException(Context c, Expression e, String message) {
        super(ExpressionException.makeMessage(c, e, null, message));
        this.context = c;
    }

    public ExpressionException(Context c, Expression e, Tokenizer.Token t, String message) {
        super(ExpressionException.makeMessage(c, e, t, message));
        this.context = c;
    }

    public ExpressionException(Context c, Expression e, Tokenizer.Token t, String message, List<FunctionValue> stack) {
        super(ExpressionException.makeMessage(c, e, t, message));
        this.stack.addAll(stack);
        this.context = c;
    }

    static String makeMessage(Context c, Expression e, Tokenizer.Token t, String message) throws ExpressionException {
        List<String> alternative;
        if (c.host.errorSnooper != null && (alternative = c.host.errorSnooper.apply(e, t, message)) != null) {
            return String.join((CharSequence)"\n", alternative);
        }
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)errorMaker.apply(e, t, message));
    }
}

