/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.config;

import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.util.HardcodedUtil;
import java.util.Comparator;
import net.fabricmc.loader.api.ModContainer;

public class ModMenuConfig {
    private boolean showLibraries = false;
    private boolean hideConfigButtons = false;
    private Sorting sorting = Sorting.ASCENDING;

    public void toggleShowLibraries() {
        this.showLibraries = !this.showLibraries;
        ModMenuConfigManager.save();
    }

    public void toggleSortMode() {
        this.sorting = Sorting.values()[(this.getSorting().ordinal() + 1) % Sorting.values().length];
        ModMenuConfigManager.save();
    }

    public boolean showLibraries() {
        return this.showLibraries;
    }

    public boolean isHidingConfigurationButtons() {
        return this.hideConfigButtons;
    }

    public Sorting getSorting() {
        return this.sorting == null ? Sorting.ASCENDING : this.sorting;
    }

    public static enum Sorting {
        ASCENDING(Comparator.comparing(modContainer -> HardcodedUtil.formatFabricModuleName(modContainer.getMetadata().getName()).method_10851()), "modmenu.sorting.ascending"),
        DESCENDING(ASCENDING.getComparator().reversed(), "modmenu.sorting.decending");

        Comparator<ModContainer> comparator;
        String translationKey;

        private Sorting(Comparator<ModContainer> comparator, String translationKey) {
            this.comparator = comparator;
            this.translationKey = translationKey;
        }

        public Comparator<ModContainer> getComparator() {
            return this.comparator;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

