# Usage from shell

```shell
$ memgen example/chol.pdb membrane.pdb
Submitting [example/chol.pdb] to [memgen.uni-saarland.de/api]. Please wait...
Output saved as [membrane.pdb].
```

```shell
$ pymol membrane.pdb
```

# Usage as a library

![jupyter](doc/jupyter.png)

# About

MemGen generates multi-component lipid membranes for molecular dynamics simulations.

If you use structures generated by MemGen for a publicaiton, we kindly request that you cite this article:

_Christopher J. Knight and Jochen S. Hub_  
_MemGen: A general web server for the setup of lipid membrane simulation systems_  
_[Bioinformatics, 31:2897-2899 (2015), doi:10.1093/bioinformatics/btv292](http://dx.doi.org/10.1093/bioinformatics/btv292)_

MemGen is not restricted to certain force fields, lipid types, or MD simulation software. MemGen provides a PDB file of the membrane, which can be processed by any MD software.

After uploading structure files of single-lipid molecules, MemGen aligns these lipids along the Z-axis and creates a more compact structure of each one. This step is required to avoid atomic overlaps between adjacent lipids while setting up the membrane. Subsequently, MemGen generates the patch according to the requested number of lipids, mole fraction of lipid types, water molecules per lipid, and salt concentration. Counter-ions are always added to neutralize the system.

![flowchart](doc/flowchart.png)

MemGen should work with any all-atom or united-atom lipid, regardless of the type of head group or tails, or even the number of tails. We tested MemGen with lipids containing between 1 and 6 tails, numerous different lipid types, common and unusual sterols, alcohol and detergent molecules. Only coarse-grained lipids are not supported.

Note that the membrane structure provided by MemGen is highly ordered, so it requires energy minimization and careful equilibration. For membranes containing only one type of lipid plus water, 10 nanoseconds of equlibration are often enough. For multi-component membranes or systems containing ions, much longer equilibration may be required. Please check the equilibration from, for instance, the convergence of box dimensions and potential energy.

# Options

```shell
$ memgen --help
usage: memgen [-h] [-c [RATIO ...]] [-a AREA_PER_LIPID] [-w WATER_PER_LIPID]
              [-n LIPIDS_PER_MONOLAYER] [-s ADDED_SALT] [-b {square,hexagonal}]
              [--png PNG] [--topology TOPOLOGY] [--server SERVER]
              input_pdbs [input_pdbs ...] output_pdb

positional arguments:
  input_pdbs            PDB files with lipids.
  output_pdb            Generated membrane.

optional arguments:
  -h, --help            show this help message and exit
  -c [RATIO ...], --ratio [RATIO ...]
                        Lipid concentration ratio. For example: 1 4 (same as 20 80). It means 20% of
                        the first lipid and 80% of the second. (default: None)
  -a AREA_PER_LIPID, --area-per-lipid AREA_PER_LIPID
                        Area per lipid (Å²) (default: 65)
  -w WATER_PER_LIPID, --water-per-lipid WATER_PER_LIPID
                        Water molecules per lipid (default: 35)
  -n LIPIDS_PER_MONOLAYER, --lipids-per-monolayer LIPIDS_PER_MONOLAYER
                        Lipids per monolayer (default: 64)
  -s ADDED_SALT, --added-salt ADDED_SALT
                        Added salt (milli molar) (default: 0)
  -b {square,hexagonal}, --box-shape {square,hexagonal}
                        Box shape (default: square)
  --png PNG             A small thumbnail depicting generated membrane. (default: None)
  --topology TOPOLOGY   Generated GROMACS topology file. (default: None)

Maintenance:
  --server SERVER       Hostname of MemGen REST API server. (default: memgen.uni-saarland.de)
```

# Privacy

We don't store input or output of jobs submitted with this script.

## The people behind MemGen

Christopher J. Knight developed the website's front-end, design, initial input processing, and lipid delineation. Jochen S. Hub designed the concept of MemGen and wrote the scripts involved in molecular modelling. This project was supported by the Deutsche Forschungsgemeinschaft (Emmy-Noehter Program and SFB 803/A12).

# Troubleshooting

In case MemGen fails to generate a membrane, or the membrane has some flaws, you can create and describe an issue [here](https://gitlab.com/cbjh/memgen/py-memgen/-/issues). Two log files `*.out.log` and `*.err.log` are created on failure. Attach them to help us solve the issue.

## Availablity

This script is just a terminal client to a web service located at http://memgen.uni-saarland.de. As a consequence:
 - It needs Internet connection to work.
 - Older versions of this package might stop working at some point (try updating the package).
 - Our server might be temporarily down.
 
In case you are feeling insecure with this, there is also an off-line version of MemGen available.

# Maintenance

[Development and publishing to PyPI](doc/maintenance.md)
